(ns comp.fetch
  (:require
    [reagent.core :as r]
    [comp.input :refer [atom-input]])
  (:require-macros
      ;[cljs.test :refer [is testing]]
      [devcards.core :as dc :refer [defcard defcard-rg deftest dom-node]]))


;;from Hoplon
(defn do-watch
  "Adds f as a watcher to ref and evaluates (f init @ref) once. The watcher
  f is a function of two arguments: the previous and next values. If init is
  not provided the default (nil) will be used."
  ([ref f]
   (do-watch ref nil f))
  ([ref init f]
   (let [k (gensym)]
     (f init @ref)
     (add-watch ref k (fn [_ _ old new] (f old new)))
     k)))



(defn fetch-data [symbol fn-get-data]
 (let [;xx (println "get-data-if-needed created for: " symbol)
       symbol-fetched (r/atom nil)]
   (fn [symbol fn-get-data]
     (do ;(println "comparing: current: " symbol " prior: " @symbol-fetched)
         (if (not= (compare symbol @symbol-fetched) 0)
             (do ;(println "fetching data for " symbol " prior: " @symbol-fetched)
                 (reset! symbol-fetched symbol)
                 (fn-get-data symbol))
              ;(println "no change: current: " symbol " prior: " @symbol-fetched)
              )
         [:<> ]))))


; DEV-CARD

(defn demo-component [symbol]
  (let  [demo-data (r/atom "NO DATA THERE")
         get-data #(reset! demo-data (str "FETCHED DATA IS: " %))]
    (fn [symbol]
        [:div
          [fetch-data symbol get-data]
          [:p (str "data [fetched via api]: " @demo-data)]
          ])))

(def symbol- (r/atom "abc"))

(defcard-rg fetch-api-data-for-symbol
  "enter symbol (and press enter)"
  (fn [symbol-] [:div ;  :<>  ;FRAGEMENT does not render to the DOM.
     [atom-input symbol-]
     [demo-component @symbol-]
     [:p "symbol:" @symbol-]
     ])
  symbol-
  {:inspect-data true :history true})
