(ns comp.highchart
  (:require [reagent.core :as reagent])
  (:require-macros
    ;[cljs.test :refer [is testing]]
    [devcards.core :as dc :refer [defcard defcard-rg deftest dom-node]]))

(defn make-chart-config [data]
  {:chart {:type "line"
           :animation false}
   :title {:text (:title data)}
   :subtitle {:text (:subtitle data)}
   :yAxis {:min 0
           :title {:text ""
                   :align "high"}
               ;:labels {:overflow "justify"}
             }
   :xAxis {:categories (:labels data)}
   :tooltip {:valueSuffix " %"}
   :plotOptions
     {:series
        {:animation 0
         :label
           {;:pointStart 2010
            :connectorAllowed false}}}
   :legend
     {;:x -40
      ;:y 100
      ;:floating true
      ;:borderWidth 1
      ;:shadow true
      :layout "vertical"
      :align "right"
      :verticalAlign "top"}
    :credits {:enabled false}
    :series (:series data)
       })

(defn home-did-mount [this data]
   ;(js/console.log "calculating chart: " data)
   (js/Highcharts.Chart. (reagent/dom-node this) (clj->js (make-chart-config data))))

(defn lineplot [data]
 (reagent/create-class {
   :component-did-mount #(home-did-mount % data)
   :reagent-render (fn []
        [:div {:style {:min-width "310px" :max-width "800px"
               :height "400px" :margin "0 auto"}}])

  ;:component-will-receive-props #(home-did-mount % %2) ; (reagent/props %)
   :component-did-update (fn [this]
       (let [[_ series-values] (reagent/argv this)]
          (home-did-mount this series-values)))}))


; DEV-CARD

(defn demo-chart []
  (let [data {:title "Economic Activity"
              :subtitle "made with Love"
              :labels ["Jan" "Feb" "Mar" "Apr" "May" "Jun" "Jul" "Aug"]
              :series [{:name "Installation" :data [439, 523, 577, 698, 931, 1131, 1333, 1175]}
                        {:name "Manufacturing" :data [249, 244, 292, 291, 390, 302, 381, 404]}
                        {:name "Sales & Distribution" :data [117, 172, 165, 191, 285, 247, 321, 393]}] }]
      [lineplot data]))


(defcard-rg lineplot-demo
   ""
   [demo-chart])
