(ns comp.input
  (:require
    [thi.ng.strf.core :as f]
    [reagent.core  :as r]
    [devcards.core])
  (:require-macros
      ;[cljs.test :refer [is testing]]
      [devcards.core :as dc :refer [defcard defcard-rg]]))

(defn atom-input
      "textbox that is bound to an external atom"
      [str-a]
      [:input {:type "text"
               :value @str-a
               :on-change #(reset! str-a (-> % .-target .-value))
               }])


(defn int-input
  "textbox that is bound to an external atom, integer value"
  [value]
  [:input {:type "text"
           :value @value
           :on-change #(reset! value (js/parseInt (-> % .-target  .-value)))
           }])


(defn bool-input
  "checkbox bound to parameter atom (bool)"
  [bool-atom]
  [:input {:type "checkbox"
           :checked @bool-atom
           :on-change #(reset! bool-atom (-> % .-target  .-checked))
           }])



; COMBOBOX 1

(defn set-atom [value-atom event]
 (let [value (.. event -target -value)
       xx (println "combo value is: " value)
       xx (println (.. event -target -selectedIndex))]
   (reset! value-atom value)))

(defn atom-selector
      "combobox that is bound to an external atom.
      list is supplied"
      [value-atom list]
      [:select {:on-change #(set-atom value-atom %)          ;  #(reset! value-atom (.. % -target -value))
                :value @value-atom}
       (map-indexed (fn [idx item] [:option {:key idx :value item} item]  ) list)
       ]
      )


; COMBOBOX 2

(defn on-combo-changed- [value-atom list action event]
  (let [;(.log js/console "selected index: " (.indexOf list value))
        value (.. event -target -value)
        index (.. event -target -selectedIndex)]
    (reset! value-atom value)
    (action value)))

(defn list-selector
      "combobox that is bound to an external atom.
      list is supplied"
      [value-atom list action]
      (let [keys  {:on-change #(on-combo-changed- value-atom  list action %) } ;  #(reset! value-atom (.. % -target -value))
            keys  (if (nil? @value-atom) keys (assoc keys :value @value-atom))]
      [:select keys :value
       (when list (map-indexed (fn [idx item] [:option {:key idx :value item} item]) list))
       ]))

(defn assoc-selected [props current-val val]
  (if (= current-val val)
      (assoc props :selected true)
       props))




(defn go-next [value-atom list action]
  (let [new-index (inc (.indexOf list @value-atom))
        new-index (if (= new-index (count list)) 0 new-index)
        new-value (nth list new-index)]
    (reset! value-atom new-value)
    (action @value-atom)))

(defn go-prior [value-atom list action]
      (let [new-index (dec (.indexOf list @value-atom))
            new-index (if (< new-index 0 ) (- (count list) 1) new-index)
            new-value (nth list new-index)]
        (reset! value-atom new-value)
        (action @value-atom)))



; DEV Cards

(defcard
  "#COMPonents to make a UI
   -**integer**
   -**list**")


(defcard integer
   (r/as-element
     (let [atom-int (r/atom 13)]
         [comp.input/int-input atom-int]))
         )

(defcard integer2
    (dc/reagent comp.input/int-input)
    (r/atom 13)
    {:inspect-data true :history true})

(defonce atom-selected (r/atom "willy"))

(defcard-rg list
  "a simple combobox (with events)"
     [list-selector
       atom-selected
       ["andreas" "florian" "willy" "peter" "bitcoin"]
       #(.log js/console "You selected: " %)
     ]
  atom-selected
  {:inspect-data true :history true})



(defonce symbol-empty (r/atom nil))

(defcard-rg list-empty
    "a simple combobox (with events) Test for empty list"
       [list-selector
         symbol-empty
         []
         #(.log js/console "You selected: " %)
       ]
    symbol-empty
    {:inspect-data true :history true})
