(ns comp.mytab
  (:require
    [reagent.core :as r]
    [devcards.core]
    [comp.mui :as mui]
    [helper.main :refer [gen-key]]
    [styles.analysis :refer [master menu strategy button-goto]]
    )
  (:require-macros
    [devcards.core :as dc :refer [defcard defcard-rg deftest dom-node]]))


(defn on-event [e val]
      ; (println "value is: " val  )
      ; (println "e is: " e  )
  val
  )

; (.. % -target -value)

(defn my-tab [& name-data-vector]
   "makes a tab from a vector of [name component] tuples that are in a vector
   example:  [my-tab 'a' [:h1 'A'] 'b' [:h2 'b'] ]
   "
  (let [active-tab (r/atom 0)]
    (fn [& name-data-vector]
      (let [rows (partition 2 name-data-vector)]
         [:<>
            [master
            [menu
              ;[mui/app-bar {:position "static"}
                [mui/tabs {:value     @active-tab
                            :on-change #(reset! active-tab (on-event %1 %2))}
                   (for [row rows]                         ; row is a lazy seq, therfore use nth instead of get
                      [mui/tab {:key (gen-key) :label (nth row 0)}])]
                      ;]
             ]

            [strategy
                 ;[mui/paper
                    (nth (nth rows @active-tab) 1)
                ;  ]
            ]
            ]]
            )

          )))


; DEV-CARD

(defonce demo-data- (r/atom ""))

(defcard-rg tab
  "enter symbol (and press enter)"
  [my-tab
     "first" [:h1 "This is the first tab"]
     "second" [:h2 "Being second is also not so bad"]]
  demo-data-
  {:inspect-data false :history false})
