(ns demo.views.controls
 (:require
   [reagent.core :as r]
   [comp.mui :as mui]
   [comp.button :as cbutton]
   [comp.mytab :as mytab]
   [comp.notification :as n]

   [comp.input :refer [atom-input]]
   [demo.level3]
   )
   (:require-macros
     ;[cljs.test :refer [is testing]]
     [devcards.core :as dc :refer [defcard defcard-rg deftest dom-node]]))


(def notification-active (r/atom true))

(defn close-notification [&args]
      (println "closing...XX")
      (reset! notification-active false))


(def dialog-active (r/atom false))

(defn open-dialog [&args]
      (reset! dialog-active true))

(defn close-dialog [&args]
      (reset! dialog-active false))





(defn controls []
   [:div
        [mui/tooltip {:title "super duper"
                      :on-open (fn [] ( println "demo tooltip onOpen"))
                      :on-close (fn [] (println "demo tooltip onClose")) }
       [:h1 "Text with Tooltips"] ]

       [:p "delete with confirmation"
              [cbutton/confirming-delete-button {:tooltip         "you want to delete?"
                                                :confirm-tooltip "are you sure?"
                                            :on-delete open-dialog
                                          }]]
       ; dialog gets opened via the confirming delete button above.
      [n/full-screen-dialog  {
           :open? @dialog-active
           :title "title"
           :close-label "close"
           :on-close   close-dialog
           :top-actions [:p "top action" ]
           :bottom-actions  [:p "bottom actions"]}
            [mui/grid {:container true :spacing 8}
                [:p "Children of the world"]]]

      ; expansion panel
      [n/expansion-panel {:label "bongo"}
             [:h1 "The universe is expanding!"]]

      (when @notification-active
        [n/notification {
           :notification {:message "Yeah! You are checking out the controls! "
                          :success? false}
           :on-close close-notification}])
   ])

; DEV-CARD

(defcard-rg demo-controls
  ""
  [controls])
