(ns demo.views.menu
 (:require
   [reagent.core :as r]
   [comp.mui :as mui]
   [comp.button :as cbutton]
   [comp.mytab :as mytab]
   [comp.notification :as n]
   [comp.input :refer [atom-input]])
 (:require-macros
   ;[cljs.test :refer [is testing]]
   [devcards.core :as dc :refer [defcard defcard-rg deftest dom-node]]))


(defn menu-button []
     [mui/icon-button
      {:id         "main-menu-btn"
       :aria-label "open-main-menu"
       ;:on-click   toggle-drawer
     }
      [mui/icon
       {:color "secondary"
        :style {:font-weight :bold}} "menu"]])

(defn mini-nav []
  [mui/tool-bar {:disable-gutters false :style {:padding "0px 8px 0px 0px"}}
   [menu-button "longo"]
   [menu-button "willy"]
   [menu-button "wonker"]
   ])

(defn menu []
  (let [anchor (r/atom nil)
        do-close #(reset! anchor nil) ]
  (fn []
  [:div
    [mini-nav]
    [mui/icon-button
    {:on-click   #(reset! anchor (.-currentTarget %))

     :id         "account-btn"
      :aria-label "account menu"} "account"]

   [mui/menu {:anchor-el @anchor
               :open      (some? @anchor)
               :on-close  do-close
             }

     [mui/menu-item {:id       "account-menu-item-login"
                     ;:on-click (comp close #(navigate! "/kirjaudu" :comeback? true))
                   }
        [mui/list-item-icon
        [mui/icon "lock"]]
     [mui/list-item-text {:primary "bongo"}]]
     [mui/menu-item {:id       "account-menu-item-logout"
                     ;:on-click (comp close logout!)
                   }
         [mui/list-item-icon
         [mui/icon "exit_to_app"]]
      [mui/list-item-text {:primary "logout"}]]
   ]
   ]
  )))


; DEV-CARD

(defcard-rg demo-menu
    ""
    [menu])
