(ns demo.views.ozchart
  (:require
    [reagent.core :refer [atom]]
    [re-frame.core :as re-frame]
    [oz.core :as oz])
  (:require-macros
    ;[cljs.test :refer [is testing]]
    [devcards.core :as dc :refer [defcard defcard-rg deftest dom-node]]))

;; define a function for generating some dummy data
(defn group-data [& names]
  (apply concat
     (for [n names]
          (map-indexed (fn [i x] {:x i :y x :col n}) (take 20 (repeatedly #(rand-int 100)))))))

(def demo-plot
  {:data {:values (group-data "monkey" "slipper" "broom")}
   :encoding {:x {:field "x"}
              :y {:field "y"}
              :color {:field "col" :type "nominal"}}
   :mark "line"})


; DEV-CARD

(defcard-rg oz-line-plot-demo
   "A little demo line-plot using oz/vega-lite"
   [oz.core/vega-lite demo-plot]
)
