(ns financials.views.oz
  (:require
    [reagent.core :refer [atom]]
    [re-frame.core :as re-frame]
    [oz.core :as oz]))


(def line-price
  {:mark "line"
   :encoding {:y  {:field "close"
                   :type "quantitative"
                   :axis {:grid false}
                   :scale {:type "log"}}
              :x  {:field "date"
                   :type "temporal"}
                   :color {:value "blue"}}})

(defn line-valuation-no-minmax [valuation-field]
  {:mark {:type "line"
        :clip true}
  :encoding {:y {:field valuation-field
               :type "quantitative"
               :axis {:grid true }
               :scale {:type "linear"  }}
           :x {:field "date" :type "temporal"}
               :color {:value "firebrick"} }})

(defn line-valuation [valuation-field [min max]]
  (if (nil? min)
      (line-valuation-no-minmax valuation-field)
      (assoc-in
          (line-valuation-no-minmax valuation-field)
          [:encoding :y :scale :domain]
               [min, max]
          )))

(defn quintile-lines [low high]
  {:mark {:type "rule"}
          :data {:values [ { :a low} { :a high}]}
   :encoding {:y {:field "a"
                  :type "quantitative"
                  :axis {:grid true }
                  :scale {:type "linear"}}
                  :color {:value "green"}}}
  )


(defn calc-settings [data valuation-field
                     percentile-low percentile-high
                     valuation-min-max]
  { :width  800
    :height 500
    :autosize {; :width  1800
              ; :height 600
              :type "fit",
              :contains "padding"
              :resize true}
   :data  {:values data}
           :layer [ line-price
                    {:layer [(line-valuation valuation-field valuation-min-max)
                             (quintile-lines percentile-low percentile-high) ]}]
           :resolve {:scale { :y "independent"}}})

(defn settings-raw [data valuation-field low high] {
  :autosize {
     :type "fit",
     :contains "padding"
     :resize true
   }
                       :width  800
                       :height 500
                       :data   {:values data}
                       :layer  [

                                {:mark     "line"
                                 :encoding {:y  {:field "close"
                                                 :type "quantitative"
                                                 :axis {:grid false}
                                                 :scale {:type "log"}}
                                            :x  {:field "date"
                                                 :type "temporal"}
                                            :color {:value "blue"}}
                                 }


                                {:layer [

                                          {:mark {:type "line"  }
                                           :encoding {:y {:field valuation-field
                                                          :type "quantitative"
                                                          :axis {:grid true }
                                                          :scale {:type "linear"   }}
                                                      :x {:field "date" :type "temporal"}
                                                      :color {:value "firebrick"}
                                                      } }

                                           {:mark {:type "rule"}
                                            :data {:values [ { :a low} { :a high}]}
                                            :encoding {:y {
                                                       :field "a"
                                                       :type "quantitative"
                                                       :axis {:grid true }
                                                       :scale {:type "linear"}}
                                                       :color {:value "green"}}}

                                        ]



                                 }





                                ]
                                           :resolve {:scale { :y "independent"}}
                       } )


(defn finance-plot [data valuation-field min max min-max-enabled]
  (let [series (:series data)
        series-data-ok? (and (not (nil? series)) (> (count series) 0))
        l (count valuation-field)
        k (keyword (subs valuation-field 15 l))
        stats (get-in data [:stats k])
        a (get-in stats [:percentiles :20])
        b (get-in stats [:percentiles :80])
        ;_ (println "stats for " k " are: " stats " Percentiles: 20%: " a "  80%: " b)
        ]
   (if series-data-ok?
      [oz.core/vega-lite (if min-max-enabled
                             (calc-settings series valuation-field a b [min max])
                             (calc-settings series valuation-field a b nil)
                             ;(settings-raw series valuation-field a b)

                             )]
      [:h1 "No Series Data to draw a chart!"])))



(def financial-demo-data [
    {:book 1.1 :close 23}
    {:book 1.5 :close 30}
    {:book 1.3 :close 24}
    {:book 0.2 :close 5}
    {:book 0.4 :close 11}
])
