(ns helper.reagent
  (:require
    [clojure.string :as string]
    [reagent.core :as r]
    [thi.ng.strf.core :as f]
    [api.get :refer [get-data]]))


(defn fetch-update
   "fetches data via rest-get and updates db in [:result db-key]"
   [db db-key query query-params]
   ;(println "fetching " query)
   (r/rswap! db assoc :fetching :true
                      :fetch-error false
                      :fetch-error-details nil)
   (r/rswap! db assoc-in [:result db-key] nil)
   (get-data query query-params
       (fn [result]
          (r/rswap! db assoc-in [:result db-key] result)
          (r/rswap! db assoc :fetching false))
       (fn [error]
          (println "fetch-update error!")
          (r/rswap! db assoc :fetching false
                             :fetch-error true
                             :fetch-error-details (str error)))
          ))
