(ns import.csv
  (:require
   [mongo.db :refer [db]]
   [clojure.data.csv :as csv]
   [import.list]
   ))

(defn csv-data->maps [csv-data]
  (doall  (map zipmap
              (->> (first csv-data) ;; First row is the header
                   (map keyword) ;; Drop if you want string keys instead
                   repeat)
              (rest csv-data))))

(defn load-csv-list [filename]
  (->> filename
       (slurp)
       (csv/read-csv)
       (csv-data->maps)
         ;(map #(assoc % :EXCH (str/split (:EXCH %) #", ")))
       ))



(defn import-csv-tickers [list-symbol filename]
  (->> (load-csv-list filename)
       (map :Ticker)
       (import.list/save-list-members list-symbol)))

(comment
  ;(defn import-csv []
  ;  (let [list (->> (instruments/get-instruments)
  ;                  (remove #(nil? %))
  ;                  (remove #(nil? (:symbol %)))
  ;                  (map separate-category)
  ;                  (filter #(in? ["Equity" "Index" "Curncy"] (:category %)))
  ;                  )]
  ;    (map #(mc/insert db "instruments" %) list))))

  (import-csv-tickers "OIL-LARGE List" "resources/CSV/oil_largecap.csv")
       
       
 )