(ns import.currency
  (:require
    [clojure.tools.logging :refer [info]]
    [mongo.db :refer [db]]
    [mongo.instrument]
    [bloomberg.data.currency :refer [get-currency-info]]
  ))

(defn update-needed?-
  "updates currency info (if needed)"
  [symbol]
  (let [existing-instrument (mongo.instrument/load-symbol symbol)
        name (get-in existing-instrument [:name])
        security-type (get-in existing-instrument [:SECURITY_TYP])
        needs-update  (or (nil? name)
                          (clojure.string/blank? name)
                          (nil? security-type)
                          (vector? security-type)
                          (clojure.string/blank? security-type))]
    needs-update
    ))


(defn currency-info [symbol]
  (do (-> symbol
          (get-currency-info)
          (mongo.instrument/update-instrument))
      {:currency 1}))

(defn currency-info? [symbol]
  (let [needs-update (update-needed?- symbol)]
    (if needs-update
        (do ;(info symbol "bond info downloading")
          (currency-info symbol))
        (do ;(info symbol "bond info is up to date.")
            {:currency 0}))))


(comment

   (let [ed (currency-info? "EURNOK Curncy")]
            (println "update cost: " ed))


)
