(ns import.equity
  (:require
    [clojure.tools.logging :refer [info]]
    [mongo.db :refer [db]]
    [mongo.instrument]
    [bloomberg.data.equity :refer [get-equity-descriptive]]
  ))

(defn update-needed?-
  "do we need to update financial report summary for an instrument?"
  [symbol]
  (let [existing-instrument (mongo.instrument/load-symbol symbol)
        name (get-in existing-instrument [:name])
        description (get-in existing-instrument [:description])
        market-status (get-in existing-instrument [:MARKET_STATUS])
        needs-update  (or (nil? name)
                          (clojure.string/blank? name)
                          (nil? description)
                          (vector? description)
                          (clojure.string/blank? description)
                          (nil? market-status)
                          )
        ]
    needs-update
    ))

(defn equity-descriptive [symbol]
  (do (-> symbol
          (get-equity-descriptive)
          (mongo.instrument/update-instrument))
      {:equity 1}))

(defn equity-descriptive? [symbol]
  (let [needs-update (update-needed?- symbol)]
    (if needs-update
      (do (equity-descriptive symbol)
          {:equity 1})
      (do ;(info symbol "equity desc up to date.")
          {:equity 0}))))


(comment

  (equity-descriptive "UQA AV Equity")
  (equity-descriptive? "EBS AV Equity")

  (pipe equity-descriptive? one-symbol "AFX GY Equity")
  (pipe equity-descriptive? index "HDAX Index")
  (pipe equity-descriptive index "DAX Index")

  )
