(ns import.report-individual
  (:require
    [clojure.tools.logging :refer [info]]
    [clj-time.core :as t]
    [clojure.data :as cljdata]
    [taoensso.tufte :as tufte :refer (defnp p profiled profile)]

    [mongo.db :refer [db]]
    [mongo.instrument]

    [mongo.report]
    [fundamental.report :refer [yearly-report-symbol? ]]
    [bloomberg.data.report-individual :refer [get-one-report]]
    ))

(defn download-one-report-and-save [symbol fields period]
  (let [report-period (:EarningsYearandPeriod period)
        report-date (:EarningsAnnouncementDate period)      ;report-date for old reports is not defined
        downloaded-report (get-one-report symbol report-period fields)
        report-with-releasedate (if (nil? report-date) downloaded-report (assoc downloaded-report :releasedate report-date))
        fields (:fields report-with-releasedate)
        _ (info "downloaded report " symbol " " report-period " release date: " report-date " #report-fields: " (count fields ))]
    (mongo.report/save-report report-with-releasedate)))


(defn diff
  [l r fl fr]
  (let [r-project (into #{} (map fr r))]
    (set (remove #(contains? r-project (fl %)) l))))


(defn financial-reports [symbol]
  (let [instrument (mongo.instrument/load-symbol symbol)
        sort-reports (partial sort-by :EarningsYearandPeriod)
        filter-reports (partial filter #(yearly-report-symbol? (:EarningsYearandPeriod %)))
        filter-sort #(sort-reports (filter-reports %))
        reports-available (:ERN_ANN_DT_AND_PER instrument)
        reports-available (filter-sort reports-available)
        ;xx (println "available:" (count reports-available))
        reports-saved (mongo.report/load-reports-available-for-symbol symbol)
        reports-saved (map #(assoc {} :EarningsYearandPeriod %) reports-saved)
        reports-saved (filter-sort reports-saved)
        ;xx (info symbol "reports available:" (count reports-available) "saved: " (count reports-saved))
        ;xx (println "available: " reports-available)
        ;xx (println "saved: " reports-saved)
        difference (diff (set reports-available) (set reports-saved) :EarningsYearandPeriod :EarningsYearandPeriod)
        to-download difference
        ;to-download (take 1 to-download)                   ; for testing only do 1 report
        ;xx (info symbol "reports to download:" to-download)
        fields (mongo.report/get-report-fields)
        ;xx (println "fields: " fields)
        ;one #(println "downloading: " %)
        one (partial download-one-report-and-save symbol fields)
        ]
    (doall (map one to-download))
    {:equity-report (count to-download)}
    ))

(comment

  (financial-reports "MAC US Equity" )

  (pipe financial-reports index "RTY Index")

  )
