(ns import.report-summary
  (:require
    [clojure.tools.logging :refer [info]]
    [clj-time.core :as t]
    [taoensso.tufte :as tufte :refer (defnp p profiled profile)]

    [mongo.db :refer [db]]
    [mongo.instrument]
    [mongo.report :as mreport]
    [mongo.universe :as muniverse]
    [bloomberg.data.report-summary :refer [get-financial-summary]]
    ))

; FINANCIAL REPORTS
(defn financial-summary [symbol]
  (let [financial-summary-data (get-financial-summary symbol)]
    (do
      ;(info "Saving Financial-Summary: " financial-summary-data)
      (mongo.instrument/update-instrument financial-summary-data)
      {:equity-report-summary 1}
      )))



(defn update-needed- [symbol]
  (let [existing-instrument (mongo.instrument/load-symbol symbol)
        expected-report-dt (get-in existing-instrument [:EXPECTED_REPORT_DT])
        ;xx (println expected-report-dt (type expected-report-dt))
        ;xx (println (t/now) (type (t/now) ))
        needs-update (or (nil? expected-report-dt)
                         (t/after? (t/now) expected-report-dt))
        ]
    needs-update
    ))

(defn financial-summary? [symbol]
  (let [needed (update-needed- symbol)]
    (if needed (do (financial-summary symbol)
                   {:equity-report-summary 1})
               (do ;(println "financial-summary up to date " symbol)
                   {:equity-report-summary 0}
                   ))
    ))

(comment

  (let [symbol "MO US Equity"
        update? (update-needed- symbol)]
        (println "symbol:" symbol "update needed:" update?)
        (financial-summary? symbol)
        (financial-summary symbol)
        (financial-summary? symbol)
        )

  (pipe financial-summary? index "RTY Index")
  (pipe financial-summary one-symbol symbol-one-)

  )
