(ns import.series
  (:require
    [clojure.tools.logging :refer [info]]
    [clj-time.core :as t]
    [clj-time.format :as f]
    [taoensso.tufte :as tufte :refer (defnp p profiled profile)]

    [bloomberg.request.series :refer [bloomberg-get-series ]]
    [mongo.series :refer [load-series save-series sanitize-series available-range append-series]]
    ))


(defn tap [symbol where series]
    (println symbol "stage: " where "series " (count series))
    series
  )


(defn daily-series [date-start date-end symbol]
  (do (println symbol "- downloading daily series " date-start date-end )
      (->> symbol
          (bloomberg-get-series date-start date-end)
          (tap symbol "bb-result")
          (sanitize-series)
          (tap symbol "sanitized")
          (save-series symbol)
          )
      {:series 10000 :series-full 1}))

(defn daily-series-if-empty [date-start date-end symbol]
  (let [existing-series (load-series symbol)]
    (if (or (nil? existing-series)
            (= 0 (count existing-series))  )
      (do (println symbol "daily-series-if-empty/ series does not exist.")
          (daily-series date-start date-end symbol))
      (do (println symbol "daily-series-if-empty /series already existing.")
          {:series-empty 0} )
      )))



(def custom-formatter (f/formatter "yyyyMMdd"))

(defn sdate [date]
  (f/unparse custom-formatter date))

(defn append-series-safe [symbol series]
   (if (and (not (nil? series))
            (> (count series) 0))
        (do (println "series received: " (count series))
            (append-series symbol series))
        {}))

;(nil? 1)

(defn daily-series-latest [symbol]
  (let [date-end (.toDateMidnight (t/now))
        ;date-end (t/plus (.toDateMidnight (t/now)) (t/days -2))
        date-end (if (= (t/day-of-week date-end) 7) (t/plus date-end (t/days -2)) date-end) ; sunday
        date-end (if (= (t/day-of-week date-end) 6) (t/plus date-end (t/days -1)) date-end) ; satursday

        disk (available-range symbol)
        date-start (:end disk)
        xx (println "disk: " (sdate date-start) "needed: " (sdate date-end))
        needs-update (and (not (nil? date-start)) (t/after? date-end date-start) )
        ]
    (if needs-update
      (do (println "Downloading series" symbol (sdate date-start) "-" (sdate date-end))
          (->> symbol
               (bloomberg-get-series (sdate (t/plus date-start (t/days 1))) (sdate date-end))
               (sanitize-series)
               (append-series-safe symbol))
          {:series 10000 :series-add 1})
      (do (println "no series Update needed for " symbol)
           {:series 0 :series-add 0})
      )))


(comment

  (daily-series-latest "DAX Index")
  (daily-series-latest "BP/ LN Equity")
  (daily-series-latest "MAC US Equity")


  ; timeseries
  (daily-series "19500101" "20191001" "DAX Index")
  (daily-series "18900101" "20191101" "TRAN Index")
  (daily-series "19500101" "20191001" "MAC US Equity")
  (daily-series "19500101" "20191201" "BP/ LN Equity")

  (daily-series "19500101" "20191201" "AU8162573 Corp")


  (daily-series-if-empty "19500101" "20181014" "MAC US Equity")
  (daily-series-if-empty "19500101" "20201231" "AN288649 Corp")
(daily-series-if-empty "19500101" "20201231" "LW6890732 Corp")


  (load-series "AO0266368 Corp")




  (pipe (partial daily-series "19500101" "20181014") symbols-from-list symbol-list-)
  (pipe (partial daily-series "19500101" "20181014") index symbol-one-)
  (pipe (partial daily-series-if-empty "19500101" "20181003") symbols-from-list symbol-list-)

  ; one symbol
  (def symbol-one- "SAP GY Equity")
  (pipe (partial daily-series "19500101" "20181213") one-symbol symbol-one-)
  (pipe (partial daily-series-if-empty "19500101" "20181003") one-symbol symbol-one-)

  )
