(ns instrument.equity)

(defn equity-info [instrument]
      [:div
       [:p "Name: " (:name instrument) ]

       [:h2 "Security"]
       [:p "Symbol: " (:symbol instrument) ]
       [:p "Market Status: " (:MARKET_STATUS instrument) ]
       [:p "ISIN: " (:isin instrument) ]
       [:p "IsPrimary: " (:primaryflag instrument) " Exchange: " (:primaryexchange instrument)  ]
       [:p "Security Type: " (:securitytype instrument) ]

       [:h2 "Business"]
       [:p "Sector: " (:sector instrument)
        " Industry: " (:industry instrument)
        " Sub-Industry: " (:subindustry instrument)]

       [:p "Description: " (:description instrument) ]
       [:p "Notes: " (:desnotes instrument) ]
       [:p "Employees: " (:employees instrument) ]
       [:p "Web: " (:companywebaddress instrument) ]

       [:h2 "Financial Reports (Fundamental Data)"]
       [:p "Expected Report Date: " (:EXPECTED_REPORT_DT instrument) ]
       [:p "Fundamental Currency: " (:EQY_FUND_CRNCY  instrument) ]
       [:p "Fundamental Industry: " (:EQY_FUND_IND  instrument) ]
       [:p "Incorporation Country: " (:incorporationcountry instrument) ]

       ])
