(ns instrument.info
  (:require
    [reagent.core :as r]
    [comp.mui :as mui]
    [comp.table :as table]
    [comp.input :as cinput]
    [comp.button :as cbutton]

    [comp.fetchcomp :refer [fetch-data-container]]
    [instrument.equity :refer [equity-info]]
    [instrument.index :refer [index-info]]  ))


(defn instrument-info-view [data]
  [:<>
    [:h1 (:symbol data)]
    (when (not (nil? data ))
       (case (:category data)
          "Equity" [equity-info data]
          "Index" [index-info data]
          "List" [index-info data]
        [:h1 "no detail views for this category."]
       ))
    ])


(defn instrument-info-page [symbol]
  (fn [symbol]
    ;(println "instrument-info-page " symbol)
    [:<>
      [fetch-data-container :instrument {:symbol symbol}
        instrument-info-view ]]))
