(ns main
  (:require
    [clj-time.core :as t]
    [clojure.data :as cljdata]
    [mount.core :as mount :refer [defstate]]
    [clojure.tools.logging :refer [info]]
    [taoensso.tufte :as tufte :refer (defnp p profiled profile)]
    [job.run :refer [run index]]
    [job.hasdata]
    [fundamental.percentile]
    [web.server]
    [web.app])
  (:gen-class))

(defn demo []
  (info "demo 123.. done!"))

(defn -main [& args]
  (let [job (first args)
        symbol (second args)]
    (println "Java/JAR Main started.")
    (info "Commandline Arguments: " args)

    (mount/start-without #'web.server/webserver)
    (mount/start)
    (tufte/add-basic-println-handler! {})
    ;(run/run run/calc-history-and-save run/index "RTY Index")
    (case job
        "demo" (demo)

        "web" (web.server/run-jetty-blocking web.app/app 5005)

        "ok" (do (println "Calculating OK List ...")
                 (job.hasdata/calculate-ok-data-list "OK List")
                 (info "OK Calculation done.")
                 )

        "metrics" (do
                    (info "Calculating Historic Sales-Ratios for [" symbol "] ..")
                    (profile {} (p :all (run fundamental.percentile/calc-history-and-save symbol index) ))
                    ;(run fundamental.percentile/calc-history-and-save symbol index)
                    (info "Calculation done! Yippie"))
      )

    (Thread/sleep 5000) ;sleep needed for tufte performance logging, otherwise app stops to fast
    (mount/stop)
    (Thread/sleep 5000) ;sleep needed for tufte performance logging, otherwise app stops to fast
    (System/exit 0)    ; otherwise log4js will not stop
    ))


(comment
  (-main "DAX Index") ;Careful with this one
  (-main "RTY Index")
  (-main "HDAX Index")
  (-main "SXXP Index")


  (tufte/add-basic-println-handler! {})

  (run fundamental.percentile/history-ratio-sales  "MCD UN Equity")
  (profile {} (p :all (run fundamental.percentile/history-ratio-sales index "DAX Index") ))
  (run fundamental.percentile/history-ratio-sales "OK List" index )


  (run fundamental.percentile/calc-history-and-save  "DAX Index" index)
  (run rf/calc-history-and-save  "RTY Index"index)
  (run rf/calc-history-and-save "HDAX Index" index)
  (run rf/calc-history-and-save  "SXXP Index" index)

  (apply max [] )


)
