(ns mongo.calculation
  (:require
    [clojure.spec.alpha :as s]
    [clojure.string :as str]
    [clj-time.core :as t]
    [clojure.tools.logging :as log]
    [monger.collection :as mc]
    [mongo.db :refer [db]]
      ))

(defn save [calculation]
  (let [c (assoc calculation :save-date (t/now))]
    (if (s/valid? map? (:data calculation))
        (mc/update db "calculation"
             {:type (:type c) :symbol (:symbol c)} c  {:upsert true})
        (println "calculation.data has to be a map - not saving."))))


(defn remove-all
  "removes calculated calculation"
  []
  (mc/remove db "calculation" {} ))


(defn load-all [category]
 (mc/find-maps db "calculation" {:type category} {:_id 0 :type 0 :save-date 0}))
; (map #(dissoc % :_id))))

; mc/find-one-as-map

(defn browse-stats []
  (mc/find-maps db "calculation"
                {:current {:$ne nil}
                 "stats.sample-count" {:$gte 200}
                 }
                {:_id 0 :symbol 1 :current-valuation 1
                 ;:$orderby {:current-valuation 1
                  }
                 ))




(defn browse-stats-info []
  (let [report (mc/aggregate
                 db
                 "calculation"
                 [{:$match {:current {:$ne nil}
                            "stats.sample-count" {:$gte 200}
                            }}

                  {:$lookup
                   {:from         "instruments",
                    :localField   "symbol",
                    :foreignField "symbol",
                    :as           "i"}}

                  {:$project {
                              "_id"      0
                              "symbol" 1
                              :current-valuation 1
                              :current 1
                              :stats 1
                              "i.name"   1
                              "i.sector"   1
                              "i.industry"   1
                              "i.subindustry"   1
                              :loosing-year-prct 1
                              :median-sales-growth 1
                              }}
                  {:$sort { :current-valuation 1}}
                  ])
        ]
    report
    ))

(comment

  (defn xxx [category]
    (->> {:type category}
         (mc/find-maps db "calculation")
         (map #(dissoc :_id))))


  ;** TESTS
  (save {:type :test :symbol "bongo" :data { :a 15 :b 30}})
  (save {:type :test :symbol "bongo" :data []})

 (count (mongo.calculation/load-all "seasonal"))

  (clojure.repl/doc load-all)

  (future (println "seasonal stats: " (count (load-all :seasonal))))

(find-ns "mongo")

  (remove-all)

  (count (browse-stats))
  (browse-stats-info )

   (s/valid? map? [])
   (s/valid? even? 1001)


)
