(ns mongo.cost
  (:require
    [clojure.tools.logging :refer [info]]
    [clj-time.core :as t]
    [monger.core :as mg]
    [monger.collection :as mc]
    [monger.joda-time]
    [mongo.db :refer [db]]))

; Bloomberg Query Cost

(defn save-cost [cost]
  (mc/update db "cost" {:date (.toDateMidnight (t/now))} {:$inc {:cost cost}} {:upsert true}))

(defn todays-cost []
  (let [obj (mc/find-one-as-map db "cost" { :date (.toDateMidnight (t/now)) } {:cost 1 })]
    (if (nil? obj) 0 (:cost obj) )
    ))

(comment
  (do
     (println "current cost: "(todays-cost))
     (save-cost 15)
     (println "current cost (after adding 15): "(todays-cost))
    )

)
