(ns mongo.field
  (:require
    [clojure.tools.logging :refer [info]]
    [clj-time.core :as t]
    [monger.core :as mg]
    [monger.collection :as mc]
    [monger.joda-time]
    [mongo.db :refer [db]]
    ))

; BLOOMBERG FIELDS

(defn save-field [field]
  (mc/update db "bloombergfields" {:id (:id field)  } {:$set field}  {:upsert true}))

(defn load-field-info [symbol]
  (:description (mc/find-one-as-map db "bloombergfields" {:symbol symbol})))


(comment
  (println db)
  (println (load-field-info "ARD_AVG_WEEKLY_FEE"))
  (save-field {:id 999 :desc "test" :a 34})
)
