(ns seasonal.math)

(def sum #(reduce + %))

(def avg #(/ (sum %) (count %)))

(defn square [n] (* n n))

(defn mean [a] (/ (reduce + a) (count a)))

(defn standarddev [a]
  (Math/sqrt (/
               (reduce + (map square (map - a (repeat (mean a)))))
               (- (count a) 1))))


(comment
  (#_(mean [1 2 3 4 5]))
  (#_(standarddev [1 2 3 4 5]))

  )
