(ns seasonal.print
  (:require [clojure.pprint :as pp]
  ))

(defn round-number [number]
  (format "%.3f" number))

(defn average-to-string
  [month-item]
  ( round-number ( :avg month-item)))


(defn print-timeseries
  "prints timeseries (with added data)"
  [timeseries]
   (->>
      ;   (doall)
      ;   (sort-by :month)
      ;   (map #(assoc % :avg2 (average-to-string %)) )
      ;   (map #(dissoc % :avg))
         (map #(update % :close round-number) timeseries)
         (map #(update % :chg-1 round-number))
         (map #(update % :chg-p-12 round-number))
         (map #(update % :chg-p-6 round-number))
         (map #(update % :chg-p-3 round-number))
         (pp/print-table)
   ))


(defn convert-month-stat [original_map] (
  let [ get-applied (partial get original_map)
        get-in-applied (partial get-in original_map)
        get-mean #(get-in original_map [ % :mean])
        get-mean-formatted #(round-number (get-mean %))
         ]
  (zipmap [:month :count :avg :avg-up-3 :avg-down-3 :avg-up-6 :avg-down-6 :avg-up-12 :avg-down-12] [
    (get-applied :month)
    (get-in-applied [ :all :count])
    (get-mean-formatted :all)
    (get-mean-formatted :up-3)
    (get-mean-formatted :down-3)
    (get-mean-formatted :up-6)
    (get-mean-formatted :down-6)
    (get-mean-formatted :up-12)
    (get-mean-formatted :down-12)
  ])))


(defn print-season-table
  "prints month stats table"
  [ month-stats]
   (->>  (map identity month-stats)
         (doall)
         (sort-by :month)
      ;   (map #(assoc % :avg2 (average-to-string %)) )
      ;   (map #(dissoc % :avg))
         (map #(convert-month-stat %) )
         (pp/print-table)
   ))


(defn file-append
   [s]
   (spit "seasonality-stats.txt" s :append true))


(defn print-trades
  "prints month stats table"
  [trades]
   (->>  (map identity trades)
      ;  (doall)
      ;   (sort-by :month)
      ;   (map #(assoc % :avg2 (average-to-string %)) )
      ;   (map #(dissoc % :avg))
         (map #(update % :pl-expected round-number))
         (map #(update % :pl-realized round-number))
         (pp/print-table)
   ))


(comment

(average-to-string {:avg 10.123456 })
;( stats/get-series-stats "DAX Index" )

; ( print-season-table  (stats/get-series-stats "DAX Index" ))

; currently not needed; I do it with string printing.
(defn round2
  "Round a double to the given precision (number of significant digits)"
  [precision d]
  (let [factor (Math/pow 10 precision)]
  (/ (Math/round (* d factor)) factor)))

) 
