(ns seasonality.instsim
  (:require
    [clojure.string :as string]
    [reagent.core :as r]
    [thi.ng.strf.core :as f]
    [comp.mytab :as mytab]
    [comp.input :refer [atom-input]]
    [api.get :refer [get-data]]
    [helper.reagent :refer [fetch-update]]
    [comp.fetch :refer [fetch-data]]
    [seasonality.views.seasonalitystats :refer [seasonality-stats]]
    [seasonality.views.tradesummary :refer [trade-summary]]
    [seasonality.views.chart :refer [perfchart price-chart]]
    [seasonality.settings :refer [default-settings seasonality-simulation-settings]]
    [seasonality.helper :refer [trades-out-of-sample]]
    [seasonality.demodata :refer [demo-result]])
  (:require-macros
    ;[cljs.test :refer [is testing]]
    [devcards.core :as dc :refer [defcard defcard-rg deftest dom-node]]))


(defonce app-state
  (r/atom {:settings default-settings
           :symbol-fetched ""
           :result {}}))

(def settings-cursor (r/cursor app-state [:settings]))

(defn request-data [symbol]
  (do (println "seasonality run:" symbol)
      (r/rswap! app-state assoc :symbol-fetched symbol)
      (fetch-update app-state :series :seasonal-series {:symbol symbol})
      (fetch-update app-state :series-stats :seasonal-stats (assoc (:settings @app-state) :symbol symbol))
      (fetch-update app-state :trades :seasonal-simulate-one  (assoc (:settings @app-state) :symbol symbol))))


(defn get-data-if-needed [symbol]
 (let [fetched-symbol (:symbol-fetched @app-state)]
   (if-not (= symbol fetched-symbol)
      (do (.log js/console "Getting Data for " symbol " ; prior symbol was: " fetched-symbol)
          (request-data symbol)))))

(defn sample [trades]
  (let [trades? (and (not (nil? trades)) (> (count trades) 0))]
    (if trades?
         [:<> [perfchart trades]
              [trade-summary trades]]
         [:h1 "No Trades"])))

(defn simulate-instrument-app [symbol]
  (let [result (:result @app-state)
        trades (:trades result)
        year-end (:year-end result)
        trades-out (trades-out-of-sample trades year-end)
        run-simulation #(request-data symbol)
        xx (get-data-if-needed symbol)]
  [:div
     [seasonality-simulation-settings settings-cursor run-simulation]
     ;[fetch-data symbol run-simulation]
     [mytab/my-tab
       "price"  [price-chart (:series result)]
       "monthly stats"  [seasonality-stats (:series-stats result) trades]
       "in-sample"  [sample trades]
       "out-sample" [sample trades-out]
   ]]))


; DEV-CARD

(defonce symbol- (r/atom "DAX Index"))

(defcard-rg seasonality-one
  "enter symbol (and press enter)"
  [:<>  ;FRAGEMENT does not render to the DOM.
    [atom-input symbol-]
    [simulate-instrument-app @symbol-]]
  symbol-
  {:inspect-data true :history true})



(comment
  (:trades @app-state)

  (update-year-start!  "2999")
  (:year-start @app-state)
  (js/parseInt (:year-start @app-state))

  (trades-out-of-sample)

  )
