(ns seasonality.settings
  (:require
    [clojure.string :as string]
    [thi.ng.strf.core :as f]
    [reagent.core :as r]
    [devcards.core]
    )
  (:require-macros
    ;[cljs.test :refer [is testing]]
    [devcards.core :as dc :refer [defcard defcard-rg]]))

(defonce default-settings {
   :year-start 0
   :year-end 0
   :max-positions 1
   :min-risk-reward 50
   :is-future false
  })

(defn combobox
  "combobox settings:map key:key in the map. list:available-options"
  [settings key list]
  (let [current-value (key @settings)
        set-data! (fn [new-value] (r/rswap! settings assoc key new-value))]
     [:select  {:on-change #(set-data! (.. % -target -value))}
       :value  (map-indexed (fn [idx val]
            [:option {:key idx :value val} val]) list)]))

(defn checkbox [settings key]
    (let [current-value (key @settings)
          toggle! (fn [] (r/rswap! settings update key not))]
       [:input {:type "checkbox" :checked current-value  :on-change toggle!
       }]))


(defn seasonality-simulation-settings [settings on-settings-changed]
  (let [settings (r/atom default-settings)
        years (conj (range 1990 2021) 0)
        max-pos (range 1 51)
        min-risk-reward (map #(* 10 %) (range 3 21))
        do-it (fn [] (on-settings-changed @settings))]
  (fn [settings on-settings-changed]  ; render function
   [:div
     [:span {:style {:background-color "orange"}} "year-start"]
     [combobox settings :year-start years]
     [:span "year-end"]
     [combobox settings :year-end years]
     [:span "max-positions"]
     [combobox settings :max-positions max-pos]
     [:span "min-risk-reward"]
     [combobox settings :min-risk-reward min-risk-reward]
     [:span "show-upcoming-trades"]
     [checkbox settings :is-future]
     [:button {:on-click do-it } "Run Simulation"]
   ])))

; DEV-CARD

(defonce settings- (r/atom default-settings))
(defn run-demo-simulation- [settings]
    (println "Settings have changed to: " settings)
    ;(reset! settings- settings)
    )

(defcard-rg seasonality-settings
 "CHANGE the settings and [Run Simulation]. You will see the settings that have been applied."
 [seasonality-simulation-settings settings- run-demo-simulation-]
 settings-
 {:inspect-data true :history true})



(comment
  ( (sim-form nil nil) ["airlines" "food" "tech"] fn[name year-start year-end] ( println "running dummy simulation") )

  )
