(ns seasonality.views.chart
  (:require
    [clojure.string :as string]
    [reagent.core :as r]
    [thi.ng.strf.core :as f]
    [goog.dom :as dom]
    [goog.events :as events]
    [goog.functions :refer [once]]
    [comp.highchart :refer [lineplot]]))

; PRICE CHART

(defn calc-price-data [series]
  {:title "Closing Price"
   :subtitle "adjusted"
   :labels (map #( str (:year %) "-" (:month %) ) series)
   :series [{:name "Price"
             :data (map :close series)}]}) ; :close-adj

(defn price-chart [series]
  (when (not (nil? series))
        [lineplot (calc-price-data series)]))

; PERF-CHART

(defn calc-chart-data [trades]
  {:title "Performance"
   :subtitle "accumulated"
   :labels (map #( str (:year %) "-" (:month %) ) trades)
   :series [{:name "Cum.PL"
             :data (map :cum-pl trades)}]})

(defn perfchart [trades]
  (when (not (nil? trades))
        [lineplot (calc-chart-data trades) ]))
