(ns seasonality.views.seasonalitystats
  (:require
    [clojure.string :as string]
    [thi.ng.strf.core :as f]
    [reagent.core :as r]
    [helper.main :refer [round-number]]
    [seasonality.helper :refer [abs]]
    [seasonality.views.tradelist :refer [trade-list]]
    [styles.seasonality :refer [td]]
    ))

(defn is-significant? [month-group-stat]
   (let [diff (- (abs (:mean month-group-stat)) (* (:stddev month-group-stat) 0.5) ) ]
    ;(println diff)
    (if (> diff 0) true false)))

(defn trade-list-filtered [trades month]
  (let [trades-filtered (filter #(= (:month %) month) trades)]
    [trade-list trades-filtered]))


(defn seasonality-stats
  "pure component that displays seasonality-stats"
  [month-stats-optimal trades]
  (let [;xxx (println month-stats-optimal)
        ignore-year (:year month-stats-optimal)
        month-stats (:stats month-stats-optimal)
        month-stats-sorted  (sort-by :month month-stats)
        format-mean #( str (round-number (get-in %1 [%2 :mean])) " [" (round-number (get-in %1 [%2 :stddev])) "] " (get-in %1 [%2 :count]))
        selected-month (r/atom 0)
        show-month (fn[m] (do ;(println "month selected: " m)
                              (reset! selected-month m)))
          ]
        (fn [month-stats-optimal trades]
  (if (nil? month-stats) nil
  [:div
    [:h4 "ignored year: " ignore-year]
    [:table [:tbody
      [:tr [:th "m"] [:th "#"] [:th "avg"] [:th "up-3"] [:th "down-3"] [:th "up-6"] [:th "down-6"] [:th "up-12"] [:th "down-12"] ]
      (for [row month-stats-sorted]
        [:tr {:key (:month row)}
          [:td {:on-click #(show-month (:month row))} (:month row) ]
          [:td (:count (:all row)) ]
          (into [:<>]
            (for [k [:all :up-3 :down-3 :up-6 :down-6 :up-12 :down-12]]
              [td {:on-click #(show-month (:month row))
                  :significant? (is-significant? (k row))}
                  (format-mean row k)]))
       ])]]
    [:div#info-box
      [:p "Month Summary Statistics"]
      [:p (str "Selected Month: " @selected-month) ]
      (if (nil? trades) [:p "No Trades"] [trade-list-filtered trades @selected-month])
    ]]))))


(comment

  (seasonality-stats nil)
  (seasonality-stats [])

  (seasonality-stats [ { :symbol "DAX Index"  :month 1
            :all { :count 5 :mean 5 :stddev 3 }
            :up-3 { :count 5 :mean 5 :stddev 3 }
            :up-6 { :count 5 :mean 5 :stddev 3 }
            :up-12 { :count 5 :mean 5 :stddev 3 }
            :down-3 { :count 5 :mean 5 :stddev 3 }
            :down-6 { :count 5 :mean 5 :stddev 3 }
            :down-12 { :count 5 :mean 5 :stddev 3 }
          }])

(seasonality-stats [{:month 7, :all {:count 27, :mean 5.119549398496031, :stddev 13.169420904475471}, :up-12 {:count 17, :mean 6.213563918155534, :stddev 9.121295089163944}, :down-12 {:count 10, :mean 3.2597247150748716, :stddev 18.62844361804149}, :up-6 {:count 14, :mean 5.5207512922861195, :stddev 10.75544010503632}, :down-6 {:count 13, :mean 4.6874858205682415, :stddev 15.813393898993906}, :up-3 {:count 13, :mean 3.946870219350679, :stddev 11.053340675242286}, :down-3 {:count 14, :mean 6.208465779130997, :stddev 15.213053862301463}} {:month 1, :all {:count 26, :mean 2.798325103026056, :stddev 16.14325331585572}, :up-12 {:count 17, :mean 0.30313448472600335, :stddev 11.81796931138576}, :down-12 {:count 9, :mean 7.511462937592821, :stddev 22.289909999209183}, :up-6 {:count 16, :mean 0.8017748686907584, :stddev 11.22555388255886}, :down-6 {:count 10, :mean 5.992805477962531, :stddev 22.258814326198344}, :up-3 {:count 18, :mean 2.0928289458016773, :stddev 11.195148473774742}, :down-3 {:count 8, :mean 4.385691456780909, :stddev 24.94383934567474}} {:month 4, :all {:count 27, :mean 2.8816851591018957, :stddev 10.342377695997147}, :up-12 {:count 16, :mean 4.380144529785947, :stddev 10.708208178098735}, :down-12 {:count 11, :mean 0.7021078926523674, :stddev 9.86365112601068}, :up-6 {:count 18, :mean 0.8000251731362337, :stddev 7.225931446005708}, :down-6 {:count 9, :mean 7.0450051310332205, :stddev 14.402456774217242}, :up-3 {:count 15, :mean 1.3584583601691558, :stddev 9.223469157242507}, :down-3 {:count 12, :mean 4.785718657767823, :stddev 11.723183710709073}} {:month 6, :all {:count 27, :mean -8.33892898317449, :stddev 20.20045349076755}, :up-12 {:count 17, :mean -9.375317040809191, :stddev 23.575937812181163}, :down-12 {:count 10, :mean -6.577069285195497, :stddev 13.609709169119498}, :up-6 {:count 18, :mean -4.79210790922991, :stddev 22.795294617425526}, :down-6 {:count 9, :mean -15.432571131063648, :stddev 11.707726309894447}, :up-3 {:count 20, :mean -6.186076457376428, :stddev 22.194782806982463}, :down-3 {:count 7, :mean -14.48993619974038, :stddev 12.195746188128126}} {:month 3, :all {:count 27, :mean 3.7975622410536514, :stddev 10.612569648220196}, :up-12 {:count 17, :mean 4.113852445511105, :stddev 10.368968097219978}, :down-12 {:count 10, :mean 3.2598688934759794, :stddev 11.563605237646291}, :up-6 {:count 20, :mean 1.7243126041085315, :stddev 9.89609312297287}, :down-6 {:count 7, :mean 9.72113263232542, :stddev 11.075377275136413}, :up-3 {:count 16, :mean 3.7093807701194317, :stddev 11.389404284721282}, :down-3 {:count 11, :mean 3.9258261987761514, :stddev 9.910646623523665}} {:month 12, :all {:count 26, :mean -1.80558229033012, :stddev 10.427600272105966}, :up-12 {:count 16, :mean 2.3467289503322735, :stddev 9.627202969734089}, :down-12 {:count 10, :mean -8.44928027538995, :stddev 8.238604137214667}, :up-6 {:count 17, :mean 1.74455395494605, :stddev 10.739198181366204}, :down-6 {:count 9, :mean -8.511395198073997, :stddev 5.635987698583568}, :up-3 {:count 18, :mean 1.5351140061641042, :stddev 8.90938095070423}, :down-3 {:count 8, :mean -9.322148957442124, :stddev 10.114249403991506}} {:month 2, :all {:count 27, :mean 0.20621823014582924, :stddev 13.230977758156103}, :up-12 {:count 16, :mean 1.447078567608917, :stddev 15.935417666866092}, :down-12 {:count 11, :mean -1.598669533436844, :stddev 8.25830171301267}, :up-6 {:count 20, :mean 1.2013707024228673, :stddev 14.944828118055598}, :down-6 {:count 7, :mean -2.6370745477885644, :stddev 6.21183622425929}, :up-3 {:count 16, :mean 0.043223146748629926, :stddev 17.02866826915923}, :down-3 {:count 11, :mean 0.443301987814483, :stddev 4.4816466158797414}} {:month 11, :all {:count 26, :mean 2.7479410252032244, :stddev 11.559330325327137}, :up-12 {:count 15, :mean 3.5221060132350446, :stddev 12.60463070246539}, :down-12 {:count 11, :mean 1.6922614960689246, :stddev 10.463889830422747}, :up-6 {:count 16, :mean 3.265983193623052, :stddev 12.148001989306897}, :down-6 {:count 10, :mean 1.9190735557314997, :stddev 11.133929916331146}, :up-3 {:count 19, :mean 3.8499928471631955, :stddev 11.346994635668453}, :down-3 {:count 7, :mean -0.2433424915452678, :stddev 12.497769686669924}} {:month 9, :all {:count 27, :mean -2.702597053106007, :stddev 16.00284612988937}, :up-12 {:count 16, :mean 0.7786891916498409, :stddev 13.834118902193813}, :down-12 {:count 11, :mean -7.766286136387242, :stddev 18.197981818154663}, :up-6 {:count 18, :mean 0.3338560524730843, :stddev 13.42712016421328}, :down-6 {:count 9, :mean -8.775503264264195, :stddev 19.671035742111542}, :up-3 {:count 17, :mean 2.6576204636036556, :stddev 9.815020426072223}, :down-3 {:count 10, :mean -11.814966831512438, :stddev 20.543229499490714}} {:month 5, :all {:count 27, :mean 2.210799336126673, :stddev 11.923553572472573}, :up-12 {:count 16, :mean 1.6312725920892726, :stddev 12.415032331709016}, :down-12 {:count 11, :mean 3.0537473274538, :stddev 11.710098903492343}, :up-6 {:count 16, :mean -1.7564604646113788, :stddev 12.779251326201772}, :down-6 {:count 11, :mean 7.98135904629111, :stddev 7.929004032875905}, :up-3 {:count 15, :mean -0.1395518378588249, :stddev 12.906181229359003}, :down-3 {:count 12, :mean 5.148738303608545, :stddev 10.34863230137543}} {:month 10, :all {:count 26, :mean 7.5019020216012295, :stddev 14.402446241155156}, :up-12 {:count 16, :mean 9.590802112575858, :stddev 12.64335562739336}, :down-12 {:count 10, :mean 4.159661876041823, :stddev 17.01771322630872}, :up-6 {:count 17, :mean 7.840060971922255, :stddev 14.380744764543472}, :down-6 {:count 9, :mean 6.863157337661519, :stddev 15.294003708476103}, :up-3 {:count 18, :mean 8.147545369657173, :stddev 13.757988825013067}, :down-3 {:count 8, :mean 6.049204488475361, :stddev 16.662948828394992}} {:month 8, :all {:count 27, :mean 4.957099842124838, :stddev 8.710582091533428}, :up-12 {:count 18, :mean 3.9905690600132337, :stddev 8.083687092320123}, :down-12 {:count 9, :mean 6.890161406348045, :stddev 10.071013392070727}, :up-6 {:count 17, :mean 5.279668424938167, :stddev 9.405140018285135}, :down-6 {:count 10, :mean 4.408733251342178, :stddev 7.836154045127856}, :up-3 {:count 16, :mean 7.077834113135732, :stddev 8.64523985087109}, :down-3 {:count 11, :mean 1.8723954479271732, :stddev 8.21582639637257}}]
  )


  )
