(ns seasonality.views.tradelist
  (:require
    [clojure.string :as string]
    [thi.ng.strf.core :as f]
    [reagent.core :as r]
    [cljss.core :as css]
    [helper.main :refer [gen-key]]
    [helper.main :refer [round-number round-number-digits]]
    [styles.seasonality :as styles]
    ))

(defn trade-list
  "pure component that displays trade table"
  [trades]
  [:div
  [:h1 "Trades # " (count trades )]
    [:table [:tbody
      [:tr {:key (gen-key)}
           [:th "y"]
           [:th "m"]
           [:th "symbol"]
           [:th "rule#"]
           [:th "type"]
           [:th "count"]
           [:th "exp"]
           [:th "stddev"]
           [:th "dir"]
           [:th "pl"]
           [:th "cum-pl"] ]
      (for [t trades]
          [:tr {:key (gen-key)}
            [:td (:year t) ]
            [:td (:month t)]
            [:td (:symbol t)]
            [:td (:rule-number t)]
            [:td (:trade-type t)]
            [:td (:count t)]
            [:td (round-number (:pl-expected t))]
            [:td (round-number (:stddev t))]
            [:td (:trade-dir t)]
            [:td (round-number (:pl-realized t))]
            [:td (round-number (:cum-pl t))]   ])]]])
