(ns seasonality.views.tradesummary
  (:require
    [clojure.string :as string]
    [thi.ng.strf.core :as f]
    [reagent.core :as r]
    [cljss.core :as css]
    [styles.seasonality :as styles]
    [seasonality.views.tradelist :refer [trade-list]]
    [seasonality.views.tradegroup :refer [trade-groups]]))


(defn trade-summary
  "pure component that displays trade summary table and trades"
  [trades]
  [:div
    [trade-groups trades]
    [trade-list trades]
    ])


(comment

(def demo-trades [
     {:symbol "DAX Index" :pl-realized 3.4 :trade-dir "long" :trend "down" :trade-type "cycle" :year 2000 :month 1 :cum-pl 7.1}
     {:symbol "DAX Index" :pl-realized -2.1 :trade-dir "long" :trend "down" :trade-type "cycle" :year 2000 :month 2 :cum-pl 8.3}
     {:symbol "AAX Index" :pl-realized 0.1 :trade-dir "short" :trend "down" :trade-type "cycle" :year 2000 :month 3 :cum-pl 9.1}
     {:symbol "AAX Index" :pl-realized 9.3 :trade-dir "long" :trend "down" :trade-type "cycle" :year 2000 :month 4 :cum-pl 5.044}
     {:symbol "DAX Index" :pl-realized -4.1 :trade-dir "short" :trend "down" :trade-type "cycle" :year 2000 :month 5 :cum-pl 17.12}
     {:symbol "SMI Index" :pl-realized 6.3 :trade-dir "long" :trend "down" :trade-type "cycle" :year 2000 :month 6 :cum-pl 12.123}])

     (add-win-or-loss demo-trades)

     (trade-list demo-trades )

     (vec (map #( assoc {} :symbol (get % 0) :pl (reduce + (map :pl-realized (get % 1))))  (group-by :symbol demo-trades)))
     ; :pl (reduce + (:pl-realized (get 1 %)))

)
