(ns universe.equity-sector
  (:require
    [reagent.core :as r]
    [api.get :refer [get-data]]
    [comp.mui :as mui]
    [comp.mytab :as mytab]
    [comp.table :as table]))

(def app-state
  (r/atom
    {
     :exchange [ ]
     :sector [ ]
     :industry [ ]
     :subindustry [ ]
     :equity-comment "Equities"
     :equity-list [ ]
     }))

(defn update-equity-list! [data]
      (r/rswap! app-state assoc :equity-list data))

(defn update-group  [key data]
      (r/rswap! app-state assoc key data))



(defn get-equity-list []
      (let [ xxx (println "getting equity list.. " )]
        (get-data :universe-equity-list #(do (update-equity-list! %)
                              ;(println "equity-list received: " %)
                              ))))


;; FETCH DATA

(defn get-equity-groups []
  (let [_ (println "getting equity groups.. ")]
    (get-data :universe-equity-groups {:group "$exchange"} #(update-group :exchange %))
    (get-data :universe-equity-groups {:group "$sector"} #(update-group :sector %))
    (get-data :universe-equity-groups {:group "$industry"} #(update-group :industry %))
    (get-data :universe-equity-groups {:group "$subindustry"} #(update-group :subindustry %))))

(defn get-equity-list-specific [category data]
  (println "get-equity-list specific" category data)
  (r/rswap! app-state assoc :equity-comment (str category ": " data))
  (get-data :universe-equity-list {:category (name category) :data data } #(update-group :equity-list %)))



(defn group-paper [category name width members]
  [mui/grid {:item true
             :xs width
             :align :top}
     [:div
       [:h4 name (count members)]
       (map-indexed
         (fn [idx m]
           [:span {:key idx
                   :on-click #(get-equity-list-specific category (:_id m))
                  }
                  (str (:_id m) " (" (:count m) ") " )])
          members)]])


(defn group-table []
      (let [exchange (:exchange @app-state)
            sector (:sector @app-state)
            industry (:industry @app-state)
            subindustry (:subindustry @app-state)
            ]

        [mui/grid {:container   true
                   :align-items :flex-start                 ; :center
                   :spacing     16
                   :xs 12}
         [group-paper :exchange "exchange" 1 exchange]
         [group-paper :sector "sector" 1 sector]
         [group-paper :industry "industry" 3 industry]
         [group-paper :subindustry "sub-industry" 7 subindustry]
         ]
        ))






(defn equity-table [comment equities]
      [mui/paper
       [:h1 (str comment " (" (count equities) ") " )]
       [table/my-table
        [[:symbol "Symbol"]
         [:exchange "Exchange"]
         [:name "Name"]
         [:sector "Sector"]
         [:industry "Industry"]
         [:subindustry "Sub-Industry"]]
         equities]
       ])


(defn equity-page []
      (let [                                                ;xx (get-equity-list)
            xx (get-equity-groups)]
        (fn []
          (let [equities (:equity-list @app-state)
                equities (sort-by :symbol < equities)
                comment (:equity-comment @app-state)
                ]
            [:div
             [group-table]
             (equity-table comment equities)
             ]

            ))
        ))
