(ns web.routes.bloomberg
  (:require
    [schema.core :as s]
    [ring.util.response :as response]
    [ring.util.http-response :refer [ok]]
    [compojure.core :refer :all] ; [compojure.core :refer [defroutes routes]]
    [compojure.route :as route]
    [compojure.api.sweet :as sweet]
    [cheshire.core :refer :all]

    [bloomberg.request.reference :refer [bloomberg-get-reference-data] ]
    [bloomberg.request.search :refer [bloomberg-search]]
  ))

(def bloomberg-routes
  (sweet/context "/api" [] :tags ["bloomberg"]

    (sweet/GET "/bloomberg" []
      :summary "bloomberg reference request"
      ;  :return {:result Long}
      :query-params [symbol :- String, field :- String]
      (ok (bloomberg-get-reference-data {:symbol symbol :field field})))

    (sweet/GET "/instrument-search" []
      :query-params [name]
      (ok (bloomberg-search name) ))


))
