(ns web.routes.demo
  (:require
    [schema.core :as s]
    [ring.util.http-response :refer [ok]]
    [compojure.core :refer :all] ; [compojure.core :refer [defroutes routes]]
    [compojure.route :as route]
    [compojure.api.sweet :as sweet]
    [cheshire.core :refer :all]
    [clj-time.core :as t] ; current time
    ))

(def demo-routes
    (sweet/context "/api" [] :tags ["demo"]

       (sweet/GET "/plus" []
          :summary "adds two numbers together"
          :return {:result Long}
          :query-params [x :- Long, y :- Long]
          (ok {:result (+ x y)}))

        (sweet/GET "/now" []
             :summary "gets current time"
             (ok {:result (t/now)}))



       (sweet/GET "/hello" []
          :query-params [name :- s/Str , {age :- s/Int nil}]
          (if (nil? age) (ok {:message (str "Hello, " name)})
                         (ok {:message (str "Hello, " name " - you look good for " age " years!")})))
))

(comment
   (t/now)

  )
