(ns web.routes.fundamental
  (:require
    [schema.core :as s]
    [ring.util.response :as response]
    [ring.util.http-response :refer [ok]]
    [compojure.core :refer :all] ; [compojure.core :refer [defroutes routes]]
    [compojure.route :as route]
    [compojure.api.sweet :as sweet]
    [cheshire.core :refer :all]

    [mongo.field]
    [job.run :refer [run index]]
    [fundamental.metrics :refer [calculate-metrics-series]]
    [fundamental.table :refer [report-table report-per-share]]
    [fundamental.percentile]
    ))

(def fundamental-routes
  (sweet/context "/api" []  :tags ["fundamental"]

     (sweet/GET "/financial-fields" []
        :query-params []
        (ok (mongo.report/get-report-fields-full)))

     (sweet/GET "/fieldinfo" []
        :query-params [symbol]
        (ok (mongo.field/load-field-info symbol)))

     (sweet/GET "/financials" []
        :query-params [symbol]
        (ok
          (let [nominal (report-table symbol)
                per-share (report-per-share nominal)]
                {:nominal nominal :per-share per-share}
                )))

     (sweet/GET "/series-metrics" []
        :query-params [symbol interval]
        (ring.util.http-response/ok
          (let [series (calculate-metrics-series symbol (keyword interval))
                stats  (fundamental.percentile/metrics-stats-all series)
                ]
            {:series series :stats stats}
            )))

     (sweet/GET "/ratio-stats" []
        :query-params [symbol]
        (ok (run fundamental.percentile/history-ratio-sales symbol index) ))

     (sweet/GET "/ratio-stats-all" []
        :query-params []
        (ok (mongo.stats/browse-stats-info) ))

))
