(ns web.routes.portfoliolist
  (:require
    [schema.core :as s]
    [ring.util.response :as response]
    [ring.util.http-response :refer [ok]]
    [compojure.core :refer :all] ; [compojure.core :refer [defroutes routes]]
    [compojure.route :as route]
    [compojure.api.sweet :as sweet]
    [cheshire.core :refer :all]

    [mongo.portfolio :as mportfolio :refer [list-detailed]]


    ))

(def routes-portfoliolist
   (sweet/context "/api/list" [] :tags ["portfoliolist"]
      ; Portfolio List management

      (sweet/GET "/details" []
        :query-params [symbol-portfolio]
        (ok (list-detailed symbol-portfolio)))

      (sweet/GET "/add" []
        :query-params [symbol-portfolio]
        (ok (do (mongo.portfolio/list-add symbol-portfolio)
                 {:status "Index added"} ) ))

      (sweet/GET "/member-add" []
        :query-params [symbol-portfolio symbol-member]
        (ok (do (mportfolio/portfolio-symbol-add symbol-portfolio symbol-member)
                {:status "Member A added"})))

      (sweet/GET "/member-remove" []
        :query-params [symbol-portfolio symbol-member]
        (ok ( do (mportfolio/portfolio-symbol-remove symbol-portfolio symbol-member)
                 {:status "Member Removed"})))


))
