(ns web.routes.universe
  (:require
    [schema.core :as s]
    [ring.util.response :as response]
    [ring.util.http-response :refer [ok]]
    [compojure.core :refer :all] ; [compojure.core :refer [defroutes routes]]
    [compojure.route :as route]
    [compojure.api.sweet :as sweet]
    [cheshire.core :refer :all]

    [mongo.instrument :refer [search-instrument]]
    [mongo.universe :as muniverse]
    [data.equity-symbol]

    ))

(defn if-empty-default-value- [field default-value]
  (if (nil? field)
      default-value
      (if (= "" field)
          default-value
          field)))

(defn search [query type exchange limit]
  (-> query
      (search-instrument (if-empty-default-value- type "")  (if-empty-default-value- exchange "") limit  )
    ))


(def routes-universe
  (sweet/context "/api" []:tags ["universe"]

      (sweet/GET "/exchanges" []
          :query-params []
          (ok (data.equity-symbol/load-exchanges)  ))

      (sweet/GET "/index-list" [category]
          :query-params []
          (ok (map #(dissoc % :_id) (muniverse/browse-indices category ) ) ))

      (sweet/GET "/equity-list" []
          :query-params [{category :- s/Str nil} {data :- s/Str nil}]
          (if (nil? category)
              (ok (map #(dissoc % :_id) (muniverse/browse-equities)))
              (ok (map #(dissoc % :_id) (muniverse/browse-equities { (keyword category) data})))
            ))

      (sweet/GET "/equity-groups" []
          :query-params [group]
          (ok (muniverse/equity-groups group)))

      (sweet/GET "/instrument" []
          :query-params [symbol]
          (ok (mongo.instrument/load-symbol-safe symbol)))

      (sweet/GET "/search" []
          :query-params [query type exchange limit :- Long]
          (ok (search query type exchange limit)))

))
