(ns aws.auth
  (:require [aws.coerce.to-sdk :refer [->sdk]])
  (:import [software.amazon.awssdk.auth.credentials DefaultCredentialsProvider ProfileCredentialsProvider]
           [software.amazon.awssdk.regions Region]))

(defmethod ->sdk DefaultCredentialsProvider [_ default-credentials-provider]
  (let [{:keys [async-credentials-update-enabled
                reuse-last-provider-enabled]} default-credentials-provider]
    (.build
     (doto (DefaultCredentialsProvider/builder)
       (cond-> async-credentials-update-enabled (.asyncCredentialUpdateEnabled async-credentials-update-enabled)
               reuse-last-provider-enabled (.reuseLastProviderEnabled reuse-last-provider-enabled))))))

(defn default-credentials-provider
  ([] (DefaultCredentialsProvider/create))
  ([options]
   (->sdk DefaultCredentialsProvider options)))


(defmethod ->sdk ProfileCredentialsProvider [_ profile-credentials-provider]
  (let [{:keys [profile-name]} default-credentials-provider]
    (.build
     (doto (ProfileCredentialsProvider/builder)
       (.profileName profile-name)))))

(defn profile-credentials-provider
  ([] (ProfileCredentialsProvider/create))
  ([profile-name]
   (ProfileCredentialsProvider/create profile-name)))


(defn as-region-dispatch-fn [t] (class t))
(defmulti  as-region #'as-region-dispatch-fn)
(defmethod as-region Region [r] r)
(defmethod as-region String [s] (Region/of s))

(defmethod ->sdk Region [_ region]
  (as-region region))
