(ns aws.util)

;; -------
;;  map maintenance
;;
;; -----

(defn mremove
  "Removes entries from a map where `(pred value)` is truthy.
  returns nil if m is nil"
  [pred m] {:pre [(or (nil? m) (map? m))]}
  (when m
    (reduce-kv
     (fn [m k v]
       (if-not (pred v)
         (assoc m k v)
         m))
     {}
     m)))

(def emptyable? (some-fn string? sequential? coll?))
(defn has-no-value? [v]
  (or (nil? v)
      (and (emptyable? v)
           (empty? v))))

(def only-valid-values (partial mremove has-no-value?))
