(ns aws.iam
  (:require [aws.coerce.to-clj :refer [->clj]]
            [aws.coerce.to-sdk :refer [->sdk]]
            [aws.iam.coercion]
            [aws.iam.client :as client])
  (:import [software.amazon.awssdk.services.iam IamClient]
           [software.amazon.awssdk.services.iam.model ListUsersRequest]))

(defn list-users
  ([client] (list-users client {}))
  ([^IamClient client request]
   (let [list-fn (fn [req]
                   (->clj (.listUsers client ^ListUsersRequest (->sdk ListUsersRequest req))))

         next-batch-fn (fn [{:keys [is-truncated marker] :as response}]
                         (when is-truncated
                           (list-fn (assoc request :marker marker))))]

     (->>  (list-fn request)
           (iterate next-batch-fn)
           (take-while (complement nil?))
           (mapcat :users)))))
