(ns aws.iam.client
  (:require [aws.auth :as auth]
            [aws.client]
            [aws.coerce.to-sdk :refer [->sdk]])
  (:import [software.amazon.awssdk.core.client.config ClientOverrideConfiguration]
           [software.amazon.awssdk.http SdkHttpClient]
           [software.amazon.awssdk.http.apache ApacheHttpClient]
           [software.amazon.awssdk.regions Region]
           [software.amazon.awssdk.services.iam IamClient]))

(defmethod ->sdk IamClient [_ iam-client]
  (let [{:keys [http-client
                credentials-provider
                endpoint-override
                override-configuration
                region]
         :or {credentials-provider (auth/default-credentials-provider)}} iam-client]
    (.build
     (doto (IamClient/builder)
       (.credentialsProvider credentials-provider)
       (cond-> http-client (.httpClient ^SdkHttpClient (->sdk ApacheHttpClient http-client)))
       (cond-> region (.region (->sdk Region region)))
       (cond-> endpoint-override (.endpointOverride endpoint-override))
       (cond-> override-configuration (.overrideConfiguration ^ClientOverrideConfiguration (->sdk ClientOverrideConfiguration override-configuration)))))))

(defn ^IamClient create
  ([] (create {}))
  ([{:keys [region] :or {region "aws-global"} :as options}]
   (->sdk IamClient (assoc options :region region))))
