(ns aws.sts.coercion
  (:require [aws.coerce.to-clj :refer [->clj]]
            [aws.coerce.to-sdk :refer [->sdk]]
            [aws.util :as u])
  (:import [software.amazon.awssdk.services.sts.model GetCallerIdentityResponse]))

;; ----
;; to clojure
;;
;; ----

(extend-type GetCallerIdentityResponse
  aws.coerce.to-clj/ToClojure
  (to-clj [response]
    (u/only-valid-values
     {:account (.account response)
      :arn (.arn response)
      :user-id (.userId response)})))

;; ----
;; to sdk
;;
;; ---
