(ns aws.sts
  (:require [aws.coerce.to-clj :refer [->clj]]
            [aws.coerce.to-sdk :refer [->sdk]]
            [aws.sts.coercion])
  (:import [software.amazon.awssdk.services.sts StsClient]))

(defn ^StsClient client
  ([] (client {}))
  ([options]
   (->sdk StsClient options)))

(defn get-caller-identity [^StsClient client]
  (->clj (.getCallerIdentity client)))
