(ns aws.sts.coercion
  (:require [aws.auth :as auth]
            [aws.client]
            [aws.coerce.to-clj :refer [->clj]]
            [aws.coerce.to-sdk :refer [->sdk]]
            [aws.util :as u])
  (:import [software.amazon.awssdk.core.client.config ClientOverrideConfiguration]
           [software.amazon.awssdk.http SdkHttpClient]
           [software.amazon.awssdk.http.apache ApacheHttpClient]
           [software.amazon.awssdk.regions Region]
           [software.amazon.awssdk.services.sts StsClient]
           [software.amazon.awssdk.services.sts.model GetCallerIdentityResponse]))
;; ----
;; client
;;
;; ----

(defmethod ->sdk StsClient [_ sts-client]
  (let [{:keys [http-client
                credentials-provider
                endpoint-override
                override-configuration
                region]
         :or {credentials-provider (auth/default-credentials-provider)}} sts-client]
    (.build
     (doto (StsClient/builder)
       (.credentialsProvider credentials-provider)
       (cond-> http-client (.httpClient ^SdkHttpClient (->sdk ApacheHttpClient http-client)))
       (cond-> region (.region (->sdk Region region)))
       (cond-> endpoint-override (.endpointOverride endpoint-override))
       (cond-> override-configuration (.overrideConfiguration ^ClientOverrideConfiguration (->sdk ClientOverrideConfiguration override-configuration)))))))

;; ----
;; to clojure
;;
;; ----

(extend-type GetCallerIdentityResponse
  aws.coerce.to-clj/ToClojure
  (to-clj [response]
    (u/only-valid-values
     {:account (.account response)
      :arn (.arn response)
      :user-id (.userId response)})))

;; ----
;; to sdk
;;
;; ---
