// Compiled by ClojureScript 1.9.671 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__31250 = arguments.length;
switch (G__31250) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async31251 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31251 = (function (f,blockable,meta31252){
this.f = f;
this.blockable = blockable;
this.meta31252 = meta31252;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async31251.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31253,meta31252__$1){
var self__ = this;
var _31253__$1 = this;
return (new cljs.core.async.t_cljs$core$async31251(self__.f,self__.blockable,meta31252__$1));
});

cljs.core.async.t_cljs$core$async31251.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31253){
var self__ = this;
var _31253__$1 = this;
return self__.meta31252;
});

cljs.core.async.t_cljs$core$async31251.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31251.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async31251.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async31251.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async31251.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta31252","meta31252",-2136764888,null)], null);
});

cljs.core.async.t_cljs$core$async31251.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31251.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31251";

cljs.core.async.t_cljs$core$async31251.cljs$lang$ctorPrWriter = (function (this__27007__auto__,writer__27008__auto__,opt__27009__auto__){
return cljs.core._write.call(null,writer__27008__auto__,"cljs.core.async/t_cljs$core$async31251");
});

cljs.core.async.__GT_t_cljs$core$async31251 = (function cljs$core$async$__GT_t_cljs$core$async31251(f__$1,blockable__$1,meta31252){
return (new cljs.core.async.t_cljs$core$async31251(f__$1,blockable__$1,meta31252));
});

}

return (new cljs.core.async.t_cljs$core$async31251(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__31257 = arguments.length;
switch (G__31257) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buffer must be supplied when transducer is"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__31260 = arguments.length;
switch (G__31260) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__31263 = arguments.length;
switch (G__31263) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_31265 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_31265);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_31265,ret){
return (function (){
return fn1.call(null,val_31265);
});})(val_31265,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__31267 = arguments.length;
switch (G__31267) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__27320__auto___31269 = n;
var x_31270 = (0);
while(true){
if((x_31270 < n__27320__auto___31269)){
(a[x_31270] = (0));

var G__31271 = (x_31270 + (1));
x_31270 = G__31271;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__31272 = (i + (1));
i = G__31272;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async31273 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31273 = (function (flag,meta31274){
this.flag = flag;
this.meta31274 = meta31274;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async31273.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_31275,meta31274__$1){
var self__ = this;
var _31275__$1 = this;
return (new cljs.core.async.t_cljs$core$async31273(self__.flag,meta31274__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async31273.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_31275){
var self__ = this;
var _31275__$1 = this;
return self__.meta31274;
});})(flag))
;

cljs.core.async.t_cljs$core$async31273.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31273.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async31273.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async31273.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async31273.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta31274","meta31274",-1491179612,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async31273.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31273.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31273";

cljs.core.async.t_cljs$core$async31273.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__27007__auto__,writer__27008__auto__,opt__27009__auto__){
return cljs.core._write.call(null,writer__27008__auto__,"cljs.core.async/t_cljs$core$async31273");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async31273 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async31273(flag__$1,meta31274){
return (new cljs.core.async.t_cljs$core$async31273(flag__$1,meta31274));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async31273(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async31276 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31276 = (function (flag,cb,meta31277){
this.flag = flag;
this.cb = cb;
this.meta31277 = meta31277;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async31276.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31278,meta31277__$1){
var self__ = this;
var _31278__$1 = this;
return (new cljs.core.async.t_cljs$core$async31276(self__.flag,self__.cb,meta31277__$1));
});

cljs.core.async.t_cljs$core$async31276.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31278){
var self__ = this;
var _31278__$1 = this;
return self__.meta31277;
});

cljs.core.async.t_cljs$core$async31276.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31276.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async31276.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async31276.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async31276.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta31277","meta31277",236363161,null)], null);
});

cljs.core.async.t_cljs$core$async31276.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31276.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31276";

cljs.core.async.t_cljs$core$async31276.cljs$lang$ctorPrWriter = (function (this__27007__auto__,writer__27008__auto__,opt__27009__auto__){
return cljs.core._write.call(null,writer__27008__auto__,"cljs.core.async/t_cljs$core$async31276");
});

cljs.core.async.__GT_t_cljs$core$async31276 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async31276(flag__$1,cb__$1,meta31277){
return (new cljs.core.async.t_cljs$core$async31276(flag__$1,cb__$1,meta31277));
});

}

return (new cljs.core.async.t_cljs$core$async31276(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31279_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31279_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31280_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31280_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__26396__auto__ = wport;
if(cljs.core.truth_(or__26396__auto__)){
return or__26396__auto__;
} else {
return port;
}
})()], null));
} else {
var G__31281 = (i + (1));
i = G__31281;
continue;
}
} else {
return null;
}
break;
}
})();
var or__26396__auto__ = ret;
if(cljs.core.truth_(or__26396__auto__)){
return or__26396__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__26384__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__26384__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__26384__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__27528__auto__ = [];
var len__27521__auto___31287 = arguments.length;
var i__27522__auto___31288 = (0);
while(true){
if((i__27522__auto___31288 < len__27521__auto___31287)){
args__27528__auto__.push((arguments[i__27522__auto___31288]));

var G__31289 = (i__27522__auto___31288 + (1));
i__27522__auto___31288 = G__31289;
continue;
} else {
}
break;
}

var argseq__27529__auto__ = ((((1) < args__27528__auto__.length))?(new cljs.core.IndexedSeq(args__27528__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__27529__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__31284){
var map__31285 = p__31284;
var map__31285__$1 = ((((!((map__31285 == null)))?((((map__31285.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31285.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31285):map__31285);
var opts = map__31285__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq31282){
var G__31283 = cljs.core.first.call(null,seq31282);
var seq31282__$1 = cljs.core.next.call(null,seq31282);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__31283,seq31282__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__31291 = arguments.length;
switch (G__31291) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__31204__auto___31337 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31204__auto___31337){
return (function (){
var f__31205__auto__ = (function (){var switch__31116__auto__ = ((function (c__31204__auto___31337){
return (function (state_31315){
var state_val_31316 = (state_31315[(1)]);
if((state_val_31316 === (7))){
var inst_31311 = (state_31315[(2)]);
var state_31315__$1 = state_31315;
var statearr_31317_31338 = state_31315__$1;
(statearr_31317_31338[(2)] = inst_31311);

(statearr_31317_31338[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31316 === (1))){
var state_31315__$1 = state_31315;
var statearr_31318_31339 = state_31315__$1;
(statearr_31318_31339[(2)] = null);

(statearr_31318_31339[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31316 === (4))){
var inst_31294 = (state_31315[(7)]);
var inst_31294__$1 = (state_31315[(2)]);
var inst_31295 = (inst_31294__$1 == null);
var state_31315__$1 = (function (){var statearr_31319 = state_31315;
(statearr_31319[(7)] = inst_31294__$1);

return statearr_31319;
})();
if(cljs.core.truth_(inst_31295)){
var statearr_31320_31340 = state_31315__$1;
(statearr_31320_31340[(1)] = (5));

} else {
var statearr_31321_31341 = state_31315__$1;
(statearr_31321_31341[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31316 === (13))){
var state_31315__$1 = state_31315;
var statearr_31322_31342 = state_31315__$1;
(statearr_31322_31342[(2)] = null);

(statearr_31322_31342[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31316 === (6))){
var inst_31294 = (state_31315[(7)]);
var state_31315__$1 = state_31315;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31315__$1,(11),to,inst_31294);
} else {
if((state_val_31316 === (3))){
var inst_31313 = (state_31315[(2)]);
var state_31315__$1 = state_31315;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31315__$1,inst_31313);
} else {
if((state_val_31316 === (12))){
var state_31315__$1 = state_31315;
var statearr_31323_31343 = state_31315__$1;
(statearr_31323_31343[(2)] = null);

(statearr_31323_31343[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31316 === (2))){
var state_31315__$1 = state_31315;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31315__$1,(4),from);
} else {
if((state_val_31316 === (11))){
var inst_31304 = (state_31315[(2)]);
var state_31315__$1 = state_31315;
if(cljs.core.truth_(inst_31304)){
var statearr_31324_31344 = state_31315__$1;
(statearr_31324_31344[(1)] = (12));

} else {
var statearr_31325_31345 = state_31315__$1;
(statearr_31325_31345[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31316 === (9))){
var state_31315__$1 = state_31315;
var statearr_31326_31346 = state_31315__$1;
(statearr_31326_31346[(2)] = null);

(statearr_31326_31346[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31316 === (5))){
var state_31315__$1 = state_31315;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31327_31347 = state_31315__$1;
(statearr_31327_31347[(1)] = (8));

} else {
var statearr_31328_31348 = state_31315__$1;
(statearr_31328_31348[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31316 === (14))){
var inst_31309 = (state_31315[(2)]);
var state_31315__$1 = state_31315;
var statearr_31329_31349 = state_31315__$1;
(statearr_31329_31349[(2)] = inst_31309);

(statearr_31329_31349[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31316 === (10))){
var inst_31301 = (state_31315[(2)]);
var state_31315__$1 = state_31315;
var statearr_31330_31350 = state_31315__$1;
(statearr_31330_31350[(2)] = inst_31301);

(statearr_31330_31350[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31316 === (8))){
var inst_31298 = cljs.core.async.close_BANG_.call(null,to);
var state_31315__$1 = state_31315;
var statearr_31331_31351 = state_31315__$1;
(statearr_31331_31351[(2)] = inst_31298);

(statearr_31331_31351[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31204__auto___31337))
;
return ((function (switch__31116__auto__,c__31204__auto___31337){
return (function() {
var cljs$core$async$state_machine__31117__auto__ = null;
var cljs$core$async$state_machine__31117__auto____0 = (function (){
var statearr_31332 = [null,null,null,null,null,null,null,null];
(statearr_31332[(0)] = cljs$core$async$state_machine__31117__auto__);

(statearr_31332[(1)] = (1));

return statearr_31332;
});
var cljs$core$async$state_machine__31117__auto____1 = (function (state_31315){
while(true){
var ret_value__31118__auto__ = (function (){try{while(true){
var result__31119__auto__ = switch__31116__auto__.call(null,state_31315);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31119__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31119__auto__;
}
break;
}
}catch (e31333){if((e31333 instanceof Object)){
var ex__31120__auto__ = e31333;
var statearr_31334_31352 = state_31315;
(statearr_31334_31352[(5)] = ex__31120__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31315);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31333;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31118__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31353 = state_31315;
state_31315 = G__31353;
continue;
} else {
return ret_value__31118__auto__;
}
break;
}
});
cljs$core$async$state_machine__31117__auto__ = function(state_31315){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31117__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31117__auto____1.call(this,state_31315);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31117__auto____0;
cljs$core$async$state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31117__auto____1;
return cljs$core$async$state_machine__31117__auto__;
})()
;})(switch__31116__auto__,c__31204__auto___31337))
})();
var state__31206__auto__ = (function (){var statearr_31335 = f__31205__auto__.call(null);
(statearr_31335[(6)] = c__31204__auto___31337);

return statearr_31335;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31206__auto__);
});})(c__31204__auto___31337))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__31354){
var vec__31355 = p__31354;
var v = cljs.core.nth.call(null,vec__31355,(0),null);
var p = cljs.core.nth.call(null,vec__31355,(1),null);
var job = vec__31355;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__31204__auto___31526 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31204__auto___31526,res,vec__31355,v,p,job,jobs,results){
return (function (){
var f__31205__auto__ = (function (){var switch__31116__auto__ = ((function (c__31204__auto___31526,res,vec__31355,v,p,job,jobs,results){
return (function (state_31362){
var state_val_31363 = (state_31362[(1)]);
if((state_val_31363 === (1))){
var state_31362__$1 = state_31362;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31362__$1,(2),res,v);
} else {
if((state_val_31363 === (2))){
var inst_31359 = (state_31362[(2)]);
var inst_31360 = cljs.core.async.close_BANG_.call(null,res);
var state_31362__$1 = (function (){var statearr_31364 = state_31362;
(statearr_31364[(7)] = inst_31359);

return statearr_31364;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31362__$1,inst_31360);
} else {
return null;
}
}
});})(c__31204__auto___31526,res,vec__31355,v,p,job,jobs,results))
;
return ((function (switch__31116__auto__,c__31204__auto___31526,res,vec__31355,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31117__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31117__auto____0 = (function (){
var statearr_31365 = [null,null,null,null,null,null,null,null];
(statearr_31365[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31117__auto__);

(statearr_31365[(1)] = (1));

return statearr_31365;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31117__auto____1 = (function (state_31362){
while(true){
var ret_value__31118__auto__ = (function (){try{while(true){
var result__31119__auto__ = switch__31116__auto__.call(null,state_31362);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31119__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31119__auto__;
}
break;
}
}catch (e31366){if((e31366 instanceof Object)){
var ex__31120__auto__ = e31366;
var statearr_31367_31527 = state_31362;
(statearr_31367_31527[(5)] = ex__31120__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31362);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31366;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31118__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31528 = state_31362;
state_31362 = G__31528;
continue;
} else {
return ret_value__31118__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31117__auto__ = function(state_31362){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31117__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31117__auto____1.call(this,state_31362);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31117__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31117__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31117__auto__;
})()
;})(switch__31116__auto__,c__31204__auto___31526,res,vec__31355,v,p,job,jobs,results))
})();
var state__31206__auto__ = (function (){var statearr_31368 = f__31205__auto__.call(null);
(statearr_31368[(6)] = c__31204__auto___31526);

return statearr_31368;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31206__auto__);
});})(c__31204__auto___31526,res,vec__31355,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__31369){
var vec__31370 = p__31369;
var v = cljs.core.nth.call(null,vec__31370,(0),null);
var p = cljs.core.nth.call(null,vec__31370,(1),null);
var job = vec__31370;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__27320__auto___31529 = n;
var __31530 = (0);
while(true){
if((__31530 < n__27320__auto___31529)){
var G__31373_31531 = type;
var G__31373_31532__$1 = (((G__31373_31531 instanceof cljs.core.Keyword))?G__31373_31531.fqn:null);
switch (G__31373_31532__$1) {
case "compute":
var c__31204__auto___31534 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__31530,c__31204__auto___31534,G__31373_31531,G__31373_31532__$1,n__27320__auto___31529,jobs,results,process,async){
return (function (){
var f__31205__auto__ = (function (){var switch__31116__auto__ = ((function (__31530,c__31204__auto___31534,G__31373_31531,G__31373_31532__$1,n__27320__auto___31529,jobs,results,process,async){
return (function (state_31386){
var state_val_31387 = (state_31386[(1)]);
if((state_val_31387 === (1))){
var state_31386__$1 = state_31386;
var statearr_31388_31535 = state_31386__$1;
(statearr_31388_31535[(2)] = null);

(statearr_31388_31535[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31387 === (2))){
var state_31386__$1 = state_31386;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31386__$1,(4),jobs);
} else {
if((state_val_31387 === (3))){
var inst_31384 = (state_31386[(2)]);
var state_31386__$1 = state_31386;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31386__$1,inst_31384);
} else {
if((state_val_31387 === (4))){
var inst_31376 = (state_31386[(2)]);
var inst_31377 = process.call(null,inst_31376);
var state_31386__$1 = state_31386;
if(cljs.core.truth_(inst_31377)){
var statearr_31389_31536 = state_31386__$1;
(statearr_31389_31536[(1)] = (5));

} else {
var statearr_31390_31537 = state_31386__$1;
(statearr_31390_31537[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31387 === (5))){
var state_31386__$1 = state_31386;
var statearr_31391_31538 = state_31386__$1;
(statearr_31391_31538[(2)] = null);

(statearr_31391_31538[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31387 === (6))){
var state_31386__$1 = state_31386;
var statearr_31392_31539 = state_31386__$1;
(statearr_31392_31539[(2)] = null);

(statearr_31392_31539[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31387 === (7))){
var inst_31382 = (state_31386[(2)]);
var state_31386__$1 = state_31386;
var statearr_31393_31540 = state_31386__$1;
(statearr_31393_31540[(2)] = inst_31382);

(statearr_31393_31540[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__31530,c__31204__auto___31534,G__31373_31531,G__31373_31532__$1,n__27320__auto___31529,jobs,results,process,async))
;
return ((function (__31530,switch__31116__auto__,c__31204__auto___31534,G__31373_31531,G__31373_31532__$1,n__27320__auto___31529,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31117__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31117__auto____0 = (function (){
var statearr_31394 = [null,null,null,null,null,null,null];
(statearr_31394[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31117__auto__);

(statearr_31394[(1)] = (1));

return statearr_31394;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31117__auto____1 = (function (state_31386){
while(true){
var ret_value__31118__auto__ = (function (){try{while(true){
var result__31119__auto__ = switch__31116__auto__.call(null,state_31386);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31119__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31119__auto__;
}
break;
}
}catch (e31395){if((e31395 instanceof Object)){
var ex__31120__auto__ = e31395;
var statearr_31396_31541 = state_31386;
(statearr_31396_31541[(5)] = ex__31120__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31386);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31395;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31118__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31542 = state_31386;
state_31386 = G__31542;
continue;
} else {
return ret_value__31118__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31117__auto__ = function(state_31386){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31117__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31117__auto____1.call(this,state_31386);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31117__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31117__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31117__auto__;
})()
;})(__31530,switch__31116__auto__,c__31204__auto___31534,G__31373_31531,G__31373_31532__$1,n__27320__auto___31529,jobs,results,process,async))
})();
var state__31206__auto__ = (function (){var statearr_31397 = f__31205__auto__.call(null);
(statearr_31397[(6)] = c__31204__auto___31534);

return statearr_31397;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31206__auto__);
});})(__31530,c__31204__auto___31534,G__31373_31531,G__31373_31532__$1,n__27320__auto___31529,jobs,results,process,async))
);


break;
case "async":
var c__31204__auto___31543 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__31530,c__31204__auto___31543,G__31373_31531,G__31373_31532__$1,n__27320__auto___31529,jobs,results,process,async){
return (function (){
var f__31205__auto__ = (function (){var switch__31116__auto__ = ((function (__31530,c__31204__auto___31543,G__31373_31531,G__31373_31532__$1,n__27320__auto___31529,jobs,results,process,async){
return (function (state_31410){
var state_val_31411 = (state_31410[(1)]);
if((state_val_31411 === (1))){
var state_31410__$1 = state_31410;
var statearr_31412_31544 = state_31410__$1;
(statearr_31412_31544[(2)] = null);

(statearr_31412_31544[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31411 === (2))){
var state_31410__$1 = state_31410;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31410__$1,(4),jobs);
} else {
if((state_val_31411 === (3))){
var inst_31408 = (state_31410[(2)]);
var state_31410__$1 = state_31410;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31410__$1,inst_31408);
} else {
if((state_val_31411 === (4))){
var inst_31400 = (state_31410[(2)]);
var inst_31401 = async.call(null,inst_31400);
var state_31410__$1 = state_31410;
if(cljs.core.truth_(inst_31401)){
var statearr_31413_31545 = state_31410__$1;
(statearr_31413_31545[(1)] = (5));

} else {
var statearr_31414_31546 = state_31410__$1;
(statearr_31414_31546[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31411 === (5))){
var state_31410__$1 = state_31410;
var statearr_31415_31547 = state_31410__$1;
(statearr_31415_31547[(2)] = null);

(statearr_31415_31547[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31411 === (6))){
var state_31410__$1 = state_31410;
var statearr_31416_31548 = state_31410__$1;
(statearr_31416_31548[(2)] = null);

(statearr_31416_31548[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31411 === (7))){
var inst_31406 = (state_31410[(2)]);
var state_31410__$1 = state_31410;
var statearr_31417_31549 = state_31410__$1;
(statearr_31417_31549[(2)] = inst_31406);

(statearr_31417_31549[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__31530,c__31204__auto___31543,G__31373_31531,G__31373_31532__$1,n__27320__auto___31529,jobs,results,process,async))
;
return ((function (__31530,switch__31116__auto__,c__31204__auto___31543,G__31373_31531,G__31373_31532__$1,n__27320__auto___31529,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31117__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31117__auto____0 = (function (){
var statearr_31418 = [null,null,null,null,null,null,null];
(statearr_31418[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31117__auto__);

(statearr_31418[(1)] = (1));

return statearr_31418;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31117__auto____1 = (function (state_31410){
while(true){
var ret_value__31118__auto__ = (function (){try{while(true){
var result__31119__auto__ = switch__31116__auto__.call(null,state_31410);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31119__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31119__auto__;
}
break;
}
}catch (e31419){if((e31419 instanceof Object)){
var ex__31120__auto__ = e31419;
var statearr_31420_31550 = state_31410;
(statearr_31420_31550[(5)] = ex__31120__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31410);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31419;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31118__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31551 = state_31410;
state_31410 = G__31551;
continue;
} else {
return ret_value__31118__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31117__auto__ = function(state_31410){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31117__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31117__auto____1.call(this,state_31410);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31117__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31117__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31117__auto__;
})()
;})(__31530,switch__31116__auto__,c__31204__auto___31543,G__31373_31531,G__31373_31532__$1,n__27320__auto___31529,jobs,results,process,async))
})();
var state__31206__auto__ = (function (){var statearr_31421 = f__31205__auto__.call(null);
(statearr_31421[(6)] = c__31204__auto___31543);

return statearr_31421;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31206__auto__);
});})(__31530,c__31204__auto___31543,G__31373_31531,G__31373_31532__$1,n__27320__auto___31529,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__31373_31532__$1)].join('')));

}

var G__31552 = (__31530 + (1));
__31530 = G__31552;
continue;
} else {
}
break;
}

var c__31204__auto___31553 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31204__auto___31553,jobs,results,process,async){
return (function (){
var f__31205__auto__ = (function (){var switch__31116__auto__ = ((function (c__31204__auto___31553,jobs,results,process,async){
return (function (state_31443){
var state_val_31444 = (state_31443[(1)]);
if((state_val_31444 === (1))){
var state_31443__$1 = state_31443;
var statearr_31445_31554 = state_31443__$1;
(statearr_31445_31554[(2)] = null);

(statearr_31445_31554[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31444 === (2))){
var state_31443__$1 = state_31443;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31443__$1,(4),from);
} else {
if((state_val_31444 === (3))){
var inst_31441 = (state_31443[(2)]);
var state_31443__$1 = state_31443;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31443__$1,inst_31441);
} else {
if((state_val_31444 === (4))){
var inst_31424 = (state_31443[(7)]);
var inst_31424__$1 = (state_31443[(2)]);
var inst_31425 = (inst_31424__$1 == null);
var state_31443__$1 = (function (){var statearr_31446 = state_31443;
(statearr_31446[(7)] = inst_31424__$1);

return statearr_31446;
})();
if(cljs.core.truth_(inst_31425)){
var statearr_31447_31555 = state_31443__$1;
(statearr_31447_31555[(1)] = (5));

} else {
var statearr_31448_31556 = state_31443__$1;
(statearr_31448_31556[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31444 === (5))){
var inst_31427 = cljs.core.async.close_BANG_.call(null,jobs);
var state_31443__$1 = state_31443;
var statearr_31449_31557 = state_31443__$1;
(statearr_31449_31557[(2)] = inst_31427);

(statearr_31449_31557[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31444 === (6))){
var inst_31429 = (state_31443[(8)]);
var inst_31424 = (state_31443[(7)]);
var inst_31429__$1 = cljs.core.async.chan.call(null,(1));
var inst_31430 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31431 = [inst_31424,inst_31429__$1];
var inst_31432 = (new cljs.core.PersistentVector(null,2,(5),inst_31430,inst_31431,null));
var state_31443__$1 = (function (){var statearr_31450 = state_31443;
(statearr_31450[(8)] = inst_31429__$1);

return statearr_31450;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31443__$1,(8),jobs,inst_31432);
} else {
if((state_val_31444 === (7))){
var inst_31439 = (state_31443[(2)]);
var state_31443__$1 = state_31443;
var statearr_31451_31558 = state_31443__$1;
(statearr_31451_31558[(2)] = inst_31439);

(statearr_31451_31558[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31444 === (8))){
var inst_31429 = (state_31443[(8)]);
var inst_31434 = (state_31443[(2)]);
var state_31443__$1 = (function (){var statearr_31452 = state_31443;
(statearr_31452[(9)] = inst_31434);

return statearr_31452;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31443__$1,(9),results,inst_31429);
} else {
if((state_val_31444 === (9))){
var inst_31436 = (state_31443[(2)]);
var state_31443__$1 = (function (){var statearr_31453 = state_31443;
(statearr_31453[(10)] = inst_31436);

return statearr_31453;
})();
var statearr_31454_31559 = state_31443__$1;
(statearr_31454_31559[(2)] = null);

(statearr_31454_31559[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__31204__auto___31553,jobs,results,process,async))
;
return ((function (switch__31116__auto__,c__31204__auto___31553,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31117__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31117__auto____0 = (function (){
var statearr_31455 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31455[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31117__auto__);

(statearr_31455[(1)] = (1));

return statearr_31455;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31117__auto____1 = (function (state_31443){
while(true){
var ret_value__31118__auto__ = (function (){try{while(true){
var result__31119__auto__ = switch__31116__auto__.call(null,state_31443);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31119__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31119__auto__;
}
break;
}
}catch (e31456){if((e31456 instanceof Object)){
var ex__31120__auto__ = e31456;
var statearr_31457_31560 = state_31443;
(statearr_31457_31560[(5)] = ex__31120__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31443);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31456;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31118__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31561 = state_31443;
state_31443 = G__31561;
continue;
} else {
return ret_value__31118__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31117__auto__ = function(state_31443){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31117__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31117__auto____1.call(this,state_31443);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31117__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31117__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31117__auto__;
})()
;})(switch__31116__auto__,c__31204__auto___31553,jobs,results,process,async))
})();
var state__31206__auto__ = (function (){var statearr_31458 = f__31205__auto__.call(null);
(statearr_31458[(6)] = c__31204__auto___31553);

return statearr_31458;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31206__auto__);
});})(c__31204__auto___31553,jobs,results,process,async))
);


var c__31204__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31204__auto__,jobs,results,process,async){
return (function (){
var f__31205__auto__ = (function (){var switch__31116__auto__ = ((function (c__31204__auto__,jobs,results,process,async){
return (function (state_31496){
var state_val_31497 = (state_31496[(1)]);
if((state_val_31497 === (7))){
var inst_31492 = (state_31496[(2)]);
var state_31496__$1 = state_31496;
var statearr_31498_31562 = state_31496__$1;
(statearr_31498_31562[(2)] = inst_31492);

(statearr_31498_31562[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31497 === (20))){
var state_31496__$1 = state_31496;
var statearr_31499_31563 = state_31496__$1;
(statearr_31499_31563[(2)] = null);

(statearr_31499_31563[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31497 === (1))){
var state_31496__$1 = state_31496;
var statearr_31500_31564 = state_31496__$1;
(statearr_31500_31564[(2)] = null);

(statearr_31500_31564[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31497 === (4))){
var inst_31461 = (state_31496[(7)]);
var inst_31461__$1 = (state_31496[(2)]);
var inst_31462 = (inst_31461__$1 == null);
var state_31496__$1 = (function (){var statearr_31501 = state_31496;
(statearr_31501[(7)] = inst_31461__$1);

return statearr_31501;
})();
if(cljs.core.truth_(inst_31462)){
var statearr_31502_31565 = state_31496__$1;
(statearr_31502_31565[(1)] = (5));

} else {
var statearr_31503_31566 = state_31496__$1;
(statearr_31503_31566[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31497 === (15))){
var inst_31474 = (state_31496[(8)]);
var state_31496__$1 = state_31496;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31496__$1,(18),to,inst_31474);
} else {
if((state_val_31497 === (21))){
var inst_31487 = (state_31496[(2)]);
var state_31496__$1 = state_31496;
var statearr_31504_31567 = state_31496__$1;
(statearr_31504_31567[(2)] = inst_31487);

(statearr_31504_31567[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31497 === (13))){
var inst_31489 = (state_31496[(2)]);
var state_31496__$1 = (function (){var statearr_31505 = state_31496;
(statearr_31505[(9)] = inst_31489);

return statearr_31505;
})();
var statearr_31506_31568 = state_31496__$1;
(statearr_31506_31568[(2)] = null);

(statearr_31506_31568[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31497 === (6))){
var inst_31461 = (state_31496[(7)]);
var state_31496__$1 = state_31496;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31496__$1,(11),inst_31461);
} else {
if((state_val_31497 === (17))){
var inst_31482 = (state_31496[(2)]);
var state_31496__$1 = state_31496;
if(cljs.core.truth_(inst_31482)){
var statearr_31507_31569 = state_31496__$1;
(statearr_31507_31569[(1)] = (19));

} else {
var statearr_31508_31570 = state_31496__$1;
(statearr_31508_31570[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31497 === (3))){
var inst_31494 = (state_31496[(2)]);
var state_31496__$1 = state_31496;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31496__$1,inst_31494);
} else {
if((state_val_31497 === (12))){
var inst_31471 = (state_31496[(10)]);
var state_31496__$1 = state_31496;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31496__$1,(14),inst_31471);
} else {
if((state_val_31497 === (2))){
var state_31496__$1 = state_31496;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31496__$1,(4),results);
} else {
if((state_val_31497 === (19))){
var state_31496__$1 = state_31496;
var statearr_31509_31571 = state_31496__$1;
(statearr_31509_31571[(2)] = null);

(statearr_31509_31571[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31497 === (11))){
var inst_31471 = (state_31496[(2)]);
var state_31496__$1 = (function (){var statearr_31510 = state_31496;
(statearr_31510[(10)] = inst_31471);

return statearr_31510;
})();
var statearr_31511_31572 = state_31496__$1;
(statearr_31511_31572[(2)] = null);

(statearr_31511_31572[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31497 === (9))){
var state_31496__$1 = state_31496;
var statearr_31512_31573 = state_31496__$1;
(statearr_31512_31573[(2)] = null);

(statearr_31512_31573[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31497 === (5))){
var state_31496__$1 = state_31496;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31513_31574 = state_31496__$1;
(statearr_31513_31574[(1)] = (8));

} else {
var statearr_31514_31575 = state_31496__$1;
(statearr_31514_31575[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31497 === (14))){
var inst_31476 = (state_31496[(11)]);
var inst_31474 = (state_31496[(8)]);
var inst_31474__$1 = (state_31496[(2)]);
var inst_31475 = (inst_31474__$1 == null);
var inst_31476__$1 = cljs.core.not.call(null,inst_31475);
var state_31496__$1 = (function (){var statearr_31515 = state_31496;
(statearr_31515[(11)] = inst_31476__$1);

(statearr_31515[(8)] = inst_31474__$1);

return statearr_31515;
})();
if(inst_31476__$1){
var statearr_31516_31576 = state_31496__$1;
(statearr_31516_31576[(1)] = (15));

} else {
var statearr_31517_31577 = state_31496__$1;
(statearr_31517_31577[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31497 === (16))){
var inst_31476 = (state_31496[(11)]);
var state_31496__$1 = state_31496;
var statearr_31518_31578 = state_31496__$1;
(statearr_31518_31578[(2)] = inst_31476);

(statearr_31518_31578[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31497 === (10))){
var inst_31468 = (state_31496[(2)]);
var state_31496__$1 = state_31496;
var statearr_31519_31579 = state_31496__$1;
(statearr_31519_31579[(2)] = inst_31468);

(statearr_31519_31579[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31497 === (18))){
var inst_31479 = (state_31496[(2)]);
var state_31496__$1 = state_31496;
var statearr_31520_31580 = state_31496__$1;
(statearr_31520_31580[(2)] = inst_31479);

(statearr_31520_31580[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31497 === (8))){
var inst_31465 = cljs.core.async.close_BANG_.call(null,to);
var state_31496__$1 = state_31496;
var statearr_31521_31581 = state_31496__$1;
(statearr_31521_31581[(2)] = inst_31465);

(statearr_31521_31581[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31204__auto__,jobs,results,process,async))
;
return ((function (switch__31116__auto__,c__31204__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31117__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31117__auto____0 = (function (){
var statearr_31522 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31522[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31117__auto__);

(statearr_31522[(1)] = (1));

return statearr_31522;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31117__auto____1 = (function (state_31496){
while(true){
var ret_value__31118__auto__ = (function (){try{while(true){
var result__31119__auto__ = switch__31116__auto__.call(null,state_31496);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31119__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31119__auto__;
}
break;
}
}catch (e31523){if((e31523 instanceof Object)){
var ex__31120__auto__ = e31523;
var statearr_31524_31582 = state_31496;
(statearr_31524_31582[(5)] = ex__31120__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31496);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31523;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31118__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31583 = state_31496;
state_31496 = G__31583;
continue;
} else {
return ret_value__31118__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31117__auto__ = function(state_31496){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31117__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31117__auto____1.call(this,state_31496);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31117__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31117__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31117__auto__;
})()
;})(switch__31116__auto__,c__31204__auto__,jobs,results,process,async))
})();
var state__31206__auto__ = (function (){var statearr_31525 = f__31205__auto__.call(null);
(statearr_31525[(6)] = c__31204__auto__);

return statearr_31525;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31206__auto__);
});})(c__31204__auto__,jobs,results,process,async))
);

return c__31204__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__31585 = arguments.length;
switch (G__31585) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__31588 = arguments.length;
switch (G__31588) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__31591 = arguments.length;
switch (G__31591) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__31204__auto___31640 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31204__auto___31640,tc,fc){
return (function (){
var f__31205__auto__ = (function (){var switch__31116__auto__ = ((function (c__31204__auto___31640,tc,fc){
return (function (state_31617){
var state_val_31618 = (state_31617[(1)]);
if((state_val_31618 === (7))){
var inst_31613 = (state_31617[(2)]);
var state_31617__$1 = state_31617;
var statearr_31619_31641 = state_31617__$1;
(statearr_31619_31641[(2)] = inst_31613);

(statearr_31619_31641[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31618 === (1))){
var state_31617__$1 = state_31617;
var statearr_31620_31642 = state_31617__$1;
(statearr_31620_31642[(2)] = null);

(statearr_31620_31642[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31618 === (4))){
var inst_31594 = (state_31617[(7)]);
var inst_31594__$1 = (state_31617[(2)]);
var inst_31595 = (inst_31594__$1 == null);
var state_31617__$1 = (function (){var statearr_31621 = state_31617;
(statearr_31621[(7)] = inst_31594__$1);

return statearr_31621;
})();
if(cljs.core.truth_(inst_31595)){
var statearr_31622_31643 = state_31617__$1;
(statearr_31622_31643[(1)] = (5));

} else {
var statearr_31623_31644 = state_31617__$1;
(statearr_31623_31644[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31618 === (13))){
var state_31617__$1 = state_31617;
var statearr_31624_31645 = state_31617__$1;
(statearr_31624_31645[(2)] = null);

(statearr_31624_31645[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31618 === (6))){
var inst_31594 = (state_31617[(7)]);
var inst_31600 = p.call(null,inst_31594);
var state_31617__$1 = state_31617;
if(cljs.core.truth_(inst_31600)){
var statearr_31625_31646 = state_31617__$1;
(statearr_31625_31646[(1)] = (9));

} else {
var statearr_31626_31647 = state_31617__$1;
(statearr_31626_31647[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31618 === (3))){
var inst_31615 = (state_31617[(2)]);
var state_31617__$1 = state_31617;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31617__$1,inst_31615);
} else {
if((state_val_31618 === (12))){
var state_31617__$1 = state_31617;
var statearr_31627_31648 = state_31617__$1;
(statearr_31627_31648[(2)] = null);

(statearr_31627_31648[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31618 === (2))){
var state_31617__$1 = state_31617;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31617__$1,(4),ch);
} else {
if((state_val_31618 === (11))){
var inst_31594 = (state_31617[(7)]);
var inst_31604 = (state_31617[(2)]);
var state_31617__$1 = state_31617;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31617__$1,(8),inst_31604,inst_31594);
} else {
if((state_val_31618 === (9))){
var state_31617__$1 = state_31617;
var statearr_31628_31649 = state_31617__$1;
(statearr_31628_31649[(2)] = tc);

(statearr_31628_31649[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31618 === (5))){
var inst_31597 = cljs.core.async.close_BANG_.call(null,tc);
var inst_31598 = cljs.core.async.close_BANG_.call(null,fc);
var state_31617__$1 = (function (){var statearr_31629 = state_31617;
(statearr_31629[(8)] = inst_31597);

return statearr_31629;
})();
var statearr_31630_31650 = state_31617__$1;
(statearr_31630_31650[(2)] = inst_31598);

(statearr_31630_31650[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31618 === (14))){
var inst_31611 = (state_31617[(2)]);
var state_31617__$1 = state_31617;
var statearr_31631_31651 = state_31617__$1;
(statearr_31631_31651[(2)] = inst_31611);

(statearr_31631_31651[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31618 === (10))){
var state_31617__$1 = state_31617;
var statearr_31632_31652 = state_31617__$1;
(statearr_31632_31652[(2)] = fc);

(statearr_31632_31652[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31618 === (8))){
var inst_31606 = (state_31617[(2)]);
var state_31617__$1 = state_31617;
if(cljs.core.truth_(inst_31606)){
var statearr_31633_31653 = state_31617__$1;
(statearr_31633_31653[(1)] = (12));

} else {
var statearr_31634_31654 = state_31617__$1;
(statearr_31634_31654[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31204__auto___31640,tc,fc))
;
return ((function (switch__31116__auto__,c__31204__auto___31640,tc,fc){
return (function() {
var cljs$core$async$state_machine__31117__auto__ = null;
var cljs$core$async$state_machine__31117__auto____0 = (function (){
var statearr_31635 = [null,null,null,null,null,null,null,null,null];
(statearr_31635[(0)] = cljs$core$async$state_machine__31117__auto__);

(statearr_31635[(1)] = (1));

return statearr_31635;
});
var cljs$core$async$state_machine__31117__auto____1 = (function (state_31617){
while(true){
var ret_value__31118__auto__ = (function (){try{while(true){
var result__31119__auto__ = switch__31116__auto__.call(null,state_31617);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31119__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31119__auto__;
}
break;
}
}catch (e31636){if((e31636 instanceof Object)){
var ex__31120__auto__ = e31636;
var statearr_31637_31655 = state_31617;
(statearr_31637_31655[(5)] = ex__31120__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31617);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31636;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31118__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31656 = state_31617;
state_31617 = G__31656;
continue;
} else {
return ret_value__31118__auto__;
}
break;
}
});
cljs$core$async$state_machine__31117__auto__ = function(state_31617){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31117__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31117__auto____1.call(this,state_31617);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31117__auto____0;
cljs$core$async$state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31117__auto____1;
return cljs$core$async$state_machine__31117__auto__;
})()
;})(switch__31116__auto__,c__31204__auto___31640,tc,fc))
})();
var state__31206__auto__ = (function (){var statearr_31638 = f__31205__auto__.call(null);
(statearr_31638[(6)] = c__31204__auto___31640);

return statearr_31638;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31206__auto__);
});})(c__31204__auto___31640,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__31204__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31204__auto__){
return (function (){
var f__31205__auto__ = (function (){var switch__31116__auto__ = ((function (c__31204__auto__){
return (function (state_31677){
var state_val_31678 = (state_31677[(1)]);
if((state_val_31678 === (7))){
var inst_31673 = (state_31677[(2)]);
var state_31677__$1 = state_31677;
var statearr_31679_31697 = state_31677__$1;
(statearr_31679_31697[(2)] = inst_31673);

(statearr_31679_31697[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31678 === (1))){
var inst_31657 = init;
var state_31677__$1 = (function (){var statearr_31680 = state_31677;
(statearr_31680[(7)] = inst_31657);

return statearr_31680;
})();
var statearr_31681_31698 = state_31677__$1;
(statearr_31681_31698[(2)] = null);

(statearr_31681_31698[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31678 === (4))){
var inst_31660 = (state_31677[(8)]);
var inst_31660__$1 = (state_31677[(2)]);
var inst_31661 = (inst_31660__$1 == null);
var state_31677__$1 = (function (){var statearr_31682 = state_31677;
(statearr_31682[(8)] = inst_31660__$1);

return statearr_31682;
})();
if(cljs.core.truth_(inst_31661)){
var statearr_31683_31699 = state_31677__$1;
(statearr_31683_31699[(1)] = (5));

} else {
var statearr_31684_31700 = state_31677__$1;
(statearr_31684_31700[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31678 === (6))){
var inst_31664 = (state_31677[(9)]);
var inst_31657 = (state_31677[(7)]);
var inst_31660 = (state_31677[(8)]);
var inst_31664__$1 = f.call(null,inst_31657,inst_31660);
var inst_31665 = cljs.core.reduced_QMARK_.call(null,inst_31664__$1);
var state_31677__$1 = (function (){var statearr_31685 = state_31677;
(statearr_31685[(9)] = inst_31664__$1);

return statearr_31685;
})();
if(inst_31665){
var statearr_31686_31701 = state_31677__$1;
(statearr_31686_31701[(1)] = (8));

} else {
var statearr_31687_31702 = state_31677__$1;
(statearr_31687_31702[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31678 === (3))){
var inst_31675 = (state_31677[(2)]);
var state_31677__$1 = state_31677;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31677__$1,inst_31675);
} else {
if((state_val_31678 === (2))){
var state_31677__$1 = state_31677;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31677__$1,(4),ch);
} else {
if((state_val_31678 === (9))){
var inst_31664 = (state_31677[(9)]);
var inst_31657 = inst_31664;
var state_31677__$1 = (function (){var statearr_31688 = state_31677;
(statearr_31688[(7)] = inst_31657);

return statearr_31688;
})();
var statearr_31689_31703 = state_31677__$1;
(statearr_31689_31703[(2)] = null);

(statearr_31689_31703[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31678 === (5))){
var inst_31657 = (state_31677[(7)]);
var state_31677__$1 = state_31677;
var statearr_31690_31704 = state_31677__$1;
(statearr_31690_31704[(2)] = inst_31657);

(statearr_31690_31704[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31678 === (10))){
var inst_31671 = (state_31677[(2)]);
var state_31677__$1 = state_31677;
var statearr_31691_31705 = state_31677__$1;
(statearr_31691_31705[(2)] = inst_31671);

(statearr_31691_31705[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31678 === (8))){
var inst_31664 = (state_31677[(9)]);
var inst_31667 = cljs.core.deref.call(null,inst_31664);
var state_31677__$1 = state_31677;
var statearr_31692_31706 = state_31677__$1;
(statearr_31692_31706[(2)] = inst_31667);

(statearr_31692_31706[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__31204__auto__))
;
return ((function (switch__31116__auto__,c__31204__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__31117__auto__ = null;
var cljs$core$async$reduce_$_state_machine__31117__auto____0 = (function (){
var statearr_31693 = [null,null,null,null,null,null,null,null,null,null];
(statearr_31693[(0)] = cljs$core$async$reduce_$_state_machine__31117__auto__);

(statearr_31693[(1)] = (1));

return statearr_31693;
});
var cljs$core$async$reduce_$_state_machine__31117__auto____1 = (function (state_31677){
while(true){
var ret_value__31118__auto__ = (function (){try{while(true){
var result__31119__auto__ = switch__31116__auto__.call(null,state_31677);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31119__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31119__auto__;
}
break;
}
}catch (e31694){if((e31694 instanceof Object)){
var ex__31120__auto__ = e31694;
var statearr_31695_31707 = state_31677;
(statearr_31695_31707[(5)] = ex__31120__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31677);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31694;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31118__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31708 = state_31677;
state_31677 = G__31708;
continue;
} else {
return ret_value__31118__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__31117__auto__ = function(state_31677){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__31117__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__31117__auto____1.call(this,state_31677);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__31117__auto____0;
cljs$core$async$reduce_$_state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__31117__auto____1;
return cljs$core$async$reduce_$_state_machine__31117__auto__;
})()
;})(switch__31116__auto__,c__31204__auto__))
})();
var state__31206__auto__ = (function (){var statearr_31696 = f__31205__auto__.call(null);
(statearr_31696[(6)] = c__31204__auto__);

return statearr_31696;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31206__auto__);
});})(c__31204__auto__))
);

return c__31204__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__31204__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31204__auto__,f__$1){
return (function (){
var f__31205__auto__ = (function (){var switch__31116__auto__ = ((function (c__31204__auto__,f__$1){
return (function (state_31714){
var state_val_31715 = (state_31714[(1)]);
if((state_val_31715 === (1))){
var inst_31709 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_31714__$1 = state_31714;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31714__$1,(2),inst_31709);
} else {
if((state_val_31715 === (2))){
var inst_31711 = (state_31714[(2)]);
var inst_31712 = f__$1.call(null,inst_31711);
var state_31714__$1 = state_31714;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31714__$1,inst_31712);
} else {
return null;
}
}
});})(c__31204__auto__,f__$1))
;
return ((function (switch__31116__auto__,c__31204__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__31117__auto__ = null;
var cljs$core$async$transduce_$_state_machine__31117__auto____0 = (function (){
var statearr_31716 = [null,null,null,null,null,null,null];
(statearr_31716[(0)] = cljs$core$async$transduce_$_state_machine__31117__auto__);

(statearr_31716[(1)] = (1));

return statearr_31716;
});
var cljs$core$async$transduce_$_state_machine__31117__auto____1 = (function (state_31714){
while(true){
var ret_value__31118__auto__ = (function (){try{while(true){
var result__31119__auto__ = switch__31116__auto__.call(null,state_31714);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31119__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31119__auto__;
}
break;
}
}catch (e31717){if((e31717 instanceof Object)){
var ex__31120__auto__ = e31717;
var statearr_31718_31720 = state_31714;
(statearr_31718_31720[(5)] = ex__31120__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31714);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31717;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31118__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31721 = state_31714;
state_31714 = G__31721;
continue;
} else {
return ret_value__31118__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__31117__auto__ = function(state_31714){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__31117__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__31117__auto____1.call(this,state_31714);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__31117__auto____0;
cljs$core$async$transduce_$_state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__31117__auto____1;
return cljs$core$async$transduce_$_state_machine__31117__auto__;
})()
;})(switch__31116__auto__,c__31204__auto__,f__$1))
})();
var state__31206__auto__ = (function (){var statearr_31719 = f__31205__auto__.call(null);
(statearr_31719[(6)] = c__31204__auto__);

return statearr_31719;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31206__auto__);
});})(c__31204__auto__,f__$1))
);

return c__31204__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__31723 = arguments.length;
switch (G__31723) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__31204__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31204__auto__){
return (function (){
var f__31205__auto__ = (function (){var switch__31116__auto__ = ((function (c__31204__auto__){
return (function (state_31748){
var state_val_31749 = (state_31748[(1)]);
if((state_val_31749 === (7))){
var inst_31730 = (state_31748[(2)]);
var state_31748__$1 = state_31748;
var statearr_31750_31771 = state_31748__$1;
(statearr_31750_31771[(2)] = inst_31730);

(statearr_31750_31771[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31749 === (1))){
var inst_31724 = cljs.core.seq.call(null,coll);
var inst_31725 = inst_31724;
var state_31748__$1 = (function (){var statearr_31751 = state_31748;
(statearr_31751[(7)] = inst_31725);

return statearr_31751;
})();
var statearr_31752_31772 = state_31748__$1;
(statearr_31752_31772[(2)] = null);

(statearr_31752_31772[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31749 === (4))){
var inst_31725 = (state_31748[(7)]);
var inst_31728 = cljs.core.first.call(null,inst_31725);
var state_31748__$1 = state_31748;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31748__$1,(7),ch,inst_31728);
} else {
if((state_val_31749 === (13))){
var inst_31742 = (state_31748[(2)]);
var state_31748__$1 = state_31748;
var statearr_31753_31773 = state_31748__$1;
(statearr_31753_31773[(2)] = inst_31742);

(statearr_31753_31773[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31749 === (6))){
var inst_31733 = (state_31748[(2)]);
var state_31748__$1 = state_31748;
if(cljs.core.truth_(inst_31733)){
var statearr_31754_31774 = state_31748__$1;
(statearr_31754_31774[(1)] = (8));

} else {
var statearr_31755_31775 = state_31748__$1;
(statearr_31755_31775[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31749 === (3))){
var inst_31746 = (state_31748[(2)]);
var state_31748__$1 = state_31748;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31748__$1,inst_31746);
} else {
if((state_val_31749 === (12))){
var state_31748__$1 = state_31748;
var statearr_31756_31776 = state_31748__$1;
(statearr_31756_31776[(2)] = null);

(statearr_31756_31776[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31749 === (2))){
var inst_31725 = (state_31748[(7)]);
var state_31748__$1 = state_31748;
if(cljs.core.truth_(inst_31725)){
var statearr_31757_31777 = state_31748__$1;
(statearr_31757_31777[(1)] = (4));

} else {
var statearr_31758_31778 = state_31748__$1;
(statearr_31758_31778[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31749 === (11))){
var inst_31739 = cljs.core.async.close_BANG_.call(null,ch);
var state_31748__$1 = state_31748;
var statearr_31759_31779 = state_31748__$1;
(statearr_31759_31779[(2)] = inst_31739);

(statearr_31759_31779[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31749 === (9))){
var state_31748__$1 = state_31748;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31760_31780 = state_31748__$1;
(statearr_31760_31780[(1)] = (11));

} else {
var statearr_31761_31781 = state_31748__$1;
(statearr_31761_31781[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31749 === (5))){
var inst_31725 = (state_31748[(7)]);
var state_31748__$1 = state_31748;
var statearr_31762_31782 = state_31748__$1;
(statearr_31762_31782[(2)] = inst_31725);

(statearr_31762_31782[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31749 === (10))){
var inst_31744 = (state_31748[(2)]);
var state_31748__$1 = state_31748;
var statearr_31763_31783 = state_31748__$1;
(statearr_31763_31783[(2)] = inst_31744);

(statearr_31763_31783[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31749 === (8))){
var inst_31725 = (state_31748[(7)]);
var inst_31735 = cljs.core.next.call(null,inst_31725);
var inst_31725__$1 = inst_31735;
var state_31748__$1 = (function (){var statearr_31764 = state_31748;
(statearr_31764[(7)] = inst_31725__$1);

return statearr_31764;
})();
var statearr_31765_31784 = state_31748__$1;
(statearr_31765_31784[(2)] = null);

(statearr_31765_31784[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31204__auto__))
;
return ((function (switch__31116__auto__,c__31204__auto__){
return (function() {
var cljs$core$async$state_machine__31117__auto__ = null;
var cljs$core$async$state_machine__31117__auto____0 = (function (){
var statearr_31766 = [null,null,null,null,null,null,null,null];
(statearr_31766[(0)] = cljs$core$async$state_machine__31117__auto__);

(statearr_31766[(1)] = (1));

return statearr_31766;
});
var cljs$core$async$state_machine__31117__auto____1 = (function (state_31748){
while(true){
var ret_value__31118__auto__ = (function (){try{while(true){
var result__31119__auto__ = switch__31116__auto__.call(null,state_31748);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31119__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31119__auto__;
}
break;
}
}catch (e31767){if((e31767 instanceof Object)){
var ex__31120__auto__ = e31767;
var statearr_31768_31785 = state_31748;
(statearr_31768_31785[(5)] = ex__31120__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31748);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31767;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31118__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31786 = state_31748;
state_31748 = G__31786;
continue;
} else {
return ret_value__31118__auto__;
}
break;
}
});
cljs$core$async$state_machine__31117__auto__ = function(state_31748){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31117__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31117__auto____1.call(this,state_31748);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31117__auto____0;
cljs$core$async$state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31117__auto____1;
return cljs$core$async$state_machine__31117__auto__;
})()
;})(switch__31116__auto__,c__31204__auto__))
})();
var state__31206__auto__ = (function (){var statearr_31769 = f__31205__auto__.call(null);
(statearr_31769[(6)] = c__31204__auto__);

return statearr_31769;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31206__auto__);
});})(c__31204__auto__))
);

return c__31204__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__27065__auto__ = (((_ == null))?null:_);
var m__27066__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__27065__auto__)]);
if(!((m__27066__auto__ == null))){
return m__27066__auto__.call(null,_);
} else {
var m__27066__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__27066__auto____$1 == null))){
return m__27066__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__27065__auto__ = (((m == null))?null:m);
var m__27066__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__27065__auto__)]);
if(!((m__27066__auto__ == null))){
return m__27066__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__27066__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__27066__auto____$1 == null))){
return m__27066__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__27065__auto__ = (((m == null))?null:m);
var m__27066__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__27065__auto__)]);
if(!((m__27066__auto__ == null))){
return m__27066__auto__.call(null,m,ch);
} else {
var m__27066__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__27066__auto____$1 == null))){
return m__27066__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__27065__auto__ = (((m == null))?null:m);
var m__27066__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__27065__auto__)]);
if(!((m__27066__auto__ == null))){
return m__27066__auto__.call(null,m);
} else {
var m__27066__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__27066__auto____$1 == null))){
return m__27066__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async31787 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31787 = (function (ch,cs,meta31788){
this.ch = ch;
this.cs = cs;
this.meta31788 = meta31788;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async31787.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_31789,meta31788__$1){
var self__ = this;
var _31789__$1 = this;
return (new cljs.core.async.t_cljs$core$async31787(self__.ch,self__.cs,meta31788__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async31787.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_31789){
var self__ = this;
var _31789__$1 = this;
return self__.meta31788;
});})(cs))
;

cljs.core.async.t_cljs$core$async31787.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31787.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async31787.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31787.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async31787.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async31787.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async31787.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta31788","meta31788",-198529858,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async31787.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31787.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31787";

cljs.core.async.t_cljs$core$async31787.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__27007__auto__,writer__27008__auto__,opt__27009__auto__){
return cljs.core._write.call(null,writer__27008__auto__,"cljs.core.async/t_cljs$core$async31787");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async31787 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async31787(ch__$1,cs__$1,meta31788){
return (new cljs.core.async.t_cljs$core$async31787(ch__$1,cs__$1,meta31788));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async31787(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__31204__auto___32009 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31204__auto___32009,cs,m,dchan,dctr,done){
return (function (){
var f__31205__auto__ = (function (){var switch__31116__auto__ = ((function (c__31204__auto___32009,cs,m,dchan,dctr,done){
return (function (state_31924){
var state_val_31925 = (state_31924[(1)]);
if((state_val_31925 === (7))){
var inst_31920 = (state_31924[(2)]);
var state_31924__$1 = state_31924;
var statearr_31926_32010 = state_31924__$1;
(statearr_31926_32010[(2)] = inst_31920);

(statearr_31926_32010[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (20))){
var inst_31823 = (state_31924[(7)]);
var inst_31835 = cljs.core.first.call(null,inst_31823);
var inst_31836 = cljs.core.nth.call(null,inst_31835,(0),null);
var inst_31837 = cljs.core.nth.call(null,inst_31835,(1),null);
var state_31924__$1 = (function (){var statearr_31927 = state_31924;
(statearr_31927[(8)] = inst_31836);

return statearr_31927;
})();
if(cljs.core.truth_(inst_31837)){
var statearr_31928_32011 = state_31924__$1;
(statearr_31928_32011[(1)] = (22));

} else {
var statearr_31929_32012 = state_31924__$1;
(statearr_31929_32012[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (27))){
var inst_31867 = (state_31924[(9)]);
var inst_31872 = (state_31924[(10)]);
var inst_31865 = (state_31924[(11)]);
var inst_31792 = (state_31924[(12)]);
var inst_31872__$1 = cljs.core._nth.call(null,inst_31865,inst_31867);
var inst_31873 = cljs.core.async.put_BANG_.call(null,inst_31872__$1,inst_31792,done);
var state_31924__$1 = (function (){var statearr_31930 = state_31924;
(statearr_31930[(10)] = inst_31872__$1);

return statearr_31930;
})();
if(cljs.core.truth_(inst_31873)){
var statearr_31931_32013 = state_31924__$1;
(statearr_31931_32013[(1)] = (30));

} else {
var statearr_31932_32014 = state_31924__$1;
(statearr_31932_32014[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (1))){
var state_31924__$1 = state_31924;
var statearr_31933_32015 = state_31924__$1;
(statearr_31933_32015[(2)] = null);

(statearr_31933_32015[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (24))){
var inst_31823 = (state_31924[(7)]);
var inst_31842 = (state_31924[(2)]);
var inst_31843 = cljs.core.next.call(null,inst_31823);
var inst_31801 = inst_31843;
var inst_31802 = null;
var inst_31803 = (0);
var inst_31804 = (0);
var state_31924__$1 = (function (){var statearr_31934 = state_31924;
(statearr_31934[(13)] = inst_31802);

(statearr_31934[(14)] = inst_31842);

(statearr_31934[(15)] = inst_31801);

(statearr_31934[(16)] = inst_31803);

(statearr_31934[(17)] = inst_31804);

return statearr_31934;
})();
var statearr_31935_32016 = state_31924__$1;
(statearr_31935_32016[(2)] = null);

(statearr_31935_32016[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (39))){
var state_31924__$1 = state_31924;
var statearr_31939_32017 = state_31924__$1;
(statearr_31939_32017[(2)] = null);

(statearr_31939_32017[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (4))){
var inst_31792 = (state_31924[(12)]);
var inst_31792__$1 = (state_31924[(2)]);
var inst_31793 = (inst_31792__$1 == null);
var state_31924__$1 = (function (){var statearr_31940 = state_31924;
(statearr_31940[(12)] = inst_31792__$1);

return statearr_31940;
})();
if(cljs.core.truth_(inst_31793)){
var statearr_31941_32018 = state_31924__$1;
(statearr_31941_32018[(1)] = (5));

} else {
var statearr_31942_32019 = state_31924__$1;
(statearr_31942_32019[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (15))){
var inst_31802 = (state_31924[(13)]);
var inst_31801 = (state_31924[(15)]);
var inst_31803 = (state_31924[(16)]);
var inst_31804 = (state_31924[(17)]);
var inst_31819 = (state_31924[(2)]);
var inst_31820 = (inst_31804 + (1));
var tmp31936 = inst_31802;
var tmp31937 = inst_31801;
var tmp31938 = inst_31803;
var inst_31801__$1 = tmp31937;
var inst_31802__$1 = tmp31936;
var inst_31803__$1 = tmp31938;
var inst_31804__$1 = inst_31820;
var state_31924__$1 = (function (){var statearr_31943 = state_31924;
(statearr_31943[(13)] = inst_31802__$1);

(statearr_31943[(15)] = inst_31801__$1);

(statearr_31943[(16)] = inst_31803__$1);

(statearr_31943[(18)] = inst_31819);

(statearr_31943[(17)] = inst_31804__$1);

return statearr_31943;
})();
var statearr_31944_32020 = state_31924__$1;
(statearr_31944_32020[(2)] = null);

(statearr_31944_32020[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (21))){
var inst_31846 = (state_31924[(2)]);
var state_31924__$1 = state_31924;
var statearr_31948_32021 = state_31924__$1;
(statearr_31948_32021[(2)] = inst_31846);

(statearr_31948_32021[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (31))){
var inst_31872 = (state_31924[(10)]);
var inst_31876 = done.call(null,null);
var inst_31877 = cljs.core.async.untap_STAR_.call(null,m,inst_31872);
var state_31924__$1 = (function (){var statearr_31949 = state_31924;
(statearr_31949[(19)] = inst_31876);

return statearr_31949;
})();
var statearr_31950_32022 = state_31924__$1;
(statearr_31950_32022[(2)] = inst_31877);

(statearr_31950_32022[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (32))){
var inst_31864 = (state_31924[(20)]);
var inst_31866 = (state_31924[(21)]);
var inst_31867 = (state_31924[(9)]);
var inst_31865 = (state_31924[(11)]);
var inst_31879 = (state_31924[(2)]);
var inst_31880 = (inst_31867 + (1));
var tmp31945 = inst_31864;
var tmp31946 = inst_31866;
var tmp31947 = inst_31865;
var inst_31864__$1 = tmp31945;
var inst_31865__$1 = tmp31947;
var inst_31866__$1 = tmp31946;
var inst_31867__$1 = inst_31880;
var state_31924__$1 = (function (){var statearr_31951 = state_31924;
(statearr_31951[(20)] = inst_31864__$1);

(statearr_31951[(22)] = inst_31879);

(statearr_31951[(21)] = inst_31866__$1);

(statearr_31951[(9)] = inst_31867__$1);

(statearr_31951[(11)] = inst_31865__$1);

return statearr_31951;
})();
var statearr_31952_32023 = state_31924__$1;
(statearr_31952_32023[(2)] = null);

(statearr_31952_32023[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (40))){
var inst_31892 = (state_31924[(23)]);
var inst_31896 = done.call(null,null);
var inst_31897 = cljs.core.async.untap_STAR_.call(null,m,inst_31892);
var state_31924__$1 = (function (){var statearr_31953 = state_31924;
(statearr_31953[(24)] = inst_31896);

return statearr_31953;
})();
var statearr_31954_32024 = state_31924__$1;
(statearr_31954_32024[(2)] = inst_31897);

(statearr_31954_32024[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (33))){
var inst_31883 = (state_31924[(25)]);
var inst_31885 = cljs.core.chunked_seq_QMARK_.call(null,inst_31883);
var state_31924__$1 = state_31924;
if(inst_31885){
var statearr_31955_32025 = state_31924__$1;
(statearr_31955_32025[(1)] = (36));

} else {
var statearr_31956_32026 = state_31924__$1;
(statearr_31956_32026[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (13))){
var inst_31813 = (state_31924[(26)]);
var inst_31816 = cljs.core.async.close_BANG_.call(null,inst_31813);
var state_31924__$1 = state_31924;
var statearr_31957_32027 = state_31924__$1;
(statearr_31957_32027[(2)] = inst_31816);

(statearr_31957_32027[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (22))){
var inst_31836 = (state_31924[(8)]);
var inst_31839 = cljs.core.async.close_BANG_.call(null,inst_31836);
var state_31924__$1 = state_31924;
var statearr_31958_32028 = state_31924__$1;
(statearr_31958_32028[(2)] = inst_31839);

(statearr_31958_32028[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (36))){
var inst_31883 = (state_31924[(25)]);
var inst_31887 = cljs.core.chunk_first.call(null,inst_31883);
var inst_31888 = cljs.core.chunk_rest.call(null,inst_31883);
var inst_31889 = cljs.core.count.call(null,inst_31887);
var inst_31864 = inst_31888;
var inst_31865 = inst_31887;
var inst_31866 = inst_31889;
var inst_31867 = (0);
var state_31924__$1 = (function (){var statearr_31959 = state_31924;
(statearr_31959[(20)] = inst_31864);

(statearr_31959[(21)] = inst_31866);

(statearr_31959[(9)] = inst_31867);

(statearr_31959[(11)] = inst_31865);

return statearr_31959;
})();
var statearr_31960_32029 = state_31924__$1;
(statearr_31960_32029[(2)] = null);

(statearr_31960_32029[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (41))){
var inst_31883 = (state_31924[(25)]);
var inst_31899 = (state_31924[(2)]);
var inst_31900 = cljs.core.next.call(null,inst_31883);
var inst_31864 = inst_31900;
var inst_31865 = null;
var inst_31866 = (0);
var inst_31867 = (0);
var state_31924__$1 = (function (){var statearr_31961 = state_31924;
(statearr_31961[(20)] = inst_31864);

(statearr_31961[(21)] = inst_31866);

(statearr_31961[(27)] = inst_31899);

(statearr_31961[(9)] = inst_31867);

(statearr_31961[(11)] = inst_31865);

return statearr_31961;
})();
var statearr_31962_32030 = state_31924__$1;
(statearr_31962_32030[(2)] = null);

(statearr_31962_32030[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (43))){
var state_31924__$1 = state_31924;
var statearr_31963_32031 = state_31924__$1;
(statearr_31963_32031[(2)] = null);

(statearr_31963_32031[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (29))){
var inst_31908 = (state_31924[(2)]);
var state_31924__$1 = state_31924;
var statearr_31964_32032 = state_31924__$1;
(statearr_31964_32032[(2)] = inst_31908);

(statearr_31964_32032[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (44))){
var inst_31917 = (state_31924[(2)]);
var state_31924__$1 = (function (){var statearr_31965 = state_31924;
(statearr_31965[(28)] = inst_31917);

return statearr_31965;
})();
var statearr_31966_32033 = state_31924__$1;
(statearr_31966_32033[(2)] = null);

(statearr_31966_32033[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (6))){
var inst_31856 = (state_31924[(29)]);
var inst_31855 = cljs.core.deref.call(null,cs);
var inst_31856__$1 = cljs.core.keys.call(null,inst_31855);
var inst_31857 = cljs.core.count.call(null,inst_31856__$1);
var inst_31858 = cljs.core.reset_BANG_.call(null,dctr,inst_31857);
var inst_31863 = cljs.core.seq.call(null,inst_31856__$1);
var inst_31864 = inst_31863;
var inst_31865 = null;
var inst_31866 = (0);
var inst_31867 = (0);
var state_31924__$1 = (function (){var statearr_31967 = state_31924;
(statearr_31967[(29)] = inst_31856__$1);

(statearr_31967[(20)] = inst_31864);

(statearr_31967[(21)] = inst_31866);

(statearr_31967[(9)] = inst_31867);

(statearr_31967[(30)] = inst_31858);

(statearr_31967[(11)] = inst_31865);

return statearr_31967;
})();
var statearr_31968_32034 = state_31924__$1;
(statearr_31968_32034[(2)] = null);

(statearr_31968_32034[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (28))){
var inst_31864 = (state_31924[(20)]);
var inst_31883 = (state_31924[(25)]);
var inst_31883__$1 = cljs.core.seq.call(null,inst_31864);
var state_31924__$1 = (function (){var statearr_31969 = state_31924;
(statearr_31969[(25)] = inst_31883__$1);

return statearr_31969;
})();
if(inst_31883__$1){
var statearr_31970_32035 = state_31924__$1;
(statearr_31970_32035[(1)] = (33));

} else {
var statearr_31971_32036 = state_31924__$1;
(statearr_31971_32036[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (25))){
var inst_31866 = (state_31924[(21)]);
var inst_31867 = (state_31924[(9)]);
var inst_31869 = (inst_31867 < inst_31866);
var inst_31870 = inst_31869;
var state_31924__$1 = state_31924;
if(cljs.core.truth_(inst_31870)){
var statearr_31972_32037 = state_31924__$1;
(statearr_31972_32037[(1)] = (27));

} else {
var statearr_31973_32038 = state_31924__$1;
(statearr_31973_32038[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (34))){
var state_31924__$1 = state_31924;
var statearr_31974_32039 = state_31924__$1;
(statearr_31974_32039[(2)] = null);

(statearr_31974_32039[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (17))){
var state_31924__$1 = state_31924;
var statearr_31975_32040 = state_31924__$1;
(statearr_31975_32040[(2)] = null);

(statearr_31975_32040[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (3))){
var inst_31922 = (state_31924[(2)]);
var state_31924__$1 = state_31924;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31924__$1,inst_31922);
} else {
if((state_val_31925 === (12))){
var inst_31851 = (state_31924[(2)]);
var state_31924__$1 = state_31924;
var statearr_31976_32041 = state_31924__$1;
(statearr_31976_32041[(2)] = inst_31851);

(statearr_31976_32041[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (2))){
var state_31924__$1 = state_31924;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31924__$1,(4),ch);
} else {
if((state_val_31925 === (23))){
var state_31924__$1 = state_31924;
var statearr_31977_32042 = state_31924__$1;
(statearr_31977_32042[(2)] = null);

(statearr_31977_32042[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (35))){
var inst_31906 = (state_31924[(2)]);
var state_31924__$1 = state_31924;
var statearr_31978_32043 = state_31924__$1;
(statearr_31978_32043[(2)] = inst_31906);

(statearr_31978_32043[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (19))){
var inst_31823 = (state_31924[(7)]);
var inst_31827 = cljs.core.chunk_first.call(null,inst_31823);
var inst_31828 = cljs.core.chunk_rest.call(null,inst_31823);
var inst_31829 = cljs.core.count.call(null,inst_31827);
var inst_31801 = inst_31828;
var inst_31802 = inst_31827;
var inst_31803 = inst_31829;
var inst_31804 = (0);
var state_31924__$1 = (function (){var statearr_31979 = state_31924;
(statearr_31979[(13)] = inst_31802);

(statearr_31979[(15)] = inst_31801);

(statearr_31979[(16)] = inst_31803);

(statearr_31979[(17)] = inst_31804);

return statearr_31979;
})();
var statearr_31980_32044 = state_31924__$1;
(statearr_31980_32044[(2)] = null);

(statearr_31980_32044[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (11))){
var inst_31823 = (state_31924[(7)]);
var inst_31801 = (state_31924[(15)]);
var inst_31823__$1 = cljs.core.seq.call(null,inst_31801);
var state_31924__$1 = (function (){var statearr_31981 = state_31924;
(statearr_31981[(7)] = inst_31823__$1);

return statearr_31981;
})();
if(inst_31823__$1){
var statearr_31982_32045 = state_31924__$1;
(statearr_31982_32045[(1)] = (16));

} else {
var statearr_31983_32046 = state_31924__$1;
(statearr_31983_32046[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (9))){
var inst_31853 = (state_31924[(2)]);
var state_31924__$1 = state_31924;
var statearr_31984_32047 = state_31924__$1;
(statearr_31984_32047[(2)] = inst_31853);

(statearr_31984_32047[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (5))){
var inst_31799 = cljs.core.deref.call(null,cs);
var inst_31800 = cljs.core.seq.call(null,inst_31799);
var inst_31801 = inst_31800;
var inst_31802 = null;
var inst_31803 = (0);
var inst_31804 = (0);
var state_31924__$1 = (function (){var statearr_31985 = state_31924;
(statearr_31985[(13)] = inst_31802);

(statearr_31985[(15)] = inst_31801);

(statearr_31985[(16)] = inst_31803);

(statearr_31985[(17)] = inst_31804);

return statearr_31985;
})();
var statearr_31986_32048 = state_31924__$1;
(statearr_31986_32048[(2)] = null);

(statearr_31986_32048[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (14))){
var state_31924__$1 = state_31924;
var statearr_31987_32049 = state_31924__$1;
(statearr_31987_32049[(2)] = null);

(statearr_31987_32049[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (45))){
var inst_31914 = (state_31924[(2)]);
var state_31924__$1 = state_31924;
var statearr_31988_32050 = state_31924__$1;
(statearr_31988_32050[(2)] = inst_31914);

(statearr_31988_32050[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (26))){
var inst_31856 = (state_31924[(29)]);
var inst_31910 = (state_31924[(2)]);
var inst_31911 = cljs.core.seq.call(null,inst_31856);
var state_31924__$1 = (function (){var statearr_31989 = state_31924;
(statearr_31989[(31)] = inst_31910);

return statearr_31989;
})();
if(inst_31911){
var statearr_31990_32051 = state_31924__$1;
(statearr_31990_32051[(1)] = (42));

} else {
var statearr_31991_32052 = state_31924__$1;
(statearr_31991_32052[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (16))){
var inst_31823 = (state_31924[(7)]);
var inst_31825 = cljs.core.chunked_seq_QMARK_.call(null,inst_31823);
var state_31924__$1 = state_31924;
if(inst_31825){
var statearr_31992_32053 = state_31924__$1;
(statearr_31992_32053[(1)] = (19));

} else {
var statearr_31993_32054 = state_31924__$1;
(statearr_31993_32054[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (38))){
var inst_31903 = (state_31924[(2)]);
var state_31924__$1 = state_31924;
var statearr_31994_32055 = state_31924__$1;
(statearr_31994_32055[(2)] = inst_31903);

(statearr_31994_32055[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (30))){
var state_31924__$1 = state_31924;
var statearr_31995_32056 = state_31924__$1;
(statearr_31995_32056[(2)] = null);

(statearr_31995_32056[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (10))){
var inst_31802 = (state_31924[(13)]);
var inst_31804 = (state_31924[(17)]);
var inst_31812 = cljs.core._nth.call(null,inst_31802,inst_31804);
var inst_31813 = cljs.core.nth.call(null,inst_31812,(0),null);
var inst_31814 = cljs.core.nth.call(null,inst_31812,(1),null);
var state_31924__$1 = (function (){var statearr_31996 = state_31924;
(statearr_31996[(26)] = inst_31813);

return statearr_31996;
})();
if(cljs.core.truth_(inst_31814)){
var statearr_31997_32057 = state_31924__$1;
(statearr_31997_32057[(1)] = (13));

} else {
var statearr_31998_32058 = state_31924__$1;
(statearr_31998_32058[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (18))){
var inst_31849 = (state_31924[(2)]);
var state_31924__$1 = state_31924;
var statearr_31999_32059 = state_31924__$1;
(statearr_31999_32059[(2)] = inst_31849);

(statearr_31999_32059[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (42))){
var state_31924__$1 = state_31924;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31924__$1,(45),dchan);
} else {
if((state_val_31925 === (37))){
var inst_31883 = (state_31924[(25)]);
var inst_31792 = (state_31924[(12)]);
var inst_31892 = (state_31924[(23)]);
var inst_31892__$1 = cljs.core.first.call(null,inst_31883);
var inst_31893 = cljs.core.async.put_BANG_.call(null,inst_31892__$1,inst_31792,done);
var state_31924__$1 = (function (){var statearr_32000 = state_31924;
(statearr_32000[(23)] = inst_31892__$1);

return statearr_32000;
})();
if(cljs.core.truth_(inst_31893)){
var statearr_32001_32060 = state_31924__$1;
(statearr_32001_32060[(1)] = (39));

} else {
var statearr_32002_32061 = state_31924__$1;
(statearr_32002_32061[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31925 === (8))){
var inst_31803 = (state_31924[(16)]);
var inst_31804 = (state_31924[(17)]);
var inst_31806 = (inst_31804 < inst_31803);
var inst_31807 = inst_31806;
var state_31924__$1 = state_31924;
if(cljs.core.truth_(inst_31807)){
var statearr_32003_32062 = state_31924__$1;
(statearr_32003_32062[(1)] = (10));

} else {
var statearr_32004_32063 = state_31924__$1;
(statearr_32004_32063[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31204__auto___32009,cs,m,dchan,dctr,done))
;
return ((function (switch__31116__auto__,c__31204__auto___32009,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__31117__auto__ = null;
var cljs$core$async$mult_$_state_machine__31117__auto____0 = (function (){
var statearr_32005 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32005[(0)] = cljs$core$async$mult_$_state_machine__31117__auto__);

(statearr_32005[(1)] = (1));

return statearr_32005;
});
var cljs$core$async$mult_$_state_machine__31117__auto____1 = (function (state_31924){
while(true){
var ret_value__31118__auto__ = (function (){try{while(true){
var result__31119__auto__ = switch__31116__auto__.call(null,state_31924);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31119__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31119__auto__;
}
break;
}
}catch (e32006){if((e32006 instanceof Object)){
var ex__31120__auto__ = e32006;
var statearr_32007_32064 = state_31924;
(statearr_32007_32064[(5)] = ex__31120__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31924);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32006;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31118__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32065 = state_31924;
state_31924 = G__32065;
continue;
} else {
return ret_value__31118__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__31117__auto__ = function(state_31924){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__31117__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__31117__auto____1.call(this,state_31924);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__31117__auto____0;
cljs$core$async$mult_$_state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__31117__auto____1;
return cljs$core$async$mult_$_state_machine__31117__auto__;
})()
;})(switch__31116__auto__,c__31204__auto___32009,cs,m,dchan,dctr,done))
})();
var state__31206__auto__ = (function (){var statearr_32008 = f__31205__auto__.call(null);
(statearr_32008[(6)] = c__31204__auto___32009);

return statearr_32008;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31206__auto__);
});})(c__31204__auto___32009,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__32067 = arguments.length;
switch (G__32067) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__27065__auto__ = (((m == null))?null:m);
var m__27066__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__27065__auto__)]);
if(!((m__27066__auto__ == null))){
return m__27066__auto__.call(null,m,ch);
} else {
var m__27066__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__27066__auto____$1 == null))){
return m__27066__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__27065__auto__ = (((m == null))?null:m);
var m__27066__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__27065__auto__)]);
if(!((m__27066__auto__ == null))){
return m__27066__auto__.call(null,m,ch);
} else {
var m__27066__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__27066__auto____$1 == null))){
return m__27066__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__27065__auto__ = (((m == null))?null:m);
var m__27066__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__27065__auto__)]);
if(!((m__27066__auto__ == null))){
return m__27066__auto__.call(null,m);
} else {
var m__27066__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__27066__auto____$1 == null))){
return m__27066__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__27065__auto__ = (((m == null))?null:m);
var m__27066__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__27065__auto__)]);
if(!((m__27066__auto__ == null))){
return m__27066__auto__.call(null,m,state_map);
} else {
var m__27066__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__27066__auto____$1 == null))){
return m__27066__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__27065__auto__ = (((m == null))?null:m);
var m__27066__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__27065__auto__)]);
if(!((m__27066__auto__ == null))){
return m__27066__auto__.call(null,m,mode);
} else {
var m__27066__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__27066__auto____$1 == null))){
return m__27066__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__27528__auto__ = [];
var len__27521__auto___32079 = arguments.length;
var i__27522__auto___32080 = (0);
while(true){
if((i__27522__auto___32080 < len__27521__auto___32079)){
args__27528__auto__.push((arguments[i__27522__auto___32080]));

var G__32081 = (i__27522__auto___32080 + (1));
i__27522__auto___32080 = G__32081;
continue;
} else {
}
break;
}

var argseq__27529__auto__ = ((((3) < args__27528__auto__.length))?(new cljs.core.IndexedSeq(args__27528__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__27529__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__32073){
var map__32074 = p__32073;
var map__32074__$1 = ((((!((map__32074 == null)))?((((map__32074.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32074.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32074):map__32074);
var opts = map__32074__$1;
var statearr_32076_32082 = state;
(statearr_32076_32082[(1)] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__32074,map__32074__$1,opts){
return (function (val){
var statearr_32077_32083 = state;
(statearr_32077_32083[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__32074,map__32074__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_32078_32084 = state;
(statearr_32078_32084[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq32069){
var G__32070 = cljs.core.first.call(null,seq32069);
var seq32069__$1 = cljs.core.next.call(null,seq32069);
var G__32071 = cljs.core.first.call(null,seq32069__$1);
var seq32069__$2 = cljs.core.next.call(null,seq32069__$1);
var G__32072 = cljs.core.first.call(null,seq32069__$2);
var seq32069__$3 = cljs.core.next.call(null,seq32069__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__32070,G__32071,G__32072,seq32069__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async32085 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32085 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta32086){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta32086 = meta32086;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32085.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_32087,meta32086__$1){
var self__ = this;
var _32087__$1 = this;
return (new cljs.core.async.t_cljs$core$async32085(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta32086__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32085.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_32087){
var self__ = this;
var _32087__$1 = this;
return self__.meta32086;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32085.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32085.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32085.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32085.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32085.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32085.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32085.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32085.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1("mode must be one of: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32085.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta32086","meta32086",1307443528,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32085.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32085.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32085";

cljs.core.async.t_cljs$core$async32085.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__27007__auto__,writer__27008__auto__,opt__27009__auto__){
return cljs.core._write.call(null,writer__27008__auto__,"cljs.core.async/t_cljs$core$async32085");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async32085 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async32085(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta32086){
return (new cljs.core.async.t_cljs$core$async32085(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta32086));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async32085(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__31204__auto___32249 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31204__auto___32249,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__31205__auto__ = (function (){var switch__31116__auto__ = ((function (c__31204__auto___32249,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_32189){
var state_val_32190 = (state_32189[(1)]);
if((state_val_32190 === (7))){
var inst_32104 = (state_32189[(2)]);
var state_32189__$1 = state_32189;
var statearr_32191_32250 = state_32189__$1;
(statearr_32191_32250[(2)] = inst_32104);

(statearr_32191_32250[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32190 === (20))){
var inst_32116 = (state_32189[(7)]);
var state_32189__$1 = state_32189;
var statearr_32192_32251 = state_32189__$1;
(statearr_32192_32251[(2)] = inst_32116);

(statearr_32192_32251[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32190 === (27))){
var state_32189__$1 = state_32189;
var statearr_32193_32252 = state_32189__$1;
(statearr_32193_32252[(2)] = null);

(statearr_32193_32252[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32190 === (1))){
var inst_32091 = (state_32189[(8)]);
var inst_32091__$1 = calc_state.call(null);
var inst_32093 = (inst_32091__$1 == null);
var inst_32094 = cljs.core.not.call(null,inst_32093);
var state_32189__$1 = (function (){var statearr_32194 = state_32189;
(statearr_32194[(8)] = inst_32091__$1);

return statearr_32194;
})();
if(inst_32094){
var statearr_32195_32253 = state_32189__$1;
(statearr_32195_32253[(1)] = (2));

} else {
var statearr_32196_32254 = state_32189__$1;
(statearr_32196_32254[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32190 === (24))){
var inst_32140 = (state_32189[(9)]);
var inst_32149 = (state_32189[(10)]);
var inst_32163 = (state_32189[(11)]);
var inst_32163__$1 = inst_32140.call(null,inst_32149);
var state_32189__$1 = (function (){var statearr_32197 = state_32189;
(statearr_32197[(11)] = inst_32163__$1);

return statearr_32197;
})();
if(cljs.core.truth_(inst_32163__$1)){
var statearr_32198_32255 = state_32189__$1;
(statearr_32198_32255[(1)] = (29));

} else {
var statearr_32199_32256 = state_32189__$1;
(statearr_32199_32256[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32190 === (4))){
var inst_32107 = (state_32189[(2)]);
var state_32189__$1 = state_32189;
if(cljs.core.truth_(inst_32107)){
var statearr_32200_32257 = state_32189__$1;
(statearr_32200_32257[(1)] = (8));

} else {
var statearr_32201_32258 = state_32189__$1;
(statearr_32201_32258[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32190 === (15))){
var inst_32134 = (state_32189[(2)]);
var state_32189__$1 = state_32189;
if(cljs.core.truth_(inst_32134)){
var statearr_32202_32259 = state_32189__$1;
(statearr_32202_32259[(1)] = (19));

} else {
var statearr_32203_32260 = state_32189__$1;
(statearr_32203_32260[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32190 === (21))){
var inst_32139 = (state_32189[(12)]);
var inst_32139__$1 = (state_32189[(2)]);
var inst_32140 = cljs.core.get.call(null,inst_32139__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_32141 = cljs.core.get.call(null,inst_32139__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_32142 = cljs.core.get.call(null,inst_32139__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_32189__$1 = (function (){var statearr_32204 = state_32189;
(statearr_32204[(9)] = inst_32140);

(statearr_32204[(12)] = inst_32139__$1);

(statearr_32204[(13)] = inst_32141);

return statearr_32204;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_32189__$1,(22),inst_32142);
} else {
if((state_val_32190 === (31))){
var inst_32171 = (state_32189[(2)]);
var state_32189__$1 = state_32189;
if(cljs.core.truth_(inst_32171)){
var statearr_32205_32261 = state_32189__$1;
(statearr_32205_32261[(1)] = (32));

} else {
var statearr_32206_32262 = state_32189__$1;
(statearr_32206_32262[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32190 === (32))){
var inst_32148 = (state_32189[(14)]);
var state_32189__$1 = state_32189;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32189__$1,(35),out,inst_32148);
} else {
if((state_val_32190 === (33))){
var inst_32139 = (state_32189[(12)]);
var inst_32116 = inst_32139;
var state_32189__$1 = (function (){var statearr_32207 = state_32189;
(statearr_32207[(7)] = inst_32116);

return statearr_32207;
})();
var statearr_32208_32263 = state_32189__$1;
(statearr_32208_32263[(2)] = null);

(statearr_32208_32263[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32190 === (13))){
var inst_32116 = (state_32189[(7)]);
var inst_32123 = inst_32116.cljs$lang$protocol_mask$partition0$;
var inst_32124 = (inst_32123 & (64));
var inst_32125 = inst_32116.cljs$core$ISeq$;
var inst_32126 = (cljs.core.PROTOCOL_SENTINEL === inst_32125);
var inst_32127 = (inst_32124) || (inst_32126);
var state_32189__$1 = state_32189;
if(cljs.core.truth_(inst_32127)){
var statearr_32209_32264 = state_32189__$1;
(statearr_32209_32264[(1)] = (16));

} else {
var statearr_32210_32265 = state_32189__$1;
(statearr_32210_32265[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32190 === (22))){
var inst_32149 = (state_32189[(10)]);
var inst_32148 = (state_32189[(14)]);
var inst_32147 = (state_32189[(2)]);
var inst_32148__$1 = cljs.core.nth.call(null,inst_32147,(0),null);
var inst_32149__$1 = cljs.core.nth.call(null,inst_32147,(1),null);
var inst_32150 = (inst_32148__$1 == null);
var inst_32151 = cljs.core._EQ_.call(null,inst_32149__$1,change);
var inst_32152 = (inst_32150) || (inst_32151);
var state_32189__$1 = (function (){var statearr_32211 = state_32189;
(statearr_32211[(10)] = inst_32149__$1);

(statearr_32211[(14)] = inst_32148__$1);

return statearr_32211;
})();
if(cljs.core.truth_(inst_32152)){
var statearr_32212_32266 = state_32189__$1;
(statearr_32212_32266[(1)] = (23));

} else {
var statearr_32213_32267 = state_32189__$1;
(statearr_32213_32267[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32190 === (36))){
var inst_32139 = (state_32189[(12)]);
var inst_32116 = inst_32139;
var state_32189__$1 = (function (){var statearr_32214 = state_32189;
(statearr_32214[(7)] = inst_32116);

return statearr_32214;
})();
var statearr_32215_32268 = state_32189__$1;
(statearr_32215_32268[(2)] = null);

(statearr_32215_32268[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32190 === (29))){
var inst_32163 = (state_32189[(11)]);
var state_32189__$1 = state_32189;
var statearr_32216_32269 = state_32189__$1;
(statearr_32216_32269[(2)] = inst_32163);

(statearr_32216_32269[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32190 === (6))){
var state_32189__$1 = state_32189;
var statearr_32217_32270 = state_32189__$1;
(statearr_32217_32270[(2)] = false);

(statearr_32217_32270[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32190 === (28))){
var inst_32159 = (state_32189[(2)]);
var inst_32160 = calc_state.call(null);
var inst_32116 = inst_32160;
var state_32189__$1 = (function (){var statearr_32218 = state_32189;
(statearr_32218[(15)] = inst_32159);

(statearr_32218[(7)] = inst_32116);

return statearr_32218;
})();
var statearr_32219_32271 = state_32189__$1;
(statearr_32219_32271[(2)] = null);

(statearr_32219_32271[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32190 === (25))){
var inst_32185 = (state_32189[(2)]);
var state_32189__$1 = state_32189;
var statearr_32220_32272 = state_32189__$1;
(statearr_32220_32272[(2)] = inst_32185);

(statearr_32220_32272[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32190 === (34))){
var inst_32183 = (state_32189[(2)]);
var state_32189__$1 = state_32189;
var statearr_32221_32273 = state_32189__$1;
(statearr_32221_32273[(2)] = inst_32183);

(statearr_32221_32273[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32190 === (17))){
var state_32189__$1 = state_32189;
var statearr_32222_32274 = state_32189__$1;
(statearr_32222_32274[(2)] = false);

(statearr_32222_32274[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32190 === (3))){
var state_32189__$1 = state_32189;
var statearr_32223_32275 = state_32189__$1;
(statearr_32223_32275[(2)] = false);

(statearr_32223_32275[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32190 === (12))){
var inst_32187 = (state_32189[(2)]);
var state_32189__$1 = state_32189;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32189__$1,inst_32187);
} else {
if((state_val_32190 === (2))){
var inst_32091 = (state_32189[(8)]);
var inst_32096 = inst_32091.cljs$lang$protocol_mask$partition0$;
var inst_32097 = (inst_32096 & (64));
var inst_32098 = inst_32091.cljs$core$ISeq$;
var inst_32099 = (cljs.core.PROTOCOL_SENTINEL === inst_32098);
var inst_32100 = (inst_32097) || (inst_32099);
var state_32189__$1 = state_32189;
if(cljs.core.truth_(inst_32100)){
var statearr_32224_32276 = state_32189__$1;
(statearr_32224_32276[(1)] = (5));

} else {
var statearr_32225_32277 = state_32189__$1;
(statearr_32225_32277[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32190 === (23))){
var inst_32148 = (state_32189[(14)]);
var inst_32154 = (inst_32148 == null);
var state_32189__$1 = state_32189;
if(cljs.core.truth_(inst_32154)){
var statearr_32226_32278 = state_32189__$1;
(statearr_32226_32278[(1)] = (26));

} else {
var statearr_32227_32279 = state_32189__$1;
(statearr_32227_32279[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32190 === (35))){
var inst_32174 = (state_32189[(2)]);
var state_32189__$1 = state_32189;
if(cljs.core.truth_(inst_32174)){
var statearr_32228_32280 = state_32189__$1;
(statearr_32228_32280[(1)] = (36));

} else {
var statearr_32229_32281 = state_32189__$1;
(statearr_32229_32281[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32190 === (19))){
var inst_32116 = (state_32189[(7)]);
var inst_32136 = cljs.core.apply.call(null,cljs.core.hash_map,inst_32116);
var state_32189__$1 = state_32189;
var statearr_32230_32282 = state_32189__$1;
(statearr_32230_32282[(2)] = inst_32136);

(statearr_32230_32282[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32190 === (11))){
var inst_32116 = (state_32189[(7)]);
var inst_32120 = (inst_32116 == null);
var inst_32121 = cljs.core.not.call(null,inst_32120);
var state_32189__$1 = state_32189;
if(inst_32121){
var statearr_32231_32283 = state_32189__$1;
(statearr_32231_32283[(1)] = (13));

} else {
var statearr_32232_32284 = state_32189__$1;
(statearr_32232_32284[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32190 === (9))){
var inst_32091 = (state_32189[(8)]);
var state_32189__$1 = state_32189;
var statearr_32233_32285 = state_32189__$1;
(statearr_32233_32285[(2)] = inst_32091);

(statearr_32233_32285[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32190 === (5))){
var state_32189__$1 = state_32189;
var statearr_32234_32286 = state_32189__$1;
(statearr_32234_32286[(2)] = true);

(statearr_32234_32286[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32190 === (14))){
var state_32189__$1 = state_32189;
var statearr_32235_32287 = state_32189__$1;
(statearr_32235_32287[(2)] = false);

(statearr_32235_32287[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32190 === (26))){
var inst_32149 = (state_32189[(10)]);
var inst_32156 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_32149);
var state_32189__$1 = state_32189;
var statearr_32236_32288 = state_32189__$1;
(statearr_32236_32288[(2)] = inst_32156);

(statearr_32236_32288[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32190 === (16))){
var state_32189__$1 = state_32189;
var statearr_32237_32289 = state_32189__$1;
(statearr_32237_32289[(2)] = true);

(statearr_32237_32289[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32190 === (38))){
var inst_32179 = (state_32189[(2)]);
var state_32189__$1 = state_32189;
var statearr_32238_32290 = state_32189__$1;
(statearr_32238_32290[(2)] = inst_32179);

(statearr_32238_32290[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32190 === (30))){
var inst_32140 = (state_32189[(9)]);
var inst_32149 = (state_32189[(10)]);
var inst_32141 = (state_32189[(13)]);
var inst_32166 = cljs.core.empty_QMARK_.call(null,inst_32140);
var inst_32167 = inst_32141.call(null,inst_32149);
var inst_32168 = cljs.core.not.call(null,inst_32167);
var inst_32169 = (inst_32166) && (inst_32168);
var state_32189__$1 = state_32189;
var statearr_32239_32291 = state_32189__$1;
(statearr_32239_32291[(2)] = inst_32169);

(statearr_32239_32291[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32190 === (10))){
var inst_32091 = (state_32189[(8)]);
var inst_32112 = (state_32189[(2)]);
var inst_32113 = cljs.core.get.call(null,inst_32112,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_32114 = cljs.core.get.call(null,inst_32112,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_32115 = cljs.core.get.call(null,inst_32112,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_32116 = inst_32091;
var state_32189__$1 = (function (){var statearr_32240 = state_32189;
(statearr_32240[(16)] = inst_32114);

(statearr_32240[(17)] = inst_32113);

(statearr_32240[(18)] = inst_32115);

(statearr_32240[(7)] = inst_32116);

return statearr_32240;
})();
var statearr_32241_32292 = state_32189__$1;
(statearr_32241_32292[(2)] = null);

(statearr_32241_32292[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32190 === (18))){
var inst_32131 = (state_32189[(2)]);
var state_32189__$1 = state_32189;
var statearr_32242_32293 = state_32189__$1;
(statearr_32242_32293[(2)] = inst_32131);

(statearr_32242_32293[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32190 === (37))){
var state_32189__$1 = state_32189;
var statearr_32243_32294 = state_32189__$1;
(statearr_32243_32294[(2)] = null);

(statearr_32243_32294[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32190 === (8))){
var inst_32091 = (state_32189[(8)]);
var inst_32109 = cljs.core.apply.call(null,cljs.core.hash_map,inst_32091);
var state_32189__$1 = state_32189;
var statearr_32244_32295 = state_32189__$1;
(statearr_32244_32295[(2)] = inst_32109);

(statearr_32244_32295[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31204__auto___32249,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__31116__auto__,c__31204__auto___32249,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__31117__auto__ = null;
var cljs$core$async$mix_$_state_machine__31117__auto____0 = (function (){
var statearr_32245 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32245[(0)] = cljs$core$async$mix_$_state_machine__31117__auto__);

(statearr_32245[(1)] = (1));

return statearr_32245;
});
var cljs$core$async$mix_$_state_machine__31117__auto____1 = (function (state_32189){
while(true){
var ret_value__31118__auto__ = (function (){try{while(true){
var result__31119__auto__ = switch__31116__auto__.call(null,state_32189);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31119__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31119__auto__;
}
break;
}
}catch (e32246){if((e32246 instanceof Object)){
var ex__31120__auto__ = e32246;
var statearr_32247_32296 = state_32189;
(statearr_32247_32296[(5)] = ex__31120__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32189);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32246;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31118__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32297 = state_32189;
state_32189 = G__32297;
continue;
} else {
return ret_value__31118__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__31117__auto__ = function(state_32189){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__31117__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__31117__auto____1.call(this,state_32189);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__31117__auto____0;
cljs$core$async$mix_$_state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__31117__auto____1;
return cljs$core$async$mix_$_state_machine__31117__auto__;
})()
;})(switch__31116__auto__,c__31204__auto___32249,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__31206__auto__ = (function (){var statearr_32248 = f__31205__auto__.call(null);
(statearr_32248[(6)] = c__31204__auto___32249);

return statearr_32248;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31206__auto__);
});})(c__31204__auto___32249,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__27065__auto__ = (((p == null))?null:p);
var m__27066__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__27065__auto__)]);
if(!((m__27066__auto__ == null))){
return m__27066__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__27066__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__27066__auto____$1 == null))){
return m__27066__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__27065__auto__ = (((p == null))?null:p);
var m__27066__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__27065__auto__)]);
if(!((m__27066__auto__ == null))){
return m__27066__auto__.call(null,p,v,ch);
} else {
var m__27066__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__27066__auto____$1 == null))){
return m__27066__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__32299 = arguments.length;
switch (G__32299) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__27065__auto__ = (((p == null))?null:p);
var m__27066__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__27065__auto__)]);
if(!((m__27066__auto__ == null))){
return m__27066__auto__.call(null,p);
} else {
var m__27066__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__27066__auto____$1 == null))){
return m__27066__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__27065__auto__ = (((p == null))?null:p);
var m__27066__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__27065__auto__)]);
if(!((m__27066__auto__ == null))){
return m__27066__auto__.call(null,p,v);
} else {
var m__27066__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__27066__auto____$1 == null))){
return m__27066__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__32303 = arguments.length;
switch (G__32303) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__26396__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__26396__auto__)){
return or__26396__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__26396__auto__,mults){
return (function (p1__32301_SHARP_){
if(cljs.core.truth_(p1__32301_SHARP_.call(null,topic))){
return p1__32301_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__32301_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__26396__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async32304 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32304 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta32305){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta32305 = meta32305;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32304.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_32306,meta32305__$1){
var self__ = this;
var _32306__$1 = this;
return (new cljs.core.async.t_cljs$core$async32304(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta32305__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32304.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_32306){
var self__ = this;
var _32306__$1 = this;
return self__.meta32305;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32304.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32304.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32304.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32304.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32304.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32304.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32304.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32304.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta32305","meta32305",256798653,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32304.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32304.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32304";

cljs.core.async.t_cljs$core$async32304.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__27007__auto__,writer__27008__auto__,opt__27009__auto__){
return cljs.core._write.call(null,writer__27008__auto__,"cljs.core.async/t_cljs$core$async32304");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async32304 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async32304(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta32305){
return (new cljs.core.async.t_cljs$core$async32304(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta32305));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async32304(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__31204__auto___32424 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31204__auto___32424,mults,ensure_mult,p){
return (function (){
var f__31205__auto__ = (function (){var switch__31116__auto__ = ((function (c__31204__auto___32424,mults,ensure_mult,p){
return (function (state_32378){
var state_val_32379 = (state_32378[(1)]);
if((state_val_32379 === (7))){
var inst_32374 = (state_32378[(2)]);
var state_32378__$1 = state_32378;
var statearr_32380_32425 = state_32378__$1;
(statearr_32380_32425[(2)] = inst_32374);

(statearr_32380_32425[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (20))){
var state_32378__$1 = state_32378;
var statearr_32381_32426 = state_32378__$1;
(statearr_32381_32426[(2)] = null);

(statearr_32381_32426[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (1))){
var state_32378__$1 = state_32378;
var statearr_32382_32427 = state_32378__$1;
(statearr_32382_32427[(2)] = null);

(statearr_32382_32427[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (24))){
var inst_32357 = (state_32378[(7)]);
var inst_32366 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_32357);
var state_32378__$1 = state_32378;
var statearr_32383_32428 = state_32378__$1;
(statearr_32383_32428[(2)] = inst_32366);

(statearr_32383_32428[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (4))){
var inst_32309 = (state_32378[(8)]);
var inst_32309__$1 = (state_32378[(2)]);
var inst_32310 = (inst_32309__$1 == null);
var state_32378__$1 = (function (){var statearr_32384 = state_32378;
(statearr_32384[(8)] = inst_32309__$1);

return statearr_32384;
})();
if(cljs.core.truth_(inst_32310)){
var statearr_32385_32429 = state_32378__$1;
(statearr_32385_32429[(1)] = (5));

} else {
var statearr_32386_32430 = state_32378__$1;
(statearr_32386_32430[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (15))){
var inst_32351 = (state_32378[(2)]);
var state_32378__$1 = state_32378;
var statearr_32387_32431 = state_32378__$1;
(statearr_32387_32431[(2)] = inst_32351);

(statearr_32387_32431[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (21))){
var inst_32371 = (state_32378[(2)]);
var state_32378__$1 = (function (){var statearr_32388 = state_32378;
(statearr_32388[(9)] = inst_32371);

return statearr_32388;
})();
var statearr_32389_32432 = state_32378__$1;
(statearr_32389_32432[(2)] = null);

(statearr_32389_32432[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (13))){
var inst_32333 = (state_32378[(10)]);
var inst_32335 = cljs.core.chunked_seq_QMARK_.call(null,inst_32333);
var state_32378__$1 = state_32378;
if(inst_32335){
var statearr_32390_32433 = state_32378__$1;
(statearr_32390_32433[(1)] = (16));

} else {
var statearr_32391_32434 = state_32378__$1;
(statearr_32391_32434[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (22))){
var inst_32363 = (state_32378[(2)]);
var state_32378__$1 = state_32378;
if(cljs.core.truth_(inst_32363)){
var statearr_32392_32435 = state_32378__$1;
(statearr_32392_32435[(1)] = (23));

} else {
var statearr_32393_32436 = state_32378__$1;
(statearr_32393_32436[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (6))){
var inst_32357 = (state_32378[(7)]);
var inst_32309 = (state_32378[(8)]);
var inst_32359 = (state_32378[(11)]);
var inst_32357__$1 = topic_fn.call(null,inst_32309);
var inst_32358 = cljs.core.deref.call(null,mults);
var inst_32359__$1 = cljs.core.get.call(null,inst_32358,inst_32357__$1);
var state_32378__$1 = (function (){var statearr_32394 = state_32378;
(statearr_32394[(7)] = inst_32357__$1);

(statearr_32394[(11)] = inst_32359__$1);

return statearr_32394;
})();
if(cljs.core.truth_(inst_32359__$1)){
var statearr_32395_32437 = state_32378__$1;
(statearr_32395_32437[(1)] = (19));

} else {
var statearr_32396_32438 = state_32378__$1;
(statearr_32396_32438[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (25))){
var inst_32368 = (state_32378[(2)]);
var state_32378__$1 = state_32378;
var statearr_32397_32439 = state_32378__$1;
(statearr_32397_32439[(2)] = inst_32368);

(statearr_32397_32439[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (17))){
var inst_32333 = (state_32378[(10)]);
var inst_32342 = cljs.core.first.call(null,inst_32333);
var inst_32343 = cljs.core.async.muxch_STAR_.call(null,inst_32342);
var inst_32344 = cljs.core.async.close_BANG_.call(null,inst_32343);
var inst_32345 = cljs.core.next.call(null,inst_32333);
var inst_32319 = inst_32345;
var inst_32320 = null;
var inst_32321 = (0);
var inst_32322 = (0);
var state_32378__$1 = (function (){var statearr_32398 = state_32378;
(statearr_32398[(12)] = inst_32320);

(statearr_32398[(13)] = inst_32319);

(statearr_32398[(14)] = inst_32344);

(statearr_32398[(15)] = inst_32321);

(statearr_32398[(16)] = inst_32322);

return statearr_32398;
})();
var statearr_32399_32440 = state_32378__$1;
(statearr_32399_32440[(2)] = null);

(statearr_32399_32440[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (3))){
var inst_32376 = (state_32378[(2)]);
var state_32378__$1 = state_32378;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32378__$1,inst_32376);
} else {
if((state_val_32379 === (12))){
var inst_32353 = (state_32378[(2)]);
var state_32378__$1 = state_32378;
var statearr_32400_32441 = state_32378__$1;
(statearr_32400_32441[(2)] = inst_32353);

(statearr_32400_32441[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (2))){
var state_32378__$1 = state_32378;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32378__$1,(4),ch);
} else {
if((state_val_32379 === (23))){
var state_32378__$1 = state_32378;
var statearr_32401_32442 = state_32378__$1;
(statearr_32401_32442[(2)] = null);

(statearr_32401_32442[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (19))){
var inst_32309 = (state_32378[(8)]);
var inst_32359 = (state_32378[(11)]);
var inst_32361 = cljs.core.async.muxch_STAR_.call(null,inst_32359);
var state_32378__$1 = state_32378;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32378__$1,(22),inst_32361,inst_32309);
} else {
if((state_val_32379 === (11))){
var inst_32319 = (state_32378[(13)]);
var inst_32333 = (state_32378[(10)]);
var inst_32333__$1 = cljs.core.seq.call(null,inst_32319);
var state_32378__$1 = (function (){var statearr_32402 = state_32378;
(statearr_32402[(10)] = inst_32333__$1);

return statearr_32402;
})();
if(inst_32333__$1){
var statearr_32403_32443 = state_32378__$1;
(statearr_32403_32443[(1)] = (13));

} else {
var statearr_32404_32444 = state_32378__$1;
(statearr_32404_32444[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (9))){
var inst_32355 = (state_32378[(2)]);
var state_32378__$1 = state_32378;
var statearr_32405_32445 = state_32378__$1;
(statearr_32405_32445[(2)] = inst_32355);

(statearr_32405_32445[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (5))){
var inst_32316 = cljs.core.deref.call(null,mults);
var inst_32317 = cljs.core.vals.call(null,inst_32316);
var inst_32318 = cljs.core.seq.call(null,inst_32317);
var inst_32319 = inst_32318;
var inst_32320 = null;
var inst_32321 = (0);
var inst_32322 = (0);
var state_32378__$1 = (function (){var statearr_32406 = state_32378;
(statearr_32406[(12)] = inst_32320);

(statearr_32406[(13)] = inst_32319);

(statearr_32406[(15)] = inst_32321);

(statearr_32406[(16)] = inst_32322);

return statearr_32406;
})();
var statearr_32407_32446 = state_32378__$1;
(statearr_32407_32446[(2)] = null);

(statearr_32407_32446[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (14))){
var state_32378__$1 = state_32378;
var statearr_32411_32447 = state_32378__$1;
(statearr_32411_32447[(2)] = null);

(statearr_32411_32447[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (16))){
var inst_32333 = (state_32378[(10)]);
var inst_32337 = cljs.core.chunk_first.call(null,inst_32333);
var inst_32338 = cljs.core.chunk_rest.call(null,inst_32333);
var inst_32339 = cljs.core.count.call(null,inst_32337);
var inst_32319 = inst_32338;
var inst_32320 = inst_32337;
var inst_32321 = inst_32339;
var inst_32322 = (0);
var state_32378__$1 = (function (){var statearr_32412 = state_32378;
(statearr_32412[(12)] = inst_32320);

(statearr_32412[(13)] = inst_32319);

(statearr_32412[(15)] = inst_32321);

(statearr_32412[(16)] = inst_32322);

return statearr_32412;
})();
var statearr_32413_32448 = state_32378__$1;
(statearr_32413_32448[(2)] = null);

(statearr_32413_32448[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (10))){
var inst_32320 = (state_32378[(12)]);
var inst_32319 = (state_32378[(13)]);
var inst_32321 = (state_32378[(15)]);
var inst_32322 = (state_32378[(16)]);
var inst_32327 = cljs.core._nth.call(null,inst_32320,inst_32322);
var inst_32328 = cljs.core.async.muxch_STAR_.call(null,inst_32327);
var inst_32329 = cljs.core.async.close_BANG_.call(null,inst_32328);
var inst_32330 = (inst_32322 + (1));
var tmp32408 = inst_32320;
var tmp32409 = inst_32319;
var tmp32410 = inst_32321;
var inst_32319__$1 = tmp32409;
var inst_32320__$1 = tmp32408;
var inst_32321__$1 = tmp32410;
var inst_32322__$1 = inst_32330;
var state_32378__$1 = (function (){var statearr_32414 = state_32378;
(statearr_32414[(12)] = inst_32320__$1);

(statearr_32414[(13)] = inst_32319__$1);

(statearr_32414[(15)] = inst_32321__$1);

(statearr_32414[(16)] = inst_32322__$1);

(statearr_32414[(17)] = inst_32329);

return statearr_32414;
})();
var statearr_32415_32449 = state_32378__$1;
(statearr_32415_32449[(2)] = null);

(statearr_32415_32449[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (18))){
var inst_32348 = (state_32378[(2)]);
var state_32378__$1 = state_32378;
var statearr_32416_32450 = state_32378__$1;
(statearr_32416_32450[(2)] = inst_32348);

(statearr_32416_32450[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (8))){
var inst_32321 = (state_32378[(15)]);
var inst_32322 = (state_32378[(16)]);
var inst_32324 = (inst_32322 < inst_32321);
var inst_32325 = inst_32324;
var state_32378__$1 = state_32378;
if(cljs.core.truth_(inst_32325)){
var statearr_32417_32451 = state_32378__$1;
(statearr_32417_32451[(1)] = (10));

} else {
var statearr_32418_32452 = state_32378__$1;
(statearr_32418_32452[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31204__auto___32424,mults,ensure_mult,p))
;
return ((function (switch__31116__auto__,c__31204__auto___32424,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__31117__auto__ = null;
var cljs$core$async$state_machine__31117__auto____0 = (function (){
var statearr_32419 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32419[(0)] = cljs$core$async$state_machine__31117__auto__);

(statearr_32419[(1)] = (1));

return statearr_32419;
});
var cljs$core$async$state_machine__31117__auto____1 = (function (state_32378){
while(true){
var ret_value__31118__auto__ = (function (){try{while(true){
var result__31119__auto__ = switch__31116__auto__.call(null,state_32378);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31119__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31119__auto__;
}
break;
}
}catch (e32420){if((e32420 instanceof Object)){
var ex__31120__auto__ = e32420;
var statearr_32421_32453 = state_32378;
(statearr_32421_32453[(5)] = ex__31120__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32378);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32420;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31118__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32454 = state_32378;
state_32378 = G__32454;
continue;
} else {
return ret_value__31118__auto__;
}
break;
}
});
cljs$core$async$state_machine__31117__auto__ = function(state_32378){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31117__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31117__auto____1.call(this,state_32378);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31117__auto____0;
cljs$core$async$state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31117__auto____1;
return cljs$core$async$state_machine__31117__auto__;
})()
;})(switch__31116__auto__,c__31204__auto___32424,mults,ensure_mult,p))
})();
var state__31206__auto__ = (function (){var statearr_32422 = f__31205__auto__.call(null);
(statearr_32422[(6)] = c__31204__auto___32424);

return statearr_32422;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31206__auto__);
});})(c__31204__auto___32424,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__32456 = arguments.length;
switch (G__32456) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__32459 = arguments.length;
switch (G__32459) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__32462 = arguments.length;
switch (G__32462) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__31204__auto___32529 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31204__auto___32529,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__31205__auto__ = (function (){var switch__31116__auto__ = ((function (c__31204__auto___32529,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_32501){
var state_val_32502 = (state_32501[(1)]);
if((state_val_32502 === (7))){
var state_32501__$1 = state_32501;
var statearr_32503_32530 = state_32501__$1;
(statearr_32503_32530[(2)] = null);

(statearr_32503_32530[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32502 === (1))){
var state_32501__$1 = state_32501;
var statearr_32504_32531 = state_32501__$1;
(statearr_32504_32531[(2)] = null);

(statearr_32504_32531[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32502 === (4))){
var inst_32465 = (state_32501[(7)]);
var inst_32467 = (inst_32465 < cnt);
var state_32501__$1 = state_32501;
if(cljs.core.truth_(inst_32467)){
var statearr_32505_32532 = state_32501__$1;
(statearr_32505_32532[(1)] = (6));

} else {
var statearr_32506_32533 = state_32501__$1;
(statearr_32506_32533[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32502 === (15))){
var inst_32497 = (state_32501[(2)]);
var state_32501__$1 = state_32501;
var statearr_32507_32534 = state_32501__$1;
(statearr_32507_32534[(2)] = inst_32497);

(statearr_32507_32534[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32502 === (13))){
var inst_32490 = cljs.core.async.close_BANG_.call(null,out);
var state_32501__$1 = state_32501;
var statearr_32508_32535 = state_32501__$1;
(statearr_32508_32535[(2)] = inst_32490);

(statearr_32508_32535[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32502 === (6))){
var state_32501__$1 = state_32501;
var statearr_32509_32536 = state_32501__$1;
(statearr_32509_32536[(2)] = null);

(statearr_32509_32536[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32502 === (3))){
var inst_32499 = (state_32501[(2)]);
var state_32501__$1 = state_32501;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32501__$1,inst_32499);
} else {
if((state_val_32502 === (12))){
var inst_32487 = (state_32501[(8)]);
var inst_32487__$1 = (state_32501[(2)]);
var inst_32488 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_32487__$1);
var state_32501__$1 = (function (){var statearr_32510 = state_32501;
(statearr_32510[(8)] = inst_32487__$1);

return statearr_32510;
})();
if(cljs.core.truth_(inst_32488)){
var statearr_32511_32537 = state_32501__$1;
(statearr_32511_32537[(1)] = (13));

} else {
var statearr_32512_32538 = state_32501__$1;
(statearr_32512_32538[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32502 === (2))){
var inst_32464 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_32465 = (0);
var state_32501__$1 = (function (){var statearr_32513 = state_32501;
(statearr_32513[(7)] = inst_32465);

(statearr_32513[(9)] = inst_32464);

return statearr_32513;
})();
var statearr_32514_32539 = state_32501__$1;
(statearr_32514_32539[(2)] = null);

(statearr_32514_32539[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32502 === (11))){
var inst_32465 = (state_32501[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_32501,(10),Object,null,(9));
var inst_32474 = chs__$1.call(null,inst_32465);
var inst_32475 = done.call(null,inst_32465);
var inst_32476 = cljs.core.async.take_BANG_.call(null,inst_32474,inst_32475);
var state_32501__$1 = state_32501;
var statearr_32515_32540 = state_32501__$1;
(statearr_32515_32540[(2)] = inst_32476);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32501__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32502 === (9))){
var inst_32465 = (state_32501[(7)]);
var inst_32478 = (state_32501[(2)]);
var inst_32479 = (inst_32465 + (1));
var inst_32465__$1 = inst_32479;
var state_32501__$1 = (function (){var statearr_32516 = state_32501;
(statearr_32516[(10)] = inst_32478);

(statearr_32516[(7)] = inst_32465__$1);

return statearr_32516;
})();
var statearr_32517_32541 = state_32501__$1;
(statearr_32517_32541[(2)] = null);

(statearr_32517_32541[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32502 === (5))){
var inst_32485 = (state_32501[(2)]);
var state_32501__$1 = (function (){var statearr_32518 = state_32501;
(statearr_32518[(11)] = inst_32485);

return statearr_32518;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32501__$1,(12),dchan);
} else {
if((state_val_32502 === (14))){
var inst_32487 = (state_32501[(8)]);
var inst_32492 = cljs.core.apply.call(null,f,inst_32487);
var state_32501__$1 = state_32501;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32501__$1,(16),out,inst_32492);
} else {
if((state_val_32502 === (16))){
var inst_32494 = (state_32501[(2)]);
var state_32501__$1 = (function (){var statearr_32519 = state_32501;
(statearr_32519[(12)] = inst_32494);

return statearr_32519;
})();
var statearr_32520_32542 = state_32501__$1;
(statearr_32520_32542[(2)] = null);

(statearr_32520_32542[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32502 === (10))){
var inst_32469 = (state_32501[(2)]);
var inst_32470 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_32501__$1 = (function (){var statearr_32521 = state_32501;
(statearr_32521[(13)] = inst_32469);

return statearr_32521;
})();
var statearr_32522_32543 = state_32501__$1;
(statearr_32522_32543[(2)] = inst_32470);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32501__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32502 === (8))){
var inst_32483 = (state_32501[(2)]);
var state_32501__$1 = state_32501;
var statearr_32523_32544 = state_32501__$1;
(statearr_32523_32544[(2)] = inst_32483);

(statearr_32523_32544[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31204__auto___32529,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__31116__auto__,c__31204__auto___32529,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__31117__auto__ = null;
var cljs$core$async$state_machine__31117__auto____0 = (function (){
var statearr_32524 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32524[(0)] = cljs$core$async$state_machine__31117__auto__);

(statearr_32524[(1)] = (1));

return statearr_32524;
});
var cljs$core$async$state_machine__31117__auto____1 = (function (state_32501){
while(true){
var ret_value__31118__auto__ = (function (){try{while(true){
var result__31119__auto__ = switch__31116__auto__.call(null,state_32501);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31119__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31119__auto__;
}
break;
}
}catch (e32525){if((e32525 instanceof Object)){
var ex__31120__auto__ = e32525;
var statearr_32526_32545 = state_32501;
(statearr_32526_32545[(5)] = ex__31120__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32501);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32525;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31118__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32546 = state_32501;
state_32501 = G__32546;
continue;
} else {
return ret_value__31118__auto__;
}
break;
}
});
cljs$core$async$state_machine__31117__auto__ = function(state_32501){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31117__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31117__auto____1.call(this,state_32501);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31117__auto____0;
cljs$core$async$state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31117__auto____1;
return cljs$core$async$state_machine__31117__auto__;
})()
;})(switch__31116__auto__,c__31204__auto___32529,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__31206__auto__ = (function (){var statearr_32527 = f__31205__auto__.call(null);
(statearr_32527[(6)] = c__31204__auto___32529);

return statearr_32527;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31206__auto__);
});})(c__31204__auto___32529,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__32549 = arguments.length;
switch (G__32549) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__31204__auto___32603 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31204__auto___32603,out){
return (function (){
var f__31205__auto__ = (function (){var switch__31116__auto__ = ((function (c__31204__auto___32603,out){
return (function (state_32581){
var state_val_32582 = (state_32581[(1)]);
if((state_val_32582 === (7))){
var inst_32560 = (state_32581[(7)]);
var inst_32561 = (state_32581[(8)]);
var inst_32560__$1 = (state_32581[(2)]);
var inst_32561__$1 = cljs.core.nth.call(null,inst_32560__$1,(0),null);
var inst_32562 = cljs.core.nth.call(null,inst_32560__$1,(1),null);
var inst_32563 = (inst_32561__$1 == null);
var state_32581__$1 = (function (){var statearr_32583 = state_32581;
(statearr_32583[(9)] = inst_32562);

(statearr_32583[(7)] = inst_32560__$1);

(statearr_32583[(8)] = inst_32561__$1);

return statearr_32583;
})();
if(cljs.core.truth_(inst_32563)){
var statearr_32584_32604 = state_32581__$1;
(statearr_32584_32604[(1)] = (8));

} else {
var statearr_32585_32605 = state_32581__$1;
(statearr_32585_32605[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32582 === (1))){
var inst_32550 = cljs.core.vec.call(null,chs);
var inst_32551 = inst_32550;
var state_32581__$1 = (function (){var statearr_32586 = state_32581;
(statearr_32586[(10)] = inst_32551);

return statearr_32586;
})();
var statearr_32587_32606 = state_32581__$1;
(statearr_32587_32606[(2)] = null);

(statearr_32587_32606[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32582 === (4))){
var inst_32551 = (state_32581[(10)]);
var state_32581__$1 = state_32581;
return cljs.core.async.ioc_alts_BANG_.call(null,state_32581__$1,(7),inst_32551);
} else {
if((state_val_32582 === (6))){
var inst_32577 = (state_32581[(2)]);
var state_32581__$1 = state_32581;
var statearr_32588_32607 = state_32581__$1;
(statearr_32588_32607[(2)] = inst_32577);

(statearr_32588_32607[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32582 === (3))){
var inst_32579 = (state_32581[(2)]);
var state_32581__$1 = state_32581;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32581__$1,inst_32579);
} else {
if((state_val_32582 === (2))){
var inst_32551 = (state_32581[(10)]);
var inst_32553 = cljs.core.count.call(null,inst_32551);
var inst_32554 = (inst_32553 > (0));
var state_32581__$1 = state_32581;
if(cljs.core.truth_(inst_32554)){
var statearr_32590_32608 = state_32581__$1;
(statearr_32590_32608[(1)] = (4));

} else {
var statearr_32591_32609 = state_32581__$1;
(statearr_32591_32609[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32582 === (11))){
var inst_32551 = (state_32581[(10)]);
var inst_32570 = (state_32581[(2)]);
var tmp32589 = inst_32551;
var inst_32551__$1 = tmp32589;
var state_32581__$1 = (function (){var statearr_32592 = state_32581;
(statearr_32592[(10)] = inst_32551__$1);

(statearr_32592[(11)] = inst_32570);

return statearr_32592;
})();
var statearr_32593_32610 = state_32581__$1;
(statearr_32593_32610[(2)] = null);

(statearr_32593_32610[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32582 === (9))){
var inst_32561 = (state_32581[(8)]);
var state_32581__$1 = state_32581;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32581__$1,(11),out,inst_32561);
} else {
if((state_val_32582 === (5))){
var inst_32575 = cljs.core.async.close_BANG_.call(null,out);
var state_32581__$1 = state_32581;
var statearr_32594_32611 = state_32581__$1;
(statearr_32594_32611[(2)] = inst_32575);

(statearr_32594_32611[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32582 === (10))){
var inst_32573 = (state_32581[(2)]);
var state_32581__$1 = state_32581;
var statearr_32595_32612 = state_32581__$1;
(statearr_32595_32612[(2)] = inst_32573);

(statearr_32595_32612[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32582 === (8))){
var inst_32562 = (state_32581[(9)]);
var inst_32551 = (state_32581[(10)]);
var inst_32560 = (state_32581[(7)]);
var inst_32561 = (state_32581[(8)]);
var inst_32565 = (function (){var cs = inst_32551;
var vec__32556 = inst_32560;
var v = inst_32561;
var c = inst_32562;
return ((function (cs,vec__32556,v,c,inst_32562,inst_32551,inst_32560,inst_32561,state_val_32582,c__31204__auto___32603,out){
return (function (p1__32547_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__32547_SHARP_);
});
;})(cs,vec__32556,v,c,inst_32562,inst_32551,inst_32560,inst_32561,state_val_32582,c__31204__auto___32603,out))
})();
var inst_32566 = cljs.core.filterv.call(null,inst_32565,inst_32551);
var inst_32551__$1 = inst_32566;
var state_32581__$1 = (function (){var statearr_32596 = state_32581;
(statearr_32596[(10)] = inst_32551__$1);

return statearr_32596;
})();
var statearr_32597_32613 = state_32581__$1;
(statearr_32597_32613[(2)] = null);

(statearr_32597_32613[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__31204__auto___32603,out))
;
return ((function (switch__31116__auto__,c__31204__auto___32603,out){
return (function() {
var cljs$core$async$state_machine__31117__auto__ = null;
var cljs$core$async$state_machine__31117__auto____0 = (function (){
var statearr_32598 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32598[(0)] = cljs$core$async$state_machine__31117__auto__);

(statearr_32598[(1)] = (1));

return statearr_32598;
});
var cljs$core$async$state_machine__31117__auto____1 = (function (state_32581){
while(true){
var ret_value__31118__auto__ = (function (){try{while(true){
var result__31119__auto__ = switch__31116__auto__.call(null,state_32581);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31119__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31119__auto__;
}
break;
}
}catch (e32599){if((e32599 instanceof Object)){
var ex__31120__auto__ = e32599;
var statearr_32600_32614 = state_32581;
(statearr_32600_32614[(5)] = ex__31120__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32581);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32599;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31118__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32615 = state_32581;
state_32581 = G__32615;
continue;
} else {
return ret_value__31118__auto__;
}
break;
}
});
cljs$core$async$state_machine__31117__auto__ = function(state_32581){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31117__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31117__auto____1.call(this,state_32581);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31117__auto____0;
cljs$core$async$state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31117__auto____1;
return cljs$core$async$state_machine__31117__auto__;
})()
;})(switch__31116__auto__,c__31204__auto___32603,out))
})();
var state__31206__auto__ = (function (){var statearr_32601 = f__31205__auto__.call(null);
(statearr_32601[(6)] = c__31204__auto___32603);

return statearr_32601;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31206__auto__);
});})(c__31204__auto___32603,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__32617 = arguments.length;
switch (G__32617) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__31204__auto___32662 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31204__auto___32662,out){
return (function (){
var f__31205__auto__ = (function (){var switch__31116__auto__ = ((function (c__31204__auto___32662,out){
return (function (state_32641){
var state_val_32642 = (state_32641[(1)]);
if((state_val_32642 === (7))){
var inst_32623 = (state_32641[(7)]);
var inst_32623__$1 = (state_32641[(2)]);
var inst_32624 = (inst_32623__$1 == null);
var inst_32625 = cljs.core.not.call(null,inst_32624);
var state_32641__$1 = (function (){var statearr_32643 = state_32641;
(statearr_32643[(7)] = inst_32623__$1);

return statearr_32643;
})();
if(inst_32625){
var statearr_32644_32663 = state_32641__$1;
(statearr_32644_32663[(1)] = (8));

} else {
var statearr_32645_32664 = state_32641__$1;
(statearr_32645_32664[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32642 === (1))){
var inst_32618 = (0);
var state_32641__$1 = (function (){var statearr_32646 = state_32641;
(statearr_32646[(8)] = inst_32618);

return statearr_32646;
})();
var statearr_32647_32665 = state_32641__$1;
(statearr_32647_32665[(2)] = null);

(statearr_32647_32665[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32642 === (4))){
var state_32641__$1 = state_32641;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32641__$1,(7),ch);
} else {
if((state_val_32642 === (6))){
var inst_32636 = (state_32641[(2)]);
var state_32641__$1 = state_32641;
var statearr_32648_32666 = state_32641__$1;
(statearr_32648_32666[(2)] = inst_32636);

(statearr_32648_32666[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32642 === (3))){
var inst_32638 = (state_32641[(2)]);
var inst_32639 = cljs.core.async.close_BANG_.call(null,out);
var state_32641__$1 = (function (){var statearr_32649 = state_32641;
(statearr_32649[(9)] = inst_32638);

return statearr_32649;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32641__$1,inst_32639);
} else {
if((state_val_32642 === (2))){
var inst_32618 = (state_32641[(8)]);
var inst_32620 = (inst_32618 < n);
var state_32641__$1 = state_32641;
if(cljs.core.truth_(inst_32620)){
var statearr_32650_32667 = state_32641__$1;
(statearr_32650_32667[(1)] = (4));

} else {
var statearr_32651_32668 = state_32641__$1;
(statearr_32651_32668[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32642 === (11))){
var inst_32618 = (state_32641[(8)]);
var inst_32628 = (state_32641[(2)]);
var inst_32629 = (inst_32618 + (1));
var inst_32618__$1 = inst_32629;
var state_32641__$1 = (function (){var statearr_32652 = state_32641;
(statearr_32652[(8)] = inst_32618__$1);

(statearr_32652[(10)] = inst_32628);

return statearr_32652;
})();
var statearr_32653_32669 = state_32641__$1;
(statearr_32653_32669[(2)] = null);

(statearr_32653_32669[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32642 === (9))){
var state_32641__$1 = state_32641;
var statearr_32654_32670 = state_32641__$1;
(statearr_32654_32670[(2)] = null);

(statearr_32654_32670[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32642 === (5))){
var state_32641__$1 = state_32641;
var statearr_32655_32671 = state_32641__$1;
(statearr_32655_32671[(2)] = null);

(statearr_32655_32671[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32642 === (10))){
var inst_32633 = (state_32641[(2)]);
var state_32641__$1 = state_32641;
var statearr_32656_32672 = state_32641__$1;
(statearr_32656_32672[(2)] = inst_32633);

(statearr_32656_32672[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32642 === (8))){
var inst_32623 = (state_32641[(7)]);
var state_32641__$1 = state_32641;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32641__$1,(11),out,inst_32623);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__31204__auto___32662,out))
;
return ((function (switch__31116__auto__,c__31204__auto___32662,out){
return (function() {
var cljs$core$async$state_machine__31117__auto__ = null;
var cljs$core$async$state_machine__31117__auto____0 = (function (){
var statearr_32657 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32657[(0)] = cljs$core$async$state_machine__31117__auto__);

(statearr_32657[(1)] = (1));

return statearr_32657;
});
var cljs$core$async$state_machine__31117__auto____1 = (function (state_32641){
while(true){
var ret_value__31118__auto__ = (function (){try{while(true){
var result__31119__auto__ = switch__31116__auto__.call(null,state_32641);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31119__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31119__auto__;
}
break;
}
}catch (e32658){if((e32658 instanceof Object)){
var ex__31120__auto__ = e32658;
var statearr_32659_32673 = state_32641;
(statearr_32659_32673[(5)] = ex__31120__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32641);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32658;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31118__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32674 = state_32641;
state_32641 = G__32674;
continue;
} else {
return ret_value__31118__auto__;
}
break;
}
});
cljs$core$async$state_machine__31117__auto__ = function(state_32641){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31117__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31117__auto____1.call(this,state_32641);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31117__auto____0;
cljs$core$async$state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31117__auto____1;
return cljs$core$async$state_machine__31117__auto__;
})()
;})(switch__31116__auto__,c__31204__auto___32662,out))
})();
var state__31206__auto__ = (function (){var statearr_32660 = f__31205__auto__.call(null);
(statearr_32660[(6)] = c__31204__auto___32662);

return statearr_32660;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31206__auto__);
});})(c__31204__auto___32662,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async32676 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32676 = (function (f,ch,meta32677){
this.f = f;
this.ch = ch;
this.meta32677 = meta32677;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32676.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32678,meta32677__$1){
var self__ = this;
var _32678__$1 = this;
return (new cljs.core.async.t_cljs$core$async32676(self__.f,self__.ch,meta32677__$1));
});

cljs.core.async.t_cljs$core$async32676.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32678){
var self__ = this;
var _32678__$1 = this;
return self__.meta32677;
});

cljs.core.async.t_cljs$core$async32676.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32676.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32676.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32676.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32676.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async32679 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32679 = (function (f,ch,meta32677,_,fn1,meta32680){
this.f = f;
this.ch = ch;
this.meta32677 = meta32677;
this._ = _;
this.fn1 = fn1;
this.meta32680 = meta32680;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32679.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_32681,meta32680__$1){
var self__ = this;
var _32681__$1 = this;
return (new cljs.core.async.t_cljs$core$async32679(self__.f,self__.ch,self__.meta32677,self__._,self__.fn1,meta32680__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async32679.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_32681){
var self__ = this;
var _32681__$1 = this;
return self__.meta32680;
});})(___$1))
;

cljs.core.async.t_cljs$core$async32679.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32679.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async32679.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async32679.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__32675_SHARP_){
return f1.call(null,(((p1__32675_SHARP_ == null))?null:self__.f.call(null,p1__32675_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async32679.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32677","meta32677",-1187042355,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async32676","cljs.core.async/t_cljs$core$async32676",-893798094,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta32680","meta32680",-1801301463,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async32679.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32679.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32679";

cljs.core.async.t_cljs$core$async32679.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__27007__auto__,writer__27008__auto__,opt__27009__auto__){
return cljs.core._write.call(null,writer__27008__auto__,"cljs.core.async/t_cljs$core$async32679");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async32679 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async32679(f__$1,ch__$1,meta32677__$1,___$2,fn1__$1,meta32680){
return (new cljs.core.async.t_cljs$core$async32679(f__$1,ch__$1,meta32677__$1,___$2,fn1__$1,meta32680));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async32679(self__.f,self__.ch,self__.meta32677,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__26384__auto__ = ret;
if(cljs.core.truth_(and__26384__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__26384__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async32676.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32676.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async32676.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32677","meta32677",-1187042355,null)], null);
});

cljs.core.async.t_cljs$core$async32676.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32676.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32676";

cljs.core.async.t_cljs$core$async32676.cljs$lang$ctorPrWriter = (function (this__27007__auto__,writer__27008__auto__,opt__27009__auto__){
return cljs.core._write.call(null,writer__27008__auto__,"cljs.core.async/t_cljs$core$async32676");
});

cljs.core.async.__GT_t_cljs$core$async32676 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async32676(f__$1,ch__$1,meta32677){
return (new cljs.core.async.t_cljs$core$async32676(f__$1,ch__$1,meta32677));
});

}

return (new cljs.core.async.t_cljs$core$async32676(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async32682 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32682 = (function (f,ch,meta32683){
this.f = f;
this.ch = ch;
this.meta32683 = meta32683;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32682.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32684,meta32683__$1){
var self__ = this;
var _32684__$1 = this;
return (new cljs.core.async.t_cljs$core$async32682(self__.f,self__.ch,meta32683__$1));
});

cljs.core.async.t_cljs$core$async32682.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32684){
var self__ = this;
var _32684__$1 = this;
return self__.meta32683;
});

cljs.core.async.t_cljs$core$async32682.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32682.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32682.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32682.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async32682.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32682.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async32682.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32683","meta32683",753219947,null)], null);
});

cljs.core.async.t_cljs$core$async32682.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32682.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32682";

cljs.core.async.t_cljs$core$async32682.cljs$lang$ctorPrWriter = (function (this__27007__auto__,writer__27008__auto__,opt__27009__auto__){
return cljs.core._write.call(null,writer__27008__auto__,"cljs.core.async/t_cljs$core$async32682");
});

cljs.core.async.__GT_t_cljs$core$async32682 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async32682(f__$1,ch__$1,meta32683){
return (new cljs.core.async.t_cljs$core$async32682(f__$1,ch__$1,meta32683));
});

}

return (new cljs.core.async.t_cljs$core$async32682(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async32685 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32685 = (function (p,ch,meta32686){
this.p = p;
this.ch = ch;
this.meta32686 = meta32686;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32685.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32687,meta32686__$1){
var self__ = this;
var _32687__$1 = this;
return (new cljs.core.async.t_cljs$core$async32685(self__.p,self__.ch,meta32686__$1));
});

cljs.core.async.t_cljs$core$async32685.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32687){
var self__ = this;
var _32687__$1 = this;
return self__.meta32686;
});

cljs.core.async.t_cljs$core$async32685.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32685.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32685.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32685.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32685.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async32685.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32685.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async32685.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32686","meta32686",-901104203,null)], null);
});

cljs.core.async.t_cljs$core$async32685.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32685.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32685";

cljs.core.async.t_cljs$core$async32685.cljs$lang$ctorPrWriter = (function (this__27007__auto__,writer__27008__auto__,opt__27009__auto__){
return cljs.core._write.call(null,writer__27008__auto__,"cljs.core.async/t_cljs$core$async32685");
});

cljs.core.async.__GT_t_cljs$core$async32685 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async32685(p__$1,ch__$1,meta32686){
return (new cljs.core.async.t_cljs$core$async32685(p__$1,ch__$1,meta32686));
});

}

return (new cljs.core.async.t_cljs$core$async32685(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__32689 = arguments.length;
switch (G__32689) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__31204__auto___32729 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31204__auto___32729,out){
return (function (){
var f__31205__auto__ = (function (){var switch__31116__auto__ = ((function (c__31204__auto___32729,out){
return (function (state_32710){
var state_val_32711 = (state_32710[(1)]);
if((state_val_32711 === (7))){
var inst_32706 = (state_32710[(2)]);
var state_32710__$1 = state_32710;
var statearr_32712_32730 = state_32710__$1;
(statearr_32712_32730[(2)] = inst_32706);

(statearr_32712_32730[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32711 === (1))){
var state_32710__$1 = state_32710;
var statearr_32713_32731 = state_32710__$1;
(statearr_32713_32731[(2)] = null);

(statearr_32713_32731[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32711 === (4))){
var inst_32692 = (state_32710[(7)]);
var inst_32692__$1 = (state_32710[(2)]);
var inst_32693 = (inst_32692__$1 == null);
var state_32710__$1 = (function (){var statearr_32714 = state_32710;
(statearr_32714[(7)] = inst_32692__$1);

return statearr_32714;
})();
if(cljs.core.truth_(inst_32693)){
var statearr_32715_32732 = state_32710__$1;
(statearr_32715_32732[(1)] = (5));

} else {
var statearr_32716_32733 = state_32710__$1;
(statearr_32716_32733[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32711 === (6))){
var inst_32692 = (state_32710[(7)]);
var inst_32697 = p.call(null,inst_32692);
var state_32710__$1 = state_32710;
if(cljs.core.truth_(inst_32697)){
var statearr_32717_32734 = state_32710__$1;
(statearr_32717_32734[(1)] = (8));

} else {
var statearr_32718_32735 = state_32710__$1;
(statearr_32718_32735[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32711 === (3))){
var inst_32708 = (state_32710[(2)]);
var state_32710__$1 = state_32710;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32710__$1,inst_32708);
} else {
if((state_val_32711 === (2))){
var state_32710__$1 = state_32710;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32710__$1,(4),ch);
} else {
if((state_val_32711 === (11))){
var inst_32700 = (state_32710[(2)]);
var state_32710__$1 = state_32710;
var statearr_32719_32736 = state_32710__$1;
(statearr_32719_32736[(2)] = inst_32700);

(statearr_32719_32736[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32711 === (9))){
var state_32710__$1 = state_32710;
var statearr_32720_32737 = state_32710__$1;
(statearr_32720_32737[(2)] = null);

(statearr_32720_32737[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32711 === (5))){
var inst_32695 = cljs.core.async.close_BANG_.call(null,out);
var state_32710__$1 = state_32710;
var statearr_32721_32738 = state_32710__$1;
(statearr_32721_32738[(2)] = inst_32695);

(statearr_32721_32738[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32711 === (10))){
var inst_32703 = (state_32710[(2)]);
var state_32710__$1 = (function (){var statearr_32722 = state_32710;
(statearr_32722[(8)] = inst_32703);

return statearr_32722;
})();
var statearr_32723_32739 = state_32710__$1;
(statearr_32723_32739[(2)] = null);

(statearr_32723_32739[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32711 === (8))){
var inst_32692 = (state_32710[(7)]);
var state_32710__$1 = state_32710;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32710__$1,(11),out,inst_32692);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__31204__auto___32729,out))
;
return ((function (switch__31116__auto__,c__31204__auto___32729,out){
return (function() {
var cljs$core$async$state_machine__31117__auto__ = null;
var cljs$core$async$state_machine__31117__auto____0 = (function (){
var statearr_32724 = [null,null,null,null,null,null,null,null,null];
(statearr_32724[(0)] = cljs$core$async$state_machine__31117__auto__);

(statearr_32724[(1)] = (1));

return statearr_32724;
});
var cljs$core$async$state_machine__31117__auto____1 = (function (state_32710){
while(true){
var ret_value__31118__auto__ = (function (){try{while(true){
var result__31119__auto__ = switch__31116__auto__.call(null,state_32710);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31119__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31119__auto__;
}
break;
}
}catch (e32725){if((e32725 instanceof Object)){
var ex__31120__auto__ = e32725;
var statearr_32726_32740 = state_32710;
(statearr_32726_32740[(5)] = ex__31120__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32710);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32725;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31118__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32741 = state_32710;
state_32710 = G__32741;
continue;
} else {
return ret_value__31118__auto__;
}
break;
}
});
cljs$core$async$state_machine__31117__auto__ = function(state_32710){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31117__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31117__auto____1.call(this,state_32710);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31117__auto____0;
cljs$core$async$state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31117__auto____1;
return cljs$core$async$state_machine__31117__auto__;
})()
;})(switch__31116__auto__,c__31204__auto___32729,out))
})();
var state__31206__auto__ = (function (){var statearr_32727 = f__31205__auto__.call(null);
(statearr_32727[(6)] = c__31204__auto___32729);

return statearr_32727;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31206__auto__);
});})(c__31204__auto___32729,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__32743 = arguments.length;
switch (G__32743) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__31204__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31204__auto__){
return (function (){
var f__31205__auto__ = (function (){var switch__31116__auto__ = ((function (c__31204__auto__){
return (function (state_32806){
var state_val_32807 = (state_32806[(1)]);
if((state_val_32807 === (7))){
var inst_32802 = (state_32806[(2)]);
var state_32806__$1 = state_32806;
var statearr_32808_32846 = state_32806__$1;
(statearr_32808_32846[(2)] = inst_32802);

(statearr_32808_32846[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32807 === (20))){
var inst_32772 = (state_32806[(7)]);
var inst_32783 = (state_32806[(2)]);
var inst_32784 = cljs.core.next.call(null,inst_32772);
var inst_32758 = inst_32784;
var inst_32759 = null;
var inst_32760 = (0);
var inst_32761 = (0);
var state_32806__$1 = (function (){var statearr_32809 = state_32806;
(statearr_32809[(8)] = inst_32761);

(statearr_32809[(9)] = inst_32759);

(statearr_32809[(10)] = inst_32783);

(statearr_32809[(11)] = inst_32758);

(statearr_32809[(12)] = inst_32760);

return statearr_32809;
})();
var statearr_32810_32847 = state_32806__$1;
(statearr_32810_32847[(2)] = null);

(statearr_32810_32847[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32807 === (1))){
var state_32806__$1 = state_32806;
var statearr_32811_32848 = state_32806__$1;
(statearr_32811_32848[(2)] = null);

(statearr_32811_32848[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32807 === (4))){
var inst_32747 = (state_32806[(13)]);
var inst_32747__$1 = (state_32806[(2)]);
var inst_32748 = (inst_32747__$1 == null);
var state_32806__$1 = (function (){var statearr_32812 = state_32806;
(statearr_32812[(13)] = inst_32747__$1);

return statearr_32812;
})();
if(cljs.core.truth_(inst_32748)){
var statearr_32813_32849 = state_32806__$1;
(statearr_32813_32849[(1)] = (5));

} else {
var statearr_32814_32850 = state_32806__$1;
(statearr_32814_32850[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32807 === (15))){
var state_32806__$1 = state_32806;
var statearr_32818_32851 = state_32806__$1;
(statearr_32818_32851[(2)] = null);

(statearr_32818_32851[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32807 === (21))){
var state_32806__$1 = state_32806;
var statearr_32819_32852 = state_32806__$1;
(statearr_32819_32852[(2)] = null);

(statearr_32819_32852[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32807 === (13))){
var inst_32761 = (state_32806[(8)]);
var inst_32759 = (state_32806[(9)]);
var inst_32758 = (state_32806[(11)]);
var inst_32760 = (state_32806[(12)]);
var inst_32768 = (state_32806[(2)]);
var inst_32769 = (inst_32761 + (1));
var tmp32815 = inst_32759;
var tmp32816 = inst_32758;
var tmp32817 = inst_32760;
var inst_32758__$1 = tmp32816;
var inst_32759__$1 = tmp32815;
var inst_32760__$1 = tmp32817;
var inst_32761__$1 = inst_32769;
var state_32806__$1 = (function (){var statearr_32820 = state_32806;
(statearr_32820[(8)] = inst_32761__$1);

(statearr_32820[(9)] = inst_32759__$1);

(statearr_32820[(11)] = inst_32758__$1);

(statearr_32820[(14)] = inst_32768);

(statearr_32820[(12)] = inst_32760__$1);

return statearr_32820;
})();
var statearr_32821_32853 = state_32806__$1;
(statearr_32821_32853[(2)] = null);

(statearr_32821_32853[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32807 === (22))){
var state_32806__$1 = state_32806;
var statearr_32822_32854 = state_32806__$1;
(statearr_32822_32854[(2)] = null);

(statearr_32822_32854[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32807 === (6))){
var inst_32747 = (state_32806[(13)]);
var inst_32756 = f.call(null,inst_32747);
var inst_32757 = cljs.core.seq.call(null,inst_32756);
var inst_32758 = inst_32757;
var inst_32759 = null;
var inst_32760 = (0);
var inst_32761 = (0);
var state_32806__$1 = (function (){var statearr_32823 = state_32806;
(statearr_32823[(8)] = inst_32761);

(statearr_32823[(9)] = inst_32759);

(statearr_32823[(11)] = inst_32758);

(statearr_32823[(12)] = inst_32760);

return statearr_32823;
})();
var statearr_32824_32855 = state_32806__$1;
(statearr_32824_32855[(2)] = null);

(statearr_32824_32855[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32807 === (17))){
var inst_32772 = (state_32806[(7)]);
var inst_32776 = cljs.core.chunk_first.call(null,inst_32772);
var inst_32777 = cljs.core.chunk_rest.call(null,inst_32772);
var inst_32778 = cljs.core.count.call(null,inst_32776);
var inst_32758 = inst_32777;
var inst_32759 = inst_32776;
var inst_32760 = inst_32778;
var inst_32761 = (0);
var state_32806__$1 = (function (){var statearr_32825 = state_32806;
(statearr_32825[(8)] = inst_32761);

(statearr_32825[(9)] = inst_32759);

(statearr_32825[(11)] = inst_32758);

(statearr_32825[(12)] = inst_32760);

return statearr_32825;
})();
var statearr_32826_32856 = state_32806__$1;
(statearr_32826_32856[(2)] = null);

(statearr_32826_32856[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32807 === (3))){
var inst_32804 = (state_32806[(2)]);
var state_32806__$1 = state_32806;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32806__$1,inst_32804);
} else {
if((state_val_32807 === (12))){
var inst_32792 = (state_32806[(2)]);
var state_32806__$1 = state_32806;
var statearr_32827_32857 = state_32806__$1;
(statearr_32827_32857[(2)] = inst_32792);

(statearr_32827_32857[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32807 === (2))){
var state_32806__$1 = state_32806;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32806__$1,(4),in$);
} else {
if((state_val_32807 === (23))){
var inst_32800 = (state_32806[(2)]);
var state_32806__$1 = state_32806;
var statearr_32828_32858 = state_32806__$1;
(statearr_32828_32858[(2)] = inst_32800);

(statearr_32828_32858[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32807 === (19))){
var inst_32787 = (state_32806[(2)]);
var state_32806__$1 = state_32806;
var statearr_32829_32859 = state_32806__$1;
(statearr_32829_32859[(2)] = inst_32787);

(statearr_32829_32859[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32807 === (11))){
var inst_32758 = (state_32806[(11)]);
var inst_32772 = (state_32806[(7)]);
var inst_32772__$1 = cljs.core.seq.call(null,inst_32758);
var state_32806__$1 = (function (){var statearr_32830 = state_32806;
(statearr_32830[(7)] = inst_32772__$1);

return statearr_32830;
})();
if(inst_32772__$1){
var statearr_32831_32860 = state_32806__$1;
(statearr_32831_32860[(1)] = (14));

} else {
var statearr_32832_32861 = state_32806__$1;
(statearr_32832_32861[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32807 === (9))){
var inst_32794 = (state_32806[(2)]);
var inst_32795 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_32806__$1 = (function (){var statearr_32833 = state_32806;
(statearr_32833[(15)] = inst_32794);

return statearr_32833;
})();
if(cljs.core.truth_(inst_32795)){
var statearr_32834_32862 = state_32806__$1;
(statearr_32834_32862[(1)] = (21));

} else {
var statearr_32835_32863 = state_32806__$1;
(statearr_32835_32863[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32807 === (5))){
var inst_32750 = cljs.core.async.close_BANG_.call(null,out);
var state_32806__$1 = state_32806;
var statearr_32836_32864 = state_32806__$1;
(statearr_32836_32864[(2)] = inst_32750);

(statearr_32836_32864[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32807 === (14))){
var inst_32772 = (state_32806[(7)]);
var inst_32774 = cljs.core.chunked_seq_QMARK_.call(null,inst_32772);
var state_32806__$1 = state_32806;
if(inst_32774){
var statearr_32837_32865 = state_32806__$1;
(statearr_32837_32865[(1)] = (17));

} else {
var statearr_32838_32866 = state_32806__$1;
(statearr_32838_32866[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32807 === (16))){
var inst_32790 = (state_32806[(2)]);
var state_32806__$1 = state_32806;
var statearr_32839_32867 = state_32806__$1;
(statearr_32839_32867[(2)] = inst_32790);

(statearr_32839_32867[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32807 === (10))){
var inst_32761 = (state_32806[(8)]);
var inst_32759 = (state_32806[(9)]);
var inst_32766 = cljs.core._nth.call(null,inst_32759,inst_32761);
var state_32806__$1 = state_32806;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32806__$1,(13),out,inst_32766);
} else {
if((state_val_32807 === (18))){
var inst_32772 = (state_32806[(7)]);
var inst_32781 = cljs.core.first.call(null,inst_32772);
var state_32806__$1 = state_32806;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32806__$1,(20),out,inst_32781);
} else {
if((state_val_32807 === (8))){
var inst_32761 = (state_32806[(8)]);
var inst_32760 = (state_32806[(12)]);
var inst_32763 = (inst_32761 < inst_32760);
var inst_32764 = inst_32763;
var state_32806__$1 = state_32806;
if(cljs.core.truth_(inst_32764)){
var statearr_32840_32868 = state_32806__$1;
(statearr_32840_32868[(1)] = (10));

} else {
var statearr_32841_32869 = state_32806__$1;
(statearr_32841_32869[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31204__auto__))
;
return ((function (switch__31116__auto__,c__31204__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__31117__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__31117__auto____0 = (function (){
var statearr_32842 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32842[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__31117__auto__);

(statearr_32842[(1)] = (1));

return statearr_32842;
});
var cljs$core$async$mapcat_STAR__$_state_machine__31117__auto____1 = (function (state_32806){
while(true){
var ret_value__31118__auto__ = (function (){try{while(true){
var result__31119__auto__ = switch__31116__auto__.call(null,state_32806);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31119__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31119__auto__;
}
break;
}
}catch (e32843){if((e32843 instanceof Object)){
var ex__31120__auto__ = e32843;
var statearr_32844_32870 = state_32806;
(statearr_32844_32870[(5)] = ex__31120__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32806);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32843;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31118__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32871 = state_32806;
state_32806 = G__32871;
continue;
} else {
return ret_value__31118__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__31117__auto__ = function(state_32806){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__31117__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__31117__auto____1.call(this,state_32806);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__31117__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__31117__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__31117__auto__;
})()
;})(switch__31116__auto__,c__31204__auto__))
})();
var state__31206__auto__ = (function (){var statearr_32845 = f__31205__auto__.call(null);
(statearr_32845[(6)] = c__31204__auto__);

return statearr_32845;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31206__auto__);
});})(c__31204__auto__))
);

return c__31204__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__32873 = arguments.length;
switch (G__32873) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__32876 = arguments.length;
switch (G__32876) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__32879 = arguments.length;
switch (G__32879) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__31204__auto___32926 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31204__auto___32926,out){
return (function (){
var f__31205__auto__ = (function (){var switch__31116__auto__ = ((function (c__31204__auto___32926,out){
return (function (state_32903){
var state_val_32904 = (state_32903[(1)]);
if((state_val_32904 === (7))){
var inst_32898 = (state_32903[(2)]);
var state_32903__$1 = state_32903;
var statearr_32905_32927 = state_32903__$1;
(statearr_32905_32927[(2)] = inst_32898);

(statearr_32905_32927[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (1))){
var inst_32880 = null;
var state_32903__$1 = (function (){var statearr_32906 = state_32903;
(statearr_32906[(7)] = inst_32880);

return statearr_32906;
})();
var statearr_32907_32928 = state_32903__$1;
(statearr_32907_32928[(2)] = null);

(statearr_32907_32928[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (4))){
var inst_32883 = (state_32903[(8)]);
var inst_32883__$1 = (state_32903[(2)]);
var inst_32884 = (inst_32883__$1 == null);
var inst_32885 = cljs.core.not.call(null,inst_32884);
var state_32903__$1 = (function (){var statearr_32908 = state_32903;
(statearr_32908[(8)] = inst_32883__$1);

return statearr_32908;
})();
if(inst_32885){
var statearr_32909_32929 = state_32903__$1;
(statearr_32909_32929[(1)] = (5));

} else {
var statearr_32910_32930 = state_32903__$1;
(statearr_32910_32930[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (6))){
var state_32903__$1 = state_32903;
var statearr_32911_32931 = state_32903__$1;
(statearr_32911_32931[(2)] = null);

(statearr_32911_32931[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (3))){
var inst_32900 = (state_32903[(2)]);
var inst_32901 = cljs.core.async.close_BANG_.call(null,out);
var state_32903__$1 = (function (){var statearr_32912 = state_32903;
(statearr_32912[(9)] = inst_32900);

return statearr_32912;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32903__$1,inst_32901);
} else {
if((state_val_32904 === (2))){
var state_32903__$1 = state_32903;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32903__$1,(4),ch);
} else {
if((state_val_32904 === (11))){
var inst_32883 = (state_32903[(8)]);
var inst_32892 = (state_32903[(2)]);
var inst_32880 = inst_32883;
var state_32903__$1 = (function (){var statearr_32913 = state_32903;
(statearr_32913[(10)] = inst_32892);

(statearr_32913[(7)] = inst_32880);

return statearr_32913;
})();
var statearr_32914_32932 = state_32903__$1;
(statearr_32914_32932[(2)] = null);

(statearr_32914_32932[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (9))){
var inst_32883 = (state_32903[(8)]);
var state_32903__$1 = state_32903;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32903__$1,(11),out,inst_32883);
} else {
if((state_val_32904 === (5))){
var inst_32883 = (state_32903[(8)]);
var inst_32880 = (state_32903[(7)]);
var inst_32887 = cljs.core._EQ_.call(null,inst_32883,inst_32880);
var state_32903__$1 = state_32903;
if(inst_32887){
var statearr_32916_32933 = state_32903__$1;
(statearr_32916_32933[(1)] = (8));

} else {
var statearr_32917_32934 = state_32903__$1;
(statearr_32917_32934[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (10))){
var inst_32895 = (state_32903[(2)]);
var state_32903__$1 = state_32903;
var statearr_32918_32935 = state_32903__$1;
(statearr_32918_32935[(2)] = inst_32895);

(statearr_32918_32935[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (8))){
var inst_32880 = (state_32903[(7)]);
var tmp32915 = inst_32880;
var inst_32880__$1 = tmp32915;
var state_32903__$1 = (function (){var statearr_32919 = state_32903;
(statearr_32919[(7)] = inst_32880__$1);

return statearr_32919;
})();
var statearr_32920_32936 = state_32903__$1;
(statearr_32920_32936[(2)] = null);

(statearr_32920_32936[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__31204__auto___32926,out))
;
return ((function (switch__31116__auto__,c__31204__auto___32926,out){
return (function() {
var cljs$core$async$state_machine__31117__auto__ = null;
var cljs$core$async$state_machine__31117__auto____0 = (function (){
var statearr_32921 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32921[(0)] = cljs$core$async$state_machine__31117__auto__);

(statearr_32921[(1)] = (1));

return statearr_32921;
});
var cljs$core$async$state_machine__31117__auto____1 = (function (state_32903){
while(true){
var ret_value__31118__auto__ = (function (){try{while(true){
var result__31119__auto__ = switch__31116__auto__.call(null,state_32903);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31119__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31119__auto__;
}
break;
}
}catch (e32922){if((e32922 instanceof Object)){
var ex__31120__auto__ = e32922;
var statearr_32923_32937 = state_32903;
(statearr_32923_32937[(5)] = ex__31120__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32903);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32922;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31118__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32938 = state_32903;
state_32903 = G__32938;
continue;
} else {
return ret_value__31118__auto__;
}
break;
}
});
cljs$core$async$state_machine__31117__auto__ = function(state_32903){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31117__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31117__auto____1.call(this,state_32903);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31117__auto____0;
cljs$core$async$state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31117__auto____1;
return cljs$core$async$state_machine__31117__auto__;
})()
;})(switch__31116__auto__,c__31204__auto___32926,out))
})();
var state__31206__auto__ = (function (){var statearr_32924 = f__31205__auto__.call(null);
(statearr_32924[(6)] = c__31204__auto___32926);

return statearr_32924;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31206__auto__);
});})(c__31204__auto___32926,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__32940 = arguments.length;
switch (G__32940) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__31204__auto___33006 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31204__auto___33006,out){
return (function (){
var f__31205__auto__ = (function (){var switch__31116__auto__ = ((function (c__31204__auto___33006,out){
return (function (state_32978){
var state_val_32979 = (state_32978[(1)]);
if((state_val_32979 === (7))){
var inst_32974 = (state_32978[(2)]);
var state_32978__$1 = state_32978;
var statearr_32980_33007 = state_32978__$1;
(statearr_32980_33007[(2)] = inst_32974);

(statearr_32980_33007[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32979 === (1))){
var inst_32941 = (new Array(n));
var inst_32942 = inst_32941;
var inst_32943 = (0);
var state_32978__$1 = (function (){var statearr_32981 = state_32978;
(statearr_32981[(7)] = inst_32942);

(statearr_32981[(8)] = inst_32943);

return statearr_32981;
})();
var statearr_32982_33008 = state_32978__$1;
(statearr_32982_33008[(2)] = null);

(statearr_32982_33008[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32979 === (4))){
var inst_32946 = (state_32978[(9)]);
var inst_32946__$1 = (state_32978[(2)]);
var inst_32947 = (inst_32946__$1 == null);
var inst_32948 = cljs.core.not.call(null,inst_32947);
var state_32978__$1 = (function (){var statearr_32983 = state_32978;
(statearr_32983[(9)] = inst_32946__$1);

return statearr_32983;
})();
if(inst_32948){
var statearr_32984_33009 = state_32978__$1;
(statearr_32984_33009[(1)] = (5));

} else {
var statearr_32985_33010 = state_32978__$1;
(statearr_32985_33010[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32979 === (15))){
var inst_32968 = (state_32978[(2)]);
var state_32978__$1 = state_32978;
var statearr_32986_33011 = state_32978__$1;
(statearr_32986_33011[(2)] = inst_32968);

(statearr_32986_33011[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32979 === (13))){
var state_32978__$1 = state_32978;
var statearr_32987_33012 = state_32978__$1;
(statearr_32987_33012[(2)] = null);

(statearr_32987_33012[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32979 === (6))){
var inst_32943 = (state_32978[(8)]);
var inst_32964 = (inst_32943 > (0));
var state_32978__$1 = state_32978;
if(cljs.core.truth_(inst_32964)){
var statearr_32988_33013 = state_32978__$1;
(statearr_32988_33013[(1)] = (12));

} else {
var statearr_32989_33014 = state_32978__$1;
(statearr_32989_33014[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32979 === (3))){
var inst_32976 = (state_32978[(2)]);
var state_32978__$1 = state_32978;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32978__$1,inst_32976);
} else {
if((state_val_32979 === (12))){
var inst_32942 = (state_32978[(7)]);
var inst_32966 = cljs.core.vec.call(null,inst_32942);
var state_32978__$1 = state_32978;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32978__$1,(15),out,inst_32966);
} else {
if((state_val_32979 === (2))){
var state_32978__$1 = state_32978;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32978__$1,(4),ch);
} else {
if((state_val_32979 === (11))){
var inst_32958 = (state_32978[(2)]);
var inst_32959 = (new Array(n));
var inst_32942 = inst_32959;
var inst_32943 = (0);
var state_32978__$1 = (function (){var statearr_32990 = state_32978;
(statearr_32990[(7)] = inst_32942);

(statearr_32990[(8)] = inst_32943);

(statearr_32990[(10)] = inst_32958);

return statearr_32990;
})();
var statearr_32991_33015 = state_32978__$1;
(statearr_32991_33015[(2)] = null);

(statearr_32991_33015[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32979 === (9))){
var inst_32942 = (state_32978[(7)]);
var inst_32956 = cljs.core.vec.call(null,inst_32942);
var state_32978__$1 = state_32978;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32978__$1,(11),out,inst_32956);
} else {
if((state_val_32979 === (5))){
var inst_32942 = (state_32978[(7)]);
var inst_32943 = (state_32978[(8)]);
var inst_32951 = (state_32978[(11)]);
var inst_32946 = (state_32978[(9)]);
var inst_32950 = (inst_32942[inst_32943] = inst_32946);
var inst_32951__$1 = (inst_32943 + (1));
var inst_32952 = (inst_32951__$1 < n);
var state_32978__$1 = (function (){var statearr_32992 = state_32978;
(statearr_32992[(11)] = inst_32951__$1);

(statearr_32992[(12)] = inst_32950);

return statearr_32992;
})();
if(cljs.core.truth_(inst_32952)){
var statearr_32993_33016 = state_32978__$1;
(statearr_32993_33016[(1)] = (8));

} else {
var statearr_32994_33017 = state_32978__$1;
(statearr_32994_33017[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32979 === (14))){
var inst_32971 = (state_32978[(2)]);
var inst_32972 = cljs.core.async.close_BANG_.call(null,out);
var state_32978__$1 = (function (){var statearr_32996 = state_32978;
(statearr_32996[(13)] = inst_32971);

return statearr_32996;
})();
var statearr_32997_33018 = state_32978__$1;
(statearr_32997_33018[(2)] = inst_32972);

(statearr_32997_33018[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32979 === (10))){
var inst_32962 = (state_32978[(2)]);
var state_32978__$1 = state_32978;
var statearr_32998_33019 = state_32978__$1;
(statearr_32998_33019[(2)] = inst_32962);

(statearr_32998_33019[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32979 === (8))){
var inst_32942 = (state_32978[(7)]);
var inst_32951 = (state_32978[(11)]);
var tmp32995 = inst_32942;
var inst_32942__$1 = tmp32995;
var inst_32943 = inst_32951;
var state_32978__$1 = (function (){var statearr_32999 = state_32978;
(statearr_32999[(7)] = inst_32942__$1);

(statearr_32999[(8)] = inst_32943);

return statearr_32999;
})();
var statearr_33000_33020 = state_32978__$1;
(statearr_33000_33020[(2)] = null);

(statearr_33000_33020[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31204__auto___33006,out))
;
return ((function (switch__31116__auto__,c__31204__auto___33006,out){
return (function() {
var cljs$core$async$state_machine__31117__auto__ = null;
var cljs$core$async$state_machine__31117__auto____0 = (function (){
var statearr_33001 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33001[(0)] = cljs$core$async$state_machine__31117__auto__);

(statearr_33001[(1)] = (1));

return statearr_33001;
});
var cljs$core$async$state_machine__31117__auto____1 = (function (state_32978){
while(true){
var ret_value__31118__auto__ = (function (){try{while(true){
var result__31119__auto__ = switch__31116__auto__.call(null,state_32978);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31119__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31119__auto__;
}
break;
}
}catch (e33002){if((e33002 instanceof Object)){
var ex__31120__auto__ = e33002;
var statearr_33003_33021 = state_32978;
(statearr_33003_33021[(5)] = ex__31120__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32978);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33002;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31118__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33022 = state_32978;
state_32978 = G__33022;
continue;
} else {
return ret_value__31118__auto__;
}
break;
}
});
cljs$core$async$state_machine__31117__auto__ = function(state_32978){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31117__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31117__auto____1.call(this,state_32978);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31117__auto____0;
cljs$core$async$state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31117__auto____1;
return cljs$core$async$state_machine__31117__auto__;
})()
;})(switch__31116__auto__,c__31204__auto___33006,out))
})();
var state__31206__auto__ = (function (){var statearr_33004 = f__31205__auto__.call(null);
(statearr_33004[(6)] = c__31204__auto___33006);

return statearr_33004;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31206__auto__);
});})(c__31204__auto___33006,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__33024 = arguments.length;
switch (G__33024) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__31204__auto___33094 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31204__auto___33094,out){
return (function (){
var f__31205__auto__ = (function (){var switch__31116__auto__ = ((function (c__31204__auto___33094,out){
return (function (state_33066){
var state_val_33067 = (state_33066[(1)]);
if((state_val_33067 === (7))){
var inst_33062 = (state_33066[(2)]);
var state_33066__$1 = state_33066;
var statearr_33068_33095 = state_33066__$1;
(statearr_33068_33095[(2)] = inst_33062);

(statearr_33068_33095[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (1))){
var inst_33025 = [];
var inst_33026 = inst_33025;
var inst_33027 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_33066__$1 = (function (){var statearr_33069 = state_33066;
(statearr_33069[(7)] = inst_33026);

(statearr_33069[(8)] = inst_33027);

return statearr_33069;
})();
var statearr_33070_33096 = state_33066__$1;
(statearr_33070_33096[(2)] = null);

(statearr_33070_33096[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (4))){
var inst_33030 = (state_33066[(9)]);
var inst_33030__$1 = (state_33066[(2)]);
var inst_33031 = (inst_33030__$1 == null);
var inst_33032 = cljs.core.not.call(null,inst_33031);
var state_33066__$1 = (function (){var statearr_33071 = state_33066;
(statearr_33071[(9)] = inst_33030__$1);

return statearr_33071;
})();
if(inst_33032){
var statearr_33072_33097 = state_33066__$1;
(statearr_33072_33097[(1)] = (5));

} else {
var statearr_33073_33098 = state_33066__$1;
(statearr_33073_33098[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (15))){
var inst_33056 = (state_33066[(2)]);
var state_33066__$1 = state_33066;
var statearr_33074_33099 = state_33066__$1;
(statearr_33074_33099[(2)] = inst_33056);

(statearr_33074_33099[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (13))){
var state_33066__$1 = state_33066;
var statearr_33075_33100 = state_33066__$1;
(statearr_33075_33100[(2)] = null);

(statearr_33075_33100[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (6))){
var inst_33026 = (state_33066[(7)]);
var inst_33051 = inst_33026.length;
var inst_33052 = (inst_33051 > (0));
var state_33066__$1 = state_33066;
if(cljs.core.truth_(inst_33052)){
var statearr_33076_33101 = state_33066__$1;
(statearr_33076_33101[(1)] = (12));

} else {
var statearr_33077_33102 = state_33066__$1;
(statearr_33077_33102[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (3))){
var inst_33064 = (state_33066[(2)]);
var state_33066__$1 = state_33066;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33066__$1,inst_33064);
} else {
if((state_val_33067 === (12))){
var inst_33026 = (state_33066[(7)]);
var inst_33054 = cljs.core.vec.call(null,inst_33026);
var state_33066__$1 = state_33066;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33066__$1,(15),out,inst_33054);
} else {
if((state_val_33067 === (2))){
var state_33066__$1 = state_33066;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33066__$1,(4),ch);
} else {
if((state_val_33067 === (11))){
var inst_33034 = (state_33066[(10)]);
var inst_33030 = (state_33066[(9)]);
var inst_33044 = (state_33066[(2)]);
var inst_33045 = [];
var inst_33046 = inst_33045.push(inst_33030);
var inst_33026 = inst_33045;
var inst_33027 = inst_33034;
var state_33066__$1 = (function (){var statearr_33078 = state_33066;
(statearr_33078[(7)] = inst_33026);

(statearr_33078[(11)] = inst_33046);

(statearr_33078[(12)] = inst_33044);

(statearr_33078[(8)] = inst_33027);

return statearr_33078;
})();
var statearr_33079_33103 = state_33066__$1;
(statearr_33079_33103[(2)] = null);

(statearr_33079_33103[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (9))){
var inst_33026 = (state_33066[(7)]);
var inst_33042 = cljs.core.vec.call(null,inst_33026);
var state_33066__$1 = state_33066;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33066__$1,(11),out,inst_33042);
} else {
if((state_val_33067 === (5))){
var inst_33034 = (state_33066[(10)]);
var inst_33030 = (state_33066[(9)]);
var inst_33027 = (state_33066[(8)]);
var inst_33034__$1 = f.call(null,inst_33030);
var inst_33035 = cljs.core._EQ_.call(null,inst_33034__$1,inst_33027);
var inst_33036 = cljs.core.keyword_identical_QMARK_.call(null,inst_33027,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_33037 = (inst_33035) || (inst_33036);
var state_33066__$1 = (function (){var statearr_33080 = state_33066;
(statearr_33080[(10)] = inst_33034__$1);

return statearr_33080;
})();
if(cljs.core.truth_(inst_33037)){
var statearr_33081_33104 = state_33066__$1;
(statearr_33081_33104[(1)] = (8));

} else {
var statearr_33082_33105 = state_33066__$1;
(statearr_33082_33105[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (14))){
var inst_33059 = (state_33066[(2)]);
var inst_33060 = cljs.core.async.close_BANG_.call(null,out);
var state_33066__$1 = (function (){var statearr_33084 = state_33066;
(statearr_33084[(13)] = inst_33059);

return statearr_33084;
})();
var statearr_33085_33106 = state_33066__$1;
(statearr_33085_33106[(2)] = inst_33060);

(statearr_33085_33106[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (10))){
var inst_33049 = (state_33066[(2)]);
var state_33066__$1 = state_33066;
var statearr_33086_33107 = state_33066__$1;
(statearr_33086_33107[(2)] = inst_33049);

(statearr_33086_33107[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (8))){
var inst_33026 = (state_33066[(7)]);
var inst_33034 = (state_33066[(10)]);
var inst_33030 = (state_33066[(9)]);
var inst_33039 = inst_33026.push(inst_33030);
var tmp33083 = inst_33026;
var inst_33026__$1 = tmp33083;
var inst_33027 = inst_33034;
var state_33066__$1 = (function (){var statearr_33087 = state_33066;
(statearr_33087[(7)] = inst_33026__$1);

(statearr_33087[(14)] = inst_33039);

(statearr_33087[(8)] = inst_33027);

return statearr_33087;
})();
var statearr_33088_33108 = state_33066__$1;
(statearr_33088_33108[(2)] = null);

(statearr_33088_33108[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31204__auto___33094,out))
;
return ((function (switch__31116__auto__,c__31204__auto___33094,out){
return (function() {
var cljs$core$async$state_machine__31117__auto__ = null;
var cljs$core$async$state_machine__31117__auto____0 = (function (){
var statearr_33089 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33089[(0)] = cljs$core$async$state_machine__31117__auto__);

(statearr_33089[(1)] = (1));

return statearr_33089;
});
var cljs$core$async$state_machine__31117__auto____1 = (function (state_33066){
while(true){
var ret_value__31118__auto__ = (function (){try{while(true){
var result__31119__auto__ = switch__31116__auto__.call(null,state_33066);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31119__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31119__auto__;
}
break;
}
}catch (e33090){if((e33090 instanceof Object)){
var ex__31120__auto__ = e33090;
var statearr_33091_33109 = state_33066;
(statearr_33091_33109[(5)] = ex__31120__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33066);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33090;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31118__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33110 = state_33066;
state_33066 = G__33110;
continue;
} else {
return ret_value__31118__auto__;
}
break;
}
});
cljs$core$async$state_machine__31117__auto__ = function(state_33066){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31117__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31117__auto____1.call(this,state_33066);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31117__auto____0;
cljs$core$async$state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31117__auto____1;
return cljs$core$async$state_machine__31117__auto__;
})()
;})(switch__31116__auto__,c__31204__auto___33094,out))
})();
var state__31206__auto__ = (function (){var statearr_33092 = f__31205__auto__.call(null);
(statearr_33092[(6)] = c__31204__auto___33094);

return statearr_33092;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31206__auto__);
});})(c__31204__auto___33094,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1499963082587