// Compiled by ClojureScript 1.9.671 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.userAgent.product');
goog.require('goog.object');
goog.require('cljs.reader');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.utils');
goog.require('figwheel.client.heads_up');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('cljs.repl');
figwheel.client._figwheel_version_ = "0.5.6";
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(var_args){
var G__35700 = arguments.length;
switch (G__35700) {
case 2:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2 = (function (stream,args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"stream","stream",1534941648),stream,new cljs.core.Keyword(null,"args","args",1315556576),args], null)], null));

return null;
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1 = (function (args){
return figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);
});

figwheel.client.figwheel_repl_print.cljs$lang$maxFixedArity = 2;

figwheel.client.console_out_print = (function figwheel$client$console_out_print(args){
return console.log.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.console_err_print = (function figwheel$client$console_err_print(args){
return console.error.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.repl_out_print_fn = (function figwheel$client$repl_out_print_fn(var_args){
var args__27528__auto__ = [];
var len__27521__auto___35703 = arguments.length;
var i__27522__auto___35704 = (0);
while(true){
if((i__27522__auto___35704 < len__27521__auto___35703)){
args__27528__auto__.push((arguments[i__27522__auto___35704]));

var G__35705 = (i__27522__auto___35704 + (1));
i__27522__auto___35704 = G__35705;
continue;
} else {
}
break;
}

var argseq__27529__auto__ = ((((0) < args__27528__auto__.length))?(new cljs.core.IndexedSeq(args__27528__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__27529__auto__);
});

figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_out_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);

return null;
});

figwheel.client.repl_out_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_out_print_fn.cljs$lang$applyTo = (function (seq35702){
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq35702));
});

figwheel.client.repl_err_print_fn = (function figwheel$client$repl_err_print_fn(var_args){
var args__27528__auto__ = [];
var len__27521__auto___35707 = arguments.length;
var i__27522__auto___35708 = (0);
while(true){
if((i__27522__auto___35708 < len__27521__auto___35707)){
args__27528__auto__.push((arguments[i__27522__auto___35708]));

var G__35709 = (i__27522__auto___35708 + (1));
i__27522__auto___35708 = G__35709;
continue;
} else {
}
break;
}

var argseq__27529__auto__ = ((((0) < args__27528__auto__.length))?(new cljs.core.IndexedSeq(args__27528__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__27529__auto__);
});

figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_err_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"err","err",-2089457205),args);

return null;
});

figwheel.client.repl_err_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_err_print_fn.cljs$lang$applyTo = (function (seq35706){
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq35706));
});

figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core.set_print_fn_BANG_.call(null,figwheel.client.repl_out_print_fn);

cljs.core.set_print_err_fn_BANG_.call(null,figwheel.client.repl_err_print_fn);

return null;
});
figwheel.client.autoload_QMARK_ = (cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?(function (){
var pred__35710 = cljs.core._EQ_;
var expr__35711 = (function (){var or__26396__auto__ = (function (){try{if(cljs.core.truth_(typeof localstorage !== 'undefined')){
return localStorage.getItem("figwheel_autoload");
} else {
return null;
}
}catch (e35714){if((e35714 instanceof Error)){
var e = e35714;
return false;
} else {
throw e35714;

}
}})();
if(cljs.core.truth_(or__26396__auto__)){
return or__26396__auto__;
} else {
return "true";
}
})();
if(cljs.core.truth_(pred__35710.call(null,"true",expr__35711))){
return true;
} else {
if(cljs.core.truth_(pred__35710.call(null,"false",expr__35711))){
return false;
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__35711)].join('')));
}
}
}):(function (){
return true;
}));
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
try{if(cljs.core.truth_(typeof localstorage !== 'undefined')){
localStorage.setItem("figwheel_autoload",cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));
} else {
}

return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel autoloading "),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));
}catch (e35715){if((e35715 instanceof Error)){
var e = e35715;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Unable to access localStorage")].join(''));
} else {
throw e35715;

}
}} else {
return null;
}
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel.client.get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__35716){
var map__35717 = p__35716;
var map__35717__$1 = ((((!((map__35717 == null)))?((((map__35717.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35717.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35717):map__35717);
var message = cljs.core.get.call(null,map__35717__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__35717__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" : "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__26396__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__26396__auto__)){
return or__26396__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__26384__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__26384__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__26384__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return (cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts)));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__31204__auto___35796 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31204__auto___35796,ch){
return (function (){
var f__31205__auto__ = (function (){var switch__31116__auto__ = ((function (c__31204__auto___35796,ch){
return (function (state_35768){
var state_val_35769 = (state_35768[(1)]);
if((state_val_35769 === (7))){
var inst_35764 = (state_35768[(2)]);
var state_35768__$1 = state_35768;
var statearr_35770_35797 = state_35768__$1;
(statearr_35770_35797[(2)] = inst_35764);

(statearr_35770_35797[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35769 === (1))){
var state_35768__$1 = state_35768;
var statearr_35771_35798 = state_35768__$1;
(statearr_35771_35798[(2)] = null);

(statearr_35771_35798[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35769 === (4))){
var inst_35721 = (state_35768[(7)]);
var inst_35721__$1 = (state_35768[(2)]);
var state_35768__$1 = (function (){var statearr_35772 = state_35768;
(statearr_35772[(7)] = inst_35721__$1);

return statearr_35772;
})();
if(cljs.core.truth_(inst_35721__$1)){
var statearr_35773_35799 = state_35768__$1;
(statearr_35773_35799[(1)] = (5));

} else {
var statearr_35774_35800 = state_35768__$1;
(statearr_35774_35800[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35769 === (15))){
var inst_35728 = (state_35768[(8)]);
var inst_35743 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_35728);
var inst_35744 = cljs.core.first.call(null,inst_35743);
var inst_35745 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_35744);
var inst_35746 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Not loading code with warnings - "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35745)].join('');
var inst_35747 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_35746);
var state_35768__$1 = state_35768;
var statearr_35775_35801 = state_35768__$1;
(statearr_35775_35801[(2)] = inst_35747);

(statearr_35775_35801[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35769 === (13))){
var inst_35752 = (state_35768[(2)]);
var state_35768__$1 = state_35768;
var statearr_35776_35802 = state_35768__$1;
(statearr_35776_35802[(2)] = inst_35752);

(statearr_35776_35802[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35769 === (6))){
var state_35768__$1 = state_35768;
var statearr_35777_35803 = state_35768__$1;
(statearr_35777_35803[(2)] = null);

(statearr_35777_35803[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35769 === (17))){
var inst_35750 = (state_35768[(2)]);
var state_35768__$1 = state_35768;
var statearr_35778_35804 = state_35768__$1;
(statearr_35778_35804[(2)] = inst_35750);

(statearr_35778_35804[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35769 === (3))){
var inst_35766 = (state_35768[(2)]);
var state_35768__$1 = state_35768;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35768__$1,inst_35766);
} else {
if((state_val_35769 === (12))){
var inst_35727 = (state_35768[(9)]);
var inst_35741 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_35727,opts);
var state_35768__$1 = state_35768;
if(cljs.core.truth_(inst_35741)){
var statearr_35779_35805 = state_35768__$1;
(statearr_35779_35805[(1)] = (15));

} else {
var statearr_35780_35806 = state_35768__$1;
(statearr_35780_35806[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35769 === (2))){
var state_35768__$1 = state_35768;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35768__$1,(4),ch);
} else {
if((state_val_35769 === (11))){
var inst_35728 = (state_35768[(8)]);
var inst_35733 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35734 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_35728);
var inst_35735 = cljs.core.async.timeout.call(null,(1000));
var inst_35736 = [inst_35734,inst_35735];
var inst_35737 = (new cljs.core.PersistentVector(null,2,(5),inst_35733,inst_35736,null));
var state_35768__$1 = state_35768;
return cljs.core.async.ioc_alts_BANG_.call(null,state_35768__$1,(14),inst_35737);
} else {
if((state_val_35769 === (9))){
var inst_35728 = (state_35768[(8)]);
var inst_35754 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_35755 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_35728);
var inst_35756 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_35755);
var inst_35757 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("Not loading: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35756)].join('');
var inst_35758 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_35757);
var state_35768__$1 = (function (){var statearr_35781 = state_35768;
(statearr_35781[(10)] = inst_35754);

return statearr_35781;
})();
var statearr_35782_35807 = state_35768__$1;
(statearr_35782_35807[(2)] = inst_35758);

(statearr_35782_35807[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35769 === (5))){
var inst_35721 = (state_35768[(7)]);
var inst_35723 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_35724 = (new cljs.core.PersistentArrayMap(null,2,inst_35723,null));
var inst_35725 = (new cljs.core.PersistentHashSet(null,inst_35724,null));
var inst_35726 = figwheel.client.focus_msgs.call(null,inst_35725,inst_35721);
var inst_35727 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_35726);
var inst_35728 = cljs.core.first.call(null,inst_35726);
var inst_35729 = figwheel.client.autoload_QMARK_.call(null);
var state_35768__$1 = (function (){var statearr_35783 = state_35768;
(statearr_35783[(8)] = inst_35728);

(statearr_35783[(9)] = inst_35727);

return statearr_35783;
})();
if(cljs.core.truth_(inst_35729)){
var statearr_35784_35808 = state_35768__$1;
(statearr_35784_35808[(1)] = (8));

} else {
var statearr_35785_35809 = state_35768__$1;
(statearr_35785_35809[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35769 === (14))){
var inst_35739 = (state_35768[(2)]);
var state_35768__$1 = state_35768;
var statearr_35786_35810 = state_35768__$1;
(statearr_35786_35810[(2)] = inst_35739);

(statearr_35786_35810[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35769 === (16))){
var state_35768__$1 = state_35768;
var statearr_35787_35811 = state_35768__$1;
(statearr_35787_35811[(2)] = null);

(statearr_35787_35811[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35769 === (10))){
var inst_35760 = (state_35768[(2)]);
var state_35768__$1 = (function (){var statearr_35788 = state_35768;
(statearr_35788[(11)] = inst_35760);

return statearr_35788;
})();
var statearr_35789_35812 = state_35768__$1;
(statearr_35789_35812[(2)] = null);

(statearr_35789_35812[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35769 === (8))){
var inst_35727 = (state_35768[(9)]);
var inst_35731 = figwheel.client.reload_file_state_QMARK_.call(null,inst_35727,opts);
var state_35768__$1 = state_35768;
if(cljs.core.truth_(inst_35731)){
var statearr_35790_35813 = state_35768__$1;
(statearr_35790_35813[(1)] = (11));

} else {
var statearr_35791_35814 = state_35768__$1;
(statearr_35791_35814[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31204__auto___35796,ch))
;
return ((function (switch__31116__auto__,c__31204__auto___35796,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__31117__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__31117__auto____0 = (function (){
var statearr_35792 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35792[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__31117__auto__);

(statearr_35792[(1)] = (1));

return statearr_35792;
});
var figwheel$client$file_reloader_plugin_$_state_machine__31117__auto____1 = (function (state_35768){
while(true){
var ret_value__31118__auto__ = (function (){try{while(true){
var result__31119__auto__ = switch__31116__auto__.call(null,state_35768);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31119__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31119__auto__;
}
break;
}
}catch (e35793){if((e35793 instanceof Object)){
var ex__31120__auto__ = e35793;
var statearr_35794_35815 = state_35768;
(statearr_35794_35815[(5)] = ex__31120__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35768);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35793;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31118__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35816 = state_35768;
state_35768 = G__35816;
continue;
} else {
return ret_value__31118__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__31117__auto__ = function(state_35768){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__31117__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__31117__auto____1.call(this,state_35768);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloader_plugin_$_state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__31117__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__31117__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__31117__auto__;
})()
;})(switch__31116__auto__,c__31204__auto___35796,ch))
})();
var state__31206__auto__ = (function (){var statearr_35795 = f__31205__auto__.call(null);
(statearr_35795[(6)] = c__31204__auto___35796);

return statearr_35795;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31206__auto__);
});})(c__31204__auto___35796,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__35817_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__35817_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_35819 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_35819){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{figwheel.client.enable_repl_print_BANG_.call(null);

var result_value = figwheel.client.utils.eval_helper.call(null,code,opts);
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),result_value], null));
}catch (e35818){if((e35818 instanceof Error)){
var e = e35818;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_35819], null));
} else {
var e = e35818;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}finally {figwheel.client.enable_repl_print_BANG_.call(null);
}});})(base_path_35819))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = ({});
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__35820){
var map__35821 = p__35820;
var map__35821__$1 = ((((!((map__35821 == null)))?((((map__35821.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35821.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35821):map__35821);
var opts = map__35821__$1;
var build_id = cljs.core.get.call(null,map__35821__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__35821,map__35821__$1,opts,build_id){
return (function (p__35823){
var vec__35824 = p__35823;
var seq__35825 = cljs.core.seq.call(null,vec__35824);
var first__35826 = cljs.core.first.call(null,seq__35825);
var seq__35825__$1 = cljs.core.next.call(null,seq__35825);
var map__35827 = first__35826;
var map__35827__$1 = ((((!((map__35827 == null)))?((((map__35827.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35827.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35827):map__35827);
var msg = map__35827__$1;
var msg_name = cljs.core.get.call(null,map__35827__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__35825__$1;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__35824,seq__35825,first__35826,seq__35825__$1,map__35827,map__35827__$1,msg,msg_name,_,map__35821,map__35821__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__35824,seq__35825,first__35826,seq__35825__$1,map__35827,map__35827__$1,msg,msg_name,_,map__35821,map__35821__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__35821,map__35821__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__35829){
var vec__35830 = p__35829;
var seq__35831 = cljs.core.seq.call(null,vec__35830);
var first__35832 = cljs.core.first.call(null,seq__35831);
var seq__35831__$1 = cljs.core.next.call(null,seq__35831);
var map__35833 = first__35832;
var map__35833__$1 = ((((!((map__35833 == null)))?((((map__35833.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35833.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35833):map__35833);
var msg = map__35833__$1;
var msg_name = cljs.core.get.call(null,map__35833__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__35831__$1;
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__35835){
var map__35836 = p__35835;
var map__35836__$1 = ((((!((map__35836 == null)))?((((map__35836.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35836.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35836):map__35836);
var on_compile_warning = cljs.core.get.call(null,map__35836__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__35836__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__35836,map__35836__$1,on_compile_warning,on_compile_fail){
return (function (p__35838){
var vec__35839 = p__35838;
var seq__35840 = cljs.core.seq.call(null,vec__35839);
var first__35841 = cljs.core.first.call(null,seq__35840);
var seq__35840__$1 = cljs.core.next.call(null,seq__35840);
var map__35842 = first__35841;
var map__35842__$1 = ((((!((map__35842 == null)))?((((map__35842.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35842.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35842):map__35842);
var msg = map__35842__$1;
var msg_name = cljs.core.get.call(null,map__35842__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__35840__$1;
var pred__35844 = cljs.core._EQ_;
var expr__35845 = msg_name;
if(cljs.core.truth_(pred__35844.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__35845))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__35844.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__35845))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__35836,map__35836__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.auto_jump_to_error = (function figwheel$client$auto_jump_to_error(opts,error){
if(cljs.core.truth_(new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920).cljs$core$IFn$_invoke$arity$1(opts))){
return figwheel.client.heads_up.auto_notify_source_file_line.call(null,error);
} else {
return null;
}
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__31204__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31204__auto__,msg_hist,msg_names,msg){
return (function (){
var f__31205__auto__ = (function (){var switch__31116__auto__ = ((function (c__31204__auto__,msg_hist,msg_names,msg){
return (function (state_35934){
var state_val_35935 = (state_35934[(1)]);
if((state_val_35935 === (7))){
var inst_35854 = (state_35934[(2)]);
var state_35934__$1 = state_35934;
if(cljs.core.truth_(inst_35854)){
var statearr_35936_35983 = state_35934__$1;
(statearr_35936_35983[(1)] = (8));

} else {
var statearr_35937_35984 = state_35934__$1;
(statearr_35937_35984[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35935 === (20))){
var inst_35928 = (state_35934[(2)]);
var state_35934__$1 = state_35934;
var statearr_35938_35985 = state_35934__$1;
(statearr_35938_35985[(2)] = inst_35928);

(statearr_35938_35985[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35935 === (27))){
var inst_35924 = (state_35934[(2)]);
var state_35934__$1 = state_35934;
var statearr_35939_35986 = state_35934__$1;
(statearr_35939_35986[(2)] = inst_35924);

(statearr_35939_35986[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35935 === (1))){
var inst_35847 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_35934__$1 = state_35934;
if(cljs.core.truth_(inst_35847)){
var statearr_35940_35987 = state_35934__$1;
(statearr_35940_35987[(1)] = (2));

} else {
var statearr_35941_35988 = state_35934__$1;
(statearr_35941_35988[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35935 === (24))){
var inst_35926 = (state_35934[(2)]);
var state_35934__$1 = state_35934;
var statearr_35942_35989 = state_35934__$1;
(statearr_35942_35989[(2)] = inst_35926);

(statearr_35942_35989[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35935 === (4))){
var inst_35932 = (state_35934[(2)]);
var state_35934__$1 = state_35934;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35934__$1,inst_35932);
} else {
if((state_val_35935 === (15))){
var inst_35930 = (state_35934[(2)]);
var state_35934__$1 = state_35934;
var statearr_35943_35990 = state_35934__$1;
(statearr_35943_35990[(2)] = inst_35930);

(statearr_35943_35990[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35935 === (21))){
var inst_35883 = (state_35934[(2)]);
var inst_35884 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_35885 = figwheel.client.auto_jump_to_error.call(null,opts,inst_35884);
var state_35934__$1 = (function (){var statearr_35944 = state_35934;
(statearr_35944[(7)] = inst_35883);

return statearr_35944;
})();
var statearr_35945_35991 = state_35934__$1;
(statearr_35945_35991[(2)] = inst_35885);

(statearr_35945_35991[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35935 === (31))){
var inst_35913 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_35934__$1 = state_35934;
if(cljs.core.truth_(inst_35913)){
var statearr_35946_35992 = state_35934__$1;
(statearr_35946_35992[(1)] = (34));

} else {
var statearr_35947_35993 = state_35934__$1;
(statearr_35947_35993[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35935 === (32))){
var inst_35922 = (state_35934[(2)]);
var state_35934__$1 = state_35934;
var statearr_35948_35994 = state_35934__$1;
(statearr_35948_35994[(2)] = inst_35922);

(statearr_35948_35994[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35935 === (33))){
var inst_35909 = (state_35934[(2)]);
var inst_35910 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_35911 = figwheel.client.auto_jump_to_error.call(null,opts,inst_35910);
var state_35934__$1 = (function (){var statearr_35949 = state_35934;
(statearr_35949[(8)] = inst_35909);

return statearr_35949;
})();
var statearr_35950_35995 = state_35934__$1;
(statearr_35950_35995[(2)] = inst_35911);

(statearr_35950_35995[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35935 === (13))){
var inst_35868 = figwheel.client.heads_up.clear.call(null);
var state_35934__$1 = state_35934;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35934__$1,(16),inst_35868);
} else {
if((state_val_35935 === (22))){
var inst_35889 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_35890 = figwheel.client.heads_up.append_warning_message.call(null,inst_35889);
var state_35934__$1 = state_35934;
var statearr_35951_35996 = state_35934__$1;
(statearr_35951_35996[(2)] = inst_35890);

(statearr_35951_35996[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35935 === (36))){
var inst_35920 = (state_35934[(2)]);
var state_35934__$1 = state_35934;
var statearr_35952_35997 = state_35934__$1;
(statearr_35952_35997[(2)] = inst_35920);

(statearr_35952_35997[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35935 === (29))){
var inst_35900 = (state_35934[(2)]);
var inst_35901 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_35902 = figwheel.client.auto_jump_to_error.call(null,opts,inst_35901);
var state_35934__$1 = (function (){var statearr_35953 = state_35934;
(statearr_35953[(9)] = inst_35900);

return statearr_35953;
})();
var statearr_35954_35998 = state_35934__$1;
(statearr_35954_35998[(2)] = inst_35902);

(statearr_35954_35998[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35935 === (6))){
var inst_35849 = (state_35934[(10)]);
var state_35934__$1 = state_35934;
var statearr_35955_35999 = state_35934__$1;
(statearr_35955_35999[(2)] = inst_35849);

(statearr_35955_35999[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35935 === (28))){
var inst_35896 = (state_35934[(2)]);
var inst_35897 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_35898 = figwheel.client.heads_up.display_warning.call(null,inst_35897);
var state_35934__$1 = (function (){var statearr_35956 = state_35934;
(statearr_35956[(11)] = inst_35896);

return statearr_35956;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35934__$1,(29),inst_35898);
} else {
if((state_val_35935 === (25))){
var inst_35894 = figwheel.client.heads_up.clear.call(null);
var state_35934__$1 = state_35934;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35934__$1,(28),inst_35894);
} else {
if((state_val_35935 === (34))){
var inst_35915 = figwheel.client.heads_up.flash_loaded.call(null);
var state_35934__$1 = state_35934;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35934__$1,(37),inst_35915);
} else {
if((state_val_35935 === (17))){
var inst_35874 = (state_35934[(2)]);
var inst_35875 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_35876 = figwheel.client.auto_jump_to_error.call(null,opts,inst_35875);
var state_35934__$1 = (function (){var statearr_35957 = state_35934;
(statearr_35957[(12)] = inst_35874);

return statearr_35957;
})();
var statearr_35958_36000 = state_35934__$1;
(statearr_35958_36000[(2)] = inst_35876);

(statearr_35958_36000[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35935 === (3))){
var inst_35866 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_35934__$1 = state_35934;
if(cljs.core.truth_(inst_35866)){
var statearr_35959_36001 = state_35934__$1;
(statearr_35959_36001[(1)] = (13));

} else {
var statearr_35960_36002 = state_35934__$1;
(statearr_35960_36002[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35935 === (12))){
var inst_35862 = (state_35934[(2)]);
var state_35934__$1 = state_35934;
var statearr_35961_36003 = state_35934__$1;
(statearr_35961_36003[(2)] = inst_35862);

(statearr_35961_36003[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35935 === (2))){
var inst_35849 = (state_35934[(10)]);
var inst_35849__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_35934__$1 = (function (){var statearr_35962 = state_35934;
(statearr_35962[(10)] = inst_35849__$1);

return statearr_35962;
})();
if(cljs.core.truth_(inst_35849__$1)){
var statearr_35963_36004 = state_35934__$1;
(statearr_35963_36004[(1)] = (5));

} else {
var statearr_35964_36005 = state_35934__$1;
(statearr_35964_36005[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35935 === (23))){
var inst_35892 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_35934__$1 = state_35934;
if(cljs.core.truth_(inst_35892)){
var statearr_35965_36006 = state_35934__$1;
(statearr_35965_36006[(1)] = (25));

} else {
var statearr_35966_36007 = state_35934__$1;
(statearr_35966_36007[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35935 === (35))){
var state_35934__$1 = state_35934;
var statearr_35967_36008 = state_35934__$1;
(statearr_35967_36008[(2)] = null);

(statearr_35967_36008[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35935 === (19))){
var inst_35887 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_35934__$1 = state_35934;
if(cljs.core.truth_(inst_35887)){
var statearr_35968_36009 = state_35934__$1;
(statearr_35968_36009[(1)] = (22));

} else {
var statearr_35969_36010 = state_35934__$1;
(statearr_35969_36010[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35935 === (11))){
var inst_35858 = (state_35934[(2)]);
var state_35934__$1 = state_35934;
var statearr_35970_36011 = state_35934__$1;
(statearr_35970_36011[(2)] = inst_35858);

(statearr_35970_36011[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35935 === (9))){
var inst_35860 = figwheel.client.heads_up.clear.call(null);
var state_35934__$1 = state_35934;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35934__$1,(12),inst_35860);
} else {
if((state_val_35935 === (5))){
var inst_35851 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_35934__$1 = state_35934;
var statearr_35971_36012 = state_35934__$1;
(statearr_35971_36012[(2)] = inst_35851);

(statearr_35971_36012[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35935 === (14))){
var inst_35878 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_35934__$1 = state_35934;
if(cljs.core.truth_(inst_35878)){
var statearr_35972_36013 = state_35934__$1;
(statearr_35972_36013[(1)] = (18));

} else {
var statearr_35973_36014 = state_35934__$1;
(statearr_35973_36014[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35935 === (26))){
var inst_35904 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_35934__$1 = state_35934;
if(cljs.core.truth_(inst_35904)){
var statearr_35974_36015 = state_35934__$1;
(statearr_35974_36015[(1)] = (30));

} else {
var statearr_35975_36016 = state_35934__$1;
(statearr_35975_36016[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35935 === (16))){
var inst_35870 = (state_35934[(2)]);
var inst_35871 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_35872 = figwheel.client.heads_up.display_exception.call(null,inst_35871);
var state_35934__$1 = (function (){var statearr_35976 = state_35934;
(statearr_35976[(13)] = inst_35870);

return statearr_35976;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35934__$1,(17),inst_35872);
} else {
if((state_val_35935 === (30))){
var inst_35906 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_35907 = figwheel.client.heads_up.display_warning.call(null,inst_35906);
var state_35934__$1 = state_35934;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35934__$1,(33),inst_35907);
} else {
if((state_val_35935 === (10))){
var inst_35864 = (state_35934[(2)]);
var state_35934__$1 = state_35934;
var statearr_35977_36017 = state_35934__$1;
(statearr_35977_36017[(2)] = inst_35864);

(statearr_35977_36017[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35935 === (18))){
var inst_35880 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_35881 = figwheel.client.heads_up.display_exception.call(null,inst_35880);
var state_35934__$1 = state_35934;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35934__$1,(21),inst_35881);
} else {
if((state_val_35935 === (37))){
var inst_35917 = (state_35934[(2)]);
var state_35934__$1 = state_35934;
var statearr_35978_36018 = state_35934__$1;
(statearr_35978_36018[(2)] = inst_35917);

(statearr_35978_36018[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35935 === (8))){
var inst_35856 = figwheel.client.heads_up.flash_loaded.call(null);
var state_35934__$1 = state_35934;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35934__$1,(11),inst_35856);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31204__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__31116__auto__,c__31204__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__31117__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__31117__auto____0 = (function (){
var statearr_35979 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35979[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__31117__auto__);

(statearr_35979[(1)] = (1));

return statearr_35979;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__31117__auto____1 = (function (state_35934){
while(true){
var ret_value__31118__auto__ = (function (){try{while(true){
var result__31119__auto__ = switch__31116__auto__.call(null,state_35934);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31119__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31119__auto__;
}
break;
}
}catch (e35980){if((e35980 instanceof Object)){
var ex__31120__auto__ = e35980;
var statearr_35981_36019 = state_35934;
(statearr_35981_36019[(5)] = ex__31120__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35934);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35980;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31118__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36020 = state_35934;
state_35934 = G__36020;
continue;
} else {
return ret_value__31118__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__31117__auto__ = function(state_35934){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__31117__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__31117__auto____1.call(this,state_35934);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__31117__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__31117__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__31117__auto__;
})()
;})(switch__31116__auto__,c__31204__auto__,msg_hist,msg_names,msg))
})();
var state__31206__auto__ = (function (){var statearr_35982 = f__31205__auto__.call(null);
(statearr_35982[(6)] = c__31204__auto__);

return statearr_35982;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31206__auto__);
});})(c__31204__auto__,msg_hist,msg_names,msg))
);

return c__31204__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__31204__auto___36049 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31204__auto___36049,ch){
return (function (){
var f__31205__auto__ = (function (){var switch__31116__auto__ = ((function (c__31204__auto___36049,ch){
return (function (state_36035){
var state_val_36036 = (state_36035[(1)]);
if((state_val_36036 === (1))){
var state_36035__$1 = state_36035;
var statearr_36037_36050 = state_36035__$1;
(statearr_36037_36050[(2)] = null);

(statearr_36037_36050[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36036 === (2))){
var state_36035__$1 = state_36035;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36035__$1,(4),ch);
} else {
if((state_val_36036 === (3))){
var inst_36033 = (state_36035[(2)]);
var state_36035__$1 = state_36035;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36035__$1,inst_36033);
} else {
if((state_val_36036 === (4))){
var inst_36023 = (state_36035[(7)]);
var inst_36023__$1 = (state_36035[(2)]);
var state_36035__$1 = (function (){var statearr_36038 = state_36035;
(statearr_36038[(7)] = inst_36023__$1);

return statearr_36038;
})();
if(cljs.core.truth_(inst_36023__$1)){
var statearr_36039_36051 = state_36035__$1;
(statearr_36039_36051[(1)] = (5));

} else {
var statearr_36040_36052 = state_36035__$1;
(statearr_36040_36052[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36036 === (5))){
var inst_36023 = (state_36035[(7)]);
var inst_36025 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_36023);
var state_36035__$1 = state_36035;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36035__$1,(8),inst_36025);
} else {
if((state_val_36036 === (6))){
var state_36035__$1 = state_36035;
var statearr_36041_36053 = state_36035__$1;
(statearr_36041_36053[(2)] = null);

(statearr_36041_36053[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36036 === (7))){
var inst_36031 = (state_36035[(2)]);
var state_36035__$1 = state_36035;
var statearr_36042_36054 = state_36035__$1;
(statearr_36042_36054[(2)] = inst_36031);

(statearr_36042_36054[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36036 === (8))){
var inst_36027 = (state_36035[(2)]);
var state_36035__$1 = (function (){var statearr_36043 = state_36035;
(statearr_36043[(8)] = inst_36027);

return statearr_36043;
})();
var statearr_36044_36055 = state_36035__$1;
(statearr_36044_36055[(2)] = null);

(statearr_36044_36055[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__31204__auto___36049,ch))
;
return ((function (switch__31116__auto__,c__31204__auto___36049,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__31117__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__31117__auto____0 = (function (){
var statearr_36045 = [null,null,null,null,null,null,null,null,null];
(statearr_36045[(0)] = figwheel$client$heads_up_plugin_$_state_machine__31117__auto__);

(statearr_36045[(1)] = (1));

return statearr_36045;
});
var figwheel$client$heads_up_plugin_$_state_machine__31117__auto____1 = (function (state_36035){
while(true){
var ret_value__31118__auto__ = (function (){try{while(true){
var result__31119__auto__ = switch__31116__auto__.call(null,state_36035);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31119__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31119__auto__;
}
break;
}
}catch (e36046){if((e36046 instanceof Object)){
var ex__31120__auto__ = e36046;
var statearr_36047_36056 = state_36035;
(statearr_36047_36056[(5)] = ex__31120__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_36035);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e36046;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31118__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36057 = state_36035;
state_36035 = G__36057;
continue;
} else {
return ret_value__31118__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__31117__auto__ = function(state_36035){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__31117__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__31117__auto____1.call(this,state_36035);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_$_state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__31117__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__31117__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__31117__auto__;
})()
;})(switch__31116__auto__,c__31204__auto___36049,ch))
})();
var state__31206__auto__ = (function (){var statearr_36048 = f__31205__auto__.call(null);
(statearr_36048[(6)] = c__31204__auto___36049);

return statearr_36048;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31206__auto__);
});})(c__31204__auto___36049,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__31204__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31204__auto__){
return (function (){
var f__31205__auto__ = (function (){var switch__31116__auto__ = ((function (c__31204__auto__){
return (function (state_36063){
var state_val_36064 = (state_36063[(1)]);
if((state_val_36064 === (1))){
var inst_36058 = cljs.core.async.timeout.call(null,(3000));
var state_36063__$1 = state_36063;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36063__$1,(2),inst_36058);
} else {
if((state_val_36064 === (2))){
var inst_36060 = (state_36063[(2)]);
var inst_36061 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_36063__$1 = (function (){var statearr_36065 = state_36063;
(statearr_36065[(7)] = inst_36060);

return statearr_36065;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36063__$1,inst_36061);
} else {
return null;
}
}
});})(c__31204__auto__))
;
return ((function (switch__31116__auto__,c__31204__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__31117__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__31117__auto____0 = (function (){
var statearr_36066 = [null,null,null,null,null,null,null,null];
(statearr_36066[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__31117__auto__);

(statearr_36066[(1)] = (1));

return statearr_36066;
});
var figwheel$client$enforce_project_plugin_$_state_machine__31117__auto____1 = (function (state_36063){
while(true){
var ret_value__31118__auto__ = (function (){try{while(true){
var result__31119__auto__ = switch__31116__auto__.call(null,state_36063);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31119__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31119__auto__;
}
break;
}
}catch (e36067){if((e36067 instanceof Object)){
var ex__31120__auto__ = e36067;
var statearr_36068_36070 = state_36063;
(statearr_36068_36070[(5)] = ex__31120__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_36063);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e36067;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31118__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36071 = state_36063;
state_36063 = G__36071;
continue;
} else {
return ret_value__31118__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__31117__auto__ = function(state_36063){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__31117__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__31117__auto____1.call(this,state_36063);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_project_plugin_$_state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__31117__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__31117__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__31117__auto__;
})()
;})(switch__31116__auto__,c__31204__auto__))
})();
var state__31206__auto__ = (function (){var statearr_36069 = f__31205__auto__.call(null);
(statearr_36069[(6)] = c__31204__auto__);

return statearr_36069;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31206__auto__);
});})(c__31204__auto__))
);

return c__31204__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.enforce_figwheel_version_plugin = (function figwheel$client$enforce_figwheel_version_plugin(opts){
return (function (msg_hist){
var temp__4657__auto__ = new cljs.core.Keyword(null,"figwheel-version","figwheel-version",1409553832).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,msg_hist));
if(cljs.core.truth_(temp__4657__auto__)){
var figwheel_version = temp__4657__auto__;
if(cljs.core.not_EQ_.call(null,figwheel_version,figwheel.client._figwheel_version_)){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different version of Figwheel.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__31204__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31204__auto__,figwheel_version,temp__4657__auto__){
return (function (){
var f__31205__auto__ = (function (){var switch__31116__auto__ = ((function (c__31204__auto__,figwheel_version,temp__4657__auto__){
return (function (state_36078){
var state_val_36079 = (state_36078[(1)]);
if((state_val_36079 === (1))){
var inst_36072 = cljs.core.async.timeout.call(null,(2000));
var state_36078__$1 = state_36078;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36078__$1,(2),inst_36072);
} else {
if((state_val_36079 === (2))){
var inst_36074 = (state_36078[(2)]);
var inst_36075 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel Client Version <strong>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client._figwheel_version_),cljs.core.str.cljs$core$IFn$_invoke$arity$1("</strong> is not equal to "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel Sidecar Version <strong>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel_version),cljs.core.str.cljs$core$IFn$_invoke$arity$1("</strong>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(".  Shutting down Websocket Connection!"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("<h4>To fix try:</h4>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("<ol><li>Reload this page and make sure you are not getting a cached version of the client.</li>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("<li>You may have to clean (delete compiled assets) and rebuild to make sure that the new client code is being used.</li>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("<li>Also, make sure you have consistent Figwheel dependencies.</li></ol>")].join('');
var inst_36076 = figwheel.client.heads_up.display_system_warning.call(null,"Figwheel Client and Server have different versions!!",inst_36075);
var state_36078__$1 = (function (){var statearr_36080 = state_36078;
(statearr_36080[(7)] = inst_36074);

return statearr_36080;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36078__$1,inst_36076);
} else {
return null;
}
}
});})(c__31204__auto__,figwheel_version,temp__4657__auto__))
;
return ((function (switch__31116__auto__,c__31204__auto__,figwheel_version,temp__4657__auto__){
return (function() {
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__31117__auto__ = null;
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__31117__auto____0 = (function (){
var statearr_36081 = [null,null,null,null,null,null,null,null];
(statearr_36081[(0)] = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__31117__auto__);

(statearr_36081[(1)] = (1));

return statearr_36081;
});
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__31117__auto____1 = (function (state_36078){
while(true){
var ret_value__31118__auto__ = (function (){try{while(true){
var result__31119__auto__ = switch__31116__auto__.call(null,state_36078);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31119__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31119__auto__;
}
break;
}
}catch (e36082){if((e36082 instanceof Object)){
var ex__31120__auto__ = e36082;
var statearr_36083_36085 = state_36078;
(statearr_36083_36085[(5)] = ex__31120__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_36078);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e36082;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31118__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36086 = state_36078;
state_36078 = G__36086;
continue;
} else {
return ret_value__31118__auto__;
}
break;
}
});
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__31117__auto__ = function(state_36078){
switch(arguments.length){
case 0:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__31117__auto____0.call(this);
case 1:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__31117__auto____1.call(this,state_36078);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__31117__auto____0;
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__31117__auto____1;
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__31117__auto__;
})()
;})(switch__31116__auto__,c__31204__auto__,figwheel_version,temp__4657__auto__))
})();
var state__31206__auto__ = (function (){var statearr_36084 = f__31205__auto__.call(null);
(statearr_36084[(6)] = c__31204__auto__);

return statearr_36084;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31206__auto__);
});})(c__31204__auto__,figwheel_version,temp__4657__auto__))
);

return c__31204__auto__;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.file_line_column = (function figwheel$client$file_line_column(p__36087){
var map__36088 = p__36087;
var map__36088__$1 = ((((!((map__36088 == null)))?((((map__36088.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36088.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36088):map__36088);
var file = cljs.core.get.call(null,map__36088__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__36088__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__36088__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var G__36090 = "";
var G__36090__$1 = (cljs.core.truth_(file)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__36090),cljs.core.str.cljs$core$IFn$_invoke$arity$1("file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''):G__36090);
var G__36090__$2 = (cljs.core.truth_(line)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__36090__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" at line "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):G__36090__$1);
if(cljs.core.truth_((function (){var and__26384__auto__ = line;
if(cljs.core.truth_(and__26384__auto__)){
return column;
} else {
return and__26384__auto__;
}
})())){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__36090__$2),cljs.core.str.cljs$core$IFn$_invoke$arity$1(", column "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join('');
} else {
return G__36090__$2;
}
});
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__36091){
var map__36092 = p__36091;
var map__36092__$1 = ((((!((map__36092 == null)))?((((map__36092.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36092.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36092):map__36092);
var ed = map__36092__$1;
var formatted_exception = cljs.core.get.call(null,map__36092__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__36092__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__36092__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__36094_36098 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__36095_36099 = null;
var count__36096_36100 = (0);
var i__36097_36101 = (0);
while(true){
if((i__36097_36101 < count__36096_36100)){
var msg_36102 = cljs.core._nth.call(null,chunk__36095_36099,i__36097_36101);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_36102);

var G__36103 = seq__36094_36098;
var G__36104 = chunk__36095_36099;
var G__36105 = count__36096_36100;
var G__36106 = (i__36097_36101 + (1));
seq__36094_36098 = G__36103;
chunk__36095_36099 = G__36104;
count__36096_36100 = G__36105;
i__36097_36101 = G__36106;
continue;
} else {
var temp__4657__auto___36107 = cljs.core.seq.call(null,seq__36094_36098);
if(temp__4657__auto___36107){
var seq__36094_36108__$1 = temp__4657__auto___36107;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__36094_36108__$1)){
var c__27216__auto___36109 = cljs.core.chunk_first.call(null,seq__36094_36108__$1);
var G__36110 = cljs.core.chunk_rest.call(null,seq__36094_36108__$1);
var G__36111 = c__27216__auto___36109;
var G__36112 = cljs.core.count.call(null,c__27216__auto___36109);
var G__36113 = (0);
seq__36094_36098 = G__36110;
chunk__36095_36099 = G__36111;
count__36096_36100 = G__36112;
i__36097_36101 = G__36113;
continue;
} else {
var msg_36114 = cljs.core.first.call(null,seq__36094_36108__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_36114);

var G__36115 = cljs.core.next.call(null,seq__36094_36108__$1);
var G__36116 = null;
var G__36117 = (0);
var G__36118 = (0);
seq__36094_36098 = G__36115;
chunk__36095_36099 = G__36116;
count__36096_36100 = G__36117;
i__36097_36101 = G__36118;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Error on "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,ed))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__36119){
var map__36120 = p__36119;
var map__36120__$1 = ((((!((map__36120 == null)))?((((map__36120.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36120.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36120):map__36120);
var w = map__36120__$1;
var message = cljs.core.get.call(null,map__36120__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Compile Warning - "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(message)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" in "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,message))].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if(typeof figwheel.client.config_defaults !== 'undefined'){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[new cljs.core.Var(function(){return figwheel.client.default_on_compile_warning;},new cljs.core.Symbol("figwheel.client","default-on-compile-warning","figwheel.client/default-on-compile-warning",584144208,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-warning","default-on-compile-warning",-18911586,null),"www/cljs/tests/out/figwheel/client.cljs",33,1,336,336,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"message","message",1234475525,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"w","w",1994700528,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_warning)?figwheel.client.default_on_compile_warning.cljs$lang$test:null)])),figwheel.client.default_on_jsload,true,new cljs.core.Var(function(){return figwheel.client.default_on_compile_fail;},new cljs.core.Symbol("figwheel.client","default-on-compile-fail","figwheel.client/default-on-compile-fail",1384826337,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-fail","default-on-compile-fail",-158814813,null),"www/cljs/tests/out/figwheel/client.cljs",30,1,328,328,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"formatted-exception","formatted-exception",1524042501,null),new cljs.core.Symbol(null,"exception-data","exception-data",1128056641,null),new cljs.core.Symbol(null,"cause","cause",1872432779,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"ed","ed",2076825751,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_fail)?figwheel.client.default_on_compile_fail.cljs$lang$test:null)])),false,true,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("ws://"),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),cljs.core.str.cljs$core$IFn$_invoke$arity$1("/figwheel-ws")].join(''),false,figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.fill_url_template = (function figwheel$client$fill_url_template(config){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
return cljs.core.update_in.call(null,config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938)], null),(function (x){
return clojure.string.replace.call(null,clojure.string.replace.call(null,x,"[[client-hostname]]",location.hostname),"[[client-port]]",location.port);
}));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"enforce-figwheel-version-plugin","enforce-figwheel-version-plugin",-1916185220),figwheel.client.enforce_figwheel_version_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__26384__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__26384__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__26384__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__36122 = cljs.core.seq.call(null,plugins);
var chunk__36123 = null;
var count__36124 = (0);
var i__36125 = (0);
while(true){
if((i__36125 < count__36124)){
var vec__36126 = cljs.core._nth.call(null,chunk__36123,i__36125);
var k = cljs.core.nth.call(null,vec__36126,(0),null);
var plugin = cljs.core.nth.call(null,vec__36126,(1),null);
if(cljs.core.truth_(plugin)){
var pl_36132 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__36122,chunk__36123,count__36124,i__36125,pl_36132,vec__36126,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_36132.call(null,msg_hist);
});})(seq__36122,chunk__36123,count__36124,i__36125,pl_36132,vec__36126,k,plugin))
);
} else {
}

var G__36133 = seq__36122;
var G__36134 = chunk__36123;
var G__36135 = count__36124;
var G__36136 = (i__36125 + (1));
seq__36122 = G__36133;
chunk__36123 = G__36134;
count__36124 = G__36135;
i__36125 = G__36136;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__36122);
if(temp__4657__auto__){
var seq__36122__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__36122__$1)){
var c__27216__auto__ = cljs.core.chunk_first.call(null,seq__36122__$1);
var G__36137 = cljs.core.chunk_rest.call(null,seq__36122__$1);
var G__36138 = c__27216__auto__;
var G__36139 = cljs.core.count.call(null,c__27216__auto__);
var G__36140 = (0);
seq__36122 = G__36137;
chunk__36123 = G__36138;
count__36124 = G__36139;
i__36125 = G__36140;
continue;
} else {
var vec__36129 = cljs.core.first.call(null,seq__36122__$1);
var k = cljs.core.nth.call(null,vec__36129,(0),null);
var plugin = cljs.core.nth.call(null,vec__36129,(1),null);
if(cljs.core.truth_(plugin)){
var pl_36141 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__36122,chunk__36123,count__36124,i__36125,pl_36141,vec__36129,k,plugin,seq__36122__$1,temp__4657__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_36141.call(null,msg_hist);
});})(seq__36122,chunk__36123,count__36124,i__36125,pl_36141,vec__36129,k,plugin,seq__36122__$1,temp__4657__auto__))
);
} else {
}

var G__36142 = cljs.core.next.call(null,seq__36122__$1);
var G__36143 = null;
var G__36144 = (0);
var G__36145 = (0);
seq__36122 = G__36142;
chunk__36123 = G__36143;
count__36124 = G__36144;
i__36125 = G__36145;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var G__36147 = arguments.length;
switch (G__36147) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if(typeof figwheel.client.__figwheel_start_once__ !== 'undefined'){
return null;
} else {
return (
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.fill_url_template.call(null,figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370)))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.enable_repl_print_BANG_.call(null);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

var seq__36148_36153 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"initial-messages","initial-messages",2057377771).cljs$core$IFn$_invoke$arity$1(system_options));
var chunk__36149_36154 = null;
var count__36150_36155 = (0);
var i__36151_36156 = (0);
while(true){
if((i__36151_36156 < count__36150_36155)){
var msg_36157 = cljs.core._nth.call(null,chunk__36149_36154,i__36151_36156);
figwheel.client.socket.handle_incoming_message.call(null,msg_36157);

var G__36158 = seq__36148_36153;
var G__36159 = chunk__36149_36154;
var G__36160 = count__36150_36155;
var G__36161 = (i__36151_36156 + (1));
seq__36148_36153 = G__36158;
chunk__36149_36154 = G__36159;
count__36150_36155 = G__36160;
i__36151_36156 = G__36161;
continue;
} else {
var temp__4657__auto___36162 = cljs.core.seq.call(null,seq__36148_36153);
if(temp__4657__auto___36162){
var seq__36148_36163__$1 = temp__4657__auto___36162;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__36148_36163__$1)){
var c__27216__auto___36164 = cljs.core.chunk_first.call(null,seq__36148_36163__$1);
var G__36165 = cljs.core.chunk_rest.call(null,seq__36148_36163__$1);
var G__36166 = c__27216__auto___36164;
var G__36167 = cljs.core.count.call(null,c__27216__auto___36164);
var G__36168 = (0);
seq__36148_36153 = G__36165;
chunk__36149_36154 = G__36166;
count__36150_36155 = G__36167;
i__36151_36156 = G__36168;
continue;
} else {
var msg_36169 = cljs.core.first.call(null,seq__36148_36163__$1);
figwheel.client.socket.handle_incoming_message.call(null,msg_36169);

var G__36170 = cljs.core.next.call(null,seq__36148_36163__$1);
var G__36171 = null;
var G__36172 = (0);
var G__36173 = (0);
seq__36148_36153 = G__36170;
chunk__36149_36154 = G__36171;
count__36150_36155 = G__36172;
i__36151_36156 = G__36173;
continue;
}
} else {
}
}
break;
}

return figwheel.client.socket.open.call(null,system_options);
})))
;
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;

figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__27528__auto__ = [];
var len__27521__auto___36178 = arguments.length;
var i__27522__auto___36179 = (0);
while(true){
if((i__27522__auto___36179 < len__27521__auto___36178)){
args__27528__auto__.push((arguments[i__27522__auto___36179]));

var G__36180 = (i__27522__auto___36179 + (1));
i__27522__auto___36179 = G__36180;
continue;
} else {
}
break;
}

var argseq__27529__auto__ = ((((0) < args__27528__auto__.length))?(new cljs.core.IndexedSeq(args__27528__auto__.slice((0)),(0),null)):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__27529__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__36175){
var map__36176 = p__36175;
var map__36176__$1 = ((((!((map__36176 == null)))?((((map__36176.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36176.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36176):map__36176);
var opts = map__36176__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq36174){
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq36174));
});

figwheel.client.fetch_data_from_env = (function figwheel$client$fetch_data_from_env(){
try{return cljs.reader.read_string.call(null,goog.object.get(window,"FIGWHEEL_CLIENT_CONFIGURATION"));
}catch (e36181){if((e36181 instanceof Error)){
var e = e36181;
cljs.core._STAR_print_err_fn_STAR_.call(null,"Unable to load FIGWHEEL_CLIENT_CONFIGURATION from the environment");

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"autoload","autoload",-354122500),false], null);
} else {
throw e36181;

}
}});
figwheel.client.console_intro_message = "Figwheel has compiled a temporary helper application to your :output-file.\n\nThe code currently in your configured output file does not\nrepresent the code that you are trying to compile.\n\nThis temporary application is intended to help you continue to get\nfeedback from Figwheel until the build you are working on compiles\ncorrectly.\n\nWhen your ClojureScript source code compiles correctly this helper\napplication will auto-reload and pick up your freshly compiled\nClojureScript program.";
figwheel.client.bad_compile_helper_app = (function figwheel$client$bad_compile_helper_app(){
cljs.core.enable_console_print_BANG_.call(null);

var config = figwheel.client.fetch_data_from_env.call(null);
cljs.core.println.call(null,figwheel.client.console_intro_message);

figwheel.client.heads_up.bad_compile_screen.call(null);

if(cljs.core.truth_(goog.dependencies_)){
} else {
goog.dependencies_ = true;
}

figwheel.client.start.call(null,config);

return figwheel.client.add_message_watch.call(null,new cljs.core.Keyword(null,"listen-for-successful-compile","listen-for-successful-compile",-995277603),((function (config){
return (function (p__36182){
var map__36183 = p__36182;
var map__36183__$1 = ((((!((map__36183 == null)))?((((map__36183.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36183.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36183):map__36183);
var msg_name = cljs.core.get.call(null,map__36183__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))){
return location.href = location.href;
} else {
return null;
}
});})(config))
);
});

//# sourceMappingURL=client.js.map?rel=1499963085925