// Compiled by ClojureScript 1.9.671 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('figwheel.client.utils');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.net.jsloader');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.core.async');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__26396__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__26396__auto__){
return or__26396__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.fix_node_request_url = (function figwheel$client$file_reloading$fix_node_request_url(url){

if(cljs.core.truth_(goog.string.startsWith(url,"../"))){
return clojure.string.replace.call(null,url,"../","");
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("goog/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
}
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__26396__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, ["svgpan.SvgPan",null,"far.out",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__26396__auto__)){
return or__26396__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__34732_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__34732_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([name]));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([parent_ns]));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__34733 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__34734 = null;
var count__34735 = (0);
var i__34736 = (0);
while(true){
if((i__34736 < count__34735)){
var n = cljs.core._nth.call(null,chunk__34734,i__34736);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__34737 = seq__34733;
var G__34738 = chunk__34734;
var G__34739 = count__34735;
var G__34740 = (i__34736 + (1));
seq__34733 = G__34737;
chunk__34734 = G__34738;
count__34735 = G__34739;
i__34736 = G__34740;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__34733);
if(temp__4657__auto__){
var seq__34733__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34733__$1)){
var c__27216__auto__ = cljs.core.chunk_first.call(null,seq__34733__$1);
var G__34741 = cljs.core.chunk_rest.call(null,seq__34733__$1);
var G__34742 = c__27216__auto__;
var G__34743 = cljs.core.count.call(null,c__27216__auto__);
var G__34744 = (0);
seq__34733 = G__34741;
chunk__34734 = G__34742;
count__34735 = G__34743;
i__34736 = G__34744;
continue;
} else {
var n = cljs.core.first.call(null,seq__34733__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__34745 = cljs.core.next.call(null,seq__34733__$1);
var G__34746 = null;
var G__34747 = (0);
var G__34748 = (0);
seq__34733 = G__34745;
chunk__34734 = G__34746;
count__34735 = G__34747;
i__34736 = G__34748;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__34758_34766 = cljs.core.seq.call(null,deps);
var chunk__34759_34767 = null;
var count__34760_34768 = (0);
var i__34761_34769 = (0);
while(true){
if((i__34761_34769 < count__34760_34768)){
var dep_34770 = cljs.core._nth.call(null,chunk__34759_34767,i__34761_34769);
topo_sort_helper_STAR_.call(null,dep_34770,(depth + (1)),state);

var G__34771 = seq__34758_34766;
var G__34772 = chunk__34759_34767;
var G__34773 = count__34760_34768;
var G__34774 = (i__34761_34769 + (1));
seq__34758_34766 = G__34771;
chunk__34759_34767 = G__34772;
count__34760_34768 = G__34773;
i__34761_34769 = G__34774;
continue;
} else {
var temp__4657__auto___34775 = cljs.core.seq.call(null,seq__34758_34766);
if(temp__4657__auto___34775){
var seq__34758_34776__$1 = temp__4657__auto___34775;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34758_34776__$1)){
var c__27216__auto___34777 = cljs.core.chunk_first.call(null,seq__34758_34776__$1);
var G__34778 = cljs.core.chunk_rest.call(null,seq__34758_34776__$1);
var G__34779 = c__27216__auto___34777;
var G__34780 = cljs.core.count.call(null,c__27216__auto___34777);
var G__34781 = (0);
seq__34758_34766 = G__34778;
chunk__34759_34767 = G__34779;
count__34760_34768 = G__34780;
i__34761_34769 = G__34781;
continue;
} else {
var dep_34782 = cljs.core.first.call(null,seq__34758_34776__$1);
topo_sort_helper_STAR_.call(null,dep_34782,(depth + (1)),state);

var G__34783 = cljs.core.next.call(null,seq__34758_34776__$1);
var G__34784 = null;
var G__34785 = (0);
var G__34786 = (0);
seq__34758_34766 = G__34783;
chunk__34759_34767 = G__34784;
count__34760_34768 = G__34785;
i__34761_34769 = G__34786;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__34762){
var vec__34763 = p__34762;
var seq__34764 = cljs.core.seq.call(null,vec__34763);
var first__34765 = cljs.core.first.call(null,seq__34764);
var seq__34764__$1 = cljs.core.next.call(null,seq__34764);
var x = first__34765;
var xs = seq__34764__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__34763,seq__34764,first__34765,seq__34764__$1,x,xs,get_deps__$1){
return (function (p1__34749_SHARP_){
return clojure.set.difference.call(null,p1__34749_SHARP_,x);
});})(vec__34763,seq__34764,first__34765,seq__34764__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__34787 = cljs.core.seq.call(null,provides);
var chunk__34788 = null;
var count__34789 = (0);
var i__34790 = (0);
while(true){
if((i__34790 < count__34789)){
var prov = cljs.core._nth.call(null,chunk__34788,i__34790);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__34791_34799 = cljs.core.seq.call(null,requires);
var chunk__34792_34800 = null;
var count__34793_34801 = (0);
var i__34794_34802 = (0);
while(true){
if((i__34794_34802 < count__34793_34801)){
var req_34803 = cljs.core._nth.call(null,chunk__34792_34800,i__34794_34802);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_34803,prov);

var G__34804 = seq__34791_34799;
var G__34805 = chunk__34792_34800;
var G__34806 = count__34793_34801;
var G__34807 = (i__34794_34802 + (1));
seq__34791_34799 = G__34804;
chunk__34792_34800 = G__34805;
count__34793_34801 = G__34806;
i__34794_34802 = G__34807;
continue;
} else {
var temp__4657__auto___34808 = cljs.core.seq.call(null,seq__34791_34799);
if(temp__4657__auto___34808){
var seq__34791_34809__$1 = temp__4657__auto___34808;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34791_34809__$1)){
var c__27216__auto___34810 = cljs.core.chunk_first.call(null,seq__34791_34809__$1);
var G__34811 = cljs.core.chunk_rest.call(null,seq__34791_34809__$1);
var G__34812 = c__27216__auto___34810;
var G__34813 = cljs.core.count.call(null,c__27216__auto___34810);
var G__34814 = (0);
seq__34791_34799 = G__34811;
chunk__34792_34800 = G__34812;
count__34793_34801 = G__34813;
i__34794_34802 = G__34814;
continue;
} else {
var req_34815 = cljs.core.first.call(null,seq__34791_34809__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_34815,prov);

var G__34816 = cljs.core.next.call(null,seq__34791_34809__$1);
var G__34817 = null;
var G__34818 = (0);
var G__34819 = (0);
seq__34791_34799 = G__34816;
chunk__34792_34800 = G__34817;
count__34793_34801 = G__34818;
i__34794_34802 = G__34819;
continue;
}
} else {
}
}
break;
}

var G__34820 = seq__34787;
var G__34821 = chunk__34788;
var G__34822 = count__34789;
var G__34823 = (i__34790 + (1));
seq__34787 = G__34820;
chunk__34788 = G__34821;
count__34789 = G__34822;
i__34790 = G__34823;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__34787);
if(temp__4657__auto__){
var seq__34787__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34787__$1)){
var c__27216__auto__ = cljs.core.chunk_first.call(null,seq__34787__$1);
var G__34824 = cljs.core.chunk_rest.call(null,seq__34787__$1);
var G__34825 = c__27216__auto__;
var G__34826 = cljs.core.count.call(null,c__27216__auto__);
var G__34827 = (0);
seq__34787 = G__34824;
chunk__34788 = G__34825;
count__34789 = G__34826;
i__34790 = G__34827;
continue;
} else {
var prov = cljs.core.first.call(null,seq__34787__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__34795_34828 = cljs.core.seq.call(null,requires);
var chunk__34796_34829 = null;
var count__34797_34830 = (0);
var i__34798_34831 = (0);
while(true){
if((i__34798_34831 < count__34797_34830)){
var req_34832 = cljs.core._nth.call(null,chunk__34796_34829,i__34798_34831);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_34832,prov);

var G__34833 = seq__34795_34828;
var G__34834 = chunk__34796_34829;
var G__34835 = count__34797_34830;
var G__34836 = (i__34798_34831 + (1));
seq__34795_34828 = G__34833;
chunk__34796_34829 = G__34834;
count__34797_34830 = G__34835;
i__34798_34831 = G__34836;
continue;
} else {
var temp__4657__auto___34837__$1 = cljs.core.seq.call(null,seq__34795_34828);
if(temp__4657__auto___34837__$1){
var seq__34795_34838__$1 = temp__4657__auto___34837__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34795_34838__$1)){
var c__27216__auto___34839 = cljs.core.chunk_first.call(null,seq__34795_34838__$1);
var G__34840 = cljs.core.chunk_rest.call(null,seq__34795_34838__$1);
var G__34841 = c__27216__auto___34839;
var G__34842 = cljs.core.count.call(null,c__27216__auto___34839);
var G__34843 = (0);
seq__34795_34828 = G__34840;
chunk__34796_34829 = G__34841;
count__34797_34830 = G__34842;
i__34798_34831 = G__34843;
continue;
} else {
var req_34844 = cljs.core.first.call(null,seq__34795_34838__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_34844,prov);

var G__34845 = cljs.core.next.call(null,seq__34795_34838__$1);
var G__34846 = null;
var G__34847 = (0);
var G__34848 = (0);
seq__34795_34828 = G__34845;
chunk__34796_34829 = G__34846;
count__34797_34830 = G__34847;
i__34798_34831 = G__34848;
continue;
}
} else {
}
}
break;
}

var G__34849 = cljs.core.next.call(null,seq__34787__$1);
var G__34850 = null;
var G__34851 = (0);
var G__34852 = (0);
seq__34787 = G__34849;
chunk__34788 = G__34850;
count__34789 = G__34851;
i__34790 = G__34852;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__34853_34857 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__34854_34858 = null;
var count__34855_34859 = (0);
var i__34856_34860 = (0);
while(true){
if((i__34856_34860 < count__34855_34859)){
var ns_34861 = cljs.core._nth.call(null,chunk__34854_34858,i__34856_34860);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_34861);

var G__34862 = seq__34853_34857;
var G__34863 = chunk__34854_34858;
var G__34864 = count__34855_34859;
var G__34865 = (i__34856_34860 + (1));
seq__34853_34857 = G__34862;
chunk__34854_34858 = G__34863;
count__34855_34859 = G__34864;
i__34856_34860 = G__34865;
continue;
} else {
var temp__4657__auto___34866 = cljs.core.seq.call(null,seq__34853_34857);
if(temp__4657__auto___34866){
var seq__34853_34867__$1 = temp__4657__auto___34866;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34853_34867__$1)){
var c__27216__auto___34868 = cljs.core.chunk_first.call(null,seq__34853_34867__$1);
var G__34869 = cljs.core.chunk_rest.call(null,seq__34853_34867__$1);
var G__34870 = c__27216__auto___34868;
var G__34871 = cljs.core.count.call(null,c__27216__auto___34868);
var G__34872 = (0);
seq__34853_34857 = G__34869;
chunk__34854_34858 = G__34870;
count__34855_34859 = G__34871;
i__34856_34860 = G__34872;
continue;
} else {
var ns_34873 = cljs.core.first.call(null,seq__34853_34867__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_34873);

var G__34874 = cljs.core.next.call(null,seq__34853_34867__$1);
var G__34875 = null;
var G__34876 = (0);
var G__34877 = (0);
seq__34853_34857 = G__34874;
chunk__34854_34858 = G__34875;
count__34855_34859 = G__34876;
i__34856_34860 = G__34877;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__26396__auto__ = goog.require__;
if(cljs.core.truth_(or__26396__auto__)){
return or__26396__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__34878__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__34878 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__34879__i = 0, G__34879__a = new Array(arguments.length -  0);
while (G__34879__i < G__34879__a.length) {G__34879__a[G__34879__i] = arguments[G__34879__i + 0]; ++G__34879__i;}
  args = new cljs.core.IndexedSeq(G__34879__a,0,null);
} 
return G__34878__delegate.call(this,args);};
G__34878.cljs$lang$maxFixedArity = 0;
G__34878.cljs$lang$applyTo = (function (arglist__34880){
var args = cljs.core.seq(arglist__34880);
return G__34878__delegate(args);
});
G__34878.cljs$core$IFn$_invoke$arity$variadic = G__34878__delegate;
return G__34878;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__34882 = cljs.core._EQ_;
var expr__34883 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__34882.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__34883))){
var path_parts = ((function (pred__34882,expr__34883){
return (function (p1__34881_SHARP_){
return clojure.string.split.call(null,p1__34881_SHARP_,/[\/\\]/);
});})(pred__34882,expr__34883))
;
var sep = (cljs.core.truth_(cljs.core.re_matches.call(null,/win.*/,process.platform))?"\\":"/");
var root = clojure.string.join.call(null,sep,cljs.core.pop.call(null,cljs.core.pop.call(null,path_parts.call(null,__dirname))));
return ((function (path_parts,sep,root,pred__34882,expr__34883){
return (function (request_url,callback){

var cache_path = clojure.string.join.call(null,sep,cljs.core.cons.call(null,root,path_parts.call(null,figwheel.client.file_reloading.fix_node_request_url.call(null,request_url))));
(require.cache[cache_path] = null);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e34885){if((e34885 instanceof Error)){
var e = e34885;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Error loading file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e34885;

}
}})());
});
;})(path_parts,sep,root,pred__34882,expr__34883))
} else {
if(cljs.core.truth_(pred__34882.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__34883))){
return ((function (pred__34882,expr__34883){
return (function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
deferred.addCallback(((function (deferred,pred__34882,expr__34883){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred,pred__34882,expr__34883))
);

return deferred.addErrback(((function (deferred,pred__34882,expr__34883){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred,pred__34882,expr__34883))
);
});
;})(pred__34882,expr__34883))
} else {
return ((function (pred__34882,expr__34883){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__34882,expr__34883))
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__34886,callback){
var map__34887 = p__34886;
var map__34887__$1 = ((((!((map__34887 == null)))?((((map__34887.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34887.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34887):map__34887);
var file_msg = map__34887__$1;
var request_url = cljs.core.get.call(null,map__34887__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("FigWheel: Attempting to load "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__34887,map__34887__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("FigWheel: Successfully loaded "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Error loading file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__34887,map__34887__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__31204__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31204__auto__){
return (function (){
var f__31205__auto__ = (function (){var switch__31116__auto__ = ((function (c__31204__auto__){
return (function (state_34911){
var state_val_34912 = (state_34911[(1)]);
if((state_val_34912 === (7))){
var inst_34907 = (state_34911[(2)]);
var state_34911__$1 = state_34911;
var statearr_34913_34930 = state_34911__$1;
(statearr_34913_34930[(2)] = inst_34907);

(statearr_34913_34930[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34912 === (1))){
var state_34911__$1 = state_34911;
var statearr_34914_34931 = state_34911__$1;
(statearr_34914_34931[(2)] = null);

(statearr_34914_34931[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34912 === (4))){
var inst_34891 = (state_34911[(7)]);
var inst_34891__$1 = (state_34911[(2)]);
var state_34911__$1 = (function (){var statearr_34915 = state_34911;
(statearr_34915[(7)] = inst_34891__$1);

return statearr_34915;
})();
if(cljs.core.truth_(inst_34891__$1)){
var statearr_34916_34932 = state_34911__$1;
(statearr_34916_34932[(1)] = (5));

} else {
var statearr_34917_34933 = state_34911__$1;
(statearr_34917_34933[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34912 === (6))){
var state_34911__$1 = state_34911;
var statearr_34918_34934 = state_34911__$1;
(statearr_34918_34934[(2)] = null);

(statearr_34918_34934[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34912 === (3))){
var inst_34909 = (state_34911[(2)]);
var state_34911__$1 = state_34911;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34911__$1,inst_34909);
} else {
if((state_val_34912 === (2))){
var state_34911__$1 = state_34911;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34911__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_34912 === (11))){
var inst_34903 = (state_34911[(2)]);
var state_34911__$1 = (function (){var statearr_34919 = state_34911;
(statearr_34919[(8)] = inst_34903);

return statearr_34919;
})();
var statearr_34920_34935 = state_34911__$1;
(statearr_34920_34935[(2)] = null);

(statearr_34920_34935[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34912 === (9))){
var inst_34895 = (state_34911[(9)]);
var inst_34897 = (state_34911[(10)]);
var inst_34899 = inst_34897.call(null,inst_34895);
var state_34911__$1 = state_34911;
var statearr_34921_34936 = state_34911__$1;
(statearr_34921_34936[(2)] = inst_34899);

(statearr_34921_34936[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34912 === (5))){
var inst_34891 = (state_34911[(7)]);
var inst_34893 = figwheel.client.file_reloading.blocking_load.call(null,inst_34891);
var state_34911__$1 = state_34911;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34911__$1,(8),inst_34893);
} else {
if((state_val_34912 === (10))){
var inst_34895 = (state_34911[(9)]);
var inst_34901 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_34895);
var state_34911__$1 = state_34911;
var statearr_34922_34937 = state_34911__$1;
(statearr_34922_34937[(2)] = inst_34901);

(statearr_34922_34937[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34912 === (8))){
var inst_34891 = (state_34911[(7)]);
var inst_34897 = (state_34911[(10)]);
var inst_34895 = (state_34911[(2)]);
var inst_34896 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_34897__$1 = cljs.core.get.call(null,inst_34896,inst_34891);
var state_34911__$1 = (function (){var statearr_34923 = state_34911;
(statearr_34923[(9)] = inst_34895);

(statearr_34923[(10)] = inst_34897__$1);

return statearr_34923;
})();
if(cljs.core.truth_(inst_34897__$1)){
var statearr_34924_34938 = state_34911__$1;
(statearr_34924_34938[(1)] = (9));

} else {
var statearr_34925_34939 = state_34911__$1;
(statearr_34925_34939[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__31204__auto__))
;
return ((function (switch__31116__auto__,c__31204__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__31117__auto__ = null;
var figwheel$client$file_reloading$state_machine__31117__auto____0 = (function (){
var statearr_34926 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_34926[(0)] = figwheel$client$file_reloading$state_machine__31117__auto__);

(statearr_34926[(1)] = (1));

return statearr_34926;
});
var figwheel$client$file_reloading$state_machine__31117__auto____1 = (function (state_34911){
while(true){
var ret_value__31118__auto__ = (function (){try{while(true){
var result__31119__auto__ = switch__31116__auto__.call(null,state_34911);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31119__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31119__auto__;
}
break;
}
}catch (e34927){if((e34927 instanceof Object)){
var ex__31120__auto__ = e34927;
var statearr_34928_34940 = state_34911;
(statearr_34928_34940[(5)] = ex__31120__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34911);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34927;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31118__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34941 = state_34911;
state_34911 = G__34941;
continue;
} else {
return ret_value__31118__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__31117__auto__ = function(state_34911){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__31117__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__31117__auto____1.call(this,state_34911);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__31117__auto____0;
figwheel$client$file_reloading$state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__31117__auto____1;
return figwheel$client$file_reloading$state_machine__31117__auto__;
})()
;})(switch__31116__auto__,c__31204__auto__))
})();
var state__31206__auto__ = (function (){var statearr_34929 = f__31205__auto__.call(null);
(statearr_34929[(6)] = c__31204__auto__);

return statearr_34929;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31206__auto__);
});})(c__31204__auto__))
);

return c__31204__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__34942,callback){
var map__34943 = p__34942;
var map__34943__$1 = ((((!((map__34943 == null)))?((((map__34943.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34943.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34943):map__34943);
var file_msg = map__34943__$1;
var namespace = cljs.core.get.call(null,map__34943__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__34943,map__34943__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__34943,map__34943__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__34945){
var map__34946 = p__34945;
var map__34946__$1 = ((((!((map__34946 == null)))?((((map__34946.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34946.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34946):map__34946);
var file_msg = map__34946__$1;
var namespace = cljs.core.get.call(null,map__34946__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__26384__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas));
if(and__26384__auto__){
var or__26396__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__26396__auto__)){
return or__26396__auto__;
} else {
var or__26396__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__26396__auto____$1)){
return or__26396__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__26384__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__34948,callback){
var map__34949 = p__34948;
var map__34949__$1 = ((((!((map__34949 == null)))?((((map__34949.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34949.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34949):map__34949);
var file_msg = map__34949__$1;
var request_url = cljs.core.get.call(null,map__34949__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__34949__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Not trying to load file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__31204__auto___34999 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31204__auto___34999,out){
return (function (){
var f__31205__auto__ = (function (){var switch__31116__auto__ = ((function (c__31204__auto___34999,out){
return (function (state_34984){
var state_val_34985 = (state_34984[(1)]);
if((state_val_34985 === (1))){
var inst_34958 = cljs.core.seq.call(null,files);
var inst_34959 = cljs.core.first.call(null,inst_34958);
var inst_34960 = cljs.core.next.call(null,inst_34958);
var inst_34961 = files;
var state_34984__$1 = (function (){var statearr_34986 = state_34984;
(statearr_34986[(7)] = inst_34959);

(statearr_34986[(8)] = inst_34960);

(statearr_34986[(9)] = inst_34961);

return statearr_34986;
})();
var statearr_34987_35000 = state_34984__$1;
(statearr_34987_35000[(2)] = null);

(statearr_34987_35000[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34985 === (2))){
var inst_34961 = (state_34984[(9)]);
var inst_34967 = (state_34984[(10)]);
var inst_34966 = cljs.core.seq.call(null,inst_34961);
var inst_34967__$1 = cljs.core.first.call(null,inst_34966);
var inst_34968 = cljs.core.next.call(null,inst_34966);
var inst_34969 = (inst_34967__$1 == null);
var inst_34970 = cljs.core.not.call(null,inst_34969);
var state_34984__$1 = (function (){var statearr_34988 = state_34984;
(statearr_34988[(11)] = inst_34968);

(statearr_34988[(10)] = inst_34967__$1);

return statearr_34988;
})();
if(inst_34970){
var statearr_34989_35001 = state_34984__$1;
(statearr_34989_35001[(1)] = (4));

} else {
var statearr_34990_35002 = state_34984__$1;
(statearr_34990_35002[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34985 === (3))){
var inst_34982 = (state_34984[(2)]);
var state_34984__$1 = state_34984;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34984__$1,inst_34982);
} else {
if((state_val_34985 === (4))){
var inst_34967 = (state_34984[(10)]);
var inst_34972 = figwheel.client.file_reloading.reload_js_file.call(null,inst_34967);
var state_34984__$1 = state_34984;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34984__$1,(7),inst_34972);
} else {
if((state_val_34985 === (5))){
var inst_34978 = cljs.core.async.close_BANG_.call(null,out);
var state_34984__$1 = state_34984;
var statearr_34991_35003 = state_34984__$1;
(statearr_34991_35003[(2)] = inst_34978);

(statearr_34991_35003[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34985 === (6))){
var inst_34980 = (state_34984[(2)]);
var state_34984__$1 = state_34984;
var statearr_34992_35004 = state_34984__$1;
(statearr_34992_35004[(2)] = inst_34980);

(statearr_34992_35004[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34985 === (7))){
var inst_34968 = (state_34984[(11)]);
var inst_34974 = (state_34984[(2)]);
var inst_34975 = cljs.core.async.put_BANG_.call(null,out,inst_34974);
var inst_34961 = inst_34968;
var state_34984__$1 = (function (){var statearr_34993 = state_34984;
(statearr_34993[(12)] = inst_34975);

(statearr_34993[(9)] = inst_34961);

return statearr_34993;
})();
var statearr_34994_35005 = state_34984__$1;
(statearr_34994_35005[(2)] = null);

(statearr_34994_35005[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__31204__auto___34999,out))
;
return ((function (switch__31116__auto__,c__31204__auto___34999,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__31117__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__31117__auto____0 = (function (){
var statearr_34995 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34995[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__31117__auto__);

(statearr_34995[(1)] = (1));

return statearr_34995;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__31117__auto____1 = (function (state_34984){
while(true){
var ret_value__31118__auto__ = (function (){try{while(true){
var result__31119__auto__ = switch__31116__auto__.call(null,state_34984);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31119__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31119__auto__;
}
break;
}
}catch (e34996){if((e34996 instanceof Object)){
var ex__31120__auto__ = e34996;
var statearr_34997_35006 = state_34984;
(statearr_34997_35006[(5)] = ex__31120__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34984);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34996;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31118__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35007 = state_34984;
state_34984 = G__35007;
continue;
} else {
return ret_value__31118__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__31117__auto__ = function(state_34984){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__31117__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__31117__auto____1.call(this,state_34984);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__31117__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__31117__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__31117__auto__;
})()
;})(switch__31116__auto__,c__31204__auto___34999,out))
})();
var state__31206__auto__ = (function (){var statearr_34998 = f__31205__auto__.call(null);
(statearr_34998[(6)] = c__31204__auto___34999);

return statearr_34998;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31206__auto__);
});})(c__31204__auto___34999,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__35008,opts){
var map__35009 = p__35008;
var map__35009__$1 = ((((!((map__35009 == null)))?((((map__35009.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35009.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35009):map__35009);
var eval_body = cljs.core.get.call(null,map__35009__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__35009__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__26384__auto__ = eval_body;
if(cljs.core.truth_(and__26384__auto__)){
return typeof eval_body === 'string';
} else {
return and__26384__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Evaling file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e35011){var e = e35011;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Unable to evaluate "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["figwheel.connect",null], null), null),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__4655__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__35012_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__35012_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__4655__auto__)){
var file_msg = temp__4655__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__35013){
var vec__35014 = p__35013;
var k = cljs.core.nth.call(null,vec__35014,(0),null);
var v = cljs.core.nth.call(null,vec__35014,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__35017){
var vec__35018 = p__35017;
var k = cljs.core.nth.call(null,vec__35018,(0),null);
var v = cljs.core.nth.call(null,vec__35018,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__35024,p__35025){
var map__35026 = p__35024;
var map__35026__$1 = ((((!((map__35026 == null)))?((((map__35026.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35026.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35026):map__35026);
var opts = map__35026__$1;
var before_jsload = cljs.core.get.call(null,map__35026__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__35026__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__35026__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__35027 = p__35025;
var map__35027__$1 = ((((!((map__35027 == null)))?((((map__35027.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35027.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35027):map__35027);
var msg = map__35027__$1;
var files = cljs.core.get.call(null,map__35027__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__35027__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__35027__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__31204__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31204__auto__,map__35026,map__35026__$1,opts,before_jsload,on_jsload,reload_dependents,map__35027,map__35027__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__31205__auto__ = (function (){var switch__31116__auto__ = ((function (c__31204__auto__,map__35026,map__35026__$1,opts,before_jsload,on_jsload,reload_dependents,map__35027,map__35027__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_35181){
var state_val_35182 = (state_35181[(1)]);
if((state_val_35182 === (7))){
var inst_35044 = (state_35181[(7)]);
var inst_35042 = (state_35181[(8)]);
var inst_35043 = (state_35181[(9)]);
var inst_35041 = (state_35181[(10)]);
var inst_35049 = cljs.core._nth.call(null,inst_35042,inst_35044);
var inst_35050 = figwheel.client.file_reloading.eval_body.call(null,inst_35049,opts);
var inst_35051 = (inst_35044 + (1));
var tmp35183 = inst_35042;
var tmp35184 = inst_35043;
var tmp35185 = inst_35041;
var inst_35041__$1 = tmp35185;
var inst_35042__$1 = tmp35183;
var inst_35043__$1 = tmp35184;
var inst_35044__$1 = inst_35051;
var state_35181__$1 = (function (){var statearr_35186 = state_35181;
(statearr_35186[(7)] = inst_35044__$1);

(statearr_35186[(8)] = inst_35042__$1);

(statearr_35186[(11)] = inst_35050);

(statearr_35186[(9)] = inst_35043__$1);

(statearr_35186[(10)] = inst_35041__$1);

return statearr_35186;
})();
var statearr_35187_35270 = state_35181__$1;
(statearr_35187_35270[(2)] = null);

(statearr_35187_35270[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (20))){
var inst_35084 = (state_35181[(12)]);
var inst_35092 = figwheel.client.file_reloading.sort_files.call(null,inst_35084);
var state_35181__$1 = state_35181;
var statearr_35188_35271 = state_35181__$1;
(statearr_35188_35271[(2)] = inst_35092);

(statearr_35188_35271[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (27))){
var state_35181__$1 = state_35181;
var statearr_35189_35272 = state_35181__$1;
(statearr_35189_35272[(2)] = null);

(statearr_35189_35272[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (1))){
var inst_35033 = (state_35181[(13)]);
var inst_35030 = before_jsload.call(null,files);
var inst_35031 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_35032 = (function (){return ((function (inst_35033,inst_35030,inst_35031,state_val_35182,c__31204__auto__,map__35026,map__35026__$1,opts,before_jsload,on_jsload,reload_dependents,map__35027,map__35027__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__35021_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__35021_SHARP_);
});
;})(inst_35033,inst_35030,inst_35031,state_val_35182,c__31204__auto__,map__35026,map__35026__$1,opts,before_jsload,on_jsload,reload_dependents,map__35027,map__35027__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_35033__$1 = cljs.core.filter.call(null,inst_35032,files);
var inst_35034 = cljs.core.not_empty.call(null,inst_35033__$1);
var state_35181__$1 = (function (){var statearr_35190 = state_35181;
(statearr_35190[(13)] = inst_35033__$1);

(statearr_35190[(14)] = inst_35030);

(statearr_35190[(15)] = inst_35031);

return statearr_35190;
})();
if(cljs.core.truth_(inst_35034)){
var statearr_35191_35273 = state_35181__$1;
(statearr_35191_35273[(1)] = (2));

} else {
var statearr_35192_35274 = state_35181__$1;
(statearr_35192_35274[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (24))){
var state_35181__$1 = state_35181;
var statearr_35193_35275 = state_35181__$1;
(statearr_35193_35275[(2)] = null);

(statearr_35193_35275[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (39))){
var inst_35134 = (state_35181[(16)]);
var state_35181__$1 = state_35181;
var statearr_35194_35276 = state_35181__$1;
(statearr_35194_35276[(2)] = inst_35134);

(statearr_35194_35276[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (46))){
var inst_35176 = (state_35181[(2)]);
var state_35181__$1 = state_35181;
var statearr_35195_35277 = state_35181__$1;
(statearr_35195_35277[(2)] = inst_35176);

(statearr_35195_35277[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (4))){
var inst_35078 = (state_35181[(2)]);
var inst_35079 = cljs.core.List.EMPTY;
var inst_35080 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_35079);
var inst_35081 = (function (){return ((function (inst_35078,inst_35079,inst_35080,state_val_35182,c__31204__auto__,map__35026,map__35026__$1,opts,before_jsload,on_jsload,reload_dependents,map__35027,map__35027__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__35022_SHARP_){
var and__26384__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__35022_SHARP_);
if(cljs.core.truth_(and__26384__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__35022_SHARP_));
} else {
return and__26384__auto__;
}
});
;})(inst_35078,inst_35079,inst_35080,state_val_35182,c__31204__auto__,map__35026,map__35026__$1,opts,before_jsload,on_jsload,reload_dependents,map__35027,map__35027__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_35082 = cljs.core.filter.call(null,inst_35081,files);
var inst_35083 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_35084 = cljs.core.concat.call(null,inst_35082,inst_35083);
var state_35181__$1 = (function (){var statearr_35196 = state_35181;
(statearr_35196[(17)] = inst_35080);

(statearr_35196[(12)] = inst_35084);

(statearr_35196[(18)] = inst_35078);

return statearr_35196;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_35197_35278 = state_35181__$1;
(statearr_35197_35278[(1)] = (16));

} else {
var statearr_35198_35279 = state_35181__$1;
(statearr_35198_35279[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (15))){
var inst_35068 = (state_35181[(2)]);
var state_35181__$1 = state_35181;
var statearr_35199_35280 = state_35181__$1;
(statearr_35199_35280[(2)] = inst_35068);

(statearr_35199_35280[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (21))){
var inst_35094 = (state_35181[(19)]);
var inst_35094__$1 = (state_35181[(2)]);
var inst_35095 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_35094__$1);
var state_35181__$1 = (function (){var statearr_35200 = state_35181;
(statearr_35200[(19)] = inst_35094__$1);

return statearr_35200;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35181__$1,(22),inst_35095);
} else {
if((state_val_35182 === (31))){
var inst_35179 = (state_35181[(2)]);
var state_35181__$1 = state_35181;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35181__$1,inst_35179);
} else {
if((state_val_35182 === (32))){
var inst_35134 = (state_35181[(16)]);
var inst_35139 = inst_35134.cljs$lang$protocol_mask$partition0$;
var inst_35140 = (inst_35139 & (64));
var inst_35141 = inst_35134.cljs$core$ISeq$;
var inst_35142 = (cljs.core.PROTOCOL_SENTINEL === inst_35141);
var inst_35143 = (inst_35140) || (inst_35142);
var state_35181__$1 = state_35181;
if(cljs.core.truth_(inst_35143)){
var statearr_35201_35281 = state_35181__$1;
(statearr_35201_35281[(1)] = (35));

} else {
var statearr_35202_35282 = state_35181__$1;
(statearr_35202_35282[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (40))){
var inst_35156 = (state_35181[(20)]);
var inst_35155 = (state_35181[(2)]);
var inst_35156__$1 = cljs.core.get.call(null,inst_35155,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_35157 = cljs.core.get.call(null,inst_35155,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_35158 = cljs.core.not_empty.call(null,inst_35156__$1);
var state_35181__$1 = (function (){var statearr_35203 = state_35181;
(statearr_35203[(21)] = inst_35157);

(statearr_35203[(20)] = inst_35156__$1);

return statearr_35203;
})();
if(cljs.core.truth_(inst_35158)){
var statearr_35204_35283 = state_35181__$1;
(statearr_35204_35283[(1)] = (41));

} else {
var statearr_35205_35284 = state_35181__$1;
(statearr_35205_35284[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (33))){
var state_35181__$1 = state_35181;
var statearr_35206_35285 = state_35181__$1;
(statearr_35206_35285[(2)] = false);

(statearr_35206_35285[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (13))){
var inst_35054 = (state_35181[(22)]);
var inst_35058 = cljs.core.chunk_first.call(null,inst_35054);
var inst_35059 = cljs.core.chunk_rest.call(null,inst_35054);
var inst_35060 = cljs.core.count.call(null,inst_35058);
var inst_35041 = inst_35059;
var inst_35042 = inst_35058;
var inst_35043 = inst_35060;
var inst_35044 = (0);
var state_35181__$1 = (function (){var statearr_35207 = state_35181;
(statearr_35207[(7)] = inst_35044);

(statearr_35207[(8)] = inst_35042);

(statearr_35207[(9)] = inst_35043);

(statearr_35207[(10)] = inst_35041);

return statearr_35207;
})();
var statearr_35208_35286 = state_35181__$1;
(statearr_35208_35286[(2)] = null);

(statearr_35208_35286[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (22))){
var inst_35102 = (state_35181[(23)]);
var inst_35097 = (state_35181[(24)]);
var inst_35098 = (state_35181[(25)]);
var inst_35094 = (state_35181[(19)]);
var inst_35097__$1 = (state_35181[(2)]);
var inst_35098__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_35097__$1);
var inst_35099 = (function (){var all_files = inst_35094;
var res_SINGLEQUOTE_ = inst_35097__$1;
var res = inst_35098__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_35102,inst_35097,inst_35098,inst_35094,inst_35097__$1,inst_35098__$1,state_val_35182,c__31204__auto__,map__35026,map__35026__$1,opts,before_jsload,on_jsload,reload_dependents,map__35027,map__35027__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__35023_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__35023_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_35102,inst_35097,inst_35098,inst_35094,inst_35097__$1,inst_35098__$1,state_val_35182,c__31204__auto__,map__35026,map__35026__$1,opts,before_jsload,on_jsload,reload_dependents,map__35027,map__35027__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_35100 = cljs.core.filter.call(null,inst_35099,inst_35097__$1);
var inst_35101 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_35102__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_35101);
var inst_35103 = cljs.core.not_empty.call(null,inst_35102__$1);
var state_35181__$1 = (function (){var statearr_35209 = state_35181;
(statearr_35209[(23)] = inst_35102__$1);

(statearr_35209[(24)] = inst_35097__$1);

(statearr_35209[(25)] = inst_35098__$1);

(statearr_35209[(26)] = inst_35100);

return statearr_35209;
})();
if(cljs.core.truth_(inst_35103)){
var statearr_35210_35287 = state_35181__$1;
(statearr_35210_35287[(1)] = (23));

} else {
var statearr_35211_35288 = state_35181__$1;
(statearr_35211_35288[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (36))){
var state_35181__$1 = state_35181;
var statearr_35212_35289 = state_35181__$1;
(statearr_35212_35289[(2)] = false);

(statearr_35212_35289[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (41))){
var inst_35156 = (state_35181[(20)]);
var inst_35160 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_35161 = cljs.core.map.call(null,inst_35160,inst_35156);
var inst_35162 = cljs.core.pr_str.call(null,inst_35161);
var inst_35163 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("figwheel-no-load meta-data: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35162)].join('');
var inst_35164 = figwheel.client.utils.log.call(null,inst_35163);
var state_35181__$1 = state_35181;
var statearr_35213_35290 = state_35181__$1;
(statearr_35213_35290[(2)] = inst_35164);

(statearr_35213_35290[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (43))){
var inst_35157 = (state_35181[(21)]);
var inst_35167 = (state_35181[(2)]);
var inst_35168 = cljs.core.not_empty.call(null,inst_35157);
var state_35181__$1 = (function (){var statearr_35214 = state_35181;
(statearr_35214[(27)] = inst_35167);

return statearr_35214;
})();
if(cljs.core.truth_(inst_35168)){
var statearr_35215_35291 = state_35181__$1;
(statearr_35215_35291[(1)] = (44));

} else {
var statearr_35216_35292 = state_35181__$1;
(statearr_35216_35292[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (29))){
var inst_35134 = (state_35181[(16)]);
var inst_35102 = (state_35181[(23)]);
var inst_35097 = (state_35181[(24)]);
var inst_35098 = (state_35181[(25)]);
var inst_35094 = (state_35181[(19)]);
var inst_35100 = (state_35181[(26)]);
var inst_35130 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_35133 = (function (){var all_files = inst_35094;
var res_SINGLEQUOTE_ = inst_35097;
var res = inst_35098;
var files_not_loaded = inst_35100;
var dependencies_that_loaded = inst_35102;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_35134,inst_35102,inst_35097,inst_35098,inst_35094,inst_35100,inst_35130,state_val_35182,c__31204__auto__,map__35026,map__35026__$1,opts,before_jsload,on_jsload,reload_dependents,map__35027,map__35027__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__35132){
var map__35217 = p__35132;
var map__35217__$1 = ((((!((map__35217 == null)))?((((map__35217.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35217.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35217):map__35217);
var namespace = cljs.core.get.call(null,map__35217__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_35134,inst_35102,inst_35097,inst_35098,inst_35094,inst_35100,inst_35130,state_val_35182,c__31204__auto__,map__35026,map__35026__$1,opts,before_jsload,on_jsload,reload_dependents,map__35027,map__35027__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_35134__$1 = cljs.core.group_by.call(null,inst_35133,inst_35100);
var inst_35136 = (inst_35134__$1 == null);
var inst_35137 = cljs.core.not.call(null,inst_35136);
var state_35181__$1 = (function (){var statearr_35219 = state_35181;
(statearr_35219[(28)] = inst_35130);

(statearr_35219[(16)] = inst_35134__$1);

return statearr_35219;
})();
if(inst_35137){
var statearr_35220_35293 = state_35181__$1;
(statearr_35220_35293[(1)] = (32));

} else {
var statearr_35221_35294 = state_35181__$1;
(statearr_35221_35294[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (44))){
var inst_35157 = (state_35181[(21)]);
var inst_35170 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_35157);
var inst_35171 = cljs.core.pr_str.call(null,inst_35170);
var inst_35172 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("not required: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35171)].join('');
var inst_35173 = figwheel.client.utils.log.call(null,inst_35172);
var state_35181__$1 = state_35181;
var statearr_35222_35295 = state_35181__$1;
(statearr_35222_35295[(2)] = inst_35173);

(statearr_35222_35295[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (6))){
var inst_35075 = (state_35181[(2)]);
var state_35181__$1 = state_35181;
var statearr_35223_35296 = state_35181__$1;
(statearr_35223_35296[(2)] = inst_35075);

(statearr_35223_35296[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (28))){
var inst_35100 = (state_35181[(26)]);
var inst_35127 = (state_35181[(2)]);
var inst_35128 = cljs.core.not_empty.call(null,inst_35100);
var state_35181__$1 = (function (){var statearr_35224 = state_35181;
(statearr_35224[(29)] = inst_35127);

return statearr_35224;
})();
if(cljs.core.truth_(inst_35128)){
var statearr_35225_35297 = state_35181__$1;
(statearr_35225_35297[(1)] = (29));

} else {
var statearr_35226_35298 = state_35181__$1;
(statearr_35226_35298[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (25))){
var inst_35098 = (state_35181[(25)]);
var inst_35114 = (state_35181[(2)]);
var inst_35115 = cljs.core.not_empty.call(null,inst_35098);
var state_35181__$1 = (function (){var statearr_35227 = state_35181;
(statearr_35227[(30)] = inst_35114);

return statearr_35227;
})();
if(cljs.core.truth_(inst_35115)){
var statearr_35228_35299 = state_35181__$1;
(statearr_35228_35299[(1)] = (26));

} else {
var statearr_35229_35300 = state_35181__$1;
(statearr_35229_35300[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (34))){
var inst_35150 = (state_35181[(2)]);
var state_35181__$1 = state_35181;
if(cljs.core.truth_(inst_35150)){
var statearr_35230_35301 = state_35181__$1;
(statearr_35230_35301[(1)] = (38));

} else {
var statearr_35231_35302 = state_35181__$1;
(statearr_35231_35302[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (17))){
var state_35181__$1 = state_35181;
var statearr_35232_35303 = state_35181__$1;
(statearr_35232_35303[(2)] = recompile_dependents);

(statearr_35232_35303[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (3))){
var state_35181__$1 = state_35181;
var statearr_35233_35304 = state_35181__$1;
(statearr_35233_35304[(2)] = null);

(statearr_35233_35304[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (12))){
var inst_35071 = (state_35181[(2)]);
var state_35181__$1 = state_35181;
var statearr_35234_35305 = state_35181__$1;
(statearr_35234_35305[(2)] = inst_35071);

(statearr_35234_35305[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (2))){
var inst_35033 = (state_35181[(13)]);
var inst_35040 = cljs.core.seq.call(null,inst_35033);
var inst_35041 = inst_35040;
var inst_35042 = null;
var inst_35043 = (0);
var inst_35044 = (0);
var state_35181__$1 = (function (){var statearr_35235 = state_35181;
(statearr_35235[(7)] = inst_35044);

(statearr_35235[(8)] = inst_35042);

(statearr_35235[(9)] = inst_35043);

(statearr_35235[(10)] = inst_35041);

return statearr_35235;
})();
var statearr_35236_35306 = state_35181__$1;
(statearr_35236_35306[(2)] = null);

(statearr_35236_35306[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (23))){
var inst_35102 = (state_35181[(23)]);
var inst_35097 = (state_35181[(24)]);
var inst_35098 = (state_35181[(25)]);
var inst_35094 = (state_35181[(19)]);
var inst_35100 = (state_35181[(26)]);
var inst_35105 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_35107 = (function (){var all_files = inst_35094;
var res_SINGLEQUOTE_ = inst_35097;
var res = inst_35098;
var files_not_loaded = inst_35100;
var dependencies_that_loaded = inst_35102;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_35102,inst_35097,inst_35098,inst_35094,inst_35100,inst_35105,state_val_35182,c__31204__auto__,map__35026,map__35026__$1,opts,before_jsload,on_jsload,reload_dependents,map__35027,map__35027__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__35106){
var map__35237 = p__35106;
var map__35237__$1 = ((((!((map__35237 == null)))?((((map__35237.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35237.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35237):map__35237);
var request_url = cljs.core.get.call(null,map__35237__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_35102,inst_35097,inst_35098,inst_35094,inst_35100,inst_35105,state_val_35182,c__31204__auto__,map__35026,map__35026__$1,opts,before_jsload,on_jsload,reload_dependents,map__35027,map__35027__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_35108 = cljs.core.reverse.call(null,inst_35102);
var inst_35109 = cljs.core.map.call(null,inst_35107,inst_35108);
var inst_35110 = cljs.core.pr_str.call(null,inst_35109);
var inst_35111 = figwheel.client.utils.log.call(null,inst_35110);
var state_35181__$1 = (function (){var statearr_35239 = state_35181;
(statearr_35239[(31)] = inst_35105);

return statearr_35239;
})();
var statearr_35240_35307 = state_35181__$1;
(statearr_35240_35307[(2)] = inst_35111);

(statearr_35240_35307[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (35))){
var state_35181__$1 = state_35181;
var statearr_35241_35308 = state_35181__$1;
(statearr_35241_35308[(2)] = true);

(statearr_35241_35308[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (19))){
var inst_35084 = (state_35181[(12)]);
var inst_35090 = figwheel.client.file_reloading.expand_files.call(null,inst_35084);
var state_35181__$1 = state_35181;
var statearr_35242_35309 = state_35181__$1;
(statearr_35242_35309[(2)] = inst_35090);

(statearr_35242_35309[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (11))){
var state_35181__$1 = state_35181;
var statearr_35243_35310 = state_35181__$1;
(statearr_35243_35310[(2)] = null);

(statearr_35243_35310[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (9))){
var inst_35073 = (state_35181[(2)]);
var state_35181__$1 = state_35181;
var statearr_35244_35311 = state_35181__$1;
(statearr_35244_35311[(2)] = inst_35073);

(statearr_35244_35311[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (5))){
var inst_35044 = (state_35181[(7)]);
var inst_35043 = (state_35181[(9)]);
var inst_35046 = (inst_35044 < inst_35043);
var inst_35047 = inst_35046;
var state_35181__$1 = state_35181;
if(cljs.core.truth_(inst_35047)){
var statearr_35245_35312 = state_35181__$1;
(statearr_35245_35312[(1)] = (7));

} else {
var statearr_35246_35313 = state_35181__$1;
(statearr_35246_35313[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (14))){
var inst_35054 = (state_35181[(22)]);
var inst_35063 = cljs.core.first.call(null,inst_35054);
var inst_35064 = figwheel.client.file_reloading.eval_body.call(null,inst_35063,opts);
var inst_35065 = cljs.core.next.call(null,inst_35054);
var inst_35041 = inst_35065;
var inst_35042 = null;
var inst_35043 = (0);
var inst_35044 = (0);
var state_35181__$1 = (function (){var statearr_35247 = state_35181;
(statearr_35247[(32)] = inst_35064);

(statearr_35247[(7)] = inst_35044);

(statearr_35247[(8)] = inst_35042);

(statearr_35247[(9)] = inst_35043);

(statearr_35247[(10)] = inst_35041);

return statearr_35247;
})();
var statearr_35248_35314 = state_35181__$1;
(statearr_35248_35314[(2)] = null);

(statearr_35248_35314[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (45))){
var state_35181__$1 = state_35181;
var statearr_35249_35315 = state_35181__$1;
(statearr_35249_35315[(2)] = null);

(statearr_35249_35315[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (26))){
var inst_35102 = (state_35181[(23)]);
var inst_35097 = (state_35181[(24)]);
var inst_35098 = (state_35181[(25)]);
var inst_35094 = (state_35181[(19)]);
var inst_35100 = (state_35181[(26)]);
var inst_35117 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_35119 = (function (){var all_files = inst_35094;
var res_SINGLEQUOTE_ = inst_35097;
var res = inst_35098;
var files_not_loaded = inst_35100;
var dependencies_that_loaded = inst_35102;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_35102,inst_35097,inst_35098,inst_35094,inst_35100,inst_35117,state_val_35182,c__31204__auto__,map__35026,map__35026__$1,opts,before_jsload,on_jsload,reload_dependents,map__35027,map__35027__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__35118){
var map__35250 = p__35118;
var map__35250__$1 = ((((!((map__35250 == null)))?((((map__35250.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35250.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35250):map__35250);
var namespace = cljs.core.get.call(null,map__35250__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__35250__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_35102,inst_35097,inst_35098,inst_35094,inst_35100,inst_35117,state_val_35182,c__31204__auto__,map__35026,map__35026__$1,opts,before_jsload,on_jsload,reload_dependents,map__35027,map__35027__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_35120 = cljs.core.map.call(null,inst_35119,inst_35098);
var inst_35121 = cljs.core.pr_str.call(null,inst_35120);
var inst_35122 = figwheel.client.utils.log.call(null,inst_35121);
var inst_35123 = (function (){var all_files = inst_35094;
var res_SINGLEQUOTE_ = inst_35097;
var res = inst_35098;
var files_not_loaded = inst_35100;
var dependencies_that_loaded = inst_35102;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_35102,inst_35097,inst_35098,inst_35094,inst_35100,inst_35117,inst_35119,inst_35120,inst_35121,inst_35122,state_val_35182,c__31204__auto__,map__35026,map__35026__$1,opts,before_jsload,on_jsload,reload_dependents,map__35027,map__35027__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_35102,inst_35097,inst_35098,inst_35094,inst_35100,inst_35117,inst_35119,inst_35120,inst_35121,inst_35122,state_val_35182,c__31204__auto__,map__35026,map__35026__$1,opts,before_jsload,on_jsload,reload_dependents,map__35027,map__35027__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_35124 = setTimeout(inst_35123,(10));
var state_35181__$1 = (function (){var statearr_35252 = state_35181;
(statearr_35252[(33)] = inst_35122);

(statearr_35252[(34)] = inst_35117);

return statearr_35252;
})();
var statearr_35253_35316 = state_35181__$1;
(statearr_35253_35316[(2)] = inst_35124);

(statearr_35253_35316[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (16))){
var state_35181__$1 = state_35181;
var statearr_35254_35317 = state_35181__$1;
(statearr_35254_35317[(2)] = reload_dependents);

(statearr_35254_35317[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (38))){
var inst_35134 = (state_35181[(16)]);
var inst_35152 = cljs.core.apply.call(null,cljs.core.hash_map,inst_35134);
var state_35181__$1 = state_35181;
var statearr_35255_35318 = state_35181__$1;
(statearr_35255_35318[(2)] = inst_35152);

(statearr_35255_35318[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (30))){
var state_35181__$1 = state_35181;
var statearr_35256_35319 = state_35181__$1;
(statearr_35256_35319[(2)] = null);

(statearr_35256_35319[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (10))){
var inst_35054 = (state_35181[(22)]);
var inst_35056 = cljs.core.chunked_seq_QMARK_.call(null,inst_35054);
var state_35181__$1 = state_35181;
if(inst_35056){
var statearr_35257_35320 = state_35181__$1;
(statearr_35257_35320[(1)] = (13));

} else {
var statearr_35258_35321 = state_35181__$1;
(statearr_35258_35321[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (18))){
var inst_35088 = (state_35181[(2)]);
var state_35181__$1 = state_35181;
if(cljs.core.truth_(inst_35088)){
var statearr_35259_35322 = state_35181__$1;
(statearr_35259_35322[(1)] = (19));

} else {
var statearr_35260_35323 = state_35181__$1;
(statearr_35260_35323[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (42))){
var state_35181__$1 = state_35181;
var statearr_35261_35324 = state_35181__$1;
(statearr_35261_35324[(2)] = null);

(statearr_35261_35324[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (37))){
var inst_35147 = (state_35181[(2)]);
var state_35181__$1 = state_35181;
var statearr_35262_35325 = state_35181__$1;
(statearr_35262_35325[(2)] = inst_35147);

(statearr_35262_35325[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (8))){
var inst_35054 = (state_35181[(22)]);
var inst_35041 = (state_35181[(10)]);
var inst_35054__$1 = cljs.core.seq.call(null,inst_35041);
var state_35181__$1 = (function (){var statearr_35263 = state_35181;
(statearr_35263[(22)] = inst_35054__$1);

return statearr_35263;
})();
if(inst_35054__$1){
var statearr_35264_35326 = state_35181__$1;
(statearr_35264_35326[(1)] = (10));

} else {
var statearr_35265_35327 = state_35181__$1;
(statearr_35265_35327[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31204__auto__,map__35026,map__35026__$1,opts,before_jsload,on_jsload,reload_dependents,map__35027,map__35027__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__31116__auto__,c__31204__auto__,map__35026,map__35026__$1,opts,before_jsload,on_jsload,reload_dependents,map__35027,map__35027__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__31117__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__31117__auto____0 = (function (){
var statearr_35266 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35266[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__31117__auto__);

(statearr_35266[(1)] = (1));

return statearr_35266;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__31117__auto____1 = (function (state_35181){
while(true){
var ret_value__31118__auto__ = (function (){try{while(true){
var result__31119__auto__ = switch__31116__auto__.call(null,state_35181);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31119__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31119__auto__;
}
break;
}
}catch (e35267){if((e35267 instanceof Object)){
var ex__31120__auto__ = e35267;
var statearr_35268_35328 = state_35181;
(statearr_35268_35328[(5)] = ex__31120__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35181);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35267;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31118__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35329 = state_35181;
state_35181 = G__35329;
continue;
} else {
return ret_value__31118__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__31117__auto__ = function(state_35181){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__31117__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__31117__auto____1.call(this,state_35181);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__31117__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__31117__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__31117__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__31117__auto__;
})()
;})(switch__31116__auto__,c__31204__auto__,map__35026,map__35026__$1,opts,before_jsload,on_jsload,reload_dependents,map__35027,map__35027__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__31206__auto__ = (function (){var statearr_35269 = f__31205__auto__.call(null);
(statearr_35269[(6)] = c__31204__auto__);

return statearr_35269;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31206__auto__);
});})(c__31204__auto__,map__35026,map__35026__$1,opts,before_jsload,on_jsload,reload_dependents,map__35027,map__35027__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__31204__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),cljs.core.str.cljs$core$IFn$_invoke$arity$1("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__35332,link){
var map__35333 = p__35332;
var map__35333__$1 = ((((!((map__35333 == null)))?((((map__35333.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35333.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35333):map__35333);
var file = cljs.core.get.call(null,map__35333__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = link.href;
if(cljs.core.truth_(temp__4657__auto__)){
var link_href = temp__4657__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4657__auto__,map__35333,map__35333__$1,file){
return (function (p1__35330_SHARP_,p2__35331_SHARP_){
if(cljs.core._EQ_.call(null,p1__35330_SHARP_,p2__35331_SHARP_)){
return p1__35330_SHARP_;
} else {
return false;
}
});})(link_href,temp__4657__auto__,map__35333,map__35333__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4657__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__35336){
var map__35337 = p__35336;
var map__35337__$1 = ((((!((map__35337 == null)))?((((map__35337.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35337.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35337):map__35337);
var match_length = cljs.core.get.call(null,map__35337__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__35337__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__35335_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__35335_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4657__auto__)){
var res = temp__4657__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.add_link_to_doc = (function figwheel$client$file_reloading$add_link_to_doc(var_args){
var G__35340 = arguments.length;
switch (G__35340) {
case 1:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = (function (new_link){
return (document.getElementsByTagName("head")[(0)]).appendChild(new_link);
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = (function (orig_link,klone){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
return parent.removeChild(orig_link);
});})(parent))
,(300));
});

figwheel.client.file_reloading.add_link_to_doc.cljs$lang$maxFixedArity = 2;

figwheel.client.file_reloading.distictify = (function figwheel$client$file_reloading$distictify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__35342_SHARP_,p2__35343_SHARP_){
return cljs.core.assoc.call(null,p1__35342_SHARP_,cljs.core.get.call(null,p2__35343_SHARP_,key),p2__35343_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(p__35344){
var map__35345 = p__35344;
var map__35345__$1 = ((((!((map__35345 == null)))?((((map__35345.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35345.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35345):map__35345);
var f_data = map__35345__$1;
var file = cljs.core.get.call(null,map__35345__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4657__auto__)){
var link = temp__4657__auto__;
return figwheel.client.file_reloading.add_link_to_doc.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href));
} else {
return null;
}
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__35347,p__35348){
var map__35349 = p__35347;
var map__35349__$1 = ((((!((map__35349 == null)))?((((map__35349.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35349.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35349):map__35349);
var opts = map__35349__$1;
var on_cssload = cljs.core.get.call(null,map__35349__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__35350 = p__35348;
var map__35350__$1 = ((((!((map__35350 == null)))?((((map__35350.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35350.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35350):map__35350);
var files_msg = map__35350__$1;
var files = cljs.core.get.call(null,map__35350__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var seq__35353_35357 = cljs.core.seq.call(null,figwheel.client.file_reloading.distictify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
var chunk__35354_35358 = null;
var count__35355_35359 = (0);
var i__35356_35360 = (0);
while(true){
if((i__35356_35360 < count__35355_35359)){
var f_35361 = cljs.core._nth.call(null,chunk__35354_35358,i__35356_35360);
figwheel.client.file_reloading.reload_css_file.call(null,f_35361);

var G__35362 = seq__35353_35357;
var G__35363 = chunk__35354_35358;
var G__35364 = count__35355_35359;
var G__35365 = (i__35356_35360 + (1));
seq__35353_35357 = G__35362;
chunk__35354_35358 = G__35363;
count__35355_35359 = G__35364;
i__35356_35360 = G__35365;
continue;
} else {
var temp__4657__auto___35366 = cljs.core.seq.call(null,seq__35353_35357);
if(temp__4657__auto___35366){
var seq__35353_35367__$1 = temp__4657__auto___35366;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__35353_35367__$1)){
var c__27216__auto___35368 = cljs.core.chunk_first.call(null,seq__35353_35367__$1);
var G__35369 = cljs.core.chunk_rest.call(null,seq__35353_35367__$1);
var G__35370 = c__27216__auto___35368;
var G__35371 = cljs.core.count.call(null,c__27216__auto___35368);
var G__35372 = (0);
seq__35353_35357 = G__35369;
chunk__35354_35358 = G__35370;
count__35355_35359 = G__35371;
i__35356_35360 = G__35372;
continue;
} else {
var f_35373 = cljs.core.first.call(null,seq__35353_35367__$1);
figwheel.client.file_reloading.reload_css_file.call(null,f_35373);

var G__35374 = cljs.core.next.call(null,seq__35353_35367__$1);
var G__35375 = null;
var G__35376 = (0);
var G__35377 = (0);
seq__35353_35357 = G__35374;
chunk__35354_35358 = G__35375;
count__35355_35359 = G__35376;
i__35356_35360 = G__35377;
continue;
}
} else {
}
}
break;
}

return setTimeout(((function (map__35349,map__35349__$1,opts,on_cssload,map__35350,map__35350__$1,files_msg,files){
return (function (){
figwheel.client.file_reloading.on_cssload_custom_event.call(null,files);

return on_cssload.call(null,files);
});})(map__35349,map__35349__$1,opts,on_cssload,map__35350,map__35350__$1,files_msg,files))
,(100));
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1499963085055