// Compiled by ClojureScript 1.9.671 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('sablono.normalize');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
goog.require('cljsjs.react');
goog.require('cljsjs.react.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__33690__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__33687 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var seq__33688 = cljs.core.seq.call(null,vec__33687);
var first__33689 = cljs.core.first.call(null,seq__33688);
var seq__33688__$1 = cljs.core.next.call(null,seq__33688);
var tag = first__33689;
var body = seq__33688__$1;
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__33690 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__33691__i = 0, G__33691__a = new Array(arguments.length -  0);
while (G__33691__i < G__33691__a.length) {G__33691__a[G__33691__i] = arguments[G__33691__i + 0]; ++G__33691__i;}
  args = new cljs.core.IndexedSeq(G__33691__a,0,null);
} 
return G__33690__delegate.call(this,args);};
G__33690.cljs$lang$maxFixedArity = 0;
G__33690.cljs$lang$applyTo = (function (arglist__33692){
var args = cljs.core.seq(arglist__33692);
return G__33690__delegate(args);
});
G__33690.cljs$core$IFn$_invoke$arity$variadic = G__33690__delegate;
return G__33690;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__27185__auto__ = (function sablono$core$update_arglists_$_iter__33693(s__33694){
return (new cljs.core.LazySeq(null,(function (){
var s__33694__$1 = s__33694;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__33694__$1);
if(temp__4657__auto__){
var s__33694__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__33694__$2)){
var c__27183__auto__ = cljs.core.chunk_first.call(null,s__33694__$2);
var size__27184__auto__ = cljs.core.count.call(null,c__27183__auto__);
var b__33696 = cljs.core.chunk_buffer.call(null,size__27184__auto__);
if((function (){var i__33695 = (0);
while(true){
if((i__33695 < size__27184__auto__)){
var args = cljs.core._nth.call(null,c__27183__auto__,i__33695);
cljs.core.chunk_append.call(null,b__33696,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__33697 = (i__33695 + (1));
i__33695 = G__33697;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33696),sablono$core$update_arglists_$_iter__33693.call(null,cljs.core.chunk_rest.call(null,s__33694__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33696),null);
}
} else {
var args = cljs.core.first.call(null,s__33694__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__33693.call(null,cljs.core.rest.call(null,s__33694__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__27185__auto__.call(null,arglists);
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__27528__auto__ = [];
var len__27521__auto___33703 = arguments.length;
var i__27522__auto___33704 = (0);
while(true){
if((i__27522__auto___33704 < len__27521__auto___33703)){
args__27528__auto__.push((arguments[i__27522__auto___33704]));

var G__33705 = (i__27522__auto___33704 + (1));
i__27522__auto___33704 = G__33705;
continue;
} else {
}
break;
}

var argseq__27529__auto__ = ((((0) < args__27528__auto__.length))?(new cljs.core.IndexedSeq(args__27528__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__27529__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__27185__auto__ = (function sablono$core$iter__33699(s__33700){
return (new cljs.core.LazySeq(null,(function (){
var s__33700__$1 = s__33700;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__33700__$1);
if(temp__4657__auto__){
var s__33700__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__33700__$2)){
var c__27183__auto__ = cljs.core.chunk_first.call(null,s__33700__$2);
var size__27184__auto__ = cljs.core.count.call(null,c__27183__auto__);
var b__33702 = cljs.core.chunk_buffer.call(null,size__27184__auto__);
if((function (){var i__33701 = (0);
while(true){
if((i__33701 < size__27184__auto__)){
var style = cljs.core._nth.call(null,c__27183__auto__,i__33701);
cljs.core.chunk_append.call(null,b__33702,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__33706 = (i__33701 + (1));
i__33701 = G__33706;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33702),sablono$core$iter__33699.call(null,cljs.core.chunk_rest.call(null,s__33700__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33702),null);
}
} else {
var style = cljs.core.first.call(null,s__33700__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__33699.call(null,cljs.core.rest.call(null,s__33700__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__27185__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq33698){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq33698));
});

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",({"src": src})));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to33707 = (function sablono$core$link_to33707(var_args){
var args__27528__auto__ = [];
var len__27521__auto___33710 = arguments.length;
var i__27522__auto___33711 = (0);
while(true){
if((i__27522__auto___33711 < len__27521__auto___33710)){
args__27528__auto__.push((arguments[i__27522__auto___33711]));

var G__33712 = (i__27522__auto___33711 + (1));
i__27522__auto___33711 = G__33712;
continue;
} else {
}
break;
}

var argseq__27529__auto__ = ((((1) < args__27528__auto__.length))?(new cljs.core.IndexedSeq(args__27528__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to33707.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__27529__auto__);
});

sablono.core.link_to33707.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to33707.cljs$lang$maxFixedArity = (1);

sablono.core.link_to33707.cljs$lang$applyTo = (function (seq33708){
var G__33709 = cljs.core.first.call(null,seq33708);
var seq33708__$1 = cljs.core.next.call(null,seq33708);
return sablono.core.link_to33707.cljs$core$IFn$_invoke$arity$variadic(G__33709,seq33708__$1);
});


sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to33707);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to33713 = (function sablono$core$mail_to33713(var_args){
var args__27528__auto__ = [];
var len__27521__auto___33720 = arguments.length;
var i__27522__auto___33721 = (0);
while(true){
if((i__27522__auto___33721 < len__27521__auto___33720)){
args__27528__auto__.push((arguments[i__27522__auto___33721]));

var G__33722 = (i__27522__auto___33721 + (1));
i__27522__auto___33721 = G__33722;
continue;
} else {
}
break;
}

var argseq__27529__auto__ = ((((1) < args__27528__auto__.length))?(new cljs.core.IndexedSeq(args__27528__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to33713.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__27529__auto__);
});

sablono.core.mail_to33713.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__33716){
var vec__33717 = p__33716;
var content = cljs.core.nth.call(null,vec__33717,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("mailto:"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_mail)].join('')], null),(function (){var or__26396__auto__ = content;
if(cljs.core.truth_(or__26396__auto__)){
return or__26396__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to33713.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to33713.cljs$lang$applyTo = (function (seq33714){
var G__33715 = cljs.core.first.call(null,seq33714);
var seq33714__$1 = cljs.core.next.call(null,seq33714);
return sablono.core.mail_to33713.cljs$core$IFn$_invoke$arity$variadic(G__33715,seq33714__$1);
});


sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to33713);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list33723 = (function sablono$core$unordered_list33723(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__27185__auto__ = (function sablono$core$unordered_list33723_$_iter__33724(s__33725){
return (new cljs.core.LazySeq(null,(function (){
var s__33725__$1 = s__33725;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__33725__$1);
if(temp__4657__auto__){
var s__33725__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__33725__$2)){
var c__27183__auto__ = cljs.core.chunk_first.call(null,s__33725__$2);
var size__27184__auto__ = cljs.core.count.call(null,c__27183__auto__);
var b__33727 = cljs.core.chunk_buffer.call(null,size__27184__auto__);
if((function (){var i__33726 = (0);
while(true){
if((i__33726 < size__27184__auto__)){
var x = cljs.core._nth.call(null,c__27183__auto__,i__33726);
cljs.core.chunk_append.call(null,b__33727,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__33728 = (i__33726 + (1));
i__33726 = G__33728;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33727),sablono$core$unordered_list33723_$_iter__33724.call(null,cljs.core.chunk_rest.call(null,s__33725__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33727),null);
}
} else {
var x = cljs.core.first.call(null,s__33725__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list33723_$_iter__33724.call(null,cljs.core.rest.call(null,s__33725__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__27185__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list33723);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list33729 = (function sablono$core$ordered_list33729(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__27185__auto__ = (function sablono$core$ordered_list33729_$_iter__33730(s__33731){
return (new cljs.core.LazySeq(null,(function (){
var s__33731__$1 = s__33731;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__33731__$1);
if(temp__4657__auto__){
var s__33731__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__33731__$2)){
var c__27183__auto__ = cljs.core.chunk_first.call(null,s__33731__$2);
var size__27184__auto__ = cljs.core.count.call(null,c__27183__auto__);
var b__33733 = cljs.core.chunk_buffer.call(null,size__27184__auto__);
if((function (){var i__33732 = (0);
while(true){
if((i__33732 < size__27184__auto__)){
var x = cljs.core._nth.call(null,c__27183__auto__,i__33732);
cljs.core.chunk_append.call(null,b__33733,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__33734 = (i__33732 + (1));
i__33732 = G__33734;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33733),sablono$core$ordered_list33729_$_iter__33730.call(null,cljs.core.chunk_rest.call(null,s__33731__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33733),null);
}
} else {
var x = cljs.core.first.call(null,s__33731__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list33729_$_iter__33730.call(null,cljs.core.rest.call(null,s__33731__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__27185__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list33729);
/**
 * Create an image element.
 */
sablono.core.image33735 = (function sablono$core$image33735(var_args){
var G__33737 = arguments.length;
switch (G__33737) {
case 1:
return sablono.core.image33735.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image33735.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.image33735.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image33735.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image33735.cljs$lang$maxFixedArity = 2;


sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image33735);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__33739_SHARP_,p2__33740_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__33739_SHARP_),cljs.core.str.cljs$core$IFn$_invoke$arity$1("["),cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__33740_SHARP_),cljs.core.str.cljs$core$IFn$_invoke$arity$1("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__33741_SHARP_,p2__33742_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__33741_SHARP_),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__33742_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__26396__auto__ = value;
if(cljs.core.truth_(or__26396__auto__)){
return or__26396__auto__;
} else {
return undefined;
}
})()], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field33743 = (function sablono$core$color_field33743(var_args){
var G__33745 = arguments.length;
switch (G__33745) {
case 1:
return sablono.core.color_field33743.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field33743.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.color_field33743.cljs$core$IFn$_invoke$arity$1 = (function (name__33677__auto__){
return sablono.core.color_field33743.call(null,name__33677__auto__,null);
});

sablono.core.color_field33743.cljs$core$IFn$_invoke$arity$2 = (function (name__33677__auto__,value__33678__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__33677__auto__,value__33678__auto__);
});

sablono.core.color_field33743.cljs$lang$maxFixedArity = 2;


sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field33743);

/**
 * Creates a date input field.
 */
sablono.core.date_field33746 = (function sablono$core$date_field33746(var_args){
var G__33748 = arguments.length;
switch (G__33748) {
case 1:
return sablono.core.date_field33746.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field33746.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.date_field33746.cljs$core$IFn$_invoke$arity$1 = (function (name__33677__auto__){
return sablono.core.date_field33746.call(null,name__33677__auto__,null);
});

sablono.core.date_field33746.cljs$core$IFn$_invoke$arity$2 = (function (name__33677__auto__,value__33678__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__33677__auto__,value__33678__auto__);
});

sablono.core.date_field33746.cljs$lang$maxFixedArity = 2;


sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field33746);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field33749 = (function sablono$core$datetime_field33749(var_args){
var G__33751 = arguments.length;
switch (G__33751) {
case 1:
return sablono.core.datetime_field33749.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field33749.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.datetime_field33749.cljs$core$IFn$_invoke$arity$1 = (function (name__33677__auto__){
return sablono.core.datetime_field33749.call(null,name__33677__auto__,null);
});

sablono.core.datetime_field33749.cljs$core$IFn$_invoke$arity$2 = (function (name__33677__auto__,value__33678__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__33677__auto__,value__33678__auto__);
});

sablono.core.datetime_field33749.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field33749);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field33752 = (function sablono$core$datetime_local_field33752(var_args){
var G__33754 = arguments.length;
switch (G__33754) {
case 1:
return sablono.core.datetime_local_field33752.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field33752.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.datetime_local_field33752.cljs$core$IFn$_invoke$arity$1 = (function (name__33677__auto__){
return sablono.core.datetime_local_field33752.call(null,name__33677__auto__,null);
});

sablono.core.datetime_local_field33752.cljs$core$IFn$_invoke$arity$2 = (function (name__33677__auto__,value__33678__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__33677__auto__,value__33678__auto__);
});

sablono.core.datetime_local_field33752.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field33752);

/**
 * Creates a email input field.
 */
sablono.core.email_field33755 = (function sablono$core$email_field33755(var_args){
var G__33757 = arguments.length;
switch (G__33757) {
case 1:
return sablono.core.email_field33755.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field33755.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.email_field33755.cljs$core$IFn$_invoke$arity$1 = (function (name__33677__auto__){
return sablono.core.email_field33755.call(null,name__33677__auto__,null);
});

sablono.core.email_field33755.cljs$core$IFn$_invoke$arity$2 = (function (name__33677__auto__,value__33678__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__33677__auto__,value__33678__auto__);
});

sablono.core.email_field33755.cljs$lang$maxFixedArity = 2;


sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field33755);

/**
 * Creates a file input field.
 */
sablono.core.file_field33758 = (function sablono$core$file_field33758(var_args){
var G__33760 = arguments.length;
switch (G__33760) {
case 1:
return sablono.core.file_field33758.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field33758.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.file_field33758.cljs$core$IFn$_invoke$arity$1 = (function (name__33677__auto__){
return sablono.core.file_field33758.call(null,name__33677__auto__,null);
});

sablono.core.file_field33758.cljs$core$IFn$_invoke$arity$2 = (function (name__33677__auto__,value__33678__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__33677__auto__,value__33678__auto__);
});

sablono.core.file_field33758.cljs$lang$maxFixedArity = 2;


sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field33758);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field33761 = (function sablono$core$hidden_field33761(var_args){
var G__33763 = arguments.length;
switch (G__33763) {
case 1:
return sablono.core.hidden_field33761.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field33761.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.hidden_field33761.cljs$core$IFn$_invoke$arity$1 = (function (name__33677__auto__){
return sablono.core.hidden_field33761.call(null,name__33677__auto__,null);
});

sablono.core.hidden_field33761.cljs$core$IFn$_invoke$arity$2 = (function (name__33677__auto__,value__33678__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__33677__auto__,value__33678__auto__);
});

sablono.core.hidden_field33761.cljs$lang$maxFixedArity = 2;


sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field33761);

/**
 * Creates a month input field.
 */
sablono.core.month_field33764 = (function sablono$core$month_field33764(var_args){
var G__33766 = arguments.length;
switch (G__33766) {
case 1:
return sablono.core.month_field33764.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field33764.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.month_field33764.cljs$core$IFn$_invoke$arity$1 = (function (name__33677__auto__){
return sablono.core.month_field33764.call(null,name__33677__auto__,null);
});

sablono.core.month_field33764.cljs$core$IFn$_invoke$arity$2 = (function (name__33677__auto__,value__33678__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__33677__auto__,value__33678__auto__);
});

sablono.core.month_field33764.cljs$lang$maxFixedArity = 2;


sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field33764);

/**
 * Creates a number input field.
 */
sablono.core.number_field33767 = (function sablono$core$number_field33767(var_args){
var G__33769 = arguments.length;
switch (G__33769) {
case 1:
return sablono.core.number_field33767.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field33767.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.number_field33767.cljs$core$IFn$_invoke$arity$1 = (function (name__33677__auto__){
return sablono.core.number_field33767.call(null,name__33677__auto__,null);
});

sablono.core.number_field33767.cljs$core$IFn$_invoke$arity$2 = (function (name__33677__auto__,value__33678__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__33677__auto__,value__33678__auto__);
});

sablono.core.number_field33767.cljs$lang$maxFixedArity = 2;


sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field33767);

/**
 * Creates a password input field.
 */
sablono.core.password_field33770 = (function sablono$core$password_field33770(var_args){
var G__33772 = arguments.length;
switch (G__33772) {
case 1:
return sablono.core.password_field33770.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field33770.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.password_field33770.cljs$core$IFn$_invoke$arity$1 = (function (name__33677__auto__){
return sablono.core.password_field33770.call(null,name__33677__auto__,null);
});

sablono.core.password_field33770.cljs$core$IFn$_invoke$arity$2 = (function (name__33677__auto__,value__33678__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__33677__auto__,value__33678__auto__);
});

sablono.core.password_field33770.cljs$lang$maxFixedArity = 2;


sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field33770);

/**
 * Creates a range input field.
 */
sablono.core.range_field33773 = (function sablono$core$range_field33773(var_args){
var G__33775 = arguments.length;
switch (G__33775) {
case 1:
return sablono.core.range_field33773.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field33773.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.range_field33773.cljs$core$IFn$_invoke$arity$1 = (function (name__33677__auto__){
return sablono.core.range_field33773.call(null,name__33677__auto__,null);
});

sablono.core.range_field33773.cljs$core$IFn$_invoke$arity$2 = (function (name__33677__auto__,value__33678__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__33677__auto__,value__33678__auto__);
});

sablono.core.range_field33773.cljs$lang$maxFixedArity = 2;


sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field33773);

/**
 * Creates a search input field.
 */
sablono.core.search_field33776 = (function sablono$core$search_field33776(var_args){
var G__33778 = arguments.length;
switch (G__33778) {
case 1:
return sablono.core.search_field33776.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field33776.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.search_field33776.cljs$core$IFn$_invoke$arity$1 = (function (name__33677__auto__){
return sablono.core.search_field33776.call(null,name__33677__auto__,null);
});

sablono.core.search_field33776.cljs$core$IFn$_invoke$arity$2 = (function (name__33677__auto__,value__33678__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__33677__auto__,value__33678__auto__);
});

sablono.core.search_field33776.cljs$lang$maxFixedArity = 2;


sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field33776);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field33779 = (function sablono$core$tel_field33779(var_args){
var G__33781 = arguments.length;
switch (G__33781) {
case 1:
return sablono.core.tel_field33779.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field33779.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.tel_field33779.cljs$core$IFn$_invoke$arity$1 = (function (name__33677__auto__){
return sablono.core.tel_field33779.call(null,name__33677__auto__,null);
});

sablono.core.tel_field33779.cljs$core$IFn$_invoke$arity$2 = (function (name__33677__auto__,value__33678__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__33677__auto__,value__33678__auto__);
});

sablono.core.tel_field33779.cljs$lang$maxFixedArity = 2;


sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field33779);

/**
 * Creates a text input field.
 */
sablono.core.text_field33782 = (function sablono$core$text_field33782(var_args){
var G__33784 = arguments.length;
switch (G__33784) {
case 1:
return sablono.core.text_field33782.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field33782.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.text_field33782.cljs$core$IFn$_invoke$arity$1 = (function (name__33677__auto__){
return sablono.core.text_field33782.call(null,name__33677__auto__,null);
});

sablono.core.text_field33782.cljs$core$IFn$_invoke$arity$2 = (function (name__33677__auto__,value__33678__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__33677__auto__,value__33678__auto__);
});

sablono.core.text_field33782.cljs$lang$maxFixedArity = 2;


sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field33782);

/**
 * Creates a time input field.
 */
sablono.core.time_field33785 = (function sablono$core$time_field33785(var_args){
var G__33787 = arguments.length;
switch (G__33787) {
case 1:
return sablono.core.time_field33785.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field33785.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.time_field33785.cljs$core$IFn$_invoke$arity$1 = (function (name__33677__auto__){
return sablono.core.time_field33785.call(null,name__33677__auto__,null);
});

sablono.core.time_field33785.cljs$core$IFn$_invoke$arity$2 = (function (name__33677__auto__,value__33678__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__33677__auto__,value__33678__auto__);
});

sablono.core.time_field33785.cljs$lang$maxFixedArity = 2;


sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field33785);

/**
 * Creates a url input field.
 */
sablono.core.url_field33788 = (function sablono$core$url_field33788(var_args){
var G__33790 = arguments.length;
switch (G__33790) {
case 1:
return sablono.core.url_field33788.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field33788.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.url_field33788.cljs$core$IFn$_invoke$arity$1 = (function (name__33677__auto__){
return sablono.core.url_field33788.call(null,name__33677__auto__,null);
});

sablono.core.url_field33788.cljs$core$IFn$_invoke$arity$2 = (function (name__33677__auto__,value__33678__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__33677__auto__,value__33678__auto__);
});

sablono.core.url_field33788.cljs$lang$maxFixedArity = 2;


sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field33788);

/**
 * Creates a week input field.
 */
sablono.core.week_field33791 = (function sablono$core$week_field33791(var_args){
var G__33793 = arguments.length;
switch (G__33793) {
case 1:
return sablono.core.week_field33791.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field33791.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.week_field33791.cljs$core$IFn$_invoke$arity$1 = (function (name__33677__auto__){
return sablono.core.week_field33791.call(null,name__33677__auto__,null);
});

sablono.core.week_field33791.cljs$core$IFn$_invoke$arity$2 = (function (name__33677__auto__,value__33678__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__33677__auto__,value__33678__auto__);
});

sablono.core.week_field33791.cljs$lang$maxFixedArity = 2;


sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field33791);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box33811 = (function sablono$core$check_box33811(var_args){
var G__33813 = arguments.length;
switch (G__33813) {
case 1:
return sablono.core.check_box33811.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box33811.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box33811.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.check_box33811.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box33811.call(null,name,null);
});

sablono.core.check_box33811.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box33811.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box33811.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__26396__auto__ = value;
if(cljs.core.truth_(or__26396__auto__)){
return or__26396__auto__;
} else {
return undefined;
}
})(),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box33811.cljs$lang$maxFixedArity = 3;


sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box33811);
/**
 * Creates a radio button.
 */
sablono.core.radio_button33815 = (function sablono$core$radio_button33815(var_args){
var G__33817 = arguments.length;
switch (G__33817) {
case 1:
return sablono.core.radio_button33815.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button33815.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button33815.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.radio_button33815.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button33815.call(null,group,null);
});

sablono.core.radio_button33815.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button33815.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button33815.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(sablono.util.as_str.call(null,group)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__26396__auto__ = value;
if(cljs.core.truth_(or__26396__auto__)){
return or__26396__auto__;
} else {
return undefined;
}
})(),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button33815.cljs$lang$maxFixedArity = 3;


sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button33815);
sablono.core.hash_key = (function sablono$core$hash_key(x){
return goog.string.hashCode(cljs.core.pr_str.call(null,x));
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options33819 = (function sablono$core$select_options33819(coll){
var iter__27185__auto__ = (function sablono$core$select_options33819_$_iter__33820(s__33821){
return (new cljs.core.LazySeq(null,(function (){
var s__33821__$1 = s__33821;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__33821__$1);
if(temp__4657__auto__){
var s__33821__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__33821__$2)){
var c__27183__auto__ = cljs.core.chunk_first.call(null,s__33821__$2);
var size__27184__auto__ = cljs.core.count.call(null,c__27183__auto__);
var b__33823 = cljs.core.chunk_buffer.call(null,size__27184__auto__);
if((function (){var i__33822 = (0);
while(true){
if((i__33822 < size__27184__auto__)){
var x = cljs.core._nth.call(null,c__27183__auto__,i__33822);
cljs.core.chunk_append.call(null,b__33823,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__33824 = x;
var text = cljs.core.nth.call(null,vec__33824,(0),null);
var val = cljs.core.nth.call(null,vec__33824,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__33824,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options33819.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__33830 = (i__33822 + (1));
i__33822 = G__33830;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33823),sablono$core$select_options33819_$_iter__33820.call(null,cljs.core.chunk_rest.call(null,s__33821__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__33823),null);
}
} else {
var x = cljs.core.first.call(null,s__33821__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__33827 = x;
var text = cljs.core.nth.call(null,vec__33827,(0),null);
var val = cljs.core.nth.call(null,vec__33827,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__33827,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options33819.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options33819_$_iter__33820.call(null,cljs.core.rest.call(null,s__33821__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__27185__auto__.call(null,coll);
});

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options33819);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down33831 = (function sablono$core$drop_down33831(var_args){
var G__33833 = arguments.length;
switch (G__33833) {
case 2:
return sablono.core.drop_down33831.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down33831.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.drop_down33831.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down33831.call(null,name,options,null);
});

sablono.core.drop_down33831.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down33831.cljs$lang$maxFixedArity = 3;


sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down33831);
/**
 * Creates a text area element.
 */
sablono.core.text_area33835 = (function sablono$core$text_area33835(var_args){
var G__33837 = arguments.length;
switch (G__33837) {
case 1:
return sablono.core.text_area33835.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area33835.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.text_area33835.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area33835.call(null,name,null);
});

sablono.core.text_area33835.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__26396__auto__ = value;
if(cljs.core.truth_(or__26396__auto__)){
return or__26396__auto__;
} else {
return undefined;
}
})()], null)], null);
});

sablono.core.text_area33835.cljs$lang$maxFixedArity = 2;


sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area33835);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label33839 = (function sablono$core$label33839(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label33839);
/**
 * Creates a submit button.
 */
sablono.core.submit_button33840 = (function sablono$core$submit_button33840(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button33840);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button33841 = (function sablono$core$reset_button33841(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button33841);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to33842 = (function sablono$core$form_to33842(var_args){
var args__27528__auto__ = [];
var len__27521__auto___33849 = arguments.length;
var i__27522__auto___33850 = (0);
while(true){
if((i__27522__auto___33850 < len__27521__auto___33849)){
args__27528__auto__.push((arguments[i__27522__auto___33850]));

var G__33851 = (i__27522__auto___33850 + (1));
i__27522__auto___33850 = G__33851;
continue;
} else {
}
break;
}

var argseq__27529__auto__ = ((((1) < args__27528__auto__.length))?(new cljs.core.IndexedSeq(args__27528__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to33842.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__27529__auto__);
});

sablono.core.form_to33842.cljs$core$IFn$_invoke$arity$variadic = (function (p__33845,body){
var vec__33846 = p__33845;
var method = cljs.core.nth.call(null,vec__33846,(0),null);
var action = cljs.core.nth.call(null,vec__33846,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null),"_method",method_str)], null)),body));
});

sablono.core.form_to33842.cljs$lang$maxFixedArity = (1);

sablono.core.form_to33842.cljs$lang$applyTo = (function (seq33843){
var G__33844 = cljs.core.first.call(null,seq33843);
var seq33843__$1 = cljs.core.next.call(null,seq33843);
return sablono.core.form_to33842.cljs$core$IFn$_invoke$arity$variadic(G__33844,seq33843__$1);
});


sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to33842);

//# sourceMappingURL=core.js.map?rel=1499963083411