// Compiled by ClojureScript 1.9.671 {}
goog.provide('chord.client');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('chord.channels');
goog.require('chord.format');
chord.client.close_event__GT_maybe_error = (function chord$client$close_event__GT_maybe_error(ev){
if(cljs.core.truth_(ev.wasClean)){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reason","reason",-2070751759),ev.reason,new cljs.core.Keyword(null,"code","code",1586293142),ev.code], null);
}
});
chord.client.create_ws = (function chord$client$create_ws(url,opts){
if(cljs.core.truth_((function (){var and__7439__auto__ = typeof require !== 'undefined';
if(and__7439__auto__){
try{return require("ws");
}catch (e13218){var e = e13218;
return false;
}} else {
return and__7439__auto__;
}
})())){
var ws = require("ws");
if(cljs.core.truth_(opts)){
return (new ws(url,cljs.core.clj__GT_js.call(null,opts)));
} else {
return (new ws(url));
}
} else {
return (new WebSocket(url));

}
});
/**
 * Creates websockets connection and returns a 2-sided channel when the websocket is opened.
 * Arguments:
 *  ws-url           - (required) link to websocket service
 *  opts             - (optional) map to configure reading/writing channels
 *    :read-ch       - (optional) (possibly buffered) channel to use for reading the websocket
 *    :write-ch      - (optional) (possibly buffered) channel to use for writing to the websocket
 *    :format        - (optional) data format to use on the channel, (at the moment)
 *                                either :edn (default), :json, :json-kw or :str.
 *    :ws-opts       - (optional) Other options to be passed to the websocket constructor (NodeJS only)
 *                                see https://github.com/websockets/ws/blob/master/doc/ws.md#new-websocketaddress-protocols-options
 * 
 * Usage:
 *  (:require [cljs.core.async :as a])
 * 
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437"))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))}))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))
 *                                        :write-ch (a/chan (a/dropping-buffer 10))}))
 */
chord.client.ws_ch = (function chord$client$ws_ch(var_args){
var args__8583__auto__ = [];
var len__8576__auto___13330 = arguments.length;
var i__8577__auto___13331 = (0);
while(true){
if((i__8577__auto___13331 < len__8576__auto___13330)){
args__8583__auto__.push((arguments[i__8577__auto___13331]));

var G__13332 = (i__8577__auto___13331 + (1));
i__8577__auto___13331 = G__13332;
continue;
} else {
}
break;
}

var argseq__8584__auto__ = ((((1) < args__8583__auto__.length))?(new cljs.core.IndexedSeq(args__8583__auto__.slice((1)),(0),null)):null);
return chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8584__auto__);
});

chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic = (function (ws_url,p__13223){
var vec__13224 = p__13223;
var map__13227 = cljs.core.nth.call(null,vec__13224,(0),null);
var map__13227__$1 = ((((!((map__13227 == null)))?((((map__13227.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13227.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13227):map__13227);
var opts = map__13227__$1;
var read_ch = cljs.core.get.call(null,map__13227__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch = cljs.core.get.call(null,map__13227__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var format = cljs.core.get.call(null,map__13227__$1,new cljs.core.Keyword(null,"format","format",-1306924766));
var ws_opts = cljs.core.get.call(null,map__13227__$1,new cljs.core.Keyword(null,"ws-opts","ws-opts",1487801643));
var web_socket = chord.client.create_ws.call(null,ws_url,ws_opts);
var map__13229 = chord.format.wrap_format.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"read-ch","read-ch",-38486414),(function (){var or__7451__auto__ = read_ch;
if(cljs.core.truth_(or__7451__auto__)){
return or__7451__auto__;
} else {
return cljs.core.async.chan.call(null);
}
})(),new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599),(function (){var or__7451__auto__ = write_ch;
if(cljs.core.truth_(or__7451__auto__)){
return or__7451__auto__;
} else {
return cljs.core.async.chan.call(null);
}
})()], null),opts);
var map__13229__$1 = ((((!((map__13229 == null)))?((((map__13229.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13229.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13229):map__13229);
var read_ch__$1 = cljs.core.get.call(null,map__13229__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch__$1 = cljs.core.get.call(null,map__13229__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var open_ch = cljs.core.async.chan.call(null);
var close_ch = cljs.core.async.chan.call(null);
web_socket.binaryType = "arraybuffer";

chord.channels.read_from_ws_BANG_.call(null,web_socket,read_ch__$1);

chord.channels.write_to_ws_BANG_.call(null,web_socket,write_ch__$1);

web_socket.onopen = ((function (web_socket,map__13229,map__13229__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__13224,map__13227,map__13227__$1,opts,read_ch,write_ch,format,ws_opts){
return (function (p1__13219_SHARP_){
return cljs.core.async.put_BANG_.call(null,open_ch,p1__13219_SHARP_);
});})(web_socket,map__13229,map__13229__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__13224,map__13227,map__13227__$1,opts,read_ch,write_ch,format,ws_opts))
;

web_socket.onclose = ((function (web_socket,map__13229,map__13229__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__13224,map__13227,map__13227__$1,opts,read_ch,write_ch,format,ws_opts){
return (function (p1__13220_SHARP_){
return cljs.core.async.put_BANG_.call(null,close_ch,p1__13220_SHARP_);
});})(web_socket,map__13229,map__13229__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__13224,map__13227,map__13227__$1,opts,read_ch,write_ch,format,ws_opts))
;

var ws_chan = chord.channels.bidi_ch.call(null,read_ch__$1,write_ch__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-close","on-close",-761178394),((function (web_socket,map__13229,map__13229__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__13224,map__13227,map__13227__$1,opts,read_ch,write_ch,format,ws_opts){
return (function (){
return web_socket.close();
});})(web_socket,map__13229,map__13229__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__13224,map__13227,map__13227__$1,opts,read_ch,write_ch,format,ws_opts))
], null));
var initial_ch = cljs.core.async.chan.call(null);
var c__9890__auto___13333 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9890__auto___13333,ws_chan,initial_ch,web_socket,map__13229,map__13229__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__13224,map__13227,map__13227__$1,opts,read_ch,write_ch,format,ws_opts){
return (function (){
var f__9891__auto__ = (function (){var switch__9875__auto__ = ((function (c__9890__auto___13333,ws_chan,initial_ch,web_socket,map__13229,map__13229__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__13224,map__13227,map__13227__$1,opts,read_ch,write_ch,format,ws_opts){
return (function (state_13296){
var state_val_13297 = (state_13296[(1)]);
if((state_val_13297 === (7))){
var inst_13292 = (state_13296[(2)]);
var state_13296__$1 = state_13296;
var statearr_13298_13334 = state_13296__$1;
(statearr_13298_13334[(2)] = inst_13292);

(statearr_13298_13334[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13297 === (20))){
var state_13296__$1 = state_13296;
var statearr_13299_13335 = state_13296__$1;
(statearr_13299_13335[(2)] = null);

(statearr_13299_13335[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13297 === (1))){
var inst_13231 = false;
var state_13296__$1 = (function (){var statearr_13300 = state_13296;
(statearr_13300[(7)] = inst_13231);

return statearr_13300;
})();
var statearr_13301_13336 = state_13296__$1;
(statearr_13301_13336[(2)] = null);

(statearr_13301_13336[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13297 === (4))){
var inst_13246 = (state_13296[(8)]);
var inst_13244 = (state_13296[(9)]);
var inst_13244__$1 = (state_13296[(2)]);
var inst_13245 = cljs.core.nth.call(null,inst_13244__$1,(0),null);
var inst_13246__$1 = cljs.core.nth.call(null,inst_13244__$1,(1),null);
var inst_13247 = cljs.core._EQ_.call(null,inst_13246__$1,open_ch);
var state_13296__$1 = (function (){var statearr_13302 = state_13296;
(statearr_13302[(8)] = inst_13246__$1);

(statearr_13302[(9)] = inst_13244__$1);

(statearr_13302[(10)] = inst_13245);

return statearr_13302;
})();
if(inst_13247){
var statearr_13303_13337 = state_13296__$1;
(statearr_13303_13337[(1)] = (5));

} else {
var statearr_13304_13338 = state_13296__$1;
(statearr_13304_13338[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13297 === (15))){
var inst_13277 = (state_13296[(2)]);
var state_13296__$1 = state_13296;
var statearr_13305_13339 = state_13296__$1;
(statearr_13305_13339[(2)] = inst_13277);

(statearr_13305_13339[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13297 === (21))){
var inst_13288 = (state_13296[(2)]);
var state_13296__$1 = state_13296;
var statearr_13306_13340 = state_13296__$1;
(statearr_13306_13340[(2)] = inst_13288);

(statearr_13306_13340[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13297 === (13))){
var state_13296__$1 = state_13296;
var statearr_13307_13341 = state_13296__$1;
(statearr_13307_13341[(2)] = null);

(statearr_13307_13341[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13297 === (6))){
var inst_13246 = (state_13296[(8)]);
var inst_13261 = cljs.core._EQ_.call(null,inst_13246,close_ch);
var state_13296__$1 = state_13296;
if(inst_13261){
var statearr_13308_13342 = state_13296__$1;
(statearr_13308_13342[(1)] = (9));

} else {
var statearr_13309_13343 = state_13296__$1;
(statearr_13309_13343[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13297 === (17))){
var state_13296__$1 = state_13296;
var statearr_13310_13344 = state_13296__$1;
(statearr_13310_13344[(2)] = initial_ch);

(statearr_13310_13344[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13297 === (3))){
var inst_13294 = (state_13296[(2)]);
var state_13296__$1 = state_13296;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13296__$1,inst_13294);
} else {
if((state_val_13297 === (12))){
var inst_13231 = (state_13296[(7)]);
var state_13296__$1 = state_13296;
if(cljs.core.truth_(inst_13231)){
var statearr_13311_13345 = state_13296__$1;
(statearr_13311_13345[(1)] = (16));

} else {
var statearr_13312_13346 = state_13296__$1;
(statearr_13312_13346[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13297 === (2))){
var inst_13240 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13241 = [open_ch,close_ch];
var inst_13242 = (new cljs.core.PersistentVector(null,2,(5),inst_13240,inst_13241,null));
var state_13296__$1 = state_13296;
return cljs.core.async.ioc_alts_BANG_.call(null,state_13296__$1,(4),inst_13242);
} else {
if((state_val_13297 === (19))){
var inst_13245 = (state_13296[(10)]);
var state_13296__$1 = state_13296;
var statearr_13313_13347 = state_13296__$1;
(statearr_13313_13347[(2)] = inst_13245);

(statearr_13313_13347[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13297 === (11))){
var inst_13290 = (state_13296[(2)]);
var state_13296__$1 = state_13296;
var statearr_13314_13348 = state_13296__$1;
(statearr_13314_13348[(2)] = inst_13290);

(statearr_13314_13348[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13297 === (9))){
var inst_13267 = (state_13296[(11)]);
var inst_13244 = (state_13296[(9)]);
var inst_13266 = cljs.core.nth.call(null,inst_13244,(0),null);
var inst_13267__$1 = chord.client.close_event__GT_maybe_error.call(null,inst_13266);
var state_13296__$1 = (function (){var statearr_13315 = state_13296;
(statearr_13315[(11)] = inst_13267__$1);

return statearr_13315;
})();
if(cljs.core.truth_(inst_13267__$1)){
var statearr_13316_13349 = state_13296__$1;
(statearr_13316_13349[(1)] = (12));

} else {
var statearr_13317_13350 = state_13296__$1;
(statearr_13317_13350[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13297 === (5))){
var inst_13244 = (state_13296[(9)]);
var inst_13252 = cljs.core.nth.call(null,inst_13244,(0),null);
var inst_13253 = [new cljs.core.Keyword(null,"ws-channel","ws-channel",1643892174)];
var inst_13254 = [ws_chan];
var inst_13255 = cljs.core.PersistentHashMap.fromArrays(inst_13253,inst_13254);
var state_13296__$1 = (function (){var statearr_13318 = state_13296;
(statearr_13318[(12)] = inst_13252);

return statearr_13318;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13296__$1,(8),initial_ch,inst_13255);
} else {
if((state_val_13297 === (14))){
var inst_13280 = (state_13296[(2)]);
var inst_13281 = cljs.core.async.close_BANG_.call(null,ws_chan);
var inst_13282 = cljs.core.async.close_BANG_.call(null,initial_ch);
var state_13296__$1 = (function (){var statearr_13319 = state_13296;
(statearr_13319[(13)] = inst_13281);

(statearr_13319[(14)] = inst_13280);

return statearr_13319;
})();
var statearr_13320_13351 = state_13296__$1;
(statearr_13320_13351[(2)] = inst_13282);

(statearr_13320_13351[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13297 === (16))){
var state_13296__$1 = state_13296;
var statearr_13321_13352 = state_13296__$1;
(statearr_13321_13352[(2)] = read_ch__$1);

(statearr_13321_13352[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13297 === (10))){
var inst_13246 = (state_13296[(8)]);
var inst_13284 = cljs.core._EQ_.call(null,inst_13246,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_13296__$1 = state_13296;
if(inst_13284){
var statearr_13322_13353 = state_13296__$1;
(statearr_13322_13353[(1)] = (19));

} else {
var statearr_13323_13354 = state_13296__$1;
(statearr_13323_13354[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13297 === (18))){
var inst_13267 = (state_13296[(11)]);
var inst_13272 = (state_13296[(2)]);
var inst_13273 = [new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_13274 = [inst_13267];
var inst_13275 = cljs.core.PersistentHashMap.fromArrays(inst_13273,inst_13274);
var state_13296__$1 = state_13296;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13296__$1,(15),inst_13272,inst_13275);
} else {
if((state_val_13297 === (8))){
var inst_13257 = (state_13296[(2)]);
var inst_13258 = cljs.core.async.close_BANG_.call(null,initial_ch);
var inst_13231 = true;
var state_13296__$1 = (function (){var statearr_13324 = state_13296;
(statearr_13324[(15)] = inst_13257);

(statearr_13324[(7)] = inst_13231);

(statearr_13324[(16)] = inst_13258);

return statearr_13324;
})();
var statearr_13325_13355 = state_13296__$1;
(statearr_13325_13355[(2)] = null);

(statearr_13325_13355[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9890__auto___13333,ws_chan,initial_ch,web_socket,map__13229,map__13229__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__13224,map__13227,map__13227__$1,opts,read_ch,write_ch,format,ws_opts))
;
return ((function (switch__9875__auto__,c__9890__auto___13333,ws_chan,initial_ch,web_socket,map__13229,map__13229__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__13224,map__13227,map__13227__$1,opts,read_ch,write_ch,format,ws_opts){
return (function() {
var chord$client$state_machine__9876__auto__ = null;
var chord$client$state_machine__9876__auto____0 = (function (){
var statearr_13326 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13326[(0)] = chord$client$state_machine__9876__auto__);

(statearr_13326[(1)] = (1));

return statearr_13326;
});
var chord$client$state_machine__9876__auto____1 = (function (state_13296){
while(true){
var ret_value__9877__auto__ = (function (){try{while(true){
var result__9878__auto__ = switch__9875__auto__.call(null,state_13296);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9878__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9878__auto__;
}
break;
}
}catch (e13327){if((e13327 instanceof Object)){
var ex__9879__auto__ = e13327;
var statearr_13328_13356 = state_13296;
(statearr_13328_13356[(5)] = ex__9879__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13296);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13327;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13357 = state_13296;
state_13296 = G__13357;
continue;
} else {
return ret_value__9877__auto__;
}
break;
}
});
chord$client$state_machine__9876__auto__ = function(state_13296){
switch(arguments.length){
case 0:
return chord$client$state_machine__9876__auto____0.call(this);
case 1:
return chord$client$state_machine__9876__auto____1.call(this,state_13296);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
chord$client$state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$0 = chord$client$state_machine__9876__auto____0;
chord$client$state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$1 = chord$client$state_machine__9876__auto____1;
return chord$client$state_machine__9876__auto__;
})()
;})(switch__9875__auto__,c__9890__auto___13333,ws_chan,initial_ch,web_socket,map__13229,map__13229__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__13224,map__13227,map__13227__$1,opts,read_ch,write_ch,format,ws_opts))
})();
var state__9892__auto__ = (function (){var statearr_13329 = f__9891__auto__.call(null);
(statearr_13329[(6)] = c__9890__auto___13333);

return statearr_13329;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9892__auto__);
});})(c__9890__auto___13333,ws_chan,initial_ch,web_socket,map__13229,map__13229__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__13224,map__13227,map__13227__$1,opts,read_ch,write_ch,format,ws_opts))
);


return initial_ch;
});

chord.client.ws_ch.cljs$lang$maxFixedArity = (1);

chord.client.ws_ch.cljs$lang$applyTo = (function (seq13221){
var G__13222 = cljs.core.first.call(null,seq13221);
var seq13221__$1 = cljs.core.next.call(null,seq13221);
return chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic(G__13222,seq13221__$1);
});


//# sourceMappingURL=client.js.map?rel=1500355265909