// Compiled by ClojureScript 1.9.671 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__10994 = arguments.length;
switch (G__10994) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async10995 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async10995 = (function (f,blockable,meta10996){
this.f = f;
this.blockable = blockable;
this.meta10996 = meta10996;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async10995.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_10997,meta10996__$1){
var self__ = this;
var _10997__$1 = this;
return (new cljs.core.async.t_cljs$core$async10995(self__.f,self__.blockable,meta10996__$1));
});

cljs.core.async.t_cljs$core$async10995.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_10997){
var self__ = this;
var _10997__$1 = this;
return self__.meta10996;
});

cljs.core.async.t_cljs$core$async10995.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async10995.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async10995.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async10995.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async10995.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta10996","meta10996",-290145345,null)], null);
});

cljs.core.async.t_cljs$core$async10995.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async10995.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async10995";

cljs.core.async.t_cljs$core$async10995.cljs$lang$ctorPrWriter = (function (this__8062__auto__,writer__8063__auto__,opt__8064__auto__){
return cljs.core._write.call(null,writer__8063__auto__,"cljs.core.async/t_cljs$core$async10995");
});

cljs.core.async.__GT_t_cljs$core$async10995 = (function cljs$core$async$__GT_t_cljs$core$async10995(f__$1,blockable__$1,meta10996){
return (new cljs.core.async.t_cljs$core$async10995(f__$1,blockable__$1,meta10996));
});

}

return (new cljs.core.async.t_cljs$core$async10995(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__11001 = arguments.length;
switch (G__11001) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buffer must be supplied when transducer is"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__11004 = arguments.length;
switch (G__11004) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__11007 = arguments.length;
switch (G__11007) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_11009 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_11009);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_11009,ret){
return (function (){
return fn1.call(null,val_11009);
});})(val_11009,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__11011 = arguments.length;
switch (G__11011) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__8375__auto___11013 = n;
var x_11014 = (0);
while(true){
if((x_11014 < n__8375__auto___11013)){
(a[x_11014] = (0));

var G__11015 = (x_11014 + (1));
x_11014 = G__11015;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__11016 = (i + (1));
i = G__11016;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async11017 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11017 = (function (flag,meta11018){
this.flag = flag;
this.meta11018 = meta11018;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async11017.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_11019,meta11018__$1){
var self__ = this;
var _11019__$1 = this;
return (new cljs.core.async.t_cljs$core$async11017(self__.flag,meta11018__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async11017.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_11019){
var self__ = this;
var _11019__$1 = this;
return self__.meta11018;
});})(flag))
;

cljs.core.async.t_cljs$core$async11017.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async11017.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async11017.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async11017.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async11017.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta11018","meta11018",-307425118,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async11017.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11017.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11017";

cljs.core.async.t_cljs$core$async11017.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__8062__auto__,writer__8063__auto__,opt__8064__auto__){
return cljs.core._write.call(null,writer__8063__auto__,"cljs.core.async/t_cljs$core$async11017");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async11017 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async11017(flag__$1,meta11018){
return (new cljs.core.async.t_cljs$core$async11017(flag__$1,meta11018));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async11017(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async11020 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11020 = (function (flag,cb,meta11021){
this.flag = flag;
this.cb = cb;
this.meta11021 = meta11021;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async11020.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11022,meta11021__$1){
var self__ = this;
var _11022__$1 = this;
return (new cljs.core.async.t_cljs$core$async11020(self__.flag,self__.cb,meta11021__$1));
});

cljs.core.async.t_cljs$core$async11020.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11022){
var self__ = this;
var _11022__$1 = this;
return self__.meta11021;
});

cljs.core.async.t_cljs$core$async11020.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async11020.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async11020.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async11020.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async11020.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta11021","meta11021",-592058538,null)], null);
});

cljs.core.async.t_cljs$core$async11020.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11020.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11020";

cljs.core.async.t_cljs$core$async11020.cljs$lang$ctorPrWriter = (function (this__8062__auto__,writer__8063__auto__,opt__8064__auto__){
return cljs.core._write.call(null,writer__8063__auto__,"cljs.core.async/t_cljs$core$async11020");
});

cljs.core.async.__GT_t_cljs$core$async11020 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async11020(flag__$1,cb__$1,meta11021){
return (new cljs.core.async.t_cljs$core$async11020(flag__$1,cb__$1,meta11021));
});

}

return (new cljs.core.async.t_cljs$core$async11020(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11023_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11023_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11024_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11024_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__7451__auto__ = wport;
if(cljs.core.truth_(or__7451__auto__)){
return or__7451__auto__;
} else {
return port;
}
})()], null));
} else {
var G__11025 = (i + (1));
i = G__11025;
continue;
}
} else {
return null;
}
break;
}
})();
var or__7451__auto__ = ret;
if(cljs.core.truth_(or__7451__auto__)){
return or__7451__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__7439__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__7439__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__7439__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__8583__auto__ = [];
var len__8576__auto___11031 = arguments.length;
var i__8577__auto___11032 = (0);
while(true){
if((i__8577__auto___11032 < len__8576__auto___11031)){
args__8583__auto__.push((arguments[i__8577__auto___11032]));

var G__11033 = (i__8577__auto___11032 + (1));
i__8577__auto___11032 = G__11033;
continue;
} else {
}
break;
}

var argseq__8584__auto__ = ((((1) < args__8583__auto__.length))?(new cljs.core.IndexedSeq(args__8583__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8584__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__11028){
var map__11029 = p__11028;
var map__11029__$1 = ((((!((map__11029 == null)))?((((map__11029.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11029.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11029):map__11029);
var opts = map__11029__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq11026){
var G__11027 = cljs.core.first.call(null,seq11026);
var seq11026__$1 = cljs.core.next.call(null,seq11026);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11027,seq11026__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__11035 = arguments.length;
switch (G__11035) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__9890__auto___11081 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9890__auto___11081){
return (function (){
var f__9891__auto__ = (function (){var switch__9875__auto__ = ((function (c__9890__auto___11081){
return (function (state_11059){
var state_val_11060 = (state_11059[(1)]);
if((state_val_11060 === (7))){
var inst_11055 = (state_11059[(2)]);
var state_11059__$1 = state_11059;
var statearr_11061_11082 = state_11059__$1;
(statearr_11061_11082[(2)] = inst_11055);

(statearr_11061_11082[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11060 === (1))){
var state_11059__$1 = state_11059;
var statearr_11062_11083 = state_11059__$1;
(statearr_11062_11083[(2)] = null);

(statearr_11062_11083[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11060 === (4))){
var inst_11038 = (state_11059[(7)]);
var inst_11038__$1 = (state_11059[(2)]);
var inst_11039 = (inst_11038__$1 == null);
var state_11059__$1 = (function (){var statearr_11063 = state_11059;
(statearr_11063[(7)] = inst_11038__$1);

return statearr_11063;
})();
if(cljs.core.truth_(inst_11039)){
var statearr_11064_11084 = state_11059__$1;
(statearr_11064_11084[(1)] = (5));

} else {
var statearr_11065_11085 = state_11059__$1;
(statearr_11065_11085[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11060 === (13))){
var state_11059__$1 = state_11059;
var statearr_11066_11086 = state_11059__$1;
(statearr_11066_11086[(2)] = null);

(statearr_11066_11086[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11060 === (6))){
var inst_11038 = (state_11059[(7)]);
var state_11059__$1 = state_11059;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11059__$1,(11),to,inst_11038);
} else {
if((state_val_11060 === (3))){
var inst_11057 = (state_11059[(2)]);
var state_11059__$1 = state_11059;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11059__$1,inst_11057);
} else {
if((state_val_11060 === (12))){
var state_11059__$1 = state_11059;
var statearr_11067_11087 = state_11059__$1;
(statearr_11067_11087[(2)] = null);

(statearr_11067_11087[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11060 === (2))){
var state_11059__$1 = state_11059;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11059__$1,(4),from);
} else {
if((state_val_11060 === (11))){
var inst_11048 = (state_11059[(2)]);
var state_11059__$1 = state_11059;
if(cljs.core.truth_(inst_11048)){
var statearr_11068_11088 = state_11059__$1;
(statearr_11068_11088[(1)] = (12));

} else {
var statearr_11069_11089 = state_11059__$1;
(statearr_11069_11089[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11060 === (9))){
var state_11059__$1 = state_11059;
var statearr_11070_11090 = state_11059__$1;
(statearr_11070_11090[(2)] = null);

(statearr_11070_11090[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11060 === (5))){
var state_11059__$1 = state_11059;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11071_11091 = state_11059__$1;
(statearr_11071_11091[(1)] = (8));

} else {
var statearr_11072_11092 = state_11059__$1;
(statearr_11072_11092[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11060 === (14))){
var inst_11053 = (state_11059[(2)]);
var state_11059__$1 = state_11059;
var statearr_11073_11093 = state_11059__$1;
(statearr_11073_11093[(2)] = inst_11053);

(statearr_11073_11093[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11060 === (10))){
var inst_11045 = (state_11059[(2)]);
var state_11059__$1 = state_11059;
var statearr_11074_11094 = state_11059__$1;
(statearr_11074_11094[(2)] = inst_11045);

(statearr_11074_11094[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11060 === (8))){
var inst_11042 = cljs.core.async.close_BANG_.call(null,to);
var state_11059__$1 = state_11059;
var statearr_11075_11095 = state_11059__$1;
(statearr_11075_11095[(2)] = inst_11042);

(statearr_11075_11095[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9890__auto___11081))
;
return ((function (switch__9875__auto__,c__9890__auto___11081){
return (function() {
var cljs$core$async$state_machine__9876__auto__ = null;
var cljs$core$async$state_machine__9876__auto____0 = (function (){
var statearr_11076 = [null,null,null,null,null,null,null,null];
(statearr_11076[(0)] = cljs$core$async$state_machine__9876__auto__);

(statearr_11076[(1)] = (1));

return statearr_11076;
});
var cljs$core$async$state_machine__9876__auto____1 = (function (state_11059){
while(true){
var ret_value__9877__auto__ = (function (){try{while(true){
var result__9878__auto__ = switch__9875__auto__.call(null,state_11059);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9878__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9878__auto__;
}
break;
}
}catch (e11077){if((e11077 instanceof Object)){
var ex__9879__auto__ = e11077;
var statearr_11078_11096 = state_11059;
(statearr_11078_11096[(5)] = ex__9879__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11059);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11077;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11097 = state_11059;
state_11059 = G__11097;
continue;
} else {
return ret_value__9877__auto__;
}
break;
}
});
cljs$core$async$state_machine__9876__auto__ = function(state_11059){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9876__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9876__auto____1.call(this,state_11059);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9876__auto____0;
cljs$core$async$state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9876__auto____1;
return cljs$core$async$state_machine__9876__auto__;
})()
;})(switch__9875__auto__,c__9890__auto___11081))
})();
var state__9892__auto__ = (function (){var statearr_11079 = f__9891__auto__.call(null);
(statearr_11079[(6)] = c__9890__auto___11081);

return statearr_11079;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9892__auto__);
});})(c__9890__auto___11081))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__11098){
var vec__11099 = p__11098;
var v = cljs.core.nth.call(null,vec__11099,(0),null);
var p = cljs.core.nth.call(null,vec__11099,(1),null);
var job = vec__11099;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__9890__auto___11270 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9890__auto___11270,res,vec__11099,v,p,job,jobs,results){
return (function (){
var f__9891__auto__ = (function (){var switch__9875__auto__ = ((function (c__9890__auto___11270,res,vec__11099,v,p,job,jobs,results){
return (function (state_11106){
var state_val_11107 = (state_11106[(1)]);
if((state_val_11107 === (1))){
var state_11106__$1 = state_11106;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11106__$1,(2),res,v);
} else {
if((state_val_11107 === (2))){
var inst_11103 = (state_11106[(2)]);
var inst_11104 = cljs.core.async.close_BANG_.call(null,res);
var state_11106__$1 = (function (){var statearr_11108 = state_11106;
(statearr_11108[(7)] = inst_11103);

return statearr_11108;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11106__$1,inst_11104);
} else {
return null;
}
}
});})(c__9890__auto___11270,res,vec__11099,v,p,job,jobs,results))
;
return ((function (switch__9875__auto__,c__9890__auto___11270,res,vec__11099,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__9876__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__9876__auto____0 = (function (){
var statearr_11109 = [null,null,null,null,null,null,null,null];
(statearr_11109[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__9876__auto__);

(statearr_11109[(1)] = (1));

return statearr_11109;
});
var cljs$core$async$pipeline_STAR__$_state_machine__9876__auto____1 = (function (state_11106){
while(true){
var ret_value__9877__auto__ = (function (){try{while(true){
var result__9878__auto__ = switch__9875__auto__.call(null,state_11106);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9878__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9878__auto__;
}
break;
}
}catch (e11110){if((e11110 instanceof Object)){
var ex__9879__auto__ = e11110;
var statearr_11111_11271 = state_11106;
(statearr_11111_11271[(5)] = ex__9879__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11106);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11110;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11272 = state_11106;
state_11106 = G__11272;
continue;
} else {
return ret_value__9877__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__9876__auto__ = function(state_11106){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__9876__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__9876__auto____1.call(this,state_11106);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__9876__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__9876__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__9876__auto__;
})()
;})(switch__9875__auto__,c__9890__auto___11270,res,vec__11099,v,p,job,jobs,results))
})();
var state__9892__auto__ = (function (){var statearr_11112 = f__9891__auto__.call(null);
(statearr_11112[(6)] = c__9890__auto___11270);

return statearr_11112;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9892__auto__);
});})(c__9890__auto___11270,res,vec__11099,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__11113){
var vec__11114 = p__11113;
var v = cljs.core.nth.call(null,vec__11114,(0),null);
var p = cljs.core.nth.call(null,vec__11114,(1),null);
var job = vec__11114;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__8375__auto___11273 = n;
var __11274 = (0);
while(true){
if((__11274 < n__8375__auto___11273)){
var G__11117_11275 = type;
var G__11117_11276__$1 = (((G__11117_11275 instanceof cljs.core.Keyword))?G__11117_11275.fqn:null);
switch (G__11117_11276__$1) {
case "compute":
var c__9890__auto___11278 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11274,c__9890__auto___11278,G__11117_11275,G__11117_11276__$1,n__8375__auto___11273,jobs,results,process,async){
return (function (){
var f__9891__auto__ = (function (){var switch__9875__auto__ = ((function (__11274,c__9890__auto___11278,G__11117_11275,G__11117_11276__$1,n__8375__auto___11273,jobs,results,process,async){
return (function (state_11130){
var state_val_11131 = (state_11130[(1)]);
if((state_val_11131 === (1))){
var state_11130__$1 = state_11130;
var statearr_11132_11279 = state_11130__$1;
(statearr_11132_11279[(2)] = null);

(statearr_11132_11279[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11131 === (2))){
var state_11130__$1 = state_11130;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11130__$1,(4),jobs);
} else {
if((state_val_11131 === (3))){
var inst_11128 = (state_11130[(2)]);
var state_11130__$1 = state_11130;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11130__$1,inst_11128);
} else {
if((state_val_11131 === (4))){
var inst_11120 = (state_11130[(2)]);
var inst_11121 = process.call(null,inst_11120);
var state_11130__$1 = state_11130;
if(cljs.core.truth_(inst_11121)){
var statearr_11133_11280 = state_11130__$1;
(statearr_11133_11280[(1)] = (5));

} else {
var statearr_11134_11281 = state_11130__$1;
(statearr_11134_11281[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11131 === (5))){
var state_11130__$1 = state_11130;
var statearr_11135_11282 = state_11130__$1;
(statearr_11135_11282[(2)] = null);

(statearr_11135_11282[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11131 === (6))){
var state_11130__$1 = state_11130;
var statearr_11136_11283 = state_11130__$1;
(statearr_11136_11283[(2)] = null);

(statearr_11136_11283[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11131 === (7))){
var inst_11126 = (state_11130[(2)]);
var state_11130__$1 = state_11130;
var statearr_11137_11284 = state_11130__$1;
(statearr_11137_11284[(2)] = inst_11126);

(statearr_11137_11284[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11274,c__9890__auto___11278,G__11117_11275,G__11117_11276__$1,n__8375__auto___11273,jobs,results,process,async))
;
return ((function (__11274,switch__9875__auto__,c__9890__auto___11278,G__11117_11275,G__11117_11276__$1,n__8375__auto___11273,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__9876__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__9876__auto____0 = (function (){
var statearr_11138 = [null,null,null,null,null,null,null];
(statearr_11138[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__9876__auto__);

(statearr_11138[(1)] = (1));

return statearr_11138;
});
var cljs$core$async$pipeline_STAR__$_state_machine__9876__auto____1 = (function (state_11130){
while(true){
var ret_value__9877__auto__ = (function (){try{while(true){
var result__9878__auto__ = switch__9875__auto__.call(null,state_11130);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9878__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9878__auto__;
}
break;
}
}catch (e11139){if((e11139 instanceof Object)){
var ex__9879__auto__ = e11139;
var statearr_11140_11285 = state_11130;
(statearr_11140_11285[(5)] = ex__9879__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11130);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11139;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11286 = state_11130;
state_11130 = G__11286;
continue;
} else {
return ret_value__9877__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__9876__auto__ = function(state_11130){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__9876__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__9876__auto____1.call(this,state_11130);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__9876__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__9876__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__9876__auto__;
})()
;})(__11274,switch__9875__auto__,c__9890__auto___11278,G__11117_11275,G__11117_11276__$1,n__8375__auto___11273,jobs,results,process,async))
})();
var state__9892__auto__ = (function (){var statearr_11141 = f__9891__auto__.call(null);
(statearr_11141[(6)] = c__9890__auto___11278);

return statearr_11141;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9892__auto__);
});})(__11274,c__9890__auto___11278,G__11117_11275,G__11117_11276__$1,n__8375__auto___11273,jobs,results,process,async))
);


break;
case "async":
var c__9890__auto___11287 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11274,c__9890__auto___11287,G__11117_11275,G__11117_11276__$1,n__8375__auto___11273,jobs,results,process,async){
return (function (){
var f__9891__auto__ = (function (){var switch__9875__auto__ = ((function (__11274,c__9890__auto___11287,G__11117_11275,G__11117_11276__$1,n__8375__auto___11273,jobs,results,process,async){
return (function (state_11154){
var state_val_11155 = (state_11154[(1)]);
if((state_val_11155 === (1))){
var state_11154__$1 = state_11154;
var statearr_11156_11288 = state_11154__$1;
(statearr_11156_11288[(2)] = null);

(statearr_11156_11288[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11155 === (2))){
var state_11154__$1 = state_11154;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11154__$1,(4),jobs);
} else {
if((state_val_11155 === (3))){
var inst_11152 = (state_11154[(2)]);
var state_11154__$1 = state_11154;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11154__$1,inst_11152);
} else {
if((state_val_11155 === (4))){
var inst_11144 = (state_11154[(2)]);
var inst_11145 = async.call(null,inst_11144);
var state_11154__$1 = state_11154;
if(cljs.core.truth_(inst_11145)){
var statearr_11157_11289 = state_11154__$1;
(statearr_11157_11289[(1)] = (5));

} else {
var statearr_11158_11290 = state_11154__$1;
(statearr_11158_11290[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11155 === (5))){
var state_11154__$1 = state_11154;
var statearr_11159_11291 = state_11154__$1;
(statearr_11159_11291[(2)] = null);

(statearr_11159_11291[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11155 === (6))){
var state_11154__$1 = state_11154;
var statearr_11160_11292 = state_11154__$1;
(statearr_11160_11292[(2)] = null);

(statearr_11160_11292[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11155 === (7))){
var inst_11150 = (state_11154[(2)]);
var state_11154__$1 = state_11154;
var statearr_11161_11293 = state_11154__$1;
(statearr_11161_11293[(2)] = inst_11150);

(statearr_11161_11293[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11274,c__9890__auto___11287,G__11117_11275,G__11117_11276__$1,n__8375__auto___11273,jobs,results,process,async))
;
return ((function (__11274,switch__9875__auto__,c__9890__auto___11287,G__11117_11275,G__11117_11276__$1,n__8375__auto___11273,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__9876__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__9876__auto____0 = (function (){
var statearr_11162 = [null,null,null,null,null,null,null];
(statearr_11162[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__9876__auto__);

(statearr_11162[(1)] = (1));

return statearr_11162;
});
var cljs$core$async$pipeline_STAR__$_state_machine__9876__auto____1 = (function (state_11154){
while(true){
var ret_value__9877__auto__ = (function (){try{while(true){
var result__9878__auto__ = switch__9875__auto__.call(null,state_11154);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9878__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9878__auto__;
}
break;
}
}catch (e11163){if((e11163 instanceof Object)){
var ex__9879__auto__ = e11163;
var statearr_11164_11294 = state_11154;
(statearr_11164_11294[(5)] = ex__9879__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11154);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11163;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11295 = state_11154;
state_11154 = G__11295;
continue;
} else {
return ret_value__9877__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__9876__auto__ = function(state_11154){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__9876__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__9876__auto____1.call(this,state_11154);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__9876__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__9876__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__9876__auto__;
})()
;})(__11274,switch__9875__auto__,c__9890__auto___11287,G__11117_11275,G__11117_11276__$1,n__8375__auto___11273,jobs,results,process,async))
})();
var state__9892__auto__ = (function (){var statearr_11165 = f__9891__auto__.call(null);
(statearr_11165[(6)] = c__9890__auto___11287);

return statearr_11165;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9892__auto__);
});})(__11274,c__9890__auto___11287,G__11117_11275,G__11117_11276__$1,n__8375__auto___11273,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__11117_11276__$1)].join('')));

}

var G__11296 = (__11274 + (1));
__11274 = G__11296;
continue;
} else {
}
break;
}

var c__9890__auto___11297 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9890__auto___11297,jobs,results,process,async){
return (function (){
var f__9891__auto__ = (function (){var switch__9875__auto__ = ((function (c__9890__auto___11297,jobs,results,process,async){
return (function (state_11187){
var state_val_11188 = (state_11187[(1)]);
if((state_val_11188 === (1))){
var state_11187__$1 = state_11187;
var statearr_11189_11298 = state_11187__$1;
(statearr_11189_11298[(2)] = null);

(statearr_11189_11298[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11188 === (2))){
var state_11187__$1 = state_11187;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11187__$1,(4),from);
} else {
if((state_val_11188 === (3))){
var inst_11185 = (state_11187[(2)]);
var state_11187__$1 = state_11187;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11187__$1,inst_11185);
} else {
if((state_val_11188 === (4))){
var inst_11168 = (state_11187[(7)]);
var inst_11168__$1 = (state_11187[(2)]);
var inst_11169 = (inst_11168__$1 == null);
var state_11187__$1 = (function (){var statearr_11190 = state_11187;
(statearr_11190[(7)] = inst_11168__$1);

return statearr_11190;
})();
if(cljs.core.truth_(inst_11169)){
var statearr_11191_11299 = state_11187__$1;
(statearr_11191_11299[(1)] = (5));

} else {
var statearr_11192_11300 = state_11187__$1;
(statearr_11192_11300[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11188 === (5))){
var inst_11171 = cljs.core.async.close_BANG_.call(null,jobs);
var state_11187__$1 = state_11187;
var statearr_11193_11301 = state_11187__$1;
(statearr_11193_11301[(2)] = inst_11171);

(statearr_11193_11301[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11188 === (6))){
var inst_11173 = (state_11187[(8)]);
var inst_11168 = (state_11187[(7)]);
var inst_11173__$1 = cljs.core.async.chan.call(null,(1));
var inst_11174 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_11175 = [inst_11168,inst_11173__$1];
var inst_11176 = (new cljs.core.PersistentVector(null,2,(5),inst_11174,inst_11175,null));
var state_11187__$1 = (function (){var statearr_11194 = state_11187;
(statearr_11194[(8)] = inst_11173__$1);

return statearr_11194;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11187__$1,(8),jobs,inst_11176);
} else {
if((state_val_11188 === (7))){
var inst_11183 = (state_11187[(2)]);
var state_11187__$1 = state_11187;
var statearr_11195_11302 = state_11187__$1;
(statearr_11195_11302[(2)] = inst_11183);

(statearr_11195_11302[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11188 === (8))){
var inst_11173 = (state_11187[(8)]);
var inst_11178 = (state_11187[(2)]);
var state_11187__$1 = (function (){var statearr_11196 = state_11187;
(statearr_11196[(9)] = inst_11178);

return statearr_11196;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11187__$1,(9),results,inst_11173);
} else {
if((state_val_11188 === (9))){
var inst_11180 = (state_11187[(2)]);
var state_11187__$1 = (function (){var statearr_11197 = state_11187;
(statearr_11197[(10)] = inst_11180);

return statearr_11197;
})();
var statearr_11198_11303 = state_11187__$1;
(statearr_11198_11303[(2)] = null);

(statearr_11198_11303[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__9890__auto___11297,jobs,results,process,async))
;
return ((function (switch__9875__auto__,c__9890__auto___11297,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__9876__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__9876__auto____0 = (function (){
var statearr_11199 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_11199[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__9876__auto__);

(statearr_11199[(1)] = (1));

return statearr_11199;
});
var cljs$core$async$pipeline_STAR__$_state_machine__9876__auto____1 = (function (state_11187){
while(true){
var ret_value__9877__auto__ = (function (){try{while(true){
var result__9878__auto__ = switch__9875__auto__.call(null,state_11187);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9878__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9878__auto__;
}
break;
}
}catch (e11200){if((e11200 instanceof Object)){
var ex__9879__auto__ = e11200;
var statearr_11201_11304 = state_11187;
(statearr_11201_11304[(5)] = ex__9879__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11187);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11200;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11305 = state_11187;
state_11187 = G__11305;
continue;
} else {
return ret_value__9877__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__9876__auto__ = function(state_11187){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__9876__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__9876__auto____1.call(this,state_11187);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__9876__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__9876__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__9876__auto__;
})()
;})(switch__9875__auto__,c__9890__auto___11297,jobs,results,process,async))
})();
var state__9892__auto__ = (function (){var statearr_11202 = f__9891__auto__.call(null);
(statearr_11202[(6)] = c__9890__auto___11297);

return statearr_11202;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9892__auto__);
});})(c__9890__auto___11297,jobs,results,process,async))
);


var c__9890__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9890__auto__,jobs,results,process,async){
return (function (){
var f__9891__auto__ = (function (){var switch__9875__auto__ = ((function (c__9890__auto__,jobs,results,process,async){
return (function (state_11240){
var state_val_11241 = (state_11240[(1)]);
if((state_val_11241 === (7))){
var inst_11236 = (state_11240[(2)]);
var state_11240__$1 = state_11240;
var statearr_11242_11306 = state_11240__$1;
(statearr_11242_11306[(2)] = inst_11236);

(statearr_11242_11306[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11241 === (20))){
var state_11240__$1 = state_11240;
var statearr_11243_11307 = state_11240__$1;
(statearr_11243_11307[(2)] = null);

(statearr_11243_11307[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11241 === (1))){
var state_11240__$1 = state_11240;
var statearr_11244_11308 = state_11240__$1;
(statearr_11244_11308[(2)] = null);

(statearr_11244_11308[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11241 === (4))){
var inst_11205 = (state_11240[(7)]);
var inst_11205__$1 = (state_11240[(2)]);
var inst_11206 = (inst_11205__$1 == null);
var state_11240__$1 = (function (){var statearr_11245 = state_11240;
(statearr_11245[(7)] = inst_11205__$1);

return statearr_11245;
})();
if(cljs.core.truth_(inst_11206)){
var statearr_11246_11309 = state_11240__$1;
(statearr_11246_11309[(1)] = (5));

} else {
var statearr_11247_11310 = state_11240__$1;
(statearr_11247_11310[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11241 === (15))){
var inst_11218 = (state_11240[(8)]);
var state_11240__$1 = state_11240;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11240__$1,(18),to,inst_11218);
} else {
if((state_val_11241 === (21))){
var inst_11231 = (state_11240[(2)]);
var state_11240__$1 = state_11240;
var statearr_11248_11311 = state_11240__$1;
(statearr_11248_11311[(2)] = inst_11231);

(statearr_11248_11311[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11241 === (13))){
var inst_11233 = (state_11240[(2)]);
var state_11240__$1 = (function (){var statearr_11249 = state_11240;
(statearr_11249[(9)] = inst_11233);

return statearr_11249;
})();
var statearr_11250_11312 = state_11240__$1;
(statearr_11250_11312[(2)] = null);

(statearr_11250_11312[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11241 === (6))){
var inst_11205 = (state_11240[(7)]);
var state_11240__$1 = state_11240;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11240__$1,(11),inst_11205);
} else {
if((state_val_11241 === (17))){
var inst_11226 = (state_11240[(2)]);
var state_11240__$1 = state_11240;
if(cljs.core.truth_(inst_11226)){
var statearr_11251_11313 = state_11240__$1;
(statearr_11251_11313[(1)] = (19));

} else {
var statearr_11252_11314 = state_11240__$1;
(statearr_11252_11314[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11241 === (3))){
var inst_11238 = (state_11240[(2)]);
var state_11240__$1 = state_11240;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11240__$1,inst_11238);
} else {
if((state_val_11241 === (12))){
var inst_11215 = (state_11240[(10)]);
var state_11240__$1 = state_11240;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11240__$1,(14),inst_11215);
} else {
if((state_val_11241 === (2))){
var state_11240__$1 = state_11240;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11240__$1,(4),results);
} else {
if((state_val_11241 === (19))){
var state_11240__$1 = state_11240;
var statearr_11253_11315 = state_11240__$1;
(statearr_11253_11315[(2)] = null);

(statearr_11253_11315[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11241 === (11))){
var inst_11215 = (state_11240[(2)]);
var state_11240__$1 = (function (){var statearr_11254 = state_11240;
(statearr_11254[(10)] = inst_11215);

return statearr_11254;
})();
var statearr_11255_11316 = state_11240__$1;
(statearr_11255_11316[(2)] = null);

(statearr_11255_11316[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11241 === (9))){
var state_11240__$1 = state_11240;
var statearr_11256_11317 = state_11240__$1;
(statearr_11256_11317[(2)] = null);

(statearr_11256_11317[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11241 === (5))){
var state_11240__$1 = state_11240;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11257_11318 = state_11240__$1;
(statearr_11257_11318[(1)] = (8));

} else {
var statearr_11258_11319 = state_11240__$1;
(statearr_11258_11319[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11241 === (14))){
var inst_11220 = (state_11240[(11)]);
var inst_11218 = (state_11240[(8)]);
var inst_11218__$1 = (state_11240[(2)]);
var inst_11219 = (inst_11218__$1 == null);
var inst_11220__$1 = cljs.core.not.call(null,inst_11219);
var state_11240__$1 = (function (){var statearr_11259 = state_11240;
(statearr_11259[(11)] = inst_11220__$1);

(statearr_11259[(8)] = inst_11218__$1);

return statearr_11259;
})();
if(inst_11220__$1){
var statearr_11260_11320 = state_11240__$1;
(statearr_11260_11320[(1)] = (15));

} else {
var statearr_11261_11321 = state_11240__$1;
(statearr_11261_11321[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11241 === (16))){
var inst_11220 = (state_11240[(11)]);
var state_11240__$1 = state_11240;
var statearr_11262_11322 = state_11240__$1;
(statearr_11262_11322[(2)] = inst_11220);

(statearr_11262_11322[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11241 === (10))){
var inst_11212 = (state_11240[(2)]);
var state_11240__$1 = state_11240;
var statearr_11263_11323 = state_11240__$1;
(statearr_11263_11323[(2)] = inst_11212);

(statearr_11263_11323[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11241 === (18))){
var inst_11223 = (state_11240[(2)]);
var state_11240__$1 = state_11240;
var statearr_11264_11324 = state_11240__$1;
(statearr_11264_11324[(2)] = inst_11223);

(statearr_11264_11324[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11241 === (8))){
var inst_11209 = cljs.core.async.close_BANG_.call(null,to);
var state_11240__$1 = state_11240;
var statearr_11265_11325 = state_11240__$1;
(statearr_11265_11325[(2)] = inst_11209);

(statearr_11265_11325[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9890__auto__,jobs,results,process,async))
;
return ((function (switch__9875__auto__,c__9890__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__9876__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__9876__auto____0 = (function (){
var statearr_11266 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11266[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__9876__auto__);

(statearr_11266[(1)] = (1));

return statearr_11266;
});
var cljs$core$async$pipeline_STAR__$_state_machine__9876__auto____1 = (function (state_11240){
while(true){
var ret_value__9877__auto__ = (function (){try{while(true){
var result__9878__auto__ = switch__9875__auto__.call(null,state_11240);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9878__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9878__auto__;
}
break;
}
}catch (e11267){if((e11267 instanceof Object)){
var ex__9879__auto__ = e11267;
var statearr_11268_11326 = state_11240;
(statearr_11268_11326[(5)] = ex__9879__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11240);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11267;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11327 = state_11240;
state_11240 = G__11327;
continue;
} else {
return ret_value__9877__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__9876__auto__ = function(state_11240){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__9876__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__9876__auto____1.call(this,state_11240);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__9876__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__9876__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__9876__auto__;
})()
;})(switch__9875__auto__,c__9890__auto__,jobs,results,process,async))
})();
var state__9892__auto__ = (function (){var statearr_11269 = f__9891__auto__.call(null);
(statearr_11269[(6)] = c__9890__auto__);

return statearr_11269;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9892__auto__);
});})(c__9890__auto__,jobs,results,process,async))
);

return c__9890__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__11329 = arguments.length;
switch (G__11329) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__11332 = arguments.length;
switch (G__11332) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__11335 = arguments.length;
switch (G__11335) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__9890__auto___11384 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9890__auto___11384,tc,fc){
return (function (){
var f__9891__auto__ = (function (){var switch__9875__auto__ = ((function (c__9890__auto___11384,tc,fc){
return (function (state_11361){
var state_val_11362 = (state_11361[(1)]);
if((state_val_11362 === (7))){
var inst_11357 = (state_11361[(2)]);
var state_11361__$1 = state_11361;
var statearr_11363_11385 = state_11361__$1;
(statearr_11363_11385[(2)] = inst_11357);

(statearr_11363_11385[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11362 === (1))){
var state_11361__$1 = state_11361;
var statearr_11364_11386 = state_11361__$1;
(statearr_11364_11386[(2)] = null);

(statearr_11364_11386[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11362 === (4))){
var inst_11338 = (state_11361[(7)]);
var inst_11338__$1 = (state_11361[(2)]);
var inst_11339 = (inst_11338__$1 == null);
var state_11361__$1 = (function (){var statearr_11365 = state_11361;
(statearr_11365[(7)] = inst_11338__$1);

return statearr_11365;
})();
if(cljs.core.truth_(inst_11339)){
var statearr_11366_11387 = state_11361__$1;
(statearr_11366_11387[(1)] = (5));

} else {
var statearr_11367_11388 = state_11361__$1;
(statearr_11367_11388[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11362 === (13))){
var state_11361__$1 = state_11361;
var statearr_11368_11389 = state_11361__$1;
(statearr_11368_11389[(2)] = null);

(statearr_11368_11389[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11362 === (6))){
var inst_11338 = (state_11361[(7)]);
var inst_11344 = p.call(null,inst_11338);
var state_11361__$1 = state_11361;
if(cljs.core.truth_(inst_11344)){
var statearr_11369_11390 = state_11361__$1;
(statearr_11369_11390[(1)] = (9));

} else {
var statearr_11370_11391 = state_11361__$1;
(statearr_11370_11391[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11362 === (3))){
var inst_11359 = (state_11361[(2)]);
var state_11361__$1 = state_11361;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11361__$1,inst_11359);
} else {
if((state_val_11362 === (12))){
var state_11361__$1 = state_11361;
var statearr_11371_11392 = state_11361__$1;
(statearr_11371_11392[(2)] = null);

(statearr_11371_11392[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11362 === (2))){
var state_11361__$1 = state_11361;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11361__$1,(4),ch);
} else {
if((state_val_11362 === (11))){
var inst_11338 = (state_11361[(7)]);
var inst_11348 = (state_11361[(2)]);
var state_11361__$1 = state_11361;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11361__$1,(8),inst_11348,inst_11338);
} else {
if((state_val_11362 === (9))){
var state_11361__$1 = state_11361;
var statearr_11372_11393 = state_11361__$1;
(statearr_11372_11393[(2)] = tc);

(statearr_11372_11393[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11362 === (5))){
var inst_11341 = cljs.core.async.close_BANG_.call(null,tc);
var inst_11342 = cljs.core.async.close_BANG_.call(null,fc);
var state_11361__$1 = (function (){var statearr_11373 = state_11361;
(statearr_11373[(8)] = inst_11341);

return statearr_11373;
})();
var statearr_11374_11394 = state_11361__$1;
(statearr_11374_11394[(2)] = inst_11342);

(statearr_11374_11394[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11362 === (14))){
var inst_11355 = (state_11361[(2)]);
var state_11361__$1 = state_11361;
var statearr_11375_11395 = state_11361__$1;
(statearr_11375_11395[(2)] = inst_11355);

(statearr_11375_11395[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11362 === (10))){
var state_11361__$1 = state_11361;
var statearr_11376_11396 = state_11361__$1;
(statearr_11376_11396[(2)] = fc);

(statearr_11376_11396[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11362 === (8))){
var inst_11350 = (state_11361[(2)]);
var state_11361__$1 = state_11361;
if(cljs.core.truth_(inst_11350)){
var statearr_11377_11397 = state_11361__$1;
(statearr_11377_11397[(1)] = (12));

} else {
var statearr_11378_11398 = state_11361__$1;
(statearr_11378_11398[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9890__auto___11384,tc,fc))
;
return ((function (switch__9875__auto__,c__9890__auto___11384,tc,fc){
return (function() {
var cljs$core$async$state_machine__9876__auto__ = null;
var cljs$core$async$state_machine__9876__auto____0 = (function (){
var statearr_11379 = [null,null,null,null,null,null,null,null,null];
(statearr_11379[(0)] = cljs$core$async$state_machine__9876__auto__);

(statearr_11379[(1)] = (1));

return statearr_11379;
});
var cljs$core$async$state_machine__9876__auto____1 = (function (state_11361){
while(true){
var ret_value__9877__auto__ = (function (){try{while(true){
var result__9878__auto__ = switch__9875__auto__.call(null,state_11361);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9878__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9878__auto__;
}
break;
}
}catch (e11380){if((e11380 instanceof Object)){
var ex__9879__auto__ = e11380;
var statearr_11381_11399 = state_11361;
(statearr_11381_11399[(5)] = ex__9879__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11361);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11380;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11400 = state_11361;
state_11361 = G__11400;
continue;
} else {
return ret_value__9877__auto__;
}
break;
}
});
cljs$core$async$state_machine__9876__auto__ = function(state_11361){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9876__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9876__auto____1.call(this,state_11361);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9876__auto____0;
cljs$core$async$state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9876__auto____1;
return cljs$core$async$state_machine__9876__auto__;
})()
;})(switch__9875__auto__,c__9890__auto___11384,tc,fc))
})();
var state__9892__auto__ = (function (){var statearr_11382 = f__9891__auto__.call(null);
(statearr_11382[(6)] = c__9890__auto___11384);

return statearr_11382;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9892__auto__);
});})(c__9890__auto___11384,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__9890__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9890__auto__){
return (function (){
var f__9891__auto__ = (function (){var switch__9875__auto__ = ((function (c__9890__auto__){
return (function (state_11421){
var state_val_11422 = (state_11421[(1)]);
if((state_val_11422 === (7))){
var inst_11417 = (state_11421[(2)]);
var state_11421__$1 = state_11421;
var statearr_11423_11441 = state_11421__$1;
(statearr_11423_11441[(2)] = inst_11417);

(statearr_11423_11441[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11422 === (1))){
var inst_11401 = init;
var state_11421__$1 = (function (){var statearr_11424 = state_11421;
(statearr_11424[(7)] = inst_11401);

return statearr_11424;
})();
var statearr_11425_11442 = state_11421__$1;
(statearr_11425_11442[(2)] = null);

(statearr_11425_11442[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11422 === (4))){
var inst_11404 = (state_11421[(8)]);
var inst_11404__$1 = (state_11421[(2)]);
var inst_11405 = (inst_11404__$1 == null);
var state_11421__$1 = (function (){var statearr_11426 = state_11421;
(statearr_11426[(8)] = inst_11404__$1);

return statearr_11426;
})();
if(cljs.core.truth_(inst_11405)){
var statearr_11427_11443 = state_11421__$1;
(statearr_11427_11443[(1)] = (5));

} else {
var statearr_11428_11444 = state_11421__$1;
(statearr_11428_11444[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11422 === (6))){
var inst_11401 = (state_11421[(7)]);
var inst_11408 = (state_11421[(9)]);
var inst_11404 = (state_11421[(8)]);
var inst_11408__$1 = f.call(null,inst_11401,inst_11404);
var inst_11409 = cljs.core.reduced_QMARK_.call(null,inst_11408__$1);
var state_11421__$1 = (function (){var statearr_11429 = state_11421;
(statearr_11429[(9)] = inst_11408__$1);

return statearr_11429;
})();
if(inst_11409){
var statearr_11430_11445 = state_11421__$1;
(statearr_11430_11445[(1)] = (8));

} else {
var statearr_11431_11446 = state_11421__$1;
(statearr_11431_11446[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11422 === (3))){
var inst_11419 = (state_11421[(2)]);
var state_11421__$1 = state_11421;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11421__$1,inst_11419);
} else {
if((state_val_11422 === (2))){
var state_11421__$1 = state_11421;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11421__$1,(4),ch);
} else {
if((state_val_11422 === (9))){
var inst_11408 = (state_11421[(9)]);
var inst_11401 = inst_11408;
var state_11421__$1 = (function (){var statearr_11432 = state_11421;
(statearr_11432[(7)] = inst_11401);

return statearr_11432;
})();
var statearr_11433_11447 = state_11421__$1;
(statearr_11433_11447[(2)] = null);

(statearr_11433_11447[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11422 === (5))){
var inst_11401 = (state_11421[(7)]);
var state_11421__$1 = state_11421;
var statearr_11434_11448 = state_11421__$1;
(statearr_11434_11448[(2)] = inst_11401);

(statearr_11434_11448[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11422 === (10))){
var inst_11415 = (state_11421[(2)]);
var state_11421__$1 = state_11421;
var statearr_11435_11449 = state_11421__$1;
(statearr_11435_11449[(2)] = inst_11415);

(statearr_11435_11449[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11422 === (8))){
var inst_11408 = (state_11421[(9)]);
var inst_11411 = cljs.core.deref.call(null,inst_11408);
var state_11421__$1 = state_11421;
var statearr_11436_11450 = state_11421__$1;
(statearr_11436_11450[(2)] = inst_11411);

(statearr_11436_11450[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__9890__auto__))
;
return ((function (switch__9875__auto__,c__9890__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__9876__auto__ = null;
var cljs$core$async$reduce_$_state_machine__9876__auto____0 = (function (){
var statearr_11437 = [null,null,null,null,null,null,null,null,null,null];
(statearr_11437[(0)] = cljs$core$async$reduce_$_state_machine__9876__auto__);

(statearr_11437[(1)] = (1));

return statearr_11437;
});
var cljs$core$async$reduce_$_state_machine__9876__auto____1 = (function (state_11421){
while(true){
var ret_value__9877__auto__ = (function (){try{while(true){
var result__9878__auto__ = switch__9875__auto__.call(null,state_11421);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9878__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9878__auto__;
}
break;
}
}catch (e11438){if((e11438 instanceof Object)){
var ex__9879__auto__ = e11438;
var statearr_11439_11451 = state_11421;
(statearr_11439_11451[(5)] = ex__9879__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11421);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11438;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11452 = state_11421;
state_11421 = G__11452;
continue;
} else {
return ret_value__9877__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__9876__auto__ = function(state_11421){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__9876__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__9876__auto____1.call(this,state_11421);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__9876__auto____0;
cljs$core$async$reduce_$_state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__9876__auto____1;
return cljs$core$async$reduce_$_state_machine__9876__auto__;
})()
;})(switch__9875__auto__,c__9890__auto__))
})();
var state__9892__auto__ = (function (){var statearr_11440 = f__9891__auto__.call(null);
(statearr_11440[(6)] = c__9890__auto__);

return statearr_11440;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9892__auto__);
});})(c__9890__auto__))
);

return c__9890__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__9890__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9890__auto__,f__$1){
return (function (){
var f__9891__auto__ = (function (){var switch__9875__auto__ = ((function (c__9890__auto__,f__$1){
return (function (state_11458){
var state_val_11459 = (state_11458[(1)]);
if((state_val_11459 === (1))){
var inst_11453 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_11458__$1 = state_11458;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11458__$1,(2),inst_11453);
} else {
if((state_val_11459 === (2))){
var inst_11455 = (state_11458[(2)]);
var inst_11456 = f__$1.call(null,inst_11455);
var state_11458__$1 = state_11458;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11458__$1,inst_11456);
} else {
return null;
}
}
});})(c__9890__auto__,f__$1))
;
return ((function (switch__9875__auto__,c__9890__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__9876__auto__ = null;
var cljs$core$async$transduce_$_state_machine__9876__auto____0 = (function (){
var statearr_11460 = [null,null,null,null,null,null,null];
(statearr_11460[(0)] = cljs$core$async$transduce_$_state_machine__9876__auto__);

(statearr_11460[(1)] = (1));

return statearr_11460;
});
var cljs$core$async$transduce_$_state_machine__9876__auto____1 = (function (state_11458){
while(true){
var ret_value__9877__auto__ = (function (){try{while(true){
var result__9878__auto__ = switch__9875__auto__.call(null,state_11458);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9878__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9878__auto__;
}
break;
}
}catch (e11461){if((e11461 instanceof Object)){
var ex__9879__auto__ = e11461;
var statearr_11462_11464 = state_11458;
(statearr_11462_11464[(5)] = ex__9879__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11458);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11461;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11465 = state_11458;
state_11458 = G__11465;
continue;
} else {
return ret_value__9877__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__9876__auto__ = function(state_11458){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__9876__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__9876__auto____1.call(this,state_11458);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__9876__auto____0;
cljs$core$async$transduce_$_state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__9876__auto____1;
return cljs$core$async$transduce_$_state_machine__9876__auto__;
})()
;})(switch__9875__auto__,c__9890__auto__,f__$1))
})();
var state__9892__auto__ = (function (){var statearr_11463 = f__9891__auto__.call(null);
(statearr_11463[(6)] = c__9890__auto__);

return statearr_11463;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9892__auto__);
});})(c__9890__auto__,f__$1))
);

return c__9890__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__11467 = arguments.length;
switch (G__11467) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__9890__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9890__auto__){
return (function (){
var f__9891__auto__ = (function (){var switch__9875__auto__ = ((function (c__9890__auto__){
return (function (state_11492){
var state_val_11493 = (state_11492[(1)]);
if((state_val_11493 === (7))){
var inst_11474 = (state_11492[(2)]);
var state_11492__$1 = state_11492;
var statearr_11494_11515 = state_11492__$1;
(statearr_11494_11515[(2)] = inst_11474);

(statearr_11494_11515[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11493 === (1))){
var inst_11468 = cljs.core.seq.call(null,coll);
var inst_11469 = inst_11468;
var state_11492__$1 = (function (){var statearr_11495 = state_11492;
(statearr_11495[(7)] = inst_11469);

return statearr_11495;
})();
var statearr_11496_11516 = state_11492__$1;
(statearr_11496_11516[(2)] = null);

(statearr_11496_11516[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11493 === (4))){
var inst_11469 = (state_11492[(7)]);
var inst_11472 = cljs.core.first.call(null,inst_11469);
var state_11492__$1 = state_11492;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11492__$1,(7),ch,inst_11472);
} else {
if((state_val_11493 === (13))){
var inst_11486 = (state_11492[(2)]);
var state_11492__$1 = state_11492;
var statearr_11497_11517 = state_11492__$1;
(statearr_11497_11517[(2)] = inst_11486);

(statearr_11497_11517[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11493 === (6))){
var inst_11477 = (state_11492[(2)]);
var state_11492__$1 = state_11492;
if(cljs.core.truth_(inst_11477)){
var statearr_11498_11518 = state_11492__$1;
(statearr_11498_11518[(1)] = (8));

} else {
var statearr_11499_11519 = state_11492__$1;
(statearr_11499_11519[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11493 === (3))){
var inst_11490 = (state_11492[(2)]);
var state_11492__$1 = state_11492;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11492__$1,inst_11490);
} else {
if((state_val_11493 === (12))){
var state_11492__$1 = state_11492;
var statearr_11500_11520 = state_11492__$1;
(statearr_11500_11520[(2)] = null);

(statearr_11500_11520[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11493 === (2))){
var inst_11469 = (state_11492[(7)]);
var state_11492__$1 = state_11492;
if(cljs.core.truth_(inst_11469)){
var statearr_11501_11521 = state_11492__$1;
(statearr_11501_11521[(1)] = (4));

} else {
var statearr_11502_11522 = state_11492__$1;
(statearr_11502_11522[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11493 === (11))){
var inst_11483 = cljs.core.async.close_BANG_.call(null,ch);
var state_11492__$1 = state_11492;
var statearr_11503_11523 = state_11492__$1;
(statearr_11503_11523[(2)] = inst_11483);

(statearr_11503_11523[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11493 === (9))){
var state_11492__$1 = state_11492;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11504_11524 = state_11492__$1;
(statearr_11504_11524[(1)] = (11));

} else {
var statearr_11505_11525 = state_11492__$1;
(statearr_11505_11525[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11493 === (5))){
var inst_11469 = (state_11492[(7)]);
var state_11492__$1 = state_11492;
var statearr_11506_11526 = state_11492__$1;
(statearr_11506_11526[(2)] = inst_11469);

(statearr_11506_11526[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11493 === (10))){
var inst_11488 = (state_11492[(2)]);
var state_11492__$1 = state_11492;
var statearr_11507_11527 = state_11492__$1;
(statearr_11507_11527[(2)] = inst_11488);

(statearr_11507_11527[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11493 === (8))){
var inst_11469 = (state_11492[(7)]);
var inst_11479 = cljs.core.next.call(null,inst_11469);
var inst_11469__$1 = inst_11479;
var state_11492__$1 = (function (){var statearr_11508 = state_11492;
(statearr_11508[(7)] = inst_11469__$1);

return statearr_11508;
})();
var statearr_11509_11528 = state_11492__$1;
(statearr_11509_11528[(2)] = null);

(statearr_11509_11528[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9890__auto__))
;
return ((function (switch__9875__auto__,c__9890__auto__){
return (function() {
var cljs$core$async$state_machine__9876__auto__ = null;
var cljs$core$async$state_machine__9876__auto____0 = (function (){
var statearr_11510 = [null,null,null,null,null,null,null,null];
(statearr_11510[(0)] = cljs$core$async$state_machine__9876__auto__);

(statearr_11510[(1)] = (1));

return statearr_11510;
});
var cljs$core$async$state_machine__9876__auto____1 = (function (state_11492){
while(true){
var ret_value__9877__auto__ = (function (){try{while(true){
var result__9878__auto__ = switch__9875__auto__.call(null,state_11492);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9878__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9878__auto__;
}
break;
}
}catch (e11511){if((e11511 instanceof Object)){
var ex__9879__auto__ = e11511;
var statearr_11512_11529 = state_11492;
(statearr_11512_11529[(5)] = ex__9879__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11492);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11511;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11530 = state_11492;
state_11492 = G__11530;
continue;
} else {
return ret_value__9877__auto__;
}
break;
}
});
cljs$core$async$state_machine__9876__auto__ = function(state_11492){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9876__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9876__auto____1.call(this,state_11492);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9876__auto____0;
cljs$core$async$state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9876__auto____1;
return cljs$core$async$state_machine__9876__auto__;
})()
;})(switch__9875__auto__,c__9890__auto__))
})();
var state__9892__auto__ = (function (){var statearr_11513 = f__9891__auto__.call(null);
(statearr_11513[(6)] = c__9890__auto__);

return statearr_11513;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9892__auto__);
});})(c__9890__auto__))
);

return c__9890__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__8120__auto__ = (((_ == null))?null:_);
var m__8121__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__8120__auto__)]);
if(!((m__8121__auto__ == null))){
return m__8121__auto__.call(null,_);
} else {
var m__8121__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__8121__auto____$1 == null))){
return m__8121__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__8120__auto__ = (((m == null))?null:m);
var m__8121__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__8120__auto__)]);
if(!((m__8121__auto__ == null))){
return m__8121__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__8121__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__8121__auto____$1 == null))){
return m__8121__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__8120__auto__ = (((m == null))?null:m);
var m__8121__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__8120__auto__)]);
if(!((m__8121__auto__ == null))){
return m__8121__auto__.call(null,m,ch);
} else {
var m__8121__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__8121__auto____$1 == null))){
return m__8121__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__8120__auto__ = (((m == null))?null:m);
var m__8121__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__8120__auto__)]);
if(!((m__8121__auto__ == null))){
return m__8121__auto__.call(null,m);
} else {
var m__8121__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__8121__auto____$1 == null))){
return m__8121__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async11531 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11531 = (function (ch,cs,meta11532){
this.ch = ch;
this.cs = cs;
this.meta11532 = meta11532;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async11531.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_11533,meta11532__$1){
var self__ = this;
var _11533__$1 = this;
return (new cljs.core.async.t_cljs$core$async11531(self__.ch,self__.cs,meta11532__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async11531.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_11533){
var self__ = this;
var _11533__$1 = this;
return self__.meta11532;
});})(cs))
;

cljs.core.async.t_cljs$core$async11531.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async11531.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async11531.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async11531.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async11531.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async11531.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async11531.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta11532","meta11532",120968016,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async11531.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11531.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11531";

cljs.core.async.t_cljs$core$async11531.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__8062__auto__,writer__8063__auto__,opt__8064__auto__){
return cljs.core._write.call(null,writer__8063__auto__,"cljs.core.async/t_cljs$core$async11531");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async11531 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async11531(ch__$1,cs__$1,meta11532){
return (new cljs.core.async.t_cljs$core$async11531(ch__$1,cs__$1,meta11532));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async11531(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__9890__auto___11753 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9890__auto___11753,cs,m,dchan,dctr,done){
return (function (){
var f__9891__auto__ = (function (){var switch__9875__auto__ = ((function (c__9890__auto___11753,cs,m,dchan,dctr,done){
return (function (state_11668){
var state_val_11669 = (state_11668[(1)]);
if((state_val_11669 === (7))){
var inst_11664 = (state_11668[(2)]);
var state_11668__$1 = state_11668;
var statearr_11670_11754 = state_11668__$1;
(statearr_11670_11754[(2)] = inst_11664);

(statearr_11670_11754[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (20))){
var inst_11567 = (state_11668[(7)]);
var inst_11579 = cljs.core.first.call(null,inst_11567);
var inst_11580 = cljs.core.nth.call(null,inst_11579,(0),null);
var inst_11581 = cljs.core.nth.call(null,inst_11579,(1),null);
var state_11668__$1 = (function (){var statearr_11671 = state_11668;
(statearr_11671[(8)] = inst_11580);

return statearr_11671;
})();
if(cljs.core.truth_(inst_11581)){
var statearr_11672_11755 = state_11668__$1;
(statearr_11672_11755[(1)] = (22));

} else {
var statearr_11673_11756 = state_11668__$1;
(statearr_11673_11756[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (27))){
var inst_11611 = (state_11668[(9)]);
var inst_11616 = (state_11668[(10)]);
var inst_11609 = (state_11668[(11)]);
var inst_11536 = (state_11668[(12)]);
var inst_11616__$1 = cljs.core._nth.call(null,inst_11609,inst_11611);
var inst_11617 = cljs.core.async.put_BANG_.call(null,inst_11616__$1,inst_11536,done);
var state_11668__$1 = (function (){var statearr_11674 = state_11668;
(statearr_11674[(10)] = inst_11616__$1);

return statearr_11674;
})();
if(cljs.core.truth_(inst_11617)){
var statearr_11675_11757 = state_11668__$1;
(statearr_11675_11757[(1)] = (30));

} else {
var statearr_11676_11758 = state_11668__$1;
(statearr_11676_11758[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (1))){
var state_11668__$1 = state_11668;
var statearr_11677_11759 = state_11668__$1;
(statearr_11677_11759[(2)] = null);

(statearr_11677_11759[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (24))){
var inst_11567 = (state_11668[(7)]);
var inst_11586 = (state_11668[(2)]);
var inst_11587 = cljs.core.next.call(null,inst_11567);
var inst_11545 = inst_11587;
var inst_11546 = null;
var inst_11547 = (0);
var inst_11548 = (0);
var state_11668__$1 = (function (){var statearr_11678 = state_11668;
(statearr_11678[(13)] = inst_11546);

(statearr_11678[(14)] = inst_11545);

(statearr_11678[(15)] = inst_11586);

(statearr_11678[(16)] = inst_11547);

(statearr_11678[(17)] = inst_11548);

return statearr_11678;
})();
var statearr_11679_11760 = state_11668__$1;
(statearr_11679_11760[(2)] = null);

(statearr_11679_11760[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (39))){
var state_11668__$1 = state_11668;
var statearr_11683_11761 = state_11668__$1;
(statearr_11683_11761[(2)] = null);

(statearr_11683_11761[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (4))){
var inst_11536 = (state_11668[(12)]);
var inst_11536__$1 = (state_11668[(2)]);
var inst_11537 = (inst_11536__$1 == null);
var state_11668__$1 = (function (){var statearr_11684 = state_11668;
(statearr_11684[(12)] = inst_11536__$1);

return statearr_11684;
})();
if(cljs.core.truth_(inst_11537)){
var statearr_11685_11762 = state_11668__$1;
(statearr_11685_11762[(1)] = (5));

} else {
var statearr_11686_11763 = state_11668__$1;
(statearr_11686_11763[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (15))){
var inst_11546 = (state_11668[(13)]);
var inst_11545 = (state_11668[(14)]);
var inst_11547 = (state_11668[(16)]);
var inst_11548 = (state_11668[(17)]);
var inst_11563 = (state_11668[(2)]);
var inst_11564 = (inst_11548 + (1));
var tmp11680 = inst_11546;
var tmp11681 = inst_11545;
var tmp11682 = inst_11547;
var inst_11545__$1 = tmp11681;
var inst_11546__$1 = tmp11680;
var inst_11547__$1 = tmp11682;
var inst_11548__$1 = inst_11564;
var state_11668__$1 = (function (){var statearr_11687 = state_11668;
(statearr_11687[(13)] = inst_11546__$1);

(statearr_11687[(14)] = inst_11545__$1);

(statearr_11687[(16)] = inst_11547__$1);

(statearr_11687[(17)] = inst_11548__$1);

(statearr_11687[(18)] = inst_11563);

return statearr_11687;
})();
var statearr_11688_11764 = state_11668__$1;
(statearr_11688_11764[(2)] = null);

(statearr_11688_11764[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (21))){
var inst_11590 = (state_11668[(2)]);
var state_11668__$1 = state_11668;
var statearr_11692_11765 = state_11668__$1;
(statearr_11692_11765[(2)] = inst_11590);

(statearr_11692_11765[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (31))){
var inst_11616 = (state_11668[(10)]);
var inst_11620 = done.call(null,null);
var inst_11621 = cljs.core.async.untap_STAR_.call(null,m,inst_11616);
var state_11668__$1 = (function (){var statearr_11693 = state_11668;
(statearr_11693[(19)] = inst_11620);

return statearr_11693;
})();
var statearr_11694_11766 = state_11668__$1;
(statearr_11694_11766[(2)] = inst_11621);

(statearr_11694_11766[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (32))){
var inst_11611 = (state_11668[(9)]);
var inst_11609 = (state_11668[(11)]);
var inst_11610 = (state_11668[(20)]);
var inst_11608 = (state_11668[(21)]);
var inst_11623 = (state_11668[(2)]);
var inst_11624 = (inst_11611 + (1));
var tmp11689 = inst_11609;
var tmp11690 = inst_11610;
var tmp11691 = inst_11608;
var inst_11608__$1 = tmp11691;
var inst_11609__$1 = tmp11689;
var inst_11610__$1 = tmp11690;
var inst_11611__$1 = inst_11624;
var state_11668__$1 = (function (){var statearr_11695 = state_11668;
(statearr_11695[(9)] = inst_11611__$1);

(statearr_11695[(11)] = inst_11609__$1);

(statearr_11695[(20)] = inst_11610__$1);

(statearr_11695[(22)] = inst_11623);

(statearr_11695[(21)] = inst_11608__$1);

return statearr_11695;
})();
var statearr_11696_11767 = state_11668__$1;
(statearr_11696_11767[(2)] = null);

(statearr_11696_11767[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (40))){
var inst_11636 = (state_11668[(23)]);
var inst_11640 = done.call(null,null);
var inst_11641 = cljs.core.async.untap_STAR_.call(null,m,inst_11636);
var state_11668__$1 = (function (){var statearr_11697 = state_11668;
(statearr_11697[(24)] = inst_11640);

return statearr_11697;
})();
var statearr_11698_11768 = state_11668__$1;
(statearr_11698_11768[(2)] = inst_11641);

(statearr_11698_11768[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (33))){
var inst_11627 = (state_11668[(25)]);
var inst_11629 = cljs.core.chunked_seq_QMARK_.call(null,inst_11627);
var state_11668__$1 = state_11668;
if(inst_11629){
var statearr_11699_11769 = state_11668__$1;
(statearr_11699_11769[(1)] = (36));

} else {
var statearr_11700_11770 = state_11668__$1;
(statearr_11700_11770[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (13))){
var inst_11557 = (state_11668[(26)]);
var inst_11560 = cljs.core.async.close_BANG_.call(null,inst_11557);
var state_11668__$1 = state_11668;
var statearr_11701_11771 = state_11668__$1;
(statearr_11701_11771[(2)] = inst_11560);

(statearr_11701_11771[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (22))){
var inst_11580 = (state_11668[(8)]);
var inst_11583 = cljs.core.async.close_BANG_.call(null,inst_11580);
var state_11668__$1 = state_11668;
var statearr_11702_11772 = state_11668__$1;
(statearr_11702_11772[(2)] = inst_11583);

(statearr_11702_11772[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (36))){
var inst_11627 = (state_11668[(25)]);
var inst_11631 = cljs.core.chunk_first.call(null,inst_11627);
var inst_11632 = cljs.core.chunk_rest.call(null,inst_11627);
var inst_11633 = cljs.core.count.call(null,inst_11631);
var inst_11608 = inst_11632;
var inst_11609 = inst_11631;
var inst_11610 = inst_11633;
var inst_11611 = (0);
var state_11668__$1 = (function (){var statearr_11703 = state_11668;
(statearr_11703[(9)] = inst_11611);

(statearr_11703[(11)] = inst_11609);

(statearr_11703[(20)] = inst_11610);

(statearr_11703[(21)] = inst_11608);

return statearr_11703;
})();
var statearr_11704_11773 = state_11668__$1;
(statearr_11704_11773[(2)] = null);

(statearr_11704_11773[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (41))){
var inst_11627 = (state_11668[(25)]);
var inst_11643 = (state_11668[(2)]);
var inst_11644 = cljs.core.next.call(null,inst_11627);
var inst_11608 = inst_11644;
var inst_11609 = null;
var inst_11610 = (0);
var inst_11611 = (0);
var state_11668__$1 = (function (){var statearr_11705 = state_11668;
(statearr_11705[(9)] = inst_11611);

(statearr_11705[(27)] = inst_11643);

(statearr_11705[(11)] = inst_11609);

(statearr_11705[(20)] = inst_11610);

(statearr_11705[(21)] = inst_11608);

return statearr_11705;
})();
var statearr_11706_11774 = state_11668__$1;
(statearr_11706_11774[(2)] = null);

(statearr_11706_11774[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (43))){
var state_11668__$1 = state_11668;
var statearr_11707_11775 = state_11668__$1;
(statearr_11707_11775[(2)] = null);

(statearr_11707_11775[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (29))){
var inst_11652 = (state_11668[(2)]);
var state_11668__$1 = state_11668;
var statearr_11708_11776 = state_11668__$1;
(statearr_11708_11776[(2)] = inst_11652);

(statearr_11708_11776[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (44))){
var inst_11661 = (state_11668[(2)]);
var state_11668__$1 = (function (){var statearr_11709 = state_11668;
(statearr_11709[(28)] = inst_11661);

return statearr_11709;
})();
var statearr_11710_11777 = state_11668__$1;
(statearr_11710_11777[(2)] = null);

(statearr_11710_11777[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (6))){
var inst_11600 = (state_11668[(29)]);
var inst_11599 = cljs.core.deref.call(null,cs);
var inst_11600__$1 = cljs.core.keys.call(null,inst_11599);
var inst_11601 = cljs.core.count.call(null,inst_11600__$1);
var inst_11602 = cljs.core.reset_BANG_.call(null,dctr,inst_11601);
var inst_11607 = cljs.core.seq.call(null,inst_11600__$1);
var inst_11608 = inst_11607;
var inst_11609 = null;
var inst_11610 = (0);
var inst_11611 = (0);
var state_11668__$1 = (function (){var statearr_11711 = state_11668;
(statearr_11711[(9)] = inst_11611);

(statearr_11711[(29)] = inst_11600__$1);

(statearr_11711[(11)] = inst_11609);

(statearr_11711[(30)] = inst_11602);

(statearr_11711[(20)] = inst_11610);

(statearr_11711[(21)] = inst_11608);

return statearr_11711;
})();
var statearr_11712_11778 = state_11668__$1;
(statearr_11712_11778[(2)] = null);

(statearr_11712_11778[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (28))){
var inst_11608 = (state_11668[(21)]);
var inst_11627 = (state_11668[(25)]);
var inst_11627__$1 = cljs.core.seq.call(null,inst_11608);
var state_11668__$1 = (function (){var statearr_11713 = state_11668;
(statearr_11713[(25)] = inst_11627__$1);

return statearr_11713;
})();
if(inst_11627__$1){
var statearr_11714_11779 = state_11668__$1;
(statearr_11714_11779[(1)] = (33));

} else {
var statearr_11715_11780 = state_11668__$1;
(statearr_11715_11780[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (25))){
var inst_11611 = (state_11668[(9)]);
var inst_11610 = (state_11668[(20)]);
var inst_11613 = (inst_11611 < inst_11610);
var inst_11614 = inst_11613;
var state_11668__$1 = state_11668;
if(cljs.core.truth_(inst_11614)){
var statearr_11716_11781 = state_11668__$1;
(statearr_11716_11781[(1)] = (27));

} else {
var statearr_11717_11782 = state_11668__$1;
(statearr_11717_11782[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (34))){
var state_11668__$1 = state_11668;
var statearr_11718_11783 = state_11668__$1;
(statearr_11718_11783[(2)] = null);

(statearr_11718_11783[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (17))){
var state_11668__$1 = state_11668;
var statearr_11719_11784 = state_11668__$1;
(statearr_11719_11784[(2)] = null);

(statearr_11719_11784[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (3))){
var inst_11666 = (state_11668[(2)]);
var state_11668__$1 = state_11668;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11668__$1,inst_11666);
} else {
if((state_val_11669 === (12))){
var inst_11595 = (state_11668[(2)]);
var state_11668__$1 = state_11668;
var statearr_11720_11785 = state_11668__$1;
(statearr_11720_11785[(2)] = inst_11595);

(statearr_11720_11785[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (2))){
var state_11668__$1 = state_11668;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11668__$1,(4),ch);
} else {
if((state_val_11669 === (23))){
var state_11668__$1 = state_11668;
var statearr_11721_11786 = state_11668__$1;
(statearr_11721_11786[(2)] = null);

(statearr_11721_11786[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (35))){
var inst_11650 = (state_11668[(2)]);
var state_11668__$1 = state_11668;
var statearr_11722_11787 = state_11668__$1;
(statearr_11722_11787[(2)] = inst_11650);

(statearr_11722_11787[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (19))){
var inst_11567 = (state_11668[(7)]);
var inst_11571 = cljs.core.chunk_first.call(null,inst_11567);
var inst_11572 = cljs.core.chunk_rest.call(null,inst_11567);
var inst_11573 = cljs.core.count.call(null,inst_11571);
var inst_11545 = inst_11572;
var inst_11546 = inst_11571;
var inst_11547 = inst_11573;
var inst_11548 = (0);
var state_11668__$1 = (function (){var statearr_11723 = state_11668;
(statearr_11723[(13)] = inst_11546);

(statearr_11723[(14)] = inst_11545);

(statearr_11723[(16)] = inst_11547);

(statearr_11723[(17)] = inst_11548);

return statearr_11723;
})();
var statearr_11724_11788 = state_11668__$1;
(statearr_11724_11788[(2)] = null);

(statearr_11724_11788[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (11))){
var inst_11545 = (state_11668[(14)]);
var inst_11567 = (state_11668[(7)]);
var inst_11567__$1 = cljs.core.seq.call(null,inst_11545);
var state_11668__$1 = (function (){var statearr_11725 = state_11668;
(statearr_11725[(7)] = inst_11567__$1);

return statearr_11725;
})();
if(inst_11567__$1){
var statearr_11726_11789 = state_11668__$1;
(statearr_11726_11789[(1)] = (16));

} else {
var statearr_11727_11790 = state_11668__$1;
(statearr_11727_11790[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (9))){
var inst_11597 = (state_11668[(2)]);
var state_11668__$1 = state_11668;
var statearr_11728_11791 = state_11668__$1;
(statearr_11728_11791[(2)] = inst_11597);

(statearr_11728_11791[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (5))){
var inst_11543 = cljs.core.deref.call(null,cs);
var inst_11544 = cljs.core.seq.call(null,inst_11543);
var inst_11545 = inst_11544;
var inst_11546 = null;
var inst_11547 = (0);
var inst_11548 = (0);
var state_11668__$1 = (function (){var statearr_11729 = state_11668;
(statearr_11729[(13)] = inst_11546);

(statearr_11729[(14)] = inst_11545);

(statearr_11729[(16)] = inst_11547);

(statearr_11729[(17)] = inst_11548);

return statearr_11729;
})();
var statearr_11730_11792 = state_11668__$1;
(statearr_11730_11792[(2)] = null);

(statearr_11730_11792[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (14))){
var state_11668__$1 = state_11668;
var statearr_11731_11793 = state_11668__$1;
(statearr_11731_11793[(2)] = null);

(statearr_11731_11793[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (45))){
var inst_11658 = (state_11668[(2)]);
var state_11668__$1 = state_11668;
var statearr_11732_11794 = state_11668__$1;
(statearr_11732_11794[(2)] = inst_11658);

(statearr_11732_11794[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (26))){
var inst_11600 = (state_11668[(29)]);
var inst_11654 = (state_11668[(2)]);
var inst_11655 = cljs.core.seq.call(null,inst_11600);
var state_11668__$1 = (function (){var statearr_11733 = state_11668;
(statearr_11733[(31)] = inst_11654);

return statearr_11733;
})();
if(inst_11655){
var statearr_11734_11795 = state_11668__$1;
(statearr_11734_11795[(1)] = (42));

} else {
var statearr_11735_11796 = state_11668__$1;
(statearr_11735_11796[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (16))){
var inst_11567 = (state_11668[(7)]);
var inst_11569 = cljs.core.chunked_seq_QMARK_.call(null,inst_11567);
var state_11668__$1 = state_11668;
if(inst_11569){
var statearr_11736_11797 = state_11668__$1;
(statearr_11736_11797[(1)] = (19));

} else {
var statearr_11737_11798 = state_11668__$1;
(statearr_11737_11798[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (38))){
var inst_11647 = (state_11668[(2)]);
var state_11668__$1 = state_11668;
var statearr_11738_11799 = state_11668__$1;
(statearr_11738_11799[(2)] = inst_11647);

(statearr_11738_11799[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (30))){
var state_11668__$1 = state_11668;
var statearr_11739_11800 = state_11668__$1;
(statearr_11739_11800[(2)] = null);

(statearr_11739_11800[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (10))){
var inst_11546 = (state_11668[(13)]);
var inst_11548 = (state_11668[(17)]);
var inst_11556 = cljs.core._nth.call(null,inst_11546,inst_11548);
var inst_11557 = cljs.core.nth.call(null,inst_11556,(0),null);
var inst_11558 = cljs.core.nth.call(null,inst_11556,(1),null);
var state_11668__$1 = (function (){var statearr_11740 = state_11668;
(statearr_11740[(26)] = inst_11557);

return statearr_11740;
})();
if(cljs.core.truth_(inst_11558)){
var statearr_11741_11801 = state_11668__$1;
(statearr_11741_11801[(1)] = (13));

} else {
var statearr_11742_11802 = state_11668__$1;
(statearr_11742_11802[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (18))){
var inst_11593 = (state_11668[(2)]);
var state_11668__$1 = state_11668;
var statearr_11743_11803 = state_11668__$1;
(statearr_11743_11803[(2)] = inst_11593);

(statearr_11743_11803[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (42))){
var state_11668__$1 = state_11668;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11668__$1,(45),dchan);
} else {
if((state_val_11669 === (37))){
var inst_11636 = (state_11668[(23)]);
var inst_11536 = (state_11668[(12)]);
var inst_11627 = (state_11668[(25)]);
var inst_11636__$1 = cljs.core.first.call(null,inst_11627);
var inst_11637 = cljs.core.async.put_BANG_.call(null,inst_11636__$1,inst_11536,done);
var state_11668__$1 = (function (){var statearr_11744 = state_11668;
(statearr_11744[(23)] = inst_11636__$1);

return statearr_11744;
})();
if(cljs.core.truth_(inst_11637)){
var statearr_11745_11804 = state_11668__$1;
(statearr_11745_11804[(1)] = (39));

} else {
var statearr_11746_11805 = state_11668__$1;
(statearr_11746_11805[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11669 === (8))){
var inst_11547 = (state_11668[(16)]);
var inst_11548 = (state_11668[(17)]);
var inst_11550 = (inst_11548 < inst_11547);
var inst_11551 = inst_11550;
var state_11668__$1 = state_11668;
if(cljs.core.truth_(inst_11551)){
var statearr_11747_11806 = state_11668__$1;
(statearr_11747_11806[(1)] = (10));

} else {
var statearr_11748_11807 = state_11668__$1;
(statearr_11748_11807[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9890__auto___11753,cs,m,dchan,dctr,done))
;
return ((function (switch__9875__auto__,c__9890__auto___11753,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__9876__auto__ = null;
var cljs$core$async$mult_$_state_machine__9876__auto____0 = (function (){
var statearr_11749 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11749[(0)] = cljs$core$async$mult_$_state_machine__9876__auto__);

(statearr_11749[(1)] = (1));

return statearr_11749;
});
var cljs$core$async$mult_$_state_machine__9876__auto____1 = (function (state_11668){
while(true){
var ret_value__9877__auto__ = (function (){try{while(true){
var result__9878__auto__ = switch__9875__auto__.call(null,state_11668);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9878__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9878__auto__;
}
break;
}
}catch (e11750){if((e11750 instanceof Object)){
var ex__9879__auto__ = e11750;
var statearr_11751_11808 = state_11668;
(statearr_11751_11808[(5)] = ex__9879__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11668);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11750;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11809 = state_11668;
state_11668 = G__11809;
continue;
} else {
return ret_value__9877__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__9876__auto__ = function(state_11668){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__9876__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__9876__auto____1.call(this,state_11668);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__9876__auto____0;
cljs$core$async$mult_$_state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__9876__auto____1;
return cljs$core$async$mult_$_state_machine__9876__auto__;
})()
;})(switch__9875__auto__,c__9890__auto___11753,cs,m,dchan,dctr,done))
})();
var state__9892__auto__ = (function (){var statearr_11752 = f__9891__auto__.call(null);
(statearr_11752[(6)] = c__9890__auto___11753);

return statearr_11752;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9892__auto__);
});})(c__9890__auto___11753,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__11811 = arguments.length;
switch (G__11811) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__8120__auto__ = (((m == null))?null:m);
var m__8121__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__8120__auto__)]);
if(!((m__8121__auto__ == null))){
return m__8121__auto__.call(null,m,ch);
} else {
var m__8121__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__8121__auto____$1 == null))){
return m__8121__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__8120__auto__ = (((m == null))?null:m);
var m__8121__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__8120__auto__)]);
if(!((m__8121__auto__ == null))){
return m__8121__auto__.call(null,m,ch);
} else {
var m__8121__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__8121__auto____$1 == null))){
return m__8121__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__8120__auto__ = (((m == null))?null:m);
var m__8121__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__8120__auto__)]);
if(!((m__8121__auto__ == null))){
return m__8121__auto__.call(null,m);
} else {
var m__8121__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__8121__auto____$1 == null))){
return m__8121__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__8120__auto__ = (((m == null))?null:m);
var m__8121__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__8120__auto__)]);
if(!((m__8121__auto__ == null))){
return m__8121__auto__.call(null,m,state_map);
} else {
var m__8121__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__8121__auto____$1 == null))){
return m__8121__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__8120__auto__ = (((m == null))?null:m);
var m__8121__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__8120__auto__)]);
if(!((m__8121__auto__ == null))){
return m__8121__auto__.call(null,m,mode);
} else {
var m__8121__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__8121__auto____$1 == null))){
return m__8121__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__8583__auto__ = [];
var len__8576__auto___11823 = arguments.length;
var i__8577__auto___11824 = (0);
while(true){
if((i__8577__auto___11824 < len__8576__auto___11823)){
args__8583__auto__.push((arguments[i__8577__auto___11824]));

var G__11825 = (i__8577__auto___11824 + (1));
i__8577__auto___11824 = G__11825;
continue;
} else {
}
break;
}

var argseq__8584__auto__ = ((((3) < args__8583__auto__.length))?(new cljs.core.IndexedSeq(args__8583__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8584__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__11817){
var map__11818 = p__11817;
var map__11818__$1 = ((((!((map__11818 == null)))?((((map__11818.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11818.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11818):map__11818);
var opts = map__11818__$1;
var statearr_11820_11826 = state;
(statearr_11820_11826[(1)] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__11818,map__11818__$1,opts){
return (function (val){
var statearr_11821_11827 = state;
(statearr_11821_11827[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__11818,map__11818__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_11822_11828 = state;
(statearr_11822_11828[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq11813){
var G__11814 = cljs.core.first.call(null,seq11813);
var seq11813__$1 = cljs.core.next.call(null,seq11813);
var G__11815 = cljs.core.first.call(null,seq11813__$1);
var seq11813__$2 = cljs.core.next.call(null,seq11813__$1);
var G__11816 = cljs.core.first.call(null,seq11813__$2);
var seq11813__$3 = cljs.core.next.call(null,seq11813__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11814,G__11815,G__11816,seq11813__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async11829 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11829 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta11830){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta11830 = meta11830;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async11829.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_11831,meta11830__$1){
var self__ = this;
var _11831__$1 = this;
return (new cljs.core.async.t_cljs$core$async11829(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta11830__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async11829.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_11831){
var self__ = this;
var _11831__$1 = this;
return self__.meta11830;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async11829.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async11829.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async11829.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async11829.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async11829.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async11829.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async11829.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async11829.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1("mode must be one of: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async11829.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta11830","meta11830",1975509754,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async11829.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11829.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11829";

cljs.core.async.t_cljs$core$async11829.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__8062__auto__,writer__8063__auto__,opt__8064__auto__){
return cljs.core._write.call(null,writer__8063__auto__,"cljs.core.async/t_cljs$core$async11829");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async11829 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async11829(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta11830){
return (new cljs.core.async.t_cljs$core$async11829(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta11830));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async11829(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__9890__auto___11993 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9890__auto___11993,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__9891__auto__ = (function (){var switch__9875__auto__ = ((function (c__9890__auto___11993,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_11933){
var state_val_11934 = (state_11933[(1)]);
if((state_val_11934 === (7))){
var inst_11848 = (state_11933[(2)]);
var state_11933__$1 = state_11933;
var statearr_11935_11994 = state_11933__$1;
(statearr_11935_11994[(2)] = inst_11848);

(statearr_11935_11994[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11934 === (20))){
var inst_11860 = (state_11933[(7)]);
var state_11933__$1 = state_11933;
var statearr_11936_11995 = state_11933__$1;
(statearr_11936_11995[(2)] = inst_11860);

(statearr_11936_11995[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11934 === (27))){
var state_11933__$1 = state_11933;
var statearr_11937_11996 = state_11933__$1;
(statearr_11937_11996[(2)] = null);

(statearr_11937_11996[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11934 === (1))){
var inst_11835 = (state_11933[(8)]);
var inst_11835__$1 = calc_state.call(null);
var inst_11837 = (inst_11835__$1 == null);
var inst_11838 = cljs.core.not.call(null,inst_11837);
var state_11933__$1 = (function (){var statearr_11938 = state_11933;
(statearr_11938[(8)] = inst_11835__$1);

return statearr_11938;
})();
if(inst_11838){
var statearr_11939_11997 = state_11933__$1;
(statearr_11939_11997[(1)] = (2));

} else {
var statearr_11940_11998 = state_11933__$1;
(statearr_11940_11998[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11934 === (24))){
var inst_11884 = (state_11933[(9)]);
var inst_11907 = (state_11933[(10)]);
var inst_11893 = (state_11933[(11)]);
var inst_11907__$1 = inst_11884.call(null,inst_11893);
var state_11933__$1 = (function (){var statearr_11941 = state_11933;
(statearr_11941[(10)] = inst_11907__$1);

return statearr_11941;
})();
if(cljs.core.truth_(inst_11907__$1)){
var statearr_11942_11999 = state_11933__$1;
(statearr_11942_11999[(1)] = (29));

} else {
var statearr_11943_12000 = state_11933__$1;
(statearr_11943_12000[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11934 === (4))){
var inst_11851 = (state_11933[(2)]);
var state_11933__$1 = state_11933;
if(cljs.core.truth_(inst_11851)){
var statearr_11944_12001 = state_11933__$1;
(statearr_11944_12001[(1)] = (8));

} else {
var statearr_11945_12002 = state_11933__$1;
(statearr_11945_12002[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11934 === (15))){
var inst_11878 = (state_11933[(2)]);
var state_11933__$1 = state_11933;
if(cljs.core.truth_(inst_11878)){
var statearr_11946_12003 = state_11933__$1;
(statearr_11946_12003[(1)] = (19));

} else {
var statearr_11947_12004 = state_11933__$1;
(statearr_11947_12004[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11934 === (21))){
var inst_11883 = (state_11933[(12)]);
var inst_11883__$1 = (state_11933[(2)]);
var inst_11884 = cljs.core.get.call(null,inst_11883__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_11885 = cljs.core.get.call(null,inst_11883__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_11886 = cljs.core.get.call(null,inst_11883__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_11933__$1 = (function (){var statearr_11948 = state_11933;
(statearr_11948[(9)] = inst_11884);

(statearr_11948[(13)] = inst_11885);

(statearr_11948[(12)] = inst_11883__$1);

return statearr_11948;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_11933__$1,(22),inst_11886);
} else {
if((state_val_11934 === (31))){
var inst_11915 = (state_11933[(2)]);
var state_11933__$1 = state_11933;
if(cljs.core.truth_(inst_11915)){
var statearr_11949_12005 = state_11933__$1;
(statearr_11949_12005[(1)] = (32));

} else {
var statearr_11950_12006 = state_11933__$1;
(statearr_11950_12006[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11934 === (32))){
var inst_11892 = (state_11933[(14)]);
var state_11933__$1 = state_11933;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11933__$1,(35),out,inst_11892);
} else {
if((state_val_11934 === (33))){
var inst_11883 = (state_11933[(12)]);
var inst_11860 = inst_11883;
var state_11933__$1 = (function (){var statearr_11951 = state_11933;
(statearr_11951[(7)] = inst_11860);

return statearr_11951;
})();
var statearr_11952_12007 = state_11933__$1;
(statearr_11952_12007[(2)] = null);

(statearr_11952_12007[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11934 === (13))){
var inst_11860 = (state_11933[(7)]);
var inst_11867 = inst_11860.cljs$lang$protocol_mask$partition0$;
var inst_11868 = (inst_11867 & (64));
var inst_11869 = inst_11860.cljs$core$ISeq$;
var inst_11870 = (cljs.core.PROTOCOL_SENTINEL === inst_11869);
var inst_11871 = (inst_11868) || (inst_11870);
var state_11933__$1 = state_11933;
if(cljs.core.truth_(inst_11871)){
var statearr_11953_12008 = state_11933__$1;
(statearr_11953_12008[(1)] = (16));

} else {
var statearr_11954_12009 = state_11933__$1;
(statearr_11954_12009[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11934 === (22))){
var inst_11893 = (state_11933[(11)]);
var inst_11892 = (state_11933[(14)]);
var inst_11891 = (state_11933[(2)]);
var inst_11892__$1 = cljs.core.nth.call(null,inst_11891,(0),null);
var inst_11893__$1 = cljs.core.nth.call(null,inst_11891,(1),null);
var inst_11894 = (inst_11892__$1 == null);
var inst_11895 = cljs.core._EQ_.call(null,inst_11893__$1,change);
var inst_11896 = (inst_11894) || (inst_11895);
var state_11933__$1 = (function (){var statearr_11955 = state_11933;
(statearr_11955[(11)] = inst_11893__$1);

(statearr_11955[(14)] = inst_11892__$1);

return statearr_11955;
})();
if(cljs.core.truth_(inst_11896)){
var statearr_11956_12010 = state_11933__$1;
(statearr_11956_12010[(1)] = (23));

} else {
var statearr_11957_12011 = state_11933__$1;
(statearr_11957_12011[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11934 === (36))){
var inst_11883 = (state_11933[(12)]);
var inst_11860 = inst_11883;
var state_11933__$1 = (function (){var statearr_11958 = state_11933;
(statearr_11958[(7)] = inst_11860);

return statearr_11958;
})();
var statearr_11959_12012 = state_11933__$1;
(statearr_11959_12012[(2)] = null);

(statearr_11959_12012[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11934 === (29))){
var inst_11907 = (state_11933[(10)]);
var state_11933__$1 = state_11933;
var statearr_11960_12013 = state_11933__$1;
(statearr_11960_12013[(2)] = inst_11907);

(statearr_11960_12013[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11934 === (6))){
var state_11933__$1 = state_11933;
var statearr_11961_12014 = state_11933__$1;
(statearr_11961_12014[(2)] = false);

(statearr_11961_12014[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11934 === (28))){
var inst_11903 = (state_11933[(2)]);
var inst_11904 = calc_state.call(null);
var inst_11860 = inst_11904;
var state_11933__$1 = (function (){var statearr_11962 = state_11933;
(statearr_11962[(7)] = inst_11860);

(statearr_11962[(15)] = inst_11903);

return statearr_11962;
})();
var statearr_11963_12015 = state_11933__$1;
(statearr_11963_12015[(2)] = null);

(statearr_11963_12015[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11934 === (25))){
var inst_11929 = (state_11933[(2)]);
var state_11933__$1 = state_11933;
var statearr_11964_12016 = state_11933__$1;
(statearr_11964_12016[(2)] = inst_11929);

(statearr_11964_12016[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11934 === (34))){
var inst_11927 = (state_11933[(2)]);
var state_11933__$1 = state_11933;
var statearr_11965_12017 = state_11933__$1;
(statearr_11965_12017[(2)] = inst_11927);

(statearr_11965_12017[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11934 === (17))){
var state_11933__$1 = state_11933;
var statearr_11966_12018 = state_11933__$1;
(statearr_11966_12018[(2)] = false);

(statearr_11966_12018[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11934 === (3))){
var state_11933__$1 = state_11933;
var statearr_11967_12019 = state_11933__$1;
(statearr_11967_12019[(2)] = false);

(statearr_11967_12019[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11934 === (12))){
var inst_11931 = (state_11933[(2)]);
var state_11933__$1 = state_11933;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11933__$1,inst_11931);
} else {
if((state_val_11934 === (2))){
var inst_11835 = (state_11933[(8)]);
var inst_11840 = inst_11835.cljs$lang$protocol_mask$partition0$;
var inst_11841 = (inst_11840 & (64));
var inst_11842 = inst_11835.cljs$core$ISeq$;
var inst_11843 = (cljs.core.PROTOCOL_SENTINEL === inst_11842);
var inst_11844 = (inst_11841) || (inst_11843);
var state_11933__$1 = state_11933;
if(cljs.core.truth_(inst_11844)){
var statearr_11968_12020 = state_11933__$1;
(statearr_11968_12020[(1)] = (5));

} else {
var statearr_11969_12021 = state_11933__$1;
(statearr_11969_12021[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11934 === (23))){
var inst_11892 = (state_11933[(14)]);
var inst_11898 = (inst_11892 == null);
var state_11933__$1 = state_11933;
if(cljs.core.truth_(inst_11898)){
var statearr_11970_12022 = state_11933__$1;
(statearr_11970_12022[(1)] = (26));

} else {
var statearr_11971_12023 = state_11933__$1;
(statearr_11971_12023[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11934 === (35))){
var inst_11918 = (state_11933[(2)]);
var state_11933__$1 = state_11933;
if(cljs.core.truth_(inst_11918)){
var statearr_11972_12024 = state_11933__$1;
(statearr_11972_12024[(1)] = (36));

} else {
var statearr_11973_12025 = state_11933__$1;
(statearr_11973_12025[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11934 === (19))){
var inst_11860 = (state_11933[(7)]);
var inst_11880 = cljs.core.apply.call(null,cljs.core.hash_map,inst_11860);
var state_11933__$1 = state_11933;
var statearr_11974_12026 = state_11933__$1;
(statearr_11974_12026[(2)] = inst_11880);

(statearr_11974_12026[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11934 === (11))){
var inst_11860 = (state_11933[(7)]);
var inst_11864 = (inst_11860 == null);
var inst_11865 = cljs.core.not.call(null,inst_11864);
var state_11933__$1 = state_11933;
if(inst_11865){
var statearr_11975_12027 = state_11933__$1;
(statearr_11975_12027[(1)] = (13));

} else {
var statearr_11976_12028 = state_11933__$1;
(statearr_11976_12028[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11934 === (9))){
var inst_11835 = (state_11933[(8)]);
var state_11933__$1 = state_11933;
var statearr_11977_12029 = state_11933__$1;
(statearr_11977_12029[(2)] = inst_11835);

(statearr_11977_12029[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11934 === (5))){
var state_11933__$1 = state_11933;
var statearr_11978_12030 = state_11933__$1;
(statearr_11978_12030[(2)] = true);

(statearr_11978_12030[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11934 === (14))){
var state_11933__$1 = state_11933;
var statearr_11979_12031 = state_11933__$1;
(statearr_11979_12031[(2)] = false);

(statearr_11979_12031[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11934 === (26))){
var inst_11893 = (state_11933[(11)]);
var inst_11900 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_11893);
var state_11933__$1 = state_11933;
var statearr_11980_12032 = state_11933__$1;
(statearr_11980_12032[(2)] = inst_11900);

(statearr_11980_12032[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11934 === (16))){
var state_11933__$1 = state_11933;
var statearr_11981_12033 = state_11933__$1;
(statearr_11981_12033[(2)] = true);

(statearr_11981_12033[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11934 === (38))){
var inst_11923 = (state_11933[(2)]);
var state_11933__$1 = state_11933;
var statearr_11982_12034 = state_11933__$1;
(statearr_11982_12034[(2)] = inst_11923);

(statearr_11982_12034[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11934 === (30))){
var inst_11884 = (state_11933[(9)]);
var inst_11885 = (state_11933[(13)]);
var inst_11893 = (state_11933[(11)]);
var inst_11910 = cljs.core.empty_QMARK_.call(null,inst_11884);
var inst_11911 = inst_11885.call(null,inst_11893);
var inst_11912 = cljs.core.not.call(null,inst_11911);
var inst_11913 = (inst_11910) && (inst_11912);
var state_11933__$1 = state_11933;
var statearr_11983_12035 = state_11933__$1;
(statearr_11983_12035[(2)] = inst_11913);

(statearr_11983_12035[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11934 === (10))){
var inst_11835 = (state_11933[(8)]);
var inst_11856 = (state_11933[(2)]);
var inst_11857 = cljs.core.get.call(null,inst_11856,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_11858 = cljs.core.get.call(null,inst_11856,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_11859 = cljs.core.get.call(null,inst_11856,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_11860 = inst_11835;
var state_11933__$1 = (function (){var statearr_11984 = state_11933;
(statearr_11984[(16)] = inst_11858);

(statearr_11984[(7)] = inst_11860);

(statearr_11984[(17)] = inst_11857);

(statearr_11984[(18)] = inst_11859);

return statearr_11984;
})();
var statearr_11985_12036 = state_11933__$1;
(statearr_11985_12036[(2)] = null);

(statearr_11985_12036[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11934 === (18))){
var inst_11875 = (state_11933[(2)]);
var state_11933__$1 = state_11933;
var statearr_11986_12037 = state_11933__$1;
(statearr_11986_12037[(2)] = inst_11875);

(statearr_11986_12037[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11934 === (37))){
var state_11933__$1 = state_11933;
var statearr_11987_12038 = state_11933__$1;
(statearr_11987_12038[(2)] = null);

(statearr_11987_12038[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11934 === (8))){
var inst_11835 = (state_11933[(8)]);
var inst_11853 = cljs.core.apply.call(null,cljs.core.hash_map,inst_11835);
var state_11933__$1 = state_11933;
var statearr_11988_12039 = state_11933__$1;
(statearr_11988_12039[(2)] = inst_11853);

(statearr_11988_12039[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9890__auto___11993,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__9875__auto__,c__9890__auto___11993,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__9876__auto__ = null;
var cljs$core$async$mix_$_state_machine__9876__auto____0 = (function (){
var statearr_11989 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11989[(0)] = cljs$core$async$mix_$_state_machine__9876__auto__);

(statearr_11989[(1)] = (1));

return statearr_11989;
});
var cljs$core$async$mix_$_state_machine__9876__auto____1 = (function (state_11933){
while(true){
var ret_value__9877__auto__ = (function (){try{while(true){
var result__9878__auto__ = switch__9875__auto__.call(null,state_11933);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9878__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9878__auto__;
}
break;
}
}catch (e11990){if((e11990 instanceof Object)){
var ex__9879__auto__ = e11990;
var statearr_11991_12040 = state_11933;
(statearr_11991_12040[(5)] = ex__9879__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11933);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11990;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12041 = state_11933;
state_11933 = G__12041;
continue;
} else {
return ret_value__9877__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__9876__auto__ = function(state_11933){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__9876__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__9876__auto____1.call(this,state_11933);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__9876__auto____0;
cljs$core$async$mix_$_state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__9876__auto____1;
return cljs$core$async$mix_$_state_machine__9876__auto__;
})()
;})(switch__9875__auto__,c__9890__auto___11993,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__9892__auto__ = (function (){var statearr_11992 = f__9891__auto__.call(null);
(statearr_11992[(6)] = c__9890__auto___11993);

return statearr_11992;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9892__auto__);
});})(c__9890__auto___11993,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__8120__auto__ = (((p == null))?null:p);
var m__8121__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__8120__auto__)]);
if(!((m__8121__auto__ == null))){
return m__8121__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__8121__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__8121__auto____$1 == null))){
return m__8121__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__8120__auto__ = (((p == null))?null:p);
var m__8121__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__8120__auto__)]);
if(!((m__8121__auto__ == null))){
return m__8121__auto__.call(null,p,v,ch);
} else {
var m__8121__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__8121__auto____$1 == null))){
return m__8121__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__12043 = arguments.length;
switch (G__12043) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__8120__auto__ = (((p == null))?null:p);
var m__8121__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__8120__auto__)]);
if(!((m__8121__auto__ == null))){
return m__8121__auto__.call(null,p);
} else {
var m__8121__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__8121__auto____$1 == null))){
return m__8121__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__8120__auto__ = (((p == null))?null:p);
var m__8121__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__8120__auto__)]);
if(!((m__8121__auto__ == null))){
return m__8121__auto__.call(null,p,v);
} else {
var m__8121__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__8121__auto____$1 == null))){
return m__8121__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__12047 = arguments.length;
switch (G__12047) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__7451__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__7451__auto__)){
return or__7451__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__7451__auto__,mults){
return (function (p1__12045_SHARP_){
if(cljs.core.truth_(p1__12045_SHARP_.call(null,topic))){
return p1__12045_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__12045_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__7451__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async12048 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12048 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta12049){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta12049 = meta12049;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async12048.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_12050,meta12049__$1){
var self__ = this;
var _12050__$1 = this;
return (new cljs.core.async.t_cljs$core$async12048(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta12049__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12048.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_12050){
var self__ = this;
var _12050__$1 = this;
return self__.meta12049;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12048.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12048.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12048.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12048.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12048.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12048.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12048.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12048.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta12049","meta12049",1367582293,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12048.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12048.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12048";

cljs.core.async.t_cljs$core$async12048.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__8062__auto__,writer__8063__auto__,opt__8064__auto__){
return cljs.core._write.call(null,writer__8063__auto__,"cljs.core.async/t_cljs$core$async12048");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async12048 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async12048(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12049){
return (new cljs.core.async.t_cljs$core$async12048(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12049));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async12048(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__9890__auto___12168 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9890__auto___12168,mults,ensure_mult,p){
return (function (){
var f__9891__auto__ = (function (){var switch__9875__auto__ = ((function (c__9890__auto___12168,mults,ensure_mult,p){
return (function (state_12122){
var state_val_12123 = (state_12122[(1)]);
if((state_val_12123 === (7))){
var inst_12118 = (state_12122[(2)]);
var state_12122__$1 = state_12122;
var statearr_12124_12169 = state_12122__$1;
(statearr_12124_12169[(2)] = inst_12118);

(statearr_12124_12169[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12123 === (20))){
var state_12122__$1 = state_12122;
var statearr_12125_12170 = state_12122__$1;
(statearr_12125_12170[(2)] = null);

(statearr_12125_12170[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12123 === (1))){
var state_12122__$1 = state_12122;
var statearr_12126_12171 = state_12122__$1;
(statearr_12126_12171[(2)] = null);

(statearr_12126_12171[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12123 === (24))){
var inst_12101 = (state_12122[(7)]);
var inst_12110 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_12101);
var state_12122__$1 = state_12122;
var statearr_12127_12172 = state_12122__$1;
(statearr_12127_12172[(2)] = inst_12110);

(statearr_12127_12172[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12123 === (4))){
var inst_12053 = (state_12122[(8)]);
var inst_12053__$1 = (state_12122[(2)]);
var inst_12054 = (inst_12053__$1 == null);
var state_12122__$1 = (function (){var statearr_12128 = state_12122;
(statearr_12128[(8)] = inst_12053__$1);

return statearr_12128;
})();
if(cljs.core.truth_(inst_12054)){
var statearr_12129_12173 = state_12122__$1;
(statearr_12129_12173[(1)] = (5));

} else {
var statearr_12130_12174 = state_12122__$1;
(statearr_12130_12174[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12123 === (15))){
var inst_12095 = (state_12122[(2)]);
var state_12122__$1 = state_12122;
var statearr_12131_12175 = state_12122__$1;
(statearr_12131_12175[(2)] = inst_12095);

(statearr_12131_12175[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12123 === (21))){
var inst_12115 = (state_12122[(2)]);
var state_12122__$1 = (function (){var statearr_12132 = state_12122;
(statearr_12132[(9)] = inst_12115);

return statearr_12132;
})();
var statearr_12133_12176 = state_12122__$1;
(statearr_12133_12176[(2)] = null);

(statearr_12133_12176[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12123 === (13))){
var inst_12077 = (state_12122[(10)]);
var inst_12079 = cljs.core.chunked_seq_QMARK_.call(null,inst_12077);
var state_12122__$1 = state_12122;
if(inst_12079){
var statearr_12134_12177 = state_12122__$1;
(statearr_12134_12177[(1)] = (16));

} else {
var statearr_12135_12178 = state_12122__$1;
(statearr_12135_12178[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12123 === (22))){
var inst_12107 = (state_12122[(2)]);
var state_12122__$1 = state_12122;
if(cljs.core.truth_(inst_12107)){
var statearr_12136_12179 = state_12122__$1;
(statearr_12136_12179[(1)] = (23));

} else {
var statearr_12137_12180 = state_12122__$1;
(statearr_12137_12180[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12123 === (6))){
var inst_12103 = (state_12122[(11)]);
var inst_12053 = (state_12122[(8)]);
var inst_12101 = (state_12122[(7)]);
var inst_12101__$1 = topic_fn.call(null,inst_12053);
var inst_12102 = cljs.core.deref.call(null,mults);
var inst_12103__$1 = cljs.core.get.call(null,inst_12102,inst_12101__$1);
var state_12122__$1 = (function (){var statearr_12138 = state_12122;
(statearr_12138[(11)] = inst_12103__$1);

(statearr_12138[(7)] = inst_12101__$1);

return statearr_12138;
})();
if(cljs.core.truth_(inst_12103__$1)){
var statearr_12139_12181 = state_12122__$1;
(statearr_12139_12181[(1)] = (19));

} else {
var statearr_12140_12182 = state_12122__$1;
(statearr_12140_12182[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12123 === (25))){
var inst_12112 = (state_12122[(2)]);
var state_12122__$1 = state_12122;
var statearr_12141_12183 = state_12122__$1;
(statearr_12141_12183[(2)] = inst_12112);

(statearr_12141_12183[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12123 === (17))){
var inst_12077 = (state_12122[(10)]);
var inst_12086 = cljs.core.first.call(null,inst_12077);
var inst_12087 = cljs.core.async.muxch_STAR_.call(null,inst_12086);
var inst_12088 = cljs.core.async.close_BANG_.call(null,inst_12087);
var inst_12089 = cljs.core.next.call(null,inst_12077);
var inst_12063 = inst_12089;
var inst_12064 = null;
var inst_12065 = (0);
var inst_12066 = (0);
var state_12122__$1 = (function (){var statearr_12142 = state_12122;
(statearr_12142[(12)] = inst_12065);

(statearr_12142[(13)] = inst_12064);

(statearr_12142[(14)] = inst_12063);

(statearr_12142[(15)] = inst_12066);

(statearr_12142[(16)] = inst_12088);

return statearr_12142;
})();
var statearr_12143_12184 = state_12122__$1;
(statearr_12143_12184[(2)] = null);

(statearr_12143_12184[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12123 === (3))){
var inst_12120 = (state_12122[(2)]);
var state_12122__$1 = state_12122;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12122__$1,inst_12120);
} else {
if((state_val_12123 === (12))){
var inst_12097 = (state_12122[(2)]);
var state_12122__$1 = state_12122;
var statearr_12144_12185 = state_12122__$1;
(statearr_12144_12185[(2)] = inst_12097);

(statearr_12144_12185[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12123 === (2))){
var state_12122__$1 = state_12122;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12122__$1,(4),ch);
} else {
if((state_val_12123 === (23))){
var state_12122__$1 = state_12122;
var statearr_12145_12186 = state_12122__$1;
(statearr_12145_12186[(2)] = null);

(statearr_12145_12186[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12123 === (19))){
var inst_12103 = (state_12122[(11)]);
var inst_12053 = (state_12122[(8)]);
var inst_12105 = cljs.core.async.muxch_STAR_.call(null,inst_12103);
var state_12122__$1 = state_12122;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12122__$1,(22),inst_12105,inst_12053);
} else {
if((state_val_12123 === (11))){
var inst_12077 = (state_12122[(10)]);
var inst_12063 = (state_12122[(14)]);
var inst_12077__$1 = cljs.core.seq.call(null,inst_12063);
var state_12122__$1 = (function (){var statearr_12146 = state_12122;
(statearr_12146[(10)] = inst_12077__$1);

return statearr_12146;
})();
if(inst_12077__$1){
var statearr_12147_12187 = state_12122__$1;
(statearr_12147_12187[(1)] = (13));

} else {
var statearr_12148_12188 = state_12122__$1;
(statearr_12148_12188[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12123 === (9))){
var inst_12099 = (state_12122[(2)]);
var state_12122__$1 = state_12122;
var statearr_12149_12189 = state_12122__$1;
(statearr_12149_12189[(2)] = inst_12099);

(statearr_12149_12189[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12123 === (5))){
var inst_12060 = cljs.core.deref.call(null,mults);
var inst_12061 = cljs.core.vals.call(null,inst_12060);
var inst_12062 = cljs.core.seq.call(null,inst_12061);
var inst_12063 = inst_12062;
var inst_12064 = null;
var inst_12065 = (0);
var inst_12066 = (0);
var state_12122__$1 = (function (){var statearr_12150 = state_12122;
(statearr_12150[(12)] = inst_12065);

(statearr_12150[(13)] = inst_12064);

(statearr_12150[(14)] = inst_12063);

(statearr_12150[(15)] = inst_12066);

return statearr_12150;
})();
var statearr_12151_12190 = state_12122__$1;
(statearr_12151_12190[(2)] = null);

(statearr_12151_12190[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12123 === (14))){
var state_12122__$1 = state_12122;
var statearr_12155_12191 = state_12122__$1;
(statearr_12155_12191[(2)] = null);

(statearr_12155_12191[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12123 === (16))){
var inst_12077 = (state_12122[(10)]);
var inst_12081 = cljs.core.chunk_first.call(null,inst_12077);
var inst_12082 = cljs.core.chunk_rest.call(null,inst_12077);
var inst_12083 = cljs.core.count.call(null,inst_12081);
var inst_12063 = inst_12082;
var inst_12064 = inst_12081;
var inst_12065 = inst_12083;
var inst_12066 = (0);
var state_12122__$1 = (function (){var statearr_12156 = state_12122;
(statearr_12156[(12)] = inst_12065);

(statearr_12156[(13)] = inst_12064);

(statearr_12156[(14)] = inst_12063);

(statearr_12156[(15)] = inst_12066);

return statearr_12156;
})();
var statearr_12157_12192 = state_12122__$1;
(statearr_12157_12192[(2)] = null);

(statearr_12157_12192[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12123 === (10))){
var inst_12065 = (state_12122[(12)]);
var inst_12064 = (state_12122[(13)]);
var inst_12063 = (state_12122[(14)]);
var inst_12066 = (state_12122[(15)]);
var inst_12071 = cljs.core._nth.call(null,inst_12064,inst_12066);
var inst_12072 = cljs.core.async.muxch_STAR_.call(null,inst_12071);
var inst_12073 = cljs.core.async.close_BANG_.call(null,inst_12072);
var inst_12074 = (inst_12066 + (1));
var tmp12152 = inst_12065;
var tmp12153 = inst_12064;
var tmp12154 = inst_12063;
var inst_12063__$1 = tmp12154;
var inst_12064__$1 = tmp12153;
var inst_12065__$1 = tmp12152;
var inst_12066__$1 = inst_12074;
var state_12122__$1 = (function (){var statearr_12158 = state_12122;
(statearr_12158[(12)] = inst_12065__$1);

(statearr_12158[(13)] = inst_12064__$1);

(statearr_12158[(14)] = inst_12063__$1);

(statearr_12158[(17)] = inst_12073);

(statearr_12158[(15)] = inst_12066__$1);

return statearr_12158;
})();
var statearr_12159_12193 = state_12122__$1;
(statearr_12159_12193[(2)] = null);

(statearr_12159_12193[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12123 === (18))){
var inst_12092 = (state_12122[(2)]);
var state_12122__$1 = state_12122;
var statearr_12160_12194 = state_12122__$1;
(statearr_12160_12194[(2)] = inst_12092);

(statearr_12160_12194[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12123 === (8))){
var inst_12065 = (state_12122[(12)]);
var inst_12066 = (state_12122[(15)]);
var inst_12068 = (inst_12066 < inst_12065);
var inst_12069 = inst_12068;
var state_12122__$1 = state_12122;
if(cljs.core.truth_(inst_12069)){
var statearr_12161_12195 = state_12122__$1;
(statearr_12161_12195[(1)] = (10));

} else {
var statearr_12162_12196 = state_12122__$1;
(statearr_12162_12196[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9890__auto___12168,mults,ensure_mult,p))
;
return ((function (switch__9875__auto__,c__9890__auto___12168,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__9876__auto__ = null;
var cljs$core$async$state_machine__9876__auto____0 = (function (){
var statearr_12163 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12163[(0)] = cljs$core$async$state_machine__9876__auto__);

(statearr_12163[(1)] = (1));

return statearr_12163;
});
var cljs$core$async$state_machine__9876__auto____1 = (function (state_12122){
while(true){
var ret_value__9877__auto__ = (function (){try{while(true){
var result__9878__auto__ = switch__9875__auto__.call(null,state_12122);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9878__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9878__auto__;
}
break;
}
}catch (e12164){if((e12164 instanceof Object)){
var ex__9879__auto__ = e12164;
var statearr_12165_12197 = state_12122;
(statearr_12165_12197[(5)] = ex__9879__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12122);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12164;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12198 = state_12122;
state_12122 = G__12198;
continue;
} else {
return ret_value__9877__auto__;
}
break;
}
});
cljs$core$async$state_machine__9876__auto__ = function(state_12122){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9876__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9876__auto____1.call(this,state_12122);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9876__auto____0;
cljs$core$async$state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9876__auto____1;
return cljs$core$async$state_machine__9876__auto__;
})()
;})(switch__9875__auto__,c__9890__auto___12168,mults,ensure_mult,p))
})();
var state__9892__auto__ = (function (){var statearr_12166 = f__9891__auto__.call(null);
(statearr_12166[(6)] = c__9890__auto___12168);

return statearr_12166;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9892__auto__);
});})(c__9890__auto___12168,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__12200 = arguments.length;
switch (G__12200) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__12203 = arguments.length;
switch (G__12203) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__12206 = arguments.length;
switch (G__12206) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__9890__auto___12273 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9890__auto___12273,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__9891__auto__ = (function (){var switch__9875__auto__ = ((function (c__9890__auto___12273,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_12245){
var state_val_12246 = (state_12245[(1)]);
if((state_val_12246 === (7))){
var state_12245__$1 = state_12245;
var statearr_12247_12274 = state_12245__$1;
(statearr_12247_12274[(2)] = null);

(statearr_12247_12274[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12246 === (1))){
var state_12245__$1 = state_12245;
var statearr_12248_12275 = state_12245__$1;
(statearr_12248_12275[(2)] = null);

(statearr_12248_12275[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12246 === (4))){
var inst_12209 = (state_12245[(7)]);
var inst_12211 = (inst_12209 < cnt);
var state_12245__$1 = state_12245;
if(cljs.core.truth_(inst_12211)){
var statearr_12249_12276 = state_12245__$1;
(statearr_12249_12276[(1)] = (6));

} else {
var statearr_12250_12277 = state_12245__$1;
(statearr_12250_12277[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12246 === (15))){
var inst_12241 = (state_12245[(2)]);
var state_12245__$1 = state_12245;
var statearr_12251_12278 = state_12245__$1;
(statearr_12251_12278[(2)] = inst_12241);

(statearr_12251_12278[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12246 === (13))){
var inst_12234 = cljs.core.async.close_BANG_.call(null,out);
var state_12245__$1 = state_12245;
var statearr_12252_12279 = state_12245__$1;
(statearr_12252_12279[(2)] = inst_12234);

(statearr_12252_12279[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12246 === (6))){
var state_12245__$1 = state_12245;
var statearr_12253_12280 = state_12245__$1;
(statearr_12253_12280[(2)] = null);

(statearr_12253_12280[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12246 === (3))){
var inst_12243 = (state_12245[(2)]);
var state_12245__$1 = state_12245;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12245__$1,inst_12243);
} else {
if((state_val_12246 === (12))){
var inst_12231 = (state_12245[(8)]);
var inst_12231__$1 = (state_12245[(2)]);
var inst_12232 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_12231__$1);
var state_12245__$1 = (function (){var statearr_12254 = state_12245;
(statearr_12254[(8)] = inst_12231__$1);

return statearr_12254;
})();
if(cljs.core.truth_(inst_12232)){
var statearr_12255_12281 = state_12245__$1;
(statearr_12255_12281[(1)] = (13));

} else {
var statearr_12256_12282 = state_12245__$1;
(statearr_12256_12282[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12246 === (2))){
var inst_12208 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_12209 = (0);
var state_12245__$1 = (function (){var statearr_12257 = state_12245;
(statearr_12257[(7)] = inst_12209);

(statearr_12257[(9)] = inst_12208);

return statearr_12257;
})();
var statearr_12258_12283 = state_12245__$1;
(statearr_12258_12283[(2)] = null);

(statearr_12258_12283[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12246 === (11))){
var inst_12209 = (state_12245[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_12245,(10),Object,null,(9));
var inst_12218 = chs__$1.call(null,inst_12209);
var inst_12219 = done.call(null,inst_12209);
var inst_12220 = cljs.core.async.take_BANG_.call(null,inst_12218,inst_12219);
var state_12245__$1 = state_12245;
var statearr_12259_12284 = state_12245__$1;
(statearr_12259_12284[(2)] = inst_12220);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12245__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12246 === (9))){
var inst_12209 = (state_12245[(7)]);
var inst_12222 = (state_12245[(2)]);
var inst_12223 = (inst_12209 + (1));
var inst_12209__$1 = inst_12223;
var state_12245__$1 = (function (){var statearr_12260 = state_12245;
(statearr_12260[(7)] = inst_12209__$1);

(statearr_12260[(10)] = inst_12222);

return statearr_12260;
})();
var statearr_12261_12285 = state_12245__$1;
(statearr_12261_12285[(2)] = null);

(statearr_12261_12285[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12246 === (5))){
var inst_12229 = (state_12245[(2)]);
var state_12245__$1 = (function (){var statearr_12262 = state_12245;
(statearr_12262[(11)] = inst_12229);

return statearr_12262;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12245__$1,(12),dchan);
} else {
if((state_val_12246 === (14))){
var inst_12231 = (state_12245[(8)]);
var inst_12236 = cljs.core.apply.call(null,f,inst_12231);
var state_12245__$1 = state_12245;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12245__$1,(16),out,inst_12236);
} else {
if((state_val_12246 === (16))){
var inst_12238 = (state_12245[(2)]);
var state_12245__$1 = (function (){var statearr_12263 = state_12245;
(statearr_12263[(12)] = inst_12238);

return statearr_12263;
})();
var statearr_12264_12286 = state_12245__$1;
(statearr_12264_12286[(2)] = null);

(statearr_12264_12286[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12246 === (10))){
var inst_12213 = (state_12245[(2)]);
var inst_12214 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_12245__$1 = (function (){var statearr_12265 = state_12245;
(statearr_12265[(13)] = inst_12213);

return statearr_12265;
})();
var statearr_12266_12287 = state_12245__$1;
(statearr_12266_12287[(2)] = inst_12214);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12245__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12246 === (8))){
var inst_12227 = (state_12245[(2)]);
var state_12245__$1 = state_12245;
var statearr_12267_12288 = state_12245__$1;
(statearr_12267_12288[(2)] = inst_12227);

(statearr_12267_12288[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9890__auto___12273,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__9875__auto__,c__9890__auto___12273,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__9876__auto__ = null;
var cljs$core$async$state_machine__9876__auto____0 = (function (){
var statearr_12268 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12268[(0)] = cljs$core$async$state_machine__9876__auto__);

(statearr_12268[(1)] = (1));

return statearr_12268;
});
var cljs$core$async$state_machine__9876__auto____1 = (function (state_12245){
while(true){
var ret_value__9877__auto__ = (function (){try{while(true){
var result__9878__auto__ = switch__9875__auto__.call(null,state_12245);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9878__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9878__auto__;
}
break;
}
}catch (e12269){if((e12269 instanceof Object)){
var ex__9879__auto__ = e12269;
var statearr_12270_12289 = state_12245;
(statearr_12270_12289[(5)] = ex__9879__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12245);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12269;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12290 = state_12245;
state_12245 = G__12290;
continue;
} else {
return ret_value__9877__auto__;
}
break;
}
});
cljs$core$async$state_machine__9876__auto__ = function(state_12245){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9876__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9876__auto____1.call(this,state_12245);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9876__auto____0;
cljs$core$async$state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9876__auto____1;
return cljs$core$async$state_machine__9876__auto__;
})()
;})(switch__9875__auto__,c__9890__auto___12273,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__9892__auto__ = (function (){var statearr_12271 = f__9891__auto__.call(null);
(statearr_12271[(6)] = c__9890__auto___12273);

return statearr_12271;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9892__auto__);
});})(c__9890__auto___12273,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__12293 = arguments.length;
switch (G__12293) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__9890__auto___12347 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9890__auto___12347,out){
return (function (){
var f__9891__auto__ = (function (){var switch__9875__auto__ = ((function (c__9890__auto___12347,out){
return (function (state_12325){
var state_val_12326 = (state_12325[(1)]);
if((state_val_12326 === (7))){
var inst_12305 = (state_12325[(7)]);
var inst_12304 = (state_12325[(8)]);
var inst_12304__$1 = (state_12325[(2)]);
var inst_12305__$1 = cljs.core.nth.call(null,inst_12304__$1,(0),null);
var inst_12306 = cljs.core.nth.call(null,inst_12304__$1,(1),null);
var inst_12307 = (inst_12305__$1 == null);
var state_12325__$1 = (function (){var statearr_12327 = state_12325;
(statearr_12327[(9)] = inst_12306);

(statearr_12327[(7)] = inst_12305__$1);

(statearr_12327[(8)] = inst_12304__$1);

return statearr_12327;
})();
if(cljs.core.truth_(inst_12307)){
var statearr_12328_12348 = state_12325__$1;
(statearr_12328_12348[(1)] = (8));

} else {
var statearr_12329_12349 = state_12325__$1;
(statearr_12329_12349[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12326 === (1))){
var inst_12294 = cljs.core.vec.call(null,chs);
var inst_12295 = inst_12294;
var state_12325__$1 = (function (){var statearr_12330 = state_12325;
(statearr_12330[(10)] = inst_12295);

return statearr_12330;
})();
var statearr_12331_12350 = state_12325__$1;
(statearr_12331_12350[(2)] = null);

(statearr_12331_12350[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12326 === (4))){
var inst_12295 = (state_12325[(10)]);
var state_12325__$1 = state_12325;
return cljs.core.async.ioc_alts_BANG_.call(null,state_12325__$1,(7),inst_12295);
} else {
if((state_val_12326 === (6))){
var inst_12321 = (state_12325[(2)]);
var state_12325__$1 = state_12325;
var statearr_12332_12351 = state_12325__$1;
(statearr_12332_12351[(2)] = inst_12321);

(statearr_12332_12351[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12326 === (3))){
var inst_12323 = (state_12325[(2)]);
var state_12325__$1 = state_12325;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12325__$1,inst_12323);
} else {
if((state_val_12326 === (2))){
var inst_12295 = (state_12325[(10)]);
var inst_12297 = cljs.core.count.call(null,inst_12295);
var inst_12298 = (inst_12297 > (0));
var state_12325__$1 = state_12325;
if(cljs.core.truth_(inst_12298)){
var statearr_12334_12352 = state_12325__$1;
(statearr_12334_12352[(1)] = (4));

} else {
var statearr_12335_12353 = state_12325__$1;
(statearr_12335_12353[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12326 === (11))){
var inst_12295 = (state_12325[(10)]);
var inst_12314 = (state_12325[(2)]);
var tmp12333 = inst_12295;
var inst_12295__$1 = tmp12333;
var state_12325__$1 = (function (){var statearr_12336 = state_12325;
(statearr_12336[(10)] = inst_12295__$1);

(statearr_12336[(11)] = inst_12314);

return statearr_12336;
})();
var statearr_12337_12354 = state_12325__$1;
(statearr_12337_12354[(2)] = null);

(statearr_12337_12354[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12326 === (9))){
var inst_12305 = (state_12325[(7)]);
var state_12325__$1 = state_12325;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12325__$1,(11),out,inst_12305);
} else {
if((state_val_12326 === (5))){
var inst_12319 = cljs.core.async.close_BANG_.call(null,out);
var state_12325__$1 = state_12325;
var statearr_12338_12355 = state_12325__$1;
(statearr_12338_12355[(2)] = inst_12319);

(statearr_12338_12355[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12326 === (10))){
var inst_12317 = (state_12325[(2)]);
var state_12325__$1 = state_12325;
var statearr_12339_12356 = state_12325__$1;
(statearr_12339_12356[(2)] = inst_12317);

(statearr_12339_12356[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12326 === (8))){
var inst_12295 = (state_12325[(10)]);
var inst_12306 = (state_12325[(9)]);
var inst_12305 = (state_12325[(7)]);
var inst_12304 = (state_12325[(8)]);
var inst_12309 = (function (){var cs = inst_12295;
var vec__12300 = inst_12304;
var v = inst_12305;
var c = inst_12306;
return ((function (cs,vec__12300,v,c,inst_12295,inst_12306,inst_12305,inst_12304,state_val_12326,c__9890__auto___12347,out){
return (function (p1__12291_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__12291_SHARP_);
});
;})(cs,vec__12300,v,c,inst_12295,inst_12306,inst_12305,inst_12304,state_val_12326,c__9890__auto___12347,out))
})();
var inst_12310 = cljs.core.filterv.call(null,inst_12309,inst_12295);
var inst_12295__$1 = inst_12310;
var state_12325__$1 = (function (){var statearr_12340 = state_12325;
(statearr_12340[(10)] = inst_12295__$1);

return statearr_12340;
})();
var statearr_12341_12357 = state_12325__$1;
(statearr_12341_12357[(2)] = null);

(statearr_12341_12357[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__9890__auto___12347,out))
;
return ((function (switch__9875__auto__,c__9890__auto___12347,out){
return (function() {
var cljs$core$async$state_machine__9876__auto__ = null;
var cljs$core$async$state_machine__9876__auto____0 = (function (){
var statearr_12342 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12342[(0)] = cljs$core$async$state_machine__9876__auto__);

(statearr_12342[(1)] = (1));

return statearr_12342;
});
var cljs$core$async$state_machine__9876__auto____1 = (function (state_12325){
while(true){
var ret_value__9877__auto__ = (function (){try{while(true){
var result__9878__auto__ = switch__9875__auto__.call(null,state_12325);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9878__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9878__auto__;
}
break;
}
}catch (e12343){if((e12343 instanceof Object)){
var ex__9879__auto__ = e12343;
var statearr_12344_12358 = state_12325;
(statearr_12344_12358[(5)] = ex__9879__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12325);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12343;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12359 = state_12325;
state_12325 = G__12359;
continue;
} else {
return ret_value__9877__auto__;
}
break;
}
});
cljs$core$async$state_machine__9876__auto__ = function(state_12325){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9876__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9876__auto____1.call(this,state_12325);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9876__auto____0;
cljs$core$async$state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9876__auto____1;
return cljs$core$async$state_machine__9876__auto__;
})()
;})(switch__9875__auto__,c__9890__auto___12347,out))
})();
var state__9892__auto__ = (function (){var statearr_12345 = f__9891__auto__.call(null);
(statearr_12345[(6)] = c__9890__auto___12347);

return statearr_12345;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9892__auto__);
});})(c__9890__auto___12347,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__12361 = arguments.length;
switch (G__12361) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__9890__auto___12406 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9890__auto___12406,out){
return (function (){
var f__9891__auto__ = (function (){var switch__9875__auto__ = ((function (c__9890__auto___12406,out){
return (function (state_12385){
var state_val_12386 = (state_12385[(1)]);
if((state_val_12386 === (7))){
var inst_12367 = (state_12385[(7)]);
var inst_12367__$1 = (state_12385[(2)]);
var inst_12368 = (inst_12367__$1 == null);
var inst_12369 = cljs.core.not.call(null,inst_12368);
var state_12385__$1 = (function (){var statearr_12387 = state_12385;
(statearr_12387[(7)] = inst_12367__$1);

return statearr_12387;
})();
if(inst_12369){
var statearr_12388_12407 = state_12385__$1;
(statearr_12388_12407[(1)] = (8));

} else {
var statearr_12389_12408 = state_12385__$1;
(statearr_12389_12408[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12386 === (1))){
var inst_12362 = (0);
var state_12385__$1 = (function (){var statearr_12390 = state_12385;
(statearr_12390[(8)] = inst_12362);

return statearr_12390;
})();
var statearr_12391_12409 = state_12385__$1;
(statearr_12391_12409[(2)] = null);

(statearr_12391_12409[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12386 === (4))){
var state_12385__$1 = state_12385;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12385__$1,(7),ch);
} else {
if((state_val_12386 === (6))){
var inst_12380 = (state_12385[(2)]);
var state_12385__$1 = state_12385;
var statearr_12392_12410 = state_12385__$1;
(statearr_12392_12410[(2)] = inst_12380);

(statearr_12392_12410[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12386 === (3))){
var inst_12382 = (state_12385[(2)]);
var inst_12383 = cljs.core.async.close_BANG_.call(null,out);
var state_12385__$1 = (function (){var statearr_12393 = state_12385;
(statearr_12393[(9)] = inst_12382);

return statearr_12393;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12385__$1,inst_12383);
} else {
if((state_val_12386 === (2))){
var inst_12362 = (state_12385[(8)]);
var inst_12364 = (inst_12362 < n);
var state_12385__$1 = state_12385;
if(cljs.core.truth_(inst_12364)){
var statearr_12394_12411 = state_12385__$1;
(statearr_12394_12411[(1)] = (4));

} else {
var statearr_12395_12412 = state_12385__$1;
(statearr_12395_12412[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12386 === (11))){
var inst_12362 = (state_12385[(8)]);
var inst_12372 = (state_12385[(2)]);
var inst_12373 = (inst_12362 + (1));
var inst_12362__$1 = inst_12373;
var state_12385__$1 = (function (){var statearr_12396 = state_12385;
(statearr_12396[(10)] = inst_12372);

(statearr_12396[(8)] = inst_12362__$1);

return statearr_12396;
})();
var statearr_12397_12413 = state_12385__$1;
(statearr_12397_12413[(2)] = null);

(statearr_12397_12413[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12386 === (9))){
var state_12385__$1 = state_12385;
var statearr_12398_12414 = state_12385__$1;
(statearr_12398_12414[(2)] = null);

(statearr_12398_12414[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12386 === (5))){
var state_12385__$1 = state_12385;
var statearr_12399_12415 = state_12385__$1;
(statearr_12399_12415[(2)] = null);

(statearr_12399_12415[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12386 === (10))){
var inst_12377 = (state_12385[(2)]);
var state_12385__$1 = state_12385;
var statearr_12400_12416 = state_12385__$1;
(statearr_12400_12416[(2)] = inst_12377);

(statearr_12400_12416[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12386 === (8))){
var inst_12367 = (state_12385[(7)]);
var state_12385__$1 = state_12385;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12385__$1,(11),out,inst_12367);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__9890__auto___12406,out))
;
return ((function (switch__9875__auto__,c__9890__auto___12406,out){
return (function() {
var cljs$core$async$state_machine__9876__auto__ = null;
var cljs$core$async$state_machine__9876__auto____0 = (function (){
var statearr_12401 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12401[(0)] = cljs$core$async$state_machine__9876__auto__);

(statearr_12401[(1)] = (1));

return statearr_12401;
});
var cljs$core$async$state_machine__9876__auto____1 = (function (state_12385){
while(true){
var ret_value__9877__auto__ = (function (){try{while(true){
var result__9878__auto__ = switch__9875__auto__.call(null,state_12385);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9878__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9878__auto__;
}
break;
}
}catch (e12402){if((e12402 instanceof Object)){
var ex__9879__auto__ = e12402;
var statearr_12403_12417 = state_12385;
(statearr_12403_12417[(5)] = ex__9879__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12385);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12402;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12418 = state_12385;
state_12385 = G__12418;
continue;
} else {
return ret_value__9877__auto__;
}
break;
}
});
cljs$core$async$state_machine__9876__auto__ = function(state_12385){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9876__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9876__auto____1.call(this,state_12385);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9876__auto____0;
cljs$core$async$state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9876__auto____1;
return cljs$core$async$state_machine__9876__auto__;
})()
;})(switch__9875__auto__,c__9890__auto___12406,out))
})();
var state__9892__auto__ = (function (){var statearr_12404 = f__9891__auto__.call(null);
(statearr_12404[(6)] = c__9890__auto___12406);

return statearr_12404;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9892__auto__);
});})(c__9890__auto___12406,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async12420 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12420 = (function (f,ch,meta12421){
this.f = f;
this.ch = ch;
this.meta12421 = meta12421;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async12420.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12422,meta12421__$1){
var self__ = this;
var _12422__$1 = this;
return (new cljs.core.async.t_cljs$core$async12420(self__.f,self__.ch,meta12421__$1));
});

cljs.core.async.t_cljs$core$async12420.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12422){
var self__ = this;
var _12422__$1 = this;
return self__.meta12421;
});

cljs.core.async.t_cljs$core$async12420.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12420.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async12420.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async12420.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12420.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async12423 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12423 = (function (f,ch,meta12421,_,fn1,meta12424){
this.f = f;
this.ch = ch;
this.meta12421 = meta12421;
this._ = _;
this.fn1 = fn1;
this.meta12424 = meta12424;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async12423.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_12425,meta12424__$1){
var self__ = this;
var _12425__$1 = this;
return (new cljs.core.async.t_cljs$core$async12423(self__.f,self__.ch,self__.meta12421,self__._,self__.fn1,meta12424__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async12423.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_12425){
var self__ = this;
var _12425__$1 = this;
return self__.meta12424;
});})(___$1))
;

cljs.core.async.t_cljs$core$async12423.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12423.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async12423.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async12423.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__12419_SHARP_){
return f1.call(null,(((p1__12419_SHARP_ == null))?null:self__.f.call(null,p1__12419_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async12423.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12421","meta12421",-669939698,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async12420","cljs.core.async/t_cljs$core$async12420",-102461758,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta12424","meta12424",1763112614,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async12423.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12423.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12423";

cljs.core.async.t_cljs$core$async12423.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__8062__auto__,writer__8063__auto__,opt__8064__auto__){
return cljs.core._write.call(null,writer__8063__auto__,"cljs.core.async/t_cljs$core$async12423");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async12423 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async12423(f__$1,ch__$1,meta12421__$1,___$2,fn1__$1,meta12424){
return (new cljs.core.async.t_cljs$core$async12423(f__$1,ch__$1,meta12421__$1,___$2,fn1__$1,meta12424));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async12423(self__.f,self__.ch,self__.meta12421,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__7439__auto__ = ret;
if(cljs.core.truth_(and__7439__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__7439__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async12420.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12420.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async12420.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12421","meta12421",-669939698,null)], null);
});

cljs.core.async.t_cljs$core$async12420.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12420.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12420";

cljs.core.async.t_cljs$core$async12420.cljs$lang$ctorPrWriter = (function (this__8062__auto__,writer__8063__auto__,opt__8064__auto__){
return cljs.core._write.call(null,writer__8063__auto__,"cljs.core.async/t_cljs$core$async12420");
});

cljs.core.async.__GT_t_cljs$core$async12420 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async12420(f__$1,ch__$1,meta12421){
return (new cljs.core.async.t_cljs$core$async12420(f__$1,ch__$1,meta12421));
});

}

return (new cljs.core.async.t_cljs$core$async12420(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async12426 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12426 = (function (f,ch,meta12427){
this.f = f;
this.ch = ch;
this.meta12427 = meta12427;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async12426.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12428,meta12427__$1){
var self__ = this;
var _12428__$1 = this;
return (new cljs.core.async.t_cljs$core$async12426(self__.f,self__.ch,meta12427__$1));
});

cljs.core.async.t_cljs$core$async12426.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12428){
var self__ = this;
var _12428__$1 = this;
return self__.meta12427;
});

cljs.core.async.t_cljs$core$async12426.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12426.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async12426.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12426.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async12426.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12426.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async12426.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12427","meta12427",-130812224,null)], null);
});

cljs.core.async.t_cljs$core$async12426.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12426.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12426";

cljs.core.async.t_cljs$core$async12426.cljs$lang$ctorPrWriter = (function (this__8062__auto__,writer__8063__auto__,opt__8064__auto__){
return cljs.core._write.call(null,writer__8063__auto__,"cljs.core.async/t_cljs$core$async12426");
});

cljs.core.async.__GT_t_cljs$core$async12426 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async12426(f__$1,ch__$1,meta12427){
return (new cljs.core.async.t_cljs$core$async12426(f__$1,ch__$1,meta12427));
});

}

return (new cljs.core.async.t_cljs$core$async12426(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async12429 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12429 = (function (p,ch,meta12430){
this.p = p;
this.ch = ch;
this.meta12430 = meta12430;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async12429.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12431,meta12430__$1){
var self__ = this;
var _12431__$1 = this;
return (new cljs.core.async.t_cljs$core$async12429(self__.p,self__.ch,meta12430__$1));
});

cljs.core.async.t_cljs$core$async12429.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12431){
var self__ = this;
var _12431__$1 = this;
return self__.meta12430;
});

cljs.core.async.t_cljs$core$async12429.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12429.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async12429.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async12429.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12429.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async12429.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12429.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async12429.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12430","meta12430",-1961197361,null)], null);
});

cljs.core.async.t_cljs$core$async12429.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12429.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12429";

cljs.core.async.t_cljs$core$async12429.cljs$lang$ctorPrWriter = (function (this__8062__auto__,writer__8063__auto__,opt__8064__auto__){
return cljs.core._write.call(null,writer__8063__auto__,"cljs.core.async/t_cljs$core$async12429");
});

cljs.core.async.__GT_t_cljs$core$async12429 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async12429(p__$1,ch__$1,meta12430){
return (new cljs.core.async.t_cljs$core$async12429(p__$1,ch__$1,meta12430));
});

}

return (new cljs.core.async.t_cljs$core$async12429(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__12433 = arguments.length;
switch (G__12433) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__9890__auto___12473 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9890__auto___12473,out){
return (function (){
var f__9891__auto__ = (function (){var switch__9875__auto__ = ((function (c__9890__auto___12473,out){
return (function (state_12454){
var state_val_12455 = (state_12454[(1)]);
if((state_val_12455 === (7))){
var inst_12450 = (state_12454[(2)]);
var state_12454__$1 = state_12454;
var statearr_12456_12474 = state_12454__$1;
(statearr_12456_12474[(2)] = inst_12450);

(statearr_12456_12474[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12455 === (1))){
var state_12454__$1 = state_12454;
var statearr_12457_12475 = state_12454__$1;
(statearr_12457_12475[(2)] = null);

(statearr_12457_12475[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12455 === (4))){
var inst_12436 = (state_12454[(7)]);
var inst_12436__$1 = (state_12454[(2)]);
var inst_12437 = (inst_12436__$1 == null);
var state_12454__$1 = (function (){var statearr_12458 = state_12454;
(statearr_12458[(7)] = inst_12436__$1);

return statearr_12458;
})();
if(cljs.core.truth_(inst_12437)){
var statearr_12459_12476 = state_12454__$1;
(statearr_12459_12476[(1)] = (5));

} else {
var statearr_12460_12477 = state_12454__$1;
(statearr_12460_12477[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12455 === (6))){
var inst_12436 = (state_12454[(7)]);
var inst_12441 = p.call(null,inst_12436);
var state_12454__$1 = state_12454;
if(cljs.core.truth_(inst_12441)){
var statearr_12461_12478 = state_12454__$1;
(statearr_12461_12478[(1)] = (8));

} else {
var statearr_12462_12479 = state_12454__$1;
(statearr_12462_12479[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12455 === (3))){
var inst_12452 = (state_12454[(2)]);
var state_12454__$1 = state_12454;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12454__$1,inst_12452);
} else {
if((state_val_12455 === (2))){
var state_12454__$1 = state_12454;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12454__$1,(4),ch);
} else {
if((state_val_12455 === (11))){
var inst_12444 = (state_12454[(2)]);
var state_12454__$1 = state_12454;
var statearr_12463_12480 = state_12454__$1;
(statearr_12463_12480[(2)] = inst_12444);

(statearr_12463_12480[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12455 === (9))){
var state_12454__$1 = state_12454;
var statearr_12464_12481 = state_12454__$1;
(statearr_12464_12481[(2)] = null);

(statearr_12464_12481[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12455 === (5))){
var inst_12439 = cljs.core.async.close_BANG_.call(null,out);
var state_12454__$1 = state_12454;
var statearr_12465_12482 = state_12454__$1;
(statearr_12465_12482[(2)] = inst_12439);

(statearr_12465_12482[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12455 === (10))){
var inst_12447 = (state_12454[(2)]);
var state_12454__$1 = (function (){var statearr_12466 = state_12454;
(statearr_12466[(8)] = inst_12447);

return statearr_12466;
})();
var statearr_12467_12483 = state_12454__$1;
(statearr_12467_12483[(2)] = null);

(statearr_12467_12483[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12455 === (8))){
var inst_12436 = (state_12454[(7)]);
var state_12454__$1 = state_12454;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12454__$1,(11),out,inst_12436);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__9890__auto___12473,out))
;
return ((function (switch__9875__auto__,c__9890__auto___12473,out){
return (function() {
var cljs$core$async$state_machine__9876__auto__ = null;
var cljs$core$async$state_machine__9876__auto____0 = (function (){
var statearr_12468 = [null,null,null,null,null,null,null,null,null];
(statearr_12468[(0)] = cljs$core$async$state_machine__9876__auto__);

(statearr_12468[(1)] = (1));

return statearr_12468;
});
var cljs$core$async$state_machine__9876__auto____1 = (function (state_12454){
while(true){
var ret_value__9877__auto__ = (function (){try{while(true){
var result__9878__auto__ = switch__9875__auto__.call(null,state_12454);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9878__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9878__auto__;
}
break;
}
}catch (e12469){if((e12469 instanceof Object)){
var ex__9879__auto__ = e12469;
var statearr_12470_12484 = state_12454;
(statearr_12470_12484[(5)] = ex__9879__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12454);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12469;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12485 = state_12454;
state_12454 = G__12485;
continue;
} else {
return ret_value__9877__auto__;
}
break;
}
});
cljs$core$async$state_machine__9876__auto__ = function(state_12454){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9876__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9876__auto____1.call(this,state_12454);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9876__auto____0;
cljs$core$async$state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9876__auto____1;
return cljs$core$async$state_machine__9876__auto__;
})()
;})(switch__9875__auto__,c__9890__auto___12473,out))
})();
var state__9892__auto__ = (function (){var statearr_12471 = f__9891__auto__.call(null);
(statearr_12471[(6)] = c__9890__auto___12473);

return statearr_12471;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9892__auto__);
});})(c__9890__auto___12473,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__12487 = arguments.length;
switch (G__12487) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__9890__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9890__auto__){
return (function (){
var f__9891__auto__ = (function (){var switch__9875__auto__ = ((function (c__9890__auto__){
return (function (state_12550){
var state_val_12551 = (state_12550[(1)]);
if((state_val_12551 === (7))){
var inst_12546 = (state_12550[(2)]);
var state_12550__$1 = state_12550;
var statearr_12552_12590 = state_12550__$1;
(statearr_12552_12590[(2)] = inst_12546);

(statearr_12552_12590[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12551 === (20))){
var inst_12516 = (state_12550[(7)]);
var inst_12527 = (state_12550[(2)]);
var inst_12528 = cljs.core.next.call(null,inst_12516);
var inst_12502 = inst_12528;
var inst_12503 = null;
var inst_12504 = (0);
var inst_12505 = (0);
var state_12550__$1 = (function (){var statearr_12553 = state_12550;
(statearr_12553[(8)] = inst_12502);

(statearr_12553[(9)] = inst_12505);

(statearr_12553[(10)] = inst_12527);

(statearr_12553[(11)] = inst_12503);

(statearr_12553[(12)] = inst_12504);

return statearr_12553;
})();
var statearr_12554_12591 = state_12550__$1;
(statearr_12554_12591[(2)] = null);

(statearr_12554_12591[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12551 === (1))){
var state_12550__$1 = state_12550;
var statearr_12555_12592 = state_12550__$1;
(statearr_12555_12592[(2)] = null);

(statearr_12555_12592[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12551 === (4))){
var inst_12491 = (state_12550[(13)]);
var inst_12491__$1 = (state_12550[(2)]);
var inst_12492 = (inst_12491__$1 == null);
var state_12550__$1 = (function (){var statearr_12556 = state_12550;
(statearr_12556[(13)] = inst_12491__$1);

return statearr_12556;
})();
if(cljs.core.truth_(inst_12492)){
var statearr_12557_12593 = state_12550__$1;
(statearr_12557_12593[(1)] = (5));

} else {
var statearr_12558_12594 = state_12550__$1;
(statearr_12558_12594[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12551 === (15))){
var state_12550__$1 = state_12550;
var statearr_12562_12595 = state_12550__$1;
(statearr_12562_12595[(2)] = null);

(statearr_12562_12595[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12551 === (21))){
var state_12550__$1 = state_12550;
var statearr_12563_12596 = state_12550__$1;
(statearr_12563_12596[(2)] = null);

(statearr_12563_12596[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12551 === (13))){
var inst_12502 = (state_12550[(8)]);
var inst_12505 = (state_12550[(9)]);
var inst_12503 = (state_12550[(11)]);
var inst_12504 = (state_12550[(12)]);
var inst_12512 = (state_12550[(2)]);
var inst_12513 = (inst_12505 + (1));
var tmp12559 = inst_12502;
var tmp12560 = inst_12503;
var tmp12561 = inst_12504;
var inst_12502__$1 = tmp12559;
var inst_12503__$1 = tmp12560;
var inst_12504__$1 = tmp12561;
var inst_12505__$1 = inst_12513;
var state_12550__$1 = (function (){var statearr_12564 = state_12550;
(statearr_12564[(8)] = inst_12502__$1);

(statearr_12564[(9)] = inst_12505__$1);

(statearr_12564[(14)] = inst_12512);

(statearr_12564[(11)] = inst_12503__$1);

(statearr_12564[(12)] = inst_12504__$1);

return statearr_12564;
})();
var statearr_12565_12597 = state_12550__$1;
(statearr_12565_12597[(2)] = null);

(statearr_12565_12597[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12551 === (22))){
var state_12550__$1 = state_12550;
var statearr_12566_12598 = state_12550__$1;
(statearr_12566_12598[(2)] = null);

(statearr_12566_12598[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12551 === (6))){
var inst_12491 = (state_12550[(13)]);
var inst_12500 = f.call(null,inst_12491);
var inst_12501 = cljs.core.seq.call(null,inst_12500);
var inst_12502 = inst_12501;
var inst_12503 = null;
var inst_12504 = (0);
var inst_12505 = (0);
var state_12550__$1 = (function (){var statearr_12567 = state_12550;
(statearr_12567[(8)] = inst_12502);

(statearr_12567[(9)] = inst_12505);

(statearr_12567[(11)] = inst_12503);

(statearr_12567[(12)] = inst_12504);

return statearr_12567;
})();
var statearr_12568_12599 = state_12550__$1;
(statearr_12568_12599[(2)] = null);

(statearr_12568_12599[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12551 === (17))){
var inst_12516 = (state_12550[(7)]);
var inst_12520 = cljs.core.chunk_first.call(null,inst_12516);
var inst_12521 = cljs.core.chunk_rest.call(null,inst_12516);
var inst_12522 = cljs.core.count.call(null,inst_12520);
var inst_12502 = inst_12521;
var inst_12503 = inst_12520;
var inst_12504 = inst_12522;
var inst_12505 = (0);
var state_12550__$1 = (function (){var statearr_12569 = state_12550;
(statearr_12569[(8)] = inst_12502);

(statearr_12569[(9)] = inst_12505);

(statearr_12569[(11)] = inst_12503);

(statearr_12569[(12)] = inst_12504);

return statearr_12569;
})();
var statearr_12570_12600 = state_12550__$1;
(statearr_12570_12600[(2)] = null);

(statearr_12570_12600[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12551 === (3))){
var inst_12548 = (state_12550[(2)]);
var state_12550__$1 = state_12550;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12550__$1,inst_12548);
} else {
if((state_val_12551 === (12))){
var inst_12536 = (state_12550[(2)]);
var state_12550__$1 = state_12550;
var statearr_12571_12601 = state_12550__$1;
(statearr_12571_12601[(2)] = inst_12536);

(statearr_12571_12601[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12551 === (2))){
var state_12550__$1 = state_12550;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12550__$1,(4),in$);
} else {
if((state_val_12551 === (23))){
var inst_12544 = (state_12550[(2)]);
var state_12550__$1 = state_12550;
var statearr_12572_12602 = state_12550__$1;
(statearr_12572_12602[(2)] = inst_12544);

(statearr_12572_12602[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12551 === (19))){
var inst_12531 = (state_12550[(2)]);
var state_12550__$1 = state_12550;
var statearr_12573_12603 = state_12550__$1;
(statearr_12573_12603[(2)] = inst_12531);

(statearr_12573_12603[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12551 === (11))){
var inst_12516 = (state_12550[(7)]);
var inst_12502 = (state_12550[(8)]);
var inst_12516__$1 = cljs.core.seq.call(null,inst_12502);
var state_12550__$1 = (function (){var statearr_12574 = state_12550;
(statearr_12574[(7)] = inst_12516__$1);

return statearr_12574;
})();
if(inst_12516__$1){
var statearr_12575_12604 = state_12550__$1;
(statearr_12575_12604[(1)] = (14));

} else {
var statearr_12576_12605 = state_12550__$1;
(statearr_12576_12605[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12551 === (9))){
var inst_12538 = (state_12550[(2)]);
var inst_12539 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_12550__$1 = (function (){var statearr_12577 = state_12550;
(statearr_12577[(15)] = inst_12538);

return statearr_12577;
})();
if(cljs.core.truth_(inst_12539)){
var statearr_12578_12606 = state_12550__$1;
(statearr_12578_12606[(1)] = (21));

} else {
var statearr_12579_12607 = state_12550__$1;
(statearr_12579_12607[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12551 === (5))){
var inst_12494 = cljs.core.async.close_BANG_.call(null,out);
var state_12550__$1 = state_12550;
var statearr_12580_12608 = state_12550__$1;
(statearr_12580_12608[(2)] = inst_12494);

(statearr_12580_12608[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12551 === (14))){
var inst_12516 = (state_12550[(7)]);
var inst_12518 = cljs.core.chunked_seq_QMARK_.call(null,inst_12516);
var state_12550__$1 = state_12550;
if(inst_12518){
var statearr_12581_12609 = state_12550__$1;
(statearr_12581_12609[(1)] = (17));

} else {
var statearr_12582_12610 = state_12550__$1;
(statearr_12582_12610[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12551 === (16))){
var inst_12534 = (state_12550[(2)]);
var state_12550__$1 = state_12550;
var statearr_12583_12611 = state_12550__$1;
(statearr_12583_12611[(2)] = inst_12534);

(statearr_12583_12611[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12551 === (10))){
var inst_12505 = (state_12550[(9)]);
var inst_12503 = (state_12550[(11)]);
var inst_12510 = cljs.core._nth.call(null,inst_12503,inst_12505);
var state_12550__$1 = state_12550;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12550__$1,(13),out,inst_12510);
} else {
if((state_val_12551 === (18))){
var inst_12516 = (state_12550[(7)]);
var inst_12525 = cljs.core.first.call(null,inst_12516);
var state_12550__$1 = state_12550;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12550__$1,(20),out,inst_12525);
} else {
if((state_val_12551 === (8))){
var inst_12505 = (state_12550[(9)]);
var inst_12504 = (state_12550[(12)]);
var inst_12507 = (inst_12505 < inst_12504);
var inst_12508 = inst_12507;
var state_12550__$1 = state_12550;
if(cljs.core.truth_(inst_12508)){
var statearr_12584_12612 = state_12550__$1;
(statearr_12584_12612[(1)] = (10));

} else {
var statearr_12585_12613 = state_12550__$1;
(statearr_12585_12613[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9890__auto__))
;
return ((function (switch__9875__auto__,c__9890__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__9876__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__9876__auto____0 = (function (){
var statearr_12586 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12586[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__9876__auto__);

(statearr_12586[(1)] = (1));

return statearr_12586;
});
var cljs$core$async$mapcat_STAR__$_state_machine__9876__auto____1 = (function (state_12550){
while(true){
var ret_value__9877__auto__ = (function (){try{while(true){
var result__9878__auto__ = switch__9875__auto__.call(null,state_12550);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9878__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9878__auto__;
}
break;
}
}catch (e12587){if((e12587 instanceof Object)){
var ex__9879__auto__ = e12587;
var statearr_12588_12614 = state_12550;
(statearr_12588_12614[(5)] = ex__9879__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12550);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12587;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12615 = state_12550;
state_12550 = G__12615;
continue;
} else {
return ret_value__9877__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__9876__auto__ = function(state_12550){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__9876__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__9876__auto____1.call(this,state_12550);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__9876__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__9876__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__9876__auto__;
})()
;})(switch__9875__auto__,c__9890__auto__))
})();
var state__9892__auto__ = (function (){var statearr_12589 = f__9891__auto__.call(null);
(statearr_12589[(6)] = c__9890__auto__);

return statearr_12589;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9892__auto__);
});})(c__9890__auto__))
);

return c__9890__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__12617 = arguments.length;
switch (G__12617) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__12620 = arguments.length;
switch (G__12620) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__12623 = arguments.length;
switch (G__12623) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__9890__auto___12670 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9890__auto___12670,out){
return (function (){
var f__9891__auto__ = (function (){var switch__9875__auto__ = ((function (c__9890__auto___12670,out){
return (function (state_12647){
var state_val_12648 = (state_12647[(1)]);
if((state_val_12648 === (7))){
var inst_12642 = (state_12647[(2)]);
var state_12647__$1 = state_12647;
var statearr_12649_12671 = state_12647__$1;
(statearr_12649_12671[(2)] = inst_12642);

(statearr_12649_12671[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12648 === (1))){
var inst_12624 = null;
var state_12647__$1 = (function (){var statearr_12650 = state_12647;
(statearr_12650[(7)] = inst_12624);

return statearr_12650;
})();
var statearr_12651_12672 = state_12647__$1;
(statearr_12651_12672[(2)] = null);

(statearr_12651_12672[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12648 === (4))){
var inst_12627 = (state_12647[(8)]);
var inst_12627__$1 = (state_12647[(2)]);
var inst_12628 = (inst_12627__$1 == null);
var inst_12629 = cljs.core.not.call(null,inst_12628);
var state_12647__$1 = (function (){var statearr_12652 = state_12647;
(statearr_12652[(8)] = inst_12627__$1);

return statearr_12652;
})();
if(inst_12629){
var statearr_12653_12673 = state_12647__$1;
(statearr_12653_12673[(1)] = (5));

} else {
var statearr_12654_12674 = state_12647__$1;
(statearr_12654_12674[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12648 === (6))){
var state_12647__$1 = state_12647;
var statearr_12655_12675 = state_12647__$1;
(statearr_12655_12675[(2)] = null);

(statearr_12655_12675[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12648 === (3))){
var inst_12644 = (state_12647[(2)]);
var inst_12645 = cljs.core.async.close_BANG_.call(null,out);
var state_12647__$1 = (function (){var statearr_12656 = state_12647;
(statearr_12656[(9)] = inst_12644);

return statearr_12656;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12647__$1,inst_12645);
} else {
if((state_val_12648 === (2))){
var state_12647__$1 = state_12647;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12647__$1,(4),ch);
} else {
if((state_val_12648 === (11))){
var inst_12627 = (state_12647[(8)]);
var inst_12636 = (state_12647[(2)]);
var inst_12624 = inst_12627;
var state_12647__$1 = (function (){var statearr_12657 = state_12647;
(statearr_12657[(10)] = inst_12636);

(statearr_12657[(7)] = inst_12624);

return statearr_12657;
})();
var statearr_12658_12676 = state_12647__$1;
(statearr_12658_12676[(2)] = null);

(statearr_12658_12676[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12648 === (9))){
var inst_12627 = (state_12647[(8)]);
var state_12647__$1 = state_12647;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12647__$1,(11),out,inst_12627);
} else {
if((state_val_12648 === (5))){
var inst_12627 = (state_12647[(8)]);
var inst_12624 = (state_12647[(7)]);
var inst_12631 = cljs.core._EQ_.call(null,inst_12627,inst_12624);
var state_12647__$1 = state_12647;
if(inst_12631){
var statearr_12660_12677 = state_12647__$1;
(statearr_12660_12677[(1)] = (8));

} else {
var statearr_12661_12678 = state_12647__$1;
(statearr_12661_12678[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12648 === (10))){
var inst_12639 = (state_12647[(2)]);
var state_12647__$1 = state_12647;
var statearr_12662_12679 = state_12647__$1;
(statearr_12662_12679[(2)] = inst_12639);

(statearr_12662_12679[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12648 === (8))){
var inst_12624 = (state_12647[(7)]);
var tmp12659 = inst_12624;
var inst_12624__$1 = tmp12659;
var state_12647__$1 = (function (){var statearr_12663 = state_12647;
(statearr_12663[(7)] = inst_12624__$1);

return statearr_12663;
})();
var statearr_12664_12680 = state_12647__$1;
(statearr_12664_12680[(2)] = null);

(statearr_12664_12680[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__9890__auto___12670,out))
;
return ((function (switch__9875__auto__,c__9890__auto___12670,out){
return (function() {
var cljs$core$async$state_machine__9876__auto__ = null;
var cljs$core$async$state_machine__9876__auto____0 = (function (){
var statearr_12665 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12665[(0)] = cljs$core$async$state_machine__9876__auto__);

(statearr_12665[(1)] = (1));

return statearr_12665;
});
var cljs$core$async$state_machine__9876__auto____1 = (function (state_12647){
while(true){
var ret_value__9877__auto__ = (function (){try{while(true){
var result__9878__auto__ = switch__9875__auto__.call(null,state_12647);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9878__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9878__auto__;
}
break;
}
}catch (e12666){if((e12666 instanceof Object)){
var ex__9879__auto__ = e12666;
var statearr_12667_12681 = state_12647;
(statearr_12667_12681[(5)] = ex__9879__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12647);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12666;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12682 = state_12647;
state_12647 = G__12682;
continue;
} else {
return ret_value__9877__auto__;
}
break;
}
});
cljs$core$async$state_machine__9876__auto__ = function(state_12647){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9876__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9876__auto____1.call(this,state_12647);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9876__auto____0;
cljs$core$async$state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9876__auto____1;
return cljs$core$async$state_machine__9876__auto__;
})()
;})(switch__9875__auto__,c__9890__auto___12670,out))
})();
var state__9892__auto__ = (function (){var statearr_12668 = f__9891__auto__.call(null);
(statearr_12668[(6)] = c__9890__auto___12670);

return statearr_12668;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9892__auto__);
});})(c__9890__auto___12670,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__12684 = arguments.length;
switch (G__12684) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__9890__auto___12750 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9890__auto___12750,out){
return (function (){
var f__9891__auto__ = (function (){var switch__9875__auto__ = ((function (c__9890__auto___12750,out){
return (function (state_12722){
var state_val_12723 = (state_12722[(1)]);
if((state_val_12723 === (7))){
var inst_12718 = (state_12722[(2)]);
var state_12722__$1 = state_12722;
var statearr_12724_12751 = state_12722__$1;
(statearr_12724_12751[(2)] = inst_12718);

(statearr_12724_12751[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12723 === (1))){
var inst_12685 = (new Array(n));
var inst_12686 = inst_12685;
var inst_12687 = (0);
var state_12722__$1 = (function (){var statearr_12725 = state_12722;
(statearr_12725[(7)] = inst_12687);

(statearr_12725[(8)] = inst_12686);

return statearr_12725;
})();
var statearr_12726_12752 = state_12722__$1;
(statearr_12726_12752[(2)] = null);

(statearr_12726_12752[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12723 === (4))){
var inst_12690 = (state_12722[(9)]);
var inst_12690__$1 = (state_12722[(2)]);
var inst_12691 = (inst_12690__$1 == null);
var inst_12692 = cljs.core.not.call(null,inst_12691);
var state_12722__$1 = (function (){var statearr_12727 = state_12722;
(statearr_12727[(9)] = inst_12690__$1);

return statearr_12727;
})();
if(inst_12692){
var statearr_12728_12753 = state_12722__$1;
(statearr_12728_12753[(1)] = (5));

} else {
var statearr_12729_12754 = state_12722__$1;
(statearr_12729_12754[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12723 === (15))){
var inst_12712 = (state_12722[(2)]);
var state_12722__$1 = state_12722;
var statearr_12730_12755 = state_12722__$1;
(statearr_12730_12755[(2)] = inst_12712);

(statearr_12730_12755[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12723 === (13))){
var state_12722__$1 = state_12722;
var statearr_12731_12756 = state_12722__$1;
(statearr_12731_12756[(2)] = null);

(statearr_12731_12756[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12723 === (6))){
var inst_12687 = (state_12722[(7)]);
var inst_12708 = (inst_12687 > (0));
var state_12722__$1 = state_12722;
if(cljs.core.truth_(inst_12708)){
var statearr_12732_12757 = state_12722__$1;
(statearr_12732_12757[(1)] = (12));

} else {
var statearr_12733_12758 = state_12722__$1;
(statearr_12733_12758[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12723 === (3))){
var inst_12720 = (state_12722[(2)]);
var state_12722__$1 = state_12722;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12722__$1,inst_12720);
} else {
if((state_val_12723 === (12))){
var inst_12686 = (state_12722[(8)]);
var inst_12710 = cljs.core.vec.call(null,inst_12686);
var state_12722__$1 = state_12722;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12722__$1,(15),out,inst_12710);
} else {
if((state_val_12723 === (2))){
var state_12722__$1 = state_12722;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12722__$1,(4),ch);
} else {
if((state_val_12723 === (11))){
var inst_12702 = (state_12722[(2)]);
var inst_12703 = (new Array(n));
var inst_12686 = inst_12703;
var inst_12687 = (0);
var state_12722__$1 = (function (){var statearr_12734 = state_12722;
(statearr_12734[(10)] = inst_12702);

(statearr_12734[(7)] = inst_12687);

(statearr_12734[(8)] = inst_12686);

return statearr_12734;
})();
var statearr_12735_12759 = state_12722__$1;
(statearr_12735_12759[(2)] = null);

(statearr_12735_12759[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12723 === (9))){
var inst_12686 = (state_12722[(8)]);
var inst_12700 = cljs.core.vec.call(null,inst_12686);
var state_12722__$1 = state_12722;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12722__$1,(11),out,inst_12700);
} else {
if((state_val_12723 === (5))){
var inst_12695 = (state_12722[(11)]);
var inst_12687 = (state_12722[(7)]);
var inst_12690 = (state_12722[(9)]);
var inst_12686 = (state_12722[(8)]);
var inst_12694 = (inst_12686[inst_12687] = inst_12690);
var inst_12695__$1 = (inst_12687 + (1));
var inst_12696 = (inst_12695__$1 < n);
var state_12722__$1 = (function (){var statearr_12736 = state_12722;
(statearr_12736[(11)] = inst_12695__$1);

(statearr_12736[(12)] = inst_12694);

return statearr_12736;
})();
if(cljs.core.truth_(inst_12696)){
var statearr_12737_12760 = state_12722__$1;
(statearr_12737_12760[(1)] = (8));

} else {
var statearr_12738_12761 = state_12722__$1;
(statearr_12738_12761[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12723 === (14))){
var inst_12715 = (state_12722[(2)]);
var inst_12716 = cljs.core.async.close_BANG_.call(null,out);
var state_12722__$1 = (function (){var statearr_12740 = state_12722;
(statearr_12740[(13)] = inst_12715);

return statearr_12740;
})();
var statearr_12741_12762 = state_12722__$1;
(statearr_12741_12762[(2)] = inst_12716);

(statearr_12741_12762[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12723 === (10))){
var inst_12706 = (state_12722[(2)]);
var state_12722__$1 = state_12722;
var statearr_12742_12763 = state_12722__$1;
(statearr_12742_12763[(2)] = inst_12706);

(statearr_12742_12763[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12723 === (8))){
var inst_12695 = (state_12722[(11)]);
var inst_12686 = (state_12722[(8)]);
var tmp12739 = inst_12686;
var inst_12686__$1 = tmp12739;
var inst_12687 = inst_12695;
var state_12722__$1 = (function (){var statearr_12743 = state_12722;
(statearr_12743[(7)] = inst_12687);

(statearr_12743[(8)] = inst_12686__$1);

return statearr_12743;
})();
var statearr_12744_12764 = state_12722__$1;
(statearr_12744_12764[(2)] = null);

(statearr_12744_12764[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9890__auto___12750,out))
;
return ((function (switch__9875__auto__,c__9890__auto___12750,out){
return (function() {
var cljs$core$async$state_machine__9876__auto__ = null;
var cljs$core$async$state_machine__9876__auto____0 = (function (){
var statearr_12745 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12745[(0)] = cljs$core$async$state_machine__9876__auto__);

(statearr_12745[(1)] = (1));

return statearr_12745;
});
var cljs$core$async$state_machine__9876__auto____1 = (function (state_12722){
while(true){
var ret_value__9877__auto__ = (function (){try{while(true){
var result__9878__auto__ = switch__9875__auto__.call(null,state_12722);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9878__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9878__auto__;
}
break;
}
}catch (e12746){if((e12746 instanceof Object)){
var ex__9879__auto__ = e12746;
var statearr_12747_12765 = state_12722;
(statearr_12747_12765[(5)] = ex__9879__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12722);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12746;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12766 = state_12722;
state_12722 = G__12766;
continue;
} else {
return ret_value__9877__auto__;
}
break;
}
});
cljs$core$async$state_machine__9876__auto__ = function(state_12722){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9876__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9876__auto____1.call(this,state_12722);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9876__auto____0;
cljs$core$async$state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9876__auto____1;
return cljs$core$async$state_machine__9876__auto__;
})()
;})(switch__9875__auto__,c__9890__auto___12750,out))
})();
var state__9892__auto__ = (function (){var statearr_12748 = f__9891__auto__.call(null);
(statearr_12748[(6)] = c__9890__auto___12750);

return statearr_12748;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9892__auto__);
});})(c__9890__auto___12750,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__12768 = arguments.length;
switch (G__12768) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__9890__auto___12838 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__9890__auto___12838,out){
return (function (){
var f__9891__auto__ = (function (){var switch__9875__auto__ = ((function (c__9890__auto___12838,out){
return (function (state_12810){
var state_val_12811 = (state_12810[(1)]);
if((state_val_12811 === (7))){
var inst_12806 = (state_12810[(2)]);
var state_12810__$1 = state_12810;
var statearr_12812_12839 = state_12810__$1;
(statearr_12812_12839[(2)] = inst_12806);

(statearr_12812_12839[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12811 === (1))){
var inst_12769 = [];
var inst_12770 = inst_12769;
var inst_12771 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_12810__$1 = (function (){var statearr_12813 = state_12810;
(statearr_12813[(7)] = inst_12770);

(statearr_12813[(8)] = inst_12771);

return statearr_12813;
})();
var statearr_12814_12840 = state_12810__$1;
(statearr_12814_12840[(2)] = null);

(statearr_12814_12840[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12811 === (4))){
var inst_12774 = (state_12810[(9)]);
var inst_12774__$1 = (state_12810[(2)]);
var inst_12775 = (inst_12774__$1 == null);
var inst_12776 = cljs.core.not.call(null,inst_12775);
var state_12810__$1 = (function (){var statearr_12815 = state_12810;
(statearr_12815[(9)] = inst_12774__$1);

return statearr_12815;
})();
if(inst_12776){
var statearr_12816_12841 = state_12810__$1;
(statearr_12816_12841[(1)] = (5));

} else {
var statearr_12817_12842 = state_12810__$1;
(statearr_12817_12842[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12811 === (15))){
var inst_12800 = (state_12810[(2)]);
var state_12810__$1 = state_12810;
var statearr_12818_12843 = state_12810__$1;
(statearr_12818_12843[(2)] = inst_12800);

(statearr_12818_12843[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12811 === (13))){
var state_12810__$1 = state_12810;
var statearr_12819_12844 = state_12810__$1;
(statearr_12819_12844[(2)] = null);

(statearr_12819_12844[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12811 === (6))){
var inst_12770 = (state_12810[(7)]);
var inst_12795 = inst_12770.length;
var inst_12796 = (inst_12795 > (0));
var state_12810__$1 = state_12810;
if(cljs.core.truth_(inst_12796)){
var statearr_12820_12845 = state_12810__$1;
(statearr_12820_12845[(1)] = (12));

} else {
var statearr_12821_12846 = state_12810__$1;
(statearr_12821_12846[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12811 === (3))){
var inst_12808 = (state_12810[(2)]);
var state_12810__$1 = state_12810;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12810__$1,inst_12808);
} else {
if((state_val_12811 === (12))){
var inst_12770 = (state_12810[(7)]);
var inst_12798 = cljs.core.vec.call(null,inst_12770);
var state_12810__$1 = state_12810;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12810__$1,(15),out,inst_12798);
} else {
if((state_val_12811 === (2))){
var state_12810__$1 = state_12810;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12810__$1,(4),ch);
} else {
if((state_val_12811 === (11))){
var inst_12778 = (state_12810[(10)]);
var inst_12774 = (state_12810[(9)]);
var inst_12788 = (state_12810[(2)]);
var inst_12789 = [];
var inst_12790 = inst_12789.push(inst_12774);
var inst_12770 = inst_12789;
var inst_12771 = inst_12778;
var state_12810__$1 = (function (){var statearr_12822 = state_12810;
(statearr_12822[(7)] = inst_12770);

(statearr_12822[(8)] = inst_12771);

(statearr_12822[(11)] = inst_12790);

(statearr_12822[(12)] = inst_12788);

return statearr_12822;
})();
var statearr_12823_12847 = state_12810__$1;
(statearr_12823_12847[(2)] = null);

(statearr_12823_12847[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12811 === (9))){
var inst_12770 = (state_12810[(7)]);
var inst_12786 = cljs.core.vec.call(null,inst_12770);
var state_12810__$1 = state_12810;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12810__$1,(11),out,inst_12786);
} else {
if((state_val_12811 === (5))){
var inst_12771 = (state_12810[(8)]);
var inst_12778 = (state_12810[(10)]);
var inst_12774 = (state_12810[(9)]);
var inst_12778__$1 = f.call(null,inst_12774);
var inst_12779 = cljs.core._EQ_.call(null,inst_12778__$1,inst_12771);
var inst_12780 = cljs.core.keyword_identical_QMARK_.call(null,inst_12771,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_12781 = (inst_12779) || (inst_12780);
var state_12810__$1 = (function (){var statearr_12824 = state_12810;
(statearr_12824[(10)] = inst_12778__$1);

return statearr_12824;
})();
if(cljs.core.truth_(inst_12781)){
var statearr_12825_12848 = state_12810__$1;
(statearr_12825_12848[(1)] = (8));

} else {
var statearr_12826_12849 = state_12810__$1;
(statearr_12826_12849[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12811 === (14))){
var inst_12803 = (state_12810[(2)]);
var inst_12804 = cljs.core.async.close_BANG_.call(null,out);
var state_12810__$1 = (function (){var statearr_12828 = state_12810;
(statearr_12828[(13)] = inst_12803);

return statearr_12828;
})();
var statearr_12829_12850 = state_12810__$1;
(statearr_12829_12850[(2)] = inst_12804);

(statearr_12829_12850[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12811 === (10))){
var inst_12793 = (state_12810[(2)]);
var state_12810__$1 = state_12810;
var statearr_12830_12851 = state_12810__$1;
(statearr_12830_12851[(2)] = inst_12793);

(statearr_12830_12851[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12811 === (8))){
var inst_12770 = (state_12810[(7)]);
var inst_12778 = (state_12810[(10)]);
var inst_12774 = (state_12810[(9)]);
var inst_12783 = inst_12770.push(inst_12774);
var tmp12827 = inst_12770;
var inst_12770__$1 = tmp12827;
var inst_12771 = inst_12778;
var state_12810__$1 = (function (){var statearr_12831 = state_12810;
(statearr_12831[(7)] = inst_12770__$1);

(statearr_12831[(8)] = inst_12771);

(statearr_12831[(14)] = inst_12783);

return statearr_12831;
})();
var statearr_12832_12852 = state_12810__$1;
(statearr_12832_12852[(2)] = null);

(statearr_12832_12852[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__9890__auto___12838,out))
;
return ((function (switch__9875__auto__,c__9890__auto___12838,out){
return (function() {
var cljs$core$async$state_machine__9876__auto__ = null;
var cljs$core$async$state_machine__9876__auto____0 = (function (){
var statearr_12833 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12833[(0)] = cljs$core$async$state_machine__9876__auto__);

(statearr_12833[(1)] = (1));

return statearr_12833;
});
var cljs$core$async$state_machine__9876__auto____1 = (function (state_12810){
while(true){
var ret_value__9877__auto__ = (function (){try{while(true){
var result__9878__auto__ = switch__9875__auto__.call(null,state_12810);
if(cljs.core.keyword_identical_QMARK_.call(null,result__9878__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__9878__auto__;
}
break;
}
}catch (e12834){if((e12834 instanceof Object)){
var ex__9879__auto__ = e12834;
var statearr_12835_12853 = state_12810;
(statearr_12835_12853[(5)] = ex__9879__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12810);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12834;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__9877__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12854 = state_12810;
state_12810 = G__12854;
continue;
} else {
return ret_value__9877__auto__;
}
break;
}
});
cljs$core$async$state_machine__9876__auto__ = function(state_12810){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__9876__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__9876__auto____1.call(this,state_12810);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__9876__auto____0;
cljs$core$async$state_machine__9876__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__9876__auto____1;
return cljs$core$async$state_machine__9876__auto__;
})()
;})(switch__9875__auto__,c__9890__auto___12838,out))
})();
var state__9892__auto__ = (function (){var statearr_12836 = f__9891__auto__.call(null);
(statearr_12836[(6)] = c__9890__auto___12838);

return statearr_12836;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__9892__auto__);
});})(c__9890__auto___12838,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1500355265035