// Compiled by ClojureScript 1.9.671 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__32229 = arguments.length;
switch (G__32229) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async32230 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32230 = (function (f,blockable,meta32231){
this.f = f;
this.blockable = blockable;
this.meta32231 = meta32231;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32230.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32232,meta32231__$1){
var self__ = this;
var _32232__$1 = this;
return (new cljs.core.async.t_cljs$core$async32230(self__.f,self__.blockable,meta32231__$1));
});

cljs.core.async.t_cljs$core$async32230.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32232){
var self__ = this;
var _32232__$1 = this;
return self__.meta32231;
});

cljs.core.async.t_cljs$core$async32230.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32230.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async32230.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async32230.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async32230.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta32231","meta32231",773773293,null)], null);
});

cljs.core.async.t_cljs$core$async32230.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32230.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32230";

cljs.core.async.t_cljs$core$async32230.cljs$lang$ctorPrWriter = (function (this__27104__auto__,writer__27105__auto__,opt__27106__auto__){
return cljs.core._write.call(null,writer__27105__auto__,"cljs.core.async/t_cljs$core$async32230");
});

cljs.core.async.__GT_t_cljs$core$async32230 = (function cljs$core$async$__GT_t_cljs$core$async32230(f__$1,blockable__$1,meta32231){
return (new cljs.core.async.t_cljs$core$async32230(f__$1,blockable__$1,meta32231));
});

}

return (new cljs.core.async.t_cljs$core$async32230(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__32236 = arguments.length;
switch (G__32236) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buffer must be supplied when transducer is"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__32239 = arguments.length;
switch (G__32239) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__32242 = arguments.length;
switch (G__32242) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_32244 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_32244);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_32244,ret){
return (function (){
return fn1.call(null,val_32244);
});})(val_32244,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__32246 = arguments.length;
switch (G__32246) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__27417__auto___32248 = n;
var x_32249 = (0);
while(true){
if((x_32249 < n__27417__auto___32248)){
(a[x_32249] = (0));

var G__32250 = (x_32249 + (1));
x_32249 = G__32250;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__32251 = (i + (1));
i = G__32251;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async32252 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32252 = (function (flag,meta32253){
this.flag = flag;
this.meta32253 = meta32253;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32252.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_32254,meta32253__$1){
var self__ = this;
var _32254__$1 = this;
return (new cljs.core.async.t_cljs$core$async32252(self__.flag,meta32253__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async32252.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_32254){
var self__ = this;
var _32254__$1 = this;
return self__.meta32253;
});})(flag))
;

cljs.core.async.t_cljs$core$async32252.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32252.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async32252.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async32252.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async32252.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta32253","meta32253",-48257420,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async32252.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32252.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32252";

cljs.core.async.t_cljs$core$async32252.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__27104__auto__,writer__27105__auto__,opt__27106__auto__){
return cljs.core._write.call(null,writer__27105__auto__,"cljs.core.async/t_cljs$core$async32252");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async32252 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async32252(flag__$1,meta32253){
return (new cljs.core.async.t_cljs$core$async32252(flag__$1,meta32253));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async32252(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async32255 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32255 = (function (flag,cb,meta32256){
this.flag = flag;
this.cb = cb;
this.meta32256 = meta32256;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32255.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32257,meta32256__$1){
var self__ = this;
var _32257__$1 = this;
return (new cljs.core.async.t_cljs$core$async32255(self__.flag,self__.cb,meta32256__$1));
});

cljs.core.async.t_cljs$core$async32255.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32257){
var self__ = this;
var _32257__$1 = this;
return self__.meta32256;
});

cljs.core.async.t_cljs$core$async32255.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32255.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async32255.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async32255.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async32255.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta32256","meta32256",333220434,null)], null);
});

cljs.core.async.t_cljs$core$async32255.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32255.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32255";

cljs.core.async.t_cljs$core$async32255.cljs$lang$ctorPrWriter = (function (this__27104__auto__,writer__27105__auto__,opt__27106__auto__){
return cljs.core._write.call(null,writer__27105__auto__,"cljs.core.async/t_cljs$core$async32255");
});

cljs.core.async.__GT_t_cljs$core$async32255 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async32255(flag__$1,cb__$1,meta32256){
return (new cljs.core.async.t_cljs$core$async32255(flag__$1,cb__$1,meta32256));
});

}

return (new cljs.core.async.t_cljs$core$async32255(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__32258_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__32258_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__32259_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__32259_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__26493__auto__ = wport;
if(cljs.core.truth_(or__26493__auto__)){
return or__26493__auto__;
} else {
return port;
}
})()], null));
} else {
var G__32260 = (i + (1));
i = G__32260;
continue;
}
} else {
return null;
}
break;
}
})();
var or__26493__auto__ = ret;
if(cljs.core.truth_(or__26493__auto__)){
return or__26493__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__26481__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__26481__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__26481__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__27625__auto__ = [];
var len__27618__auto___32266 = arguments.length;
var i__27619__auto___32267 = (0);
while(true){
if((i__27619__auto___32267 < len__27618__auto___32266)){
args__27625__auto__.push((arguments[i__27619__auto___32267]));

var G__32268 = (i__27619__auto___32267 + (1));
i__27619__auto___32267 = G__32268;
continue;
} else {
}
break;
}

var argseq__27626__auto__ = ((((1) < args__27625__auto__.length))?(new cljs.core.IndexedSeq(args__27625__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__27626__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__32263){
var map__32264 = p__32263;
var map__32264__$1 = ((((!((map__32264 == null)))?((((map__32264.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32264.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32264):map__32264);
var opts = map__32264__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq32261){
var G__32262 = cljs.core.first.call(null,seq32261);
var seq32261__$1 = cljs.core.next.call(null,seq32261);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__32262,seq32261__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__32270 = arguments.length;
switch (G__32270) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__32183__auto___32316 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__32183__auto___32316){
return (function (){
var f__32184__auto__ = (function (){var switch__32095__auto__ = ((function (c__32183__auto___32316){
return (function (state_32294){
var state_val_32295 = (state_32294[(1)]);
if((state_val_32295 === (7))){
var inst_32290 = (state_32294[(2)]);
var state_32294__$1 = state_32294;
var statearr_32296_32317 = state_32294__$1;
(statearr_32296_32317[(2)] = inst_32290);

(statearr_32296_32317[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32295 === (1))){
var state_32294__$1 = state_32294;
var statearr_32297_32318 = state_32294__$1;
(statearr_32297_32318[(2)] = null);

(statearr_32297_32318[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32295 === (4))){
var inst_32273 = (state_32294[(7)]);
var inst_32273__$1 = (state_32294[(2)]);
var inst_32274 = (inst_32273__$1 == null);
var state_32294__$1 = (function (){var statearr_32298 = state_32294;
(statearr_32298[(7)] = inst_32273__$1);

return statearr_32298;
})();
if(cljs.core.truth_(inst_32274)){
var statearr_32299_32319 = state_32294__$1;
(statearr_32299_32319[(1)] = (5));

} else {
var statearr_32300_32320 = state_32294__$1;
(statearr_32300_32320[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32295 === (13))){
var state_32294__$1 = state_32294;
var statearr_32301_32321 = state_32294__$1;
(statearr_32301_32321[(2)] = null);

(statearr_32301_32321[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32295 === (6))){
var inst_32273 = (state_32294[(7)]);
var state_32294__$1 = state_32294;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32294__$1,(11),to,inst_32273);
} else {
if((state_val_32295 === (3))){
var inst_32292 = (state_32294[(2)]);
var state_32294__$1 = state_32294;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32294__$1,inst_32292);
} else {
if((state_val_32295 === (12))){
var state_32294__$1 = state_32294;
var statearr_32302_32322 = state_32294__$1;
(statearr_32302_32322[(2)] = null);

(statearr_32302_32322[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32295 === (2))){
var state_32294__$1 = state_32294;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32294__$1,(4),from);
} else {
if((state_val_32295 === (11))){
var inst_32283 = (state_32294[(2)]);
var state_32294__$1 = state_32294;
if(cljs.core.truth_(inst_32283)){
var statearr_32303_32323 = state_32294__$1;
(statearr_32303_32323[(1)] = (12));

} else {
var statearr_32304_32324 = state_32294__$1;
(statearr_32304_32324[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32295 === (9))){
var state_32294__$1 = state_32294;
var statearr_32305_32325 = state_32294__$1;
(statearr_32305_32325[(2)] = null);

(statearr_32305_32325[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32295 === (5))){
var state_32294__$1 = state_32294;
if(cljs.core.truth_(close_QMARK_)){
var statearr_32306_32326 = state_32294__$1;
(statearr_32306_32326[(1)] = (8));

} else {
var statearr_32307_32327 = state_32294__$1;
(statearr_32307_32327[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32295 === (14))){
var inst_32288 = (state_32294[(2)]);
var state_32294__$1 = state_32294;
var statearr_32308_32328 = state_32294__$1;
(statearr_32308_32328[(2)] = inst_32288);

(statearr_32308_32328[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32295 === (10))){
var inst_32280 = (state_32294[(2)]);
var state_32294__$1 = state_32294;
var statearr_32309_32329 = state_32294__$1;
(statearr_32309_32329[(2)] = inst_32280);

(statearr_32309_32329[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32295 === (8))){
var inst_32277 = cljs.core.async.close_BANG_.call(null,to);
var state_32294__$1 = state_32294;
var statearr_32310_32330 = state_32294__$1;
(statearr_32310_32330[(2)] = inst_32277);

(statearr_32310_32330[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__32183__auto___32316))
;
return ((function (switch__32095__auto__,c__32183__auto___32316){
return (function() {
var cljs$core$async$state_machine__32096__auto__ = null;
var cljs$core$async$state_machine__32096__auto____0 = (function (){
var statearr_32311 = [null,null,null,null,null,null,null,null];
(statearr_32311[(0)] = cljs$core$async$state_machine__32096__auto__);

(statearr_32311[(1)] = (1));

return statearr_32311;
});
var cljs$core$async$state_machine__32096__auto____1 = (function (state_32294){
while(true){
var ret_value__32097__auto__ = (function (){try{while(true){
var result__32098__auto__ = switch__32095__auto__.call(null,state_32294);
if(cljs.core.keyword_identical_QMARK_.call(null,result__32098__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32098__auto__;
}
break;
}
}catch (e32312){if((e32312 instanceof Object)){
var ex__32099__auto__ = e32312;
var statearr_32313_32331 = state_32294;
(statearr_32313_32331[(5)] = ex__32099__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32294);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32312;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__32097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32332 = state_32294;
state_32294 = G__32332;
continue;
} else {
return ret_value__32097__auto__;
}
break;
}
});
cljs$core$async$state_machine__32096__auto__ = function(state_32294){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__32096__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__32096__auto____1.call(this,state_32294);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__32096__auto____0;
cljs$core$async$state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__32096__auto____1;
return cljs$core$async$state_machine__32096__auto__;
})()
;})(switch__32095__auto__,c__32183__auto___32316))
})();
var state__32185__auto__ = (function (){var statearr_32314 = f__32184__auto__.call(null);
(statearr_32314[(6)] = c__32183__auto___32316);

return statearr_32314;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__32185__auto__);
});})(c__32183__auto___32316))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__32333){
var vec__32334 = p__32333;
var v = cljs.core.nth.call(null,vec__32334,(0),null);
var p = cljs.core.nth.call(null,vec__32334,(1),null);
var job = vec__32334;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__32183__auto___32505 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__32183__auto___32505,res,vec__32334,v,p,job,jobs,results){
return (function (){
var f__32184__auto__ = (function (){var switch__32095__auto__ = ((function (c__32183__auto___32505,res,vec__32334,v,p,job,jobs,results){
return (function (state_32341){
var state_val_32342 = (state_32341[(1)]);
if((state_val_32342 === (1))){
var state_32341__$1 = state_32341;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32341__$1,(2),res,v);
} else {
if((state_val_32342 === (2))){
var inst_32338 = (state_32341[(2)]);
var inst_32339 = cljs.core.async.close_BANG_.call(null,res);
var state_32341__$1 = (function (){var statearr_32343 = state_32341;
(statearr_32343[(7)] = inst_32338);

return statearr_32343;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32341__$1,inst_32339);
} else {
return null;
}
}
});})(c__32183__auto___32505,res,vec__32334,v,p,job,jobs,results))
;
return ((function (switch__32095__auto__,c__32183__auto___32505,res,vec__32334,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__32096__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__32096__auto____0 = (function (){
var statearr_32344 = [null,null,null,null,null,null,null,null];
(statearr_32344[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__32096__auto__);

(statearr_32344[(1)] = (1));

return statearr_32344;
});
var cljs$core$async$pipeline_STAR__$_state_machine__32096__auto____1 = (function (state_32341){
while(true){
var ret_value__32097__auto__ = (function (){try{while(true){
var result__32098__auto__ = switch__32095__auto__.call(null,state_32341);
if(cljs.core.keyword_identical_QMARK_.call(null,result__32098__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32098__auto__;
}
break;
}
}catch (e32345){if((e32345 instanceof Object)){
var ex__32099__auto__ = e32345;
var statearr_32346_32506 = state_32341;
(statearr_32346_32506[(5)] = ex__32099__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32341);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32345;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__32097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32507 = state_32341;
state_32341 = G__32507;
continue;
} else {
return ret_value__32097__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__32096__auto__ = function(state_32341){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__32096__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__32096__auto____1.call(this,state_32341);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__32096__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__32096__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__32096__auto__;
})()
;})(switch__32095__auto__,c__32183__auto___32505,res,vec__32334,v,p,job,jobs,results))
})();
var state__32185__auto__ = (function (){var statearr_32347 = f__32184__auto__.call(null);
(statearr_32347[(6)] = c__32183__auto___32505);

return statearr_32347;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__32185__auto__);
});})(c__32183__auto___32505,res,vec__32334,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__32348){
var vec__32349 = p__32348;
var v = cljs.core.nth.call(null,vec__32349,(0),null);
var p = cljs.core.nth.call(null,vec__32349,(1),null);
var job = vec__32349;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__27417__auto___32508 = n;
var __32509 = (0);
while(true){
if((__32509 < n__27417__auto___32508)){
var G__32352_32510 = type;
var G__32352_32511__$1 = (((G__32352_32510 instanceof cljs.core.Keyword))?G__32352_32510.fqn:null);
switch (G__32352_32511__$1) {
case "compute":
var c__32183__auto___32513 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__32509,c__32183__auto___32513,G__32352_32510,G__32352_32511__$1,n__27417__auto___32508,jobs,results,process,async){
return (function (){
var f__32184__auto__ = (function (){var switch__32095__auto__ = ((function (__32509,c__32183__auto___32513,G__32352_32510,G__32352_32511__$1,n__27417__auto___32508,jobs,results,process,async){
return (function (state_32365){
var state_val_32366 = (state_32365[(1)]);
if((state_val_32366 === (1))){
var state_32365__$1 = state_32365;
var statearr_32367_32514 = state_32365__$1;
(statearr_32367_32514[(2)] = null);

(statearr_32367_32514[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32366 === (2))){
var state_32365__$1 = state_32365;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32365__$1,(4),jobs);
} else {
if((state_val_32366 === (3))){
var inst_32363 = (state_32365[(2)]);
var state_32365__$1 = state_32365;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32365__$1,inst_32363);
} else {
if((state_val_32366 === (4))){
var inst_32355 = (state_32365[(2)]);
var inst_32356 = process.call(null,inst_32355);
var state_32365__$1 = state_32365;
if(cljs.core.truth_(inst_32356)){
var statearr_32368_32515 = state_32365__$1;
(statearr_32368_32515[(1)] = (5));

} else {
var statearr_32369_32516 = state_32365__$1;
(statearr_32369_32516[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32366 === (5))){
var state_32365__$1 = state_32365;
var statearr_32370_32517 = state_32365__$1;
(statearr_32370_32517[(2)] = null);

(statearr_32370_32517[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32366 === (6))){
var state_32365__$1 = state_32365;
var statearr_32371_32518 = state_32365__$1;
(statearr_32371_32518[(2)] = null);

(statearr_32371_32518[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32366 === (7))){
var inst_32361 = (state_32365[(2)]);
var state_32365__$1 = state_32365;
var statearr_32372_32519 = state_32365__$1;
(statearr_32372_32519[(2)] = inst_32361);

(statearr_32372_32519[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__32509,c__32183__auto___32513,G__32352_32510,G__32352_32511__$1,n__27417__auto___32508,jobs,results,process,async))
;
return ((function (__32509,switch__32095__auto__,c__32183__auto___32513,G__32352_32510,G__32352_32511__$1,n__27417__auto___32508,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__32096__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__32096__auto____0 = (function (){
var statearr_32373 = [null,null,null,null,null,null,null];
(statearr_32373[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__32096__auto__);

(statearr_32373[(1)] = (1));

return statearr_32373;
});
var cljs$core$async$pipeline_STAR__$_state_machine__32096__auto____1 = (function (state_32365){
while(true){
var ret_value__32097__auto__ = (function (){try{while(true){
var result__32098__auto__ = switch__32095__auto__.call(null,state_32365);
if(cljs.core.keyword_identical_QMARK_.call(null,result__32098__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32098__auto__;
}
break;
}
}catch (e32374){if((e32374 instanceof Object)){
var ex__32099__auto__ = e32374;
var statearr_32375_32520 = state_32365;
(statearr_32375_32520[(5)] = ex__32099__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32365);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32374;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__32097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32521 = state_32365;
state_32365 = G__32521;
continue;
} else {
return ret_value__32097__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__32096__auto__ = function(state_32365){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__32096__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__32096__auto____1.call(this,state_32365);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__32096__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__32096__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__32096__auto__;
})()
;})(__32509,switch__32095__auto__,c__32183__auto___32513,G__32352_32510,G__32352_32511__$1,n__27417__auto___32508,jobs,results,process,async))
})();
var state__32185__auto__ = (function (){var statearr_32376 = f__32184__auto__.call(null);
(statearr_32376[(6)] = c__32183__auto___32513);

return statearr_32376;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__32185__auto__);
});})(__32509,c__32183__auto___32513,G__32352_32510,G__32352_32511__$1,n__27417__auto___32508,jobs,results,process,async))
);


break;
case "async":
var c__32183__auto___32522 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__32509,c__32183__auto___32522,G__32352_32510,G__32352_32511__$1,n__27417__auto___32508,jobs,results,process,async){
return (function (){
var f__32184__auto__ = (function (){var switch__32095__auto__ = ((function (__32509,c__32183__auto___32522,G__32352_32510,G__32352_32511__$1,n__27417__auto___32508,jobs,results,process,async){
return (function (state_32389){
var state_val_32390 = (state_32389[(1)]);
if((state_val_32390 === (1))){
var state_32389__$1 = state_32389;
var statearr_32391_32523 = state_32389__$1;
(statearr_32391_32523[(2)] = null);

(statearr_32391_32523[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32390 === (2))){
var state_32389__$1 = state_32389;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32389__$1,(4),jobs);
} else {
if((state_val_32390 === (3))){
var inst_32387 = (state_32389[(2)]);
var state_32389__$1 = state_32389;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32389__$1,inst_32387);
} else {
if((state_val_32390 === (4))){
var inst_32379 = (state_32389[(2)]);
var inst_32380 = async.call(null,inst_32379);
var state_32389__$1 = state_32389;
if(cljs.core.truth_(inst_32380)){
var statearr_32392_32524 = state_32389__$1;
(statearr_32392_32524[(1)] = (5));

} else {
var statearr_32393_32525 = state_32389__$1;
(statearr_32393_32525[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32390 === (5))){
var state_32389__$1 = state_32389;
var statearr_32394_32526 = state_32389__$1;
(statearr_32394_32526[(2)] = null);

(statearr_32394_32526[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32390 === (6))){
var state_32389__$1 = state_32389;
var statearr_32395_32527 = state_32389__$1;
(statearr_32395_32527[(2)] = null);

(statearr_32395_32527[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32390 === (7))){
var inst_32385 = (state_32389[(2)]);
var state_32389__$1 = state_32389;
var statearr_32396_32528 = state_32389__$1;
(statearr_32396_32528[(2)] = inst_32385);

(statearr_32396_32528[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__32509,c__32183__auto___32522,G__32352_32510,G__32352_32511__$1,n__27417__auto___32508,jobs,results,process,async))
;
return ((function (__32509,switch__32095__auto__,c__32183__auto___32522,G__32352_32510,G__32352_32511__$1,n__27417__auto___32508,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__32096__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__32096__auto____0 = (function (){
var statearr_32397 = [null,null,null,null,null,null,null];
(statearr_32397[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__32096__auto__);

(statearr_32397[(1)] = (1));

return statearr_32397;
});
var cljs$core$async$pipeline_STAR__$_state_machine__32096__auto____1 = (function (state_32389){
while(true){
var ret_value__32097__auto__ = (function (){try{while(true){
var result__32098__auto__ = switch__32095__auto__.call(null,state_32389);
if(cljs.core.keyword_identical_QMARK_.call(null,result__32098__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32098__auto__;
}
break;
}
}catch (e32398){if((e32398 instanceof Object)){
var ex__32099__auto__ = e32398;
var statearr_32399_32529 = state_32389;
(statearr_32399_32529[(5)] = ex__32099__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32389);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32398;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__32097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32530 = state_32389;
state_32389 = G__32530;
continue;
} else {
return ret_value__32097__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__32096__auto__ = function(state_32389){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__32096__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__32096__auto____1.call(this,state_32389);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__32096__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__32096__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__32096__auto__;
})()
;})(__32509,switch__32095__auto__,c__32183__auto___32522,G__32352_32510,G__32352_32511__$1,n__27417__auto___32508,jobs,results,process,async))
})();
var state__32185__auto__ = (function (){var statearr_32400 = f__32184__auto__.call(null);
(statearr_32400[(6)] = c__32183__auto___32522);

return statearr_32400;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__32185__auto__);
});})(__32509,c__32183__auto___32522,G__32352_32510,G__32352_32511__$1,n__27417__auto___32508,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__32352_32511__$1)].join('')));

}

var G__32531 = (__32509 + (1));
__32509 = G__32531;
continue;
} else {
}
break;
}

var c__32183__auto___32532 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__32183__auto___32532,jobs,results,process,async){
return (function (){
var f__32184__auto__ = (function (){var switch__32095__auto__ = ((function (c__32183__auto___32532,jobs,results,process,async){
return (function (state_32422){
var state_val_32423 = (state_32422[(1)]);
if((state_val_32423 === (1))){
var state_32422__$1 = state_32422;
var statearr_32424_32533 = state_32422__$1;
(statearr_32424_32533[(2)] = null);

(statearr_32424_32533[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32423 === (2))){
var state_32422__$1 = state_32422;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32422__$1,(4),from);
} else {
if((state_val_32423 === (3))){
var inst_32420 = (state_32422[(2)]);
var state_32422__$1 = state_32422;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32422__$1,inst_32420);
} else {
if((state_val_32423 === (4))){
var inst_32403 = (state_32422[(7)]);
var inst_32403__$1 = (state_32422[(2)]);
var inst_32404 = (inst_32403__$1 == null);
var state_32422__$1 = (function (){var statearr_32425 = state_32422;
(statearr_32425[(7)] = inst_32403__$1);

return statearr_32425;
})();
if(cljs.core.truth_(inst_32404)){
var statearr_32426_32534 = state_32422__$1;
(statearr_32426_32534[(1)] = (5));

} else {
var statearr_32427_32535 = state_32422__$1;
(statearr_32427_32535[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32423 === (5))){
var inst_32406 = cljs.core.async.close_BANG_.call(null,jobs);
var state_32422__$1 = state_32422;
var statearr_32428_32536 = state_32422__$1;
(statearr_32428_32536[(2)] = inst_32406);

(statearr_32428_32536[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32423 === (6))){
var inst_32403 = (state_32422[(7)]);
var inst_32408 = (state_32422[(8)]);
var inst_32408__$1 = cljs.core.async.chan.call(null,(1));
var inst_32409 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32410 = [inst_32403,inst_32408__$1];
var inst_32411 = (new cljs.core.PersistentVector(null,2,(5),inst_32409,inst_32410,null));
var state_32422__$1 = (function (){var statearr_32429 = state_32422;
(statearr_32429[(8)] = inst_32408__$1);

return statearr_32429;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32422__$1,(8),jobs,inst_32411);
} else {
if((state_val_32423 === (7))){
var inst_32418 = (state_32422[(2)]);
var state_32422__$1 = state_32422;
var statearr_32430_32537 = state_32422__$1;
(statearr_32430_32537[(2)] = inst_32418);

(statearr_32430_32537[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32423 === (8))){
var inst_32408 = (state_32422[(8)]);
var inst_32413 = (state_32422[(2)]);
var state_32422__$1 = (function (){var statearr_32431 = state_32422;
(statearr_32431[(9)] = inst_32413);

return statearr_32431;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32422__$1,(9),results,inst_32408);
} else {
if((state_val_32423 === (9))){
var inst_32415 = (state_32422[(2)]);
var state_32422__$1 = (function (){var statearr_32432 = state_32422;
(statearr_32432[(10)] = inst_32415);

return statearr_32432;
})();
var statearr_32433_32538 = state_32422__$1;
(statearr_32433_32538[(2)] = null);

(statearr_32433_32538[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__32183__auto___32532,jobs,results,process,async))
;
return ((function (switch__32095__auto__,c__32183__auto___32532,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__32096__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__32096__auto____0 = (function (){
var statearr_32434 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32434[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__32096__auto__);

(statearr_32434[(1)] = (1));

return statearr_32434;
});
var cljs$core$async$pipeline_STAR__$_state_machine__32096__auto____1 = (function (state_32422){
while(true){
var ret_value__32097__auto__ = (function (){try{while(true){
var result__32098__auto__ = switch__32095__auto__.call(null,state_32422);
if(cljs.core.keyword_identical_QMARK_.call(null,result__32098__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32098__auto__;
}
break;
}
}catch (e32435){if((e32435 instanceof Object)){
var ex__32099__auto__ = e32435;
var statearr_32436_32539 = state_32422;
(statearr_32436_32539[(5)] = ex__32099__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32422);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32435;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__32097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32540 = state_32422;
state_32422 = G__32540;
continue;
} else {
return ret_value__32097__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__32096__auto__ = function(state_32422){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__32096__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__32096__auto____1.call(this,state_32422);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__32096__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__32096__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__32096__auto__;
})()
;})(switch__32095__auto__,c__32183__auto___32532,jobs,results,process,async))
})();
var state__32185__auto__ = (function (){var statearr_32437 = f__32184__auto__.call(null);
(statearr_32437[(6)] = c__32183__auto___32532);

return statearr_32437;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__32185__auto__);
});})(c__32183__auto___32532,jobs,results,process,async))
);


var c__32183__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__32183__auto__,jobs,results,process,async){
return (function (){
var f__32184__auto__ = (function (){var switch__32095__auto__ = ((function (c__32183__auto__,jobs,results,process,async){
return (function (state_32475){
var state_val_32476 = (state_32475[(1)]);
if((state_val_32476 === (7))){
var inst_32471 = (state_32475[(2)]);
var state_32475__$1 = state_32475;
var statearr_32477_32541 = state_32475__$1;
(statearr_32477_32541[(2)] = inst_32471);

(statearr_32477_32541[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32476 === (20))){
var state_32475__$1 = state_32475;
var statearr_32478_32542 = state_32475__$1;
(statearr_32478_32542[(2)] = null);

(statearr_32478_32542[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32476 === (1))){
var state_32475__$1 = state_32475;
var statearr_32479_32543 = state_32475__$1;
(statearr_32479_32543[(2)] = null);

(statearr_32479_32543[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32476 === (4))){
var inst_32440 = (state_32475[(7)]);
var inst_32440__$1 = (state_32475[(2)]);
var inst_32441 = (inst_32440__$1 == null);
var state_32475__$1 = (function (){var statearr_32480 = state_32475;
(statearr_32480[(7)] = inst_32440__$1);

return statearr_32480;
})();
if(cljs.core.truth_(inst_32441)){
var statearr_32481_32544 = state_32475__$1;
(statearr_32481_32544[(1)] = (5));

} else {
var statearr_32482_32545 = state_32475__$1;
(statearr_32482_32545[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32476 === (15))){
var inst_32453 = (state_32475[(8)]);
var state_32475__$1 = state_32475;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32475__$1,(18),to,inst_32453);
} else {
if((state_val_32476 === (21))){
var inst_32466 = (state_32475[(2)]);
var state_32475__$1 = state_32475;
var statearr_32483_32546 = state_32475__$1;
(statearr_32483_32546[(2)] = inst_32466);

(statearr_32483_32546[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32476 === (13))){
var inst_32468 = (state_32475[(2)]);
var state_32475__$1 = (function (){var statearr_32484 = state_32475;
(statearr_32484[(9)] = inst_32468);

return statearr_32484;
})();
var statearr_32485_32547 = state_32475__$1;
(statearr_32485_32547[(2)] = null);

(statearr_32485_32547[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32476 === (6))){
var inst_32440 = (state_32475[(7)]);
var state_32475__$1 = state_32475;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32475__$1,(11),inst_32440);
} else {
if((state_val_32476 === (17))){
var inst_32461 = (state_32475[(2)]);
var state_32475__$1 = state_32475;
if(cljs.core.truth_(inst_32461)){
var statearr_32486_32548 = state_32475__$1;
(statearr_32486_32548[(1)] = (19));

} else {
var statearr_32487_32549 = state_32475__$1;
(statearr_32487_32549[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32476 === (3))){
var inst_32473 = (state_32475[(2)]);
var state_32475__$1 = state_32475;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32475__$1,inst_32473);
} else {
if((state_val_32476 === (12))){
var inst_32450 = (state_32475[(10)]);
var state_32475__$1 = state_32475;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32475__$1,(14),inst_32450);
} else {
if((state_val_32476 === (2))){
var state_32475__$1 = state_32475;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32475__$1,(4),results);
} else {
if((state_val_32476 === (19))){
var state_32475__$1 = state_32475;
var statearr_32488_32550 = state_32475__$1;
(statearr_32488_32550[(2)] = null);

(statearr_32488_32550[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32476 === (11))){
var inst_32450 = (state_32475[(2)]);
var state_32475__$1 = (function (){var statearr_32489 = state_32475;
(statearr_32489[(10)] = inst_32450);

return statearr_32489;
})();
var statearr_32490_32551 = state_32475__$1;
(statearr_32490_32551[(2)] = null);

(statearr_32490_32551[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32476 === (9))){
var state_32475__$1 = state_32475;
var statearr_32491_32552 = state_32475__$1;
(statearr_32491_32552[(2)] = null);

(statearr_32491_32552[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32476 === (5))){
var state_32475__$1 = state_32475;
if(cljs.core.truth_(close_QMARK_)){
var statearr_32492_32553 = state_32475__$1;
(statearr_32492_32553[(1)] = (8));

} else {
var statearr_32493_32554 = state_32475__$1;
(statearr_32493_32554[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32476 === (14))){
var inst_32453 = (state_32475[(8)]);
var inst_32455 = (state_32475[(11)]);
var inst_32453__$1 = (state_32475[(2)]);
var inst_32454 = (inst_32453__$1 == null);
var inst_32455__$1 = cljs.core.not.call(null,inst_32454);
var state_32475__$1 = (function (){var statearr_32494 = state_32475;
(statearr_32494[(8)] = inst_32453__$1);

(statearr_32494[(11)] = inst_32455__$1);

return statearr_32494;
})();
if(inst_32455__$1){
var statearr_32495_32555 = state_32475__$1;
(statearr_32495_32555[(1)] = (15));

} else {
var statearr_32496_32556 = state_32475__$1;
(statearr_32496_32556[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32476 === (16))){
var inst_32455 = (state_32475[(11)]);
var state_32475__$1 = state_32475;
var statearr_32497_32557 = state_32475__$1;
(statearr_32497_32557[(2)] = inst_32455);

(statearr_32497_32557[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32476 === (10))){
var inst_32447 = (state_32475[(2)]);
var state_32475__$1 = state_32475;
var statearr_32498_32558 = state_32475__$1;
(statearr_32498_32558[(2)] = inst_32447);

(statearr_32498_32558[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32476 === (18))){
var inst_32458 = (state_32475[(2)]);
var state_32475__$1 = state_32475;
var statearr_32499_32559 = state_32475__$1;
(statearr_32499_32559[(2)] = inst_32458);

(statearr_32499_32559[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32476 === (8))){
var inst_32444 = cljs.core.async.close_BANG_.call(null,to);
var state_32475__$1 = state_32475;
var statearr_32500_32560 = state_32475__$1;
(statearr_32500_32560[(2)] = inst_32444);

(statearr_32500_32560[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__32183__auto__,jobs,results,process,async))
;
return ((function (switch__32095__auto__,c__32183__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__32096__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__32096__auto____0 = (function (){
var statearr_32501 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32501[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__32096__auto__);

(statearr_32501[(1)] = (1));

return statearr_32501;
});
var cljs$core$async$pipeline_STAR__$_state_machine__32096__auto____1 = (function (state_32475){
while(true){
var ret_value__32097__auto__ = (function (){try{while(true){
var result__32098__auto__ = switch__32095__auto__.call(null,state_32475);
if(cljs.core.keyword_identical_QMARK_.call(null,result__32098__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32098__auto__;
}
break;
}
}catch (e32502){if((e32502 instanceof Object)){
var ex__32099__auto__ = e32502;
var statearr_32503_32561 = state_32475;
(statearr_32503_32561[(5)] = ex__32099__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32475);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32502;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__32097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32562 = state_32475;
state_32475 = G__32562;
continue;
} else {
return ret_value__32097__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__32096__auto__ = function(state_32475){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__32096__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__32096__auto____1.call(this,state_32475);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__32096__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__32096__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__32096__auto__;
})()
;})(switch__32095__auto__,c__32183__auto__,jobs,results,process,async))
})();
var state__32185__auto__ = (function (){var statearr_32504 = f__32184__auto__.call(null);
(statearr_32504[(6)] = c__32183__auto__);

return statearr_32504;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__32185__auto__);
});})(c__32183__auto__,jobs,results,process,async))
);

return c__32183__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__32564 = arguments.length;
switch (G__32564) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__32567 = arguments.length;
switch (G__32567) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__32570 = arguments.length;
switch (G__32570) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__32183__auto___32619 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__32183__auto___32619,tc,fc){
return (function (){
var f__32184__auto__ = (function (){var switch__32095__auto__ = ((function (c__32183__auto___32619,tc,fc){
return (function (state_32596){
var state_val_32597 = (state_32596[(1)]);
if((state_val_32597 === (7))){
var inst_32592 = (state_32596[(2)]);
var state_32596__$1 = state_32596;
var statearr_32598_32620 = state_32596__$1;
(statearr_32598_32620[(2)] = inst_32592);

(statearr_32598_32620[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32597 === (1))){
var state_32596__$1 = state_32596;
var statearr_32599_32621 = state_32596__$1;
(statearr_32599_32621[(2)] = null);

(statearr_32599_32621[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32597 === (4))){
var inst_32573 = (state_32596[(7)]);
var inst_32573__$1 = (state_32596[(2)]);
var inst_32574 = (inst_32573__$1 == null);
var state_32596__$1 = (function (){var statearr_32600 = state_32596;
(statearr_32600[(7)] = inst_32573__$1);

return statearr_32600;
})();
if(cljs.core.truth_(inst_32574)){
var statearr_32601_32622 = state_32596__$1;
(statearr_32601_32622[(1)] = (5));

} else {
var statearr_32602_32623 = state_32596__$1;
(statearr_32602_32623[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32597 === (13))){
var state_32596__$1 = state_32596;
var statearr_32603_32624 = state_32596__$1;
(statearr_32603_32624[(2)] = null);

(statearr_32603_32624[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32597 === (6))){
var inst_32573 = (state_32596[(7)]);
var inst_32579 = p.call(null,inst_32573);
var state_32596__$1 = state_32596;
if(cljs.core.truth_(inst_32579)){
var statearr_32604_32625 = state_32596__$1;
(statearr_32604_32625[(1)] = (9));

} else {
var statearr_32605_32626 = state_32596__$1;
(statearr_32605_32626[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32597 === (3))){
var inst_32594 = (state_32596[(2)]);
var state_32596__$1 = state_32596;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32596__$1,inst_32594);
} else {
if((state_val_32597 === (12))){
var state_32596__$1 = state_32596;
var statearr_32606_32627 = state_32596__$1;
(statearr_32606_32627[(2)] = null);

(statearr_32606_32627[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32597 === (2))){
var state_32596__$1 = state_32596;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32596__$1,(4),ch);
} else {
if((state_val_32597 === (11))){
var inst_32573 = (state_32596[(7)]);
var inst_32583 = (state_32596[(2)]);
var state_32596__$1 = state_32596;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32596__$1,(8),inst_32583,inst_32573);
} else {
if((state_val_32597 === (9))){
var state_32596__$1 = state_32596;
var statearr_32607_32628 = state_32596__$1;
(statearr_32607_32628[(2)] = tc);

(statearr_32607_32628[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32597 === (5))){
var inst_32576 = cljs.core.async.close_BANG_.call(null,tc);
var inst_32577 = cljs.core.async.close_BANG_.call(null,fc);
var state_32596__$1 = (function (){var statearr_32608 = state_32596;
(statearr_32608[(8)] = inst_32576);

return statearr_32608;
})();
var statearr_32609_32629 = state_32596__$1;
(statearr_32609_32629[(2)] = inst_32577);

(statearr_32609_32629[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32597 === (14))){
var inst_32590 = (state_32596[(2)]);
var state_32596__$1 = state_32596;
var statearr_32610_32630 = state_32596__$1;
(statearr_32610_32630[(2)] = inst_32590);

(statearr_32610_32630[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32597 === (10))){
var state_32596__$1 = state_32596;
var statearr_32611_32631 = state_32596__$1;
(statearr_32611_32631[(2)] = fc);

(statearr_32611_32631[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32597 === (8))){
var inst_32585 = (state_32596[(2)]);
var state_32596__$1 = state_32596;
if(cljs.core.truth_(inst_32585)){
var statearr_32612_32632 = state_32596__$1;
(statearr_32612_32632[(1)] = (12));

} else {
var statearr_32613_32633 = state_32596__$1;
(statearr_32613_32633[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__32183__auto___32619,tc,fc))
;
return ((function (switch__32095__auto__,c__32183__auto___32619,tc,fc){
return (function() {
var cljs$core$async$state_machine__32096__auto__ = null;
var cljs$core$async$state_machine__32096__auto____0 = (function (){
var statearr_32614 = [null,null,null,null,null,null,null,null,null];
(statearr_32614[(0)] = cljs$core$async$state_machine__32096__auto__);

(statearr_32614[(1)] = (1));

return statearr_32614;
});
var cljs$core$async$state_machine__32096__auto____1 = (function (state_32596){
while(true){
var ret_value__32097__auto__ = (function (){try{while(true){
var result__32098__auto__ = switch__32095__auto__.call(null,state_32596);
if(cljs.core.keyword_identical_QMARK_.call(null,result__32098__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32098__auto__;
}
break;
}
}catch (e32615){if((e32615 instanceof Object)){
var ex__32099__auto__ = e32615;
var statearr_32616_32634 = state_32596;
(statearr_32616_32634[(5)] = ex__32099__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32596);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32615;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__32097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32635 = state_32596;
state_32596 = G__32635;
continue;
} else {
return ret_value__32097__auto__;
}
break;
}
});
cljs$core$async$state_machine__32096__auto__ = function(state_32596){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__32096__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__32096__auto____1.call(this,state_32596);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__32096__auto____0;
cljs$core$async$state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__32096__auto____1;
return cljs$core$async$state_machine__32096__auto__;
})()
;})(switch__32095__auto__,c__32183__auto___32619,tc,fc))
})();
var state__32185__auto__ = (function (){var statearr_32617 = f__32184__auto__.call(null);
(statearr_32617[(6)] = c__32183__auto___32619);

return statearr_32617;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__32185__auto__);
});})(c__32183__auto___32619,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__32183__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__32183__auto__){
return (function (){
var f__32184__auto__ = (function (){var switch__32095__auto__ = ((function (c__32183__auto__){
return (function (state_32656){
var state_val_32657 = (state_32656[(1)]);
if((state_val_32657 === (7))){
var inst_32652 = (state_32656[(2)]);
var state_32656__$1 = state_32656;
var statearr_32658_32676 = state_32656__$1;
(statearr_32658_32676[(2)] = inst_32652);

(statearr_32658_32676[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32657 === (1))){
var inst_32636 = init;
var state_32656__$1 = (function (){var statearr_32659 = state_32656;
(statearr_32659[(7)] = inst_32636);

return statearr_32659;
})();
var statearr_32660_32677 = state_32656__$1;
(statearr_32660_32677[(2)] = null);

(statearr_32660_32677[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32657 === (4))){
var inst_32639 = (state_32656[(8)]);
var inst_32639__$1 = (state_32656[(2)]);
var inst_32640 = (inst_32639__$1 == null);
var state_32656__$1 = (function (){var statearr_32661 = state_32656;
(statearr_32661[(8)] = inst_32639__$1);

return statearr_32661;
})();
if(cljs.core.truth_(inst_32640)){
var statearr_32662_32678 = state_32656__$1;
(statearr_32662_32678[(1)] = (5));

} else {
var statearr_32663_32679 = state_32656__$1;
(statearr_32663_32679[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32657 === (6))){
var inst_32639 = (state_32656[(8)]);
var inst_32636 = (state_32656[(7)]);
var inst_32643 = (state_32656[(9)]);
var inst_32643__$1 = f.call(null,inst_32636,inst_32639);
var inst_32644 = cljs.core.reduced_QMARK_.call(null,inst_32643__$1);
var state_32656__$1 = (function (){var statearr_32664 = state_32656;
(statearr_32664[(9)] = inst_32643__$1);

return statearr_32664;
})();
if(inst_32644){
var statearr_32665_32680 = state_32656__$1;
(statearr_32665_32680[(1)] = (8));

} else {
var statearr_32666_32681 = state_32656__$1;
(statearr_32666_32681[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32657 === (3))){
var inst_32654 = (state_32656[(2)]);
var state_32656__$1 = state_32656;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32656__$1,inst_32654);
} else {
if((state_val_32657 === (2))){
var state_32656__$1 = state_32656;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32656__$1,(4),ch);
} else {
if((state_val_32657 === (9))){
var inst_32643 = (state_32656[(9)]);
var inst_32636 = inst_32643;
var state_32656__$1 = (function (){var statearr_32667 = state_32656;
(statearr_32667[(7)] = inst_32636);

return statearr_32667;
})();
var statearr_32668_32682 = state_32656__$1;
(statearr_32668_32682[(2)] = null);

(statearr_32668_32682[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32657 === (5))){
var inst_32636 = (state_32656[(7)]);
var state_32656__$1 = state_32656;
var statearr_32669_32683 = state_32656__$1;
(statearr_32669_32683[(2)] = inst_32636);

(statearr_32669_32683[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32657 === (10))){
var inst_32650 = (state_32656[(2)]);
var state_32656__$1 = state_32656;
var statearr_32670_32684 = state_32656__$1;
(statearr_32670_32684[(2)] = inst_32650);

(statearr_32670_32684[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32657 === (8))){
var inst_32643 = (state_32656[(9)]);
var inst_32646 = cljs.core.deref.call(null,inst_32643);
var state_32656__$1 = state_32656;
var statearr_32671_32685 = state_32656__$1;
(statearr_32671_32685[(2)] = inst_32646);

(statearr_32671_32685[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__32183__auto__))
;
return ((function (switch__32095__auto__,c__32183__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__32096__auto__ = null;
var cljs$core$async$reduce_$_state_machine__32096__auto____0 = (function (){
var statearr_32672 = [null,null,null,null,null,null,null,null,null,null];
(statearr_32672[(0)] = cljs$core$async$reduce_$_state_machine__32096__auto__);

(statearr_32672[(1)] = (1));

return statearr_32672;
});
var cljs$core$async$reduce_$_state_machine__32096__auto____1 = (function (state_32656){
while(true){
var ret_value__32097__auto__ = (function (){try{while(true){
var result__32098__auto__ = switch__32095__auto__.call(null,state_32656);
if(cljs.core.keyword_identical_QMARK_.call(null,result__32098__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32098__auto__;
}
break;
}
}catch (e32673){if((e32673 instanceof Object)){
var ex__32099__auto__ = e32673;
var statearr_32674_32686 = state_32656;
(statearr_32674_32686[(5)] = ex__32099__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32656);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32673;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__32097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32687 = state_32656;
state_32656 = G__32687;
continue;
} else {
return ret_value__32097__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__32096__auto__ = function(state_32656){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__32096__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__32096__auto____1.call(this,state_32656);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__32096__auto____0;
cljs$core$async$reduce_$_state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__32096__auto____1;
return cljs$core$async$reduce_$_state_machine__32096__auto__;
})()
;})(switch__32095__auto__,c__32183__auto__))
})();
var state__32185__auto__ = (function (){var statearr_32675 = f__32184__auto__.call(null);
(statearr_32675[(6)] = c__32183__auto__);

return statearr_32675;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__32185__auto__);
});})(c__32183__auto__))
);

return c__32183__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__32183__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__32183__auto__,f__$1){
return (function (){
var f__32184__auto__ = (function (){var switch__32095__auto__ = ((function (c__32183__auto__,f__$1){
return (function (state_32693){
var state_val_32694 = (state_32693[(1)]);
if((state_val_32694 === (1))){
var inst_32688 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_32693__$1 = state_32693;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32693__$1,(2),inst_32688);
} else {
if((state_val_32694 === (2))){
var inst_32690 = (state_32693[(2)]);
var inst_32691 = f__$1.call(null,inst_32690);
var state_32693__$1 = state_32693;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32693__$1,inst_32691);
} else {
return null;
}
}
});})(c__32183__auto__,f__$1))
;
return ((function (switch__32095__auto__,c__32183__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__32096__auto__ = null;
var cljs$core$async$transduce_$_state_machine__32096__auto____0 = (function (){
var statearr_32695 = [null,null,null,null,null,null,null];
(statearr_32695[(0)] = cljs$core$async$transduce_$_state_machine__32096__auto__);

(statearr_32695[(1)] = (1));

return statearr_32695;
});
var cljs$core$async$transduce_$_state_machine__32096__auto____1 = (function (state_32693){
while(true){
var ret_value__32097__auto__ = (function (){try{while(true){
var result__32098__auto__ = switch__32095__auto__.call(null,state_32693);
if(cljs.core.keyword_identical_QMARK_.call(null,result__32098__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32098__auto__;
}
break;
}
}catch (e32696){if((e32696 instanceof Object)){
var ex__32099__auto__ = e32696;
var statearr_32697_32699 = state_32693;
(statearr_32697_32699[(5)] = ex__32099__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32693);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32696;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__32097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32700 = state_32693;
state_32693 = G__32700;
continue;
} else {
return ret_value__32097__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__32096__auto__ = function(state_32693){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__32096__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__32096__auto____1.call(this,state_32693);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__32096__auto____0;
cljs$core$async$transduce_$_state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__32096__auto____1;
return cljs$core$async$transduce_$_state_machine__32096__auto__;
})()
;})(switch__32095__auto__,c__32183__auto__,f__$1))
})();
var state__32185__auto__ = (function (){var statearr_32698 = f__32184__auto__.call(null);
(statearr_32698[(6)] = c__32183__auto__);

return statearr_32698;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__32185__auto__);
});})(c__32183__auto__,f__$1))
);

return c__32183__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__32702 = arguments.length;
switch (G__32702) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__32183__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__32183__auto__){
return (function (){
var f__32184__auto__ = (function (){var switch__32095__auto__ = ((function (c__32183__auto__){
return (function (state_32727){
var state_val_32728 = (state_32727[(1)]);
if((state_val_32728 === (7))){
var inst_32709 = (state_32727[(2)]);
var state_32727__$1 = state_32727;
var statearr_32729_32750 = state_32727__$1;
(statearr_32729_32750[(2)] = inst_32709);

(statearr_32729_32750[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32728 === (1))){
var inst_32703 = cljs.core.seq.call(null,coll);
var inst_32704 = inst_32703;
var state_32727__$1 = (function (){var statearr_32730 = state_32727;
(statearr_32730[(7)] = inst_32704);

return statearr_32730;
})();
var statearr_32731_32751 = state_32727__$1;
(statearr_32731_32751[(2)] = null);

(statearr_32731_32751[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32728 === (4))){
var inst_32704 = (state_32727[(7)]);
var inst_32707 = cljs.core.first.call(null,inst_32704);
var state_32727__$1 = state_32727;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32727__$1,(7),ch,inst_32707);
} else {
if((state_val_32728 === (13))){
var inst_32721 = (state_32727[(2)]);
var state_32727__$1 = state_32727;
var statearr_32732_32752 = state_32727__$1;
(statearr_32732_32752[(2)] = inst_32721);

(statearr_32732_32752[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32728 === (6))){
var inst_32712 = (state_32727[(2)]);
var state_32727__$1 = state_32727;
if(cljs.core.truth_(inst_32712)){
var statearr_32733_32753 = state_32727__$1;
(statearr_32733_32753[(1)] = (8));

} else {
var statearr_32734_32754 = state_32727__$1;
(statearr_32734_32754[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32728 === (3))){
var inst_32725 = (state_32727[(2)]);
var state_32727__$1 = state_32727;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32727__$1,inst_32725);
} else {
if((state_val_32728 === (12))){
var state_32727__$1 = state_32727;
var statearr_32735_32755 = state_32727__$1;
(statearr_32735_32755[(2)] = null);

(statearr_32735_32755[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32728 === (2))){
var inst_32704 = (state_32727[(7)]);
var state_32727__$1 = state_32727;
if(cljs.core.truth_(inst_32704)){
var statearr_32736_32756 = state_32727__$1;
(statearr_32736_32756[(1)] = (4));

} else {
var statearr_32737_32757 = state_32727__$1;
(statearr_32737_32757[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32728 === (11))){
var inst_32718 = cljs.core.async.close_BANG_.call(null,ch);
var state_32727__$1 = state_32727;
var statearr_32738_32758 = state_32727__$1;
(statearr_32738_32758[(2)] = inst_32718);

(statearr_32738_32758[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32728 === (9))){
var state_32727__$1 = state_32727;
if(cljs.core.truth_(close_QMARK_)){
var statearr_32739_32759 = state_32727__$1;
(statearr_32739_32759[(1)] = (11));

} else {
var statearr_32740_32760 = state_32727__$1;
(statearr_32740_32760[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32728 === (5))){
var inst_32704 = (state_32727[(7)]);
var state_32727__$1 = state_32727;
var statearr_32741_32761 = state_32727__$1;
(statearr_32741_32761[(2)] = inst_32704);

(statearr_32741_32761[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32728 === (10))){
var inst_32723 = (state_32727[(2)]);
var state_32727__$1 = state_32727;
var statearr_32742_32762 = state_32727__$1;
(statearr_32742_32762[(2)] = inst_32723);

(statearr_32742_32762[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32728 === (8))){
var inst_32704 = (state_32727[(7)]);
var inst_32714 = cljs.core.next.call(null,inst_32704);
var inst_32704__$1 = inst_32714;
var state_32727__$1 = (function (){var statearr_32743 = state_32727;
(statearr_32743[(7)] = inst_32704__$1);

return statearr_32743;
})();
var statearr_32744_32763 = state_32727__$1;
(statearr_32744_32763[(2)] = null);

(statearr_32744_32763[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__32183__auto__))
;
return ((function (switch__32095__auto__,c__32183__auto__){
return (function() {
var cljs$core$async$state_machine__32096__auto__ = null;
var cljs$core$async$state_machine__32096__auto____0 = (function (){
var statearr_32745 = [null,null,null,null,null,null,null,null];
(statearr_32745[(0)] = cljs$core$async$state_machine__32096__auto__);

(statearr_32745[(1)] = (1));

return statearr_32745;
});
var cljs$core$async$state_machine__32096__auto____1 = (function (state_32727){
while(true){
var ret_value__32097__auto__ = (function (){try{while(true){
var result__32098__auto__ = switch__32095__auto__.call(null,state_32727);
if(cljs.core.keyword_identical_QMARK_.call(null,result__32098__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32098__auto__;
}
break;
}
}catch (e32746){if((e32746 instanceof Object)){
var ex__32099__auto__ = e32746;
var statearr_32747_32764 = state_32727;
(statearr_32747_32764[(5)] = ex__32099__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32727);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32746;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__32097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32765 = state_32727;
state_32727 = G__32765;
continue;
} else {
return ret_value__32097__auto__;
}
break;
}
});
cljs$core$async$state_machine__32096__auto__ = function(state_32727){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__32096__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__32096__auto____1.call(this,state_32727);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__32096__auto____0;
cljs$core$async$state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__32096__auto____1;
return cljs$core$async$state_machine__32096__auto__;
})()
;})(switch__32095__auto__,c__32183__auto__))
})();
var state__32185__auto__ = (function (){var statearr_32748 = f__32184__auto__.call(null);
(statearr_32748[(6)] = c__32183__auto__);

return statearr_32748;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__32185__auto__);
});})(c__32183__auto__))
);

return c__32183__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__27162__auto__ = (((_ == null))?null:_);
var m__27163__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__27162__auto__)]);
if(!((m__27163__auto__ == null))){
return m__27163__auto__.call(null,_);
} else {
var m__27163__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__27163__auto____$1 == null))){
return m__27163__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__27162__auto__ = (((m == null))?null:m);
var m__27163__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__27162__auto__)]);
if(!((m__27163__auto__ == null))){
return m__27163__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__27163__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__27163__auto____$1 == null))){
return m__27163__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__27162__auto__ = (((m == null))?null:m);
var m__27163__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__27162__auto__)]);
if(!((m__27163__auto__ == null))){
return m__27163__auto__.call(null,m,ch);
} else {
var m__27163__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__27163__auto____$1 == null))){
return m__27163__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__27162__auto__ = (((m == null))?null:m);
var m__27163__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__27162__auto__)]);
if(!((m__27163__auto__ == null))){
return m__27163__auto__.call(null,m);
} else {
var m__27163__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__27163__auto____$1 == null))){
return m__27163__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async32766 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32766 = (function (ch,cs,meta32767){
this.ch = ch;
this.cs = cs;
this.meta32767 = meta32767;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32766.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_32768,meta32767__$1){
var self__ = this;
var _32768__$1 = this;
return (new cljs.core.async.t_cljs$core$async32766(self__.ch,self__.cs,meta32767__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async32766.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_32768){
var self__ = this;
var _32768__$1 = this;
return self__.meta32767;
});})(cs))
;

cljs.core.async.t_cljs$core$async32766.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32766.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async32766.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32766.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async32766.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async32766.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async32766.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta32767","meta32767",-978647819,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async32766.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32766.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32766";

cljs.core.async.t_cljs$core$async32766.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__27104__auto__,writer__27105__auto__,opt__27106__auto__){
return cljs.core._write.call(null,writer__27105__auto__,"cljs.core.async/t_cljs$core$async32766");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async32766 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async32766(ch__$1,cs__$1,meta32767){
return (new cljs.core.async.t_cljs$core$async32766(ch__$1,cs__$1,meta32767));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async32766(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__32183__auto___32988 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__32183__auto___32988,cs,m,dchan,dctr,done){
return (function (){
var f__32184__auto__ = (function (){var switch__32095__auto__ = ((function (c__32183__auto___32988,cs,m,dchan,dctr,done){
return (function (state_32903){
var state_val_32904 = (state_32903[(1)]);
if((state_val_32904 === (7))){
var inst_32899 = (state_32903[(2)]);
var state_32903__$1 = state_32903;
var statearr_32905_32989 = state_32903__$1;
(statearr_32905_32989[(2)] = inst_32899);

(statearr_32905_32989[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (20))){
var inst_32802 = (state_32903[(7)]);
var inst_32814 = cljs.core.first.call(null,inst_32802);
var inst_32815 = cljs.core.nth.call(null,inst_32814,(0),null);
var inst_32816 = cljs.core.nth.call(null,inst_32814,(1),null);
var state_32903__$1 = (function (){var statearr_32906 = state_32903;
(statearr_32906[(8)] = inst_32815);

return statearr_32906;
})();
if(cljs.core.truth_(inst_32816)){
var statearr_32907_32990 = state_32903__$1;
(statearr_32907_32990[(1)] = (22));

} else {
var statearr_32908_32991 = state_32903__$1;
(statearr_32908_32991[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (27))){
var inst_32846 = (state_32903[(9)]);
var inst_32771 = (state_32903[(10)]);
var inst_32844 = (state_32903[(11)]);
var inst_32851 = (state_32903[(12)]);
var inst_32851__$1 = cljs.core._nth.call(null,inst_32844,inst_32846);
var inst_32852 = cljs.core.async.put_BANG_.call(null,inst_32851__$1,inst_32771,done);
var state_32903__$1 = (function (){var statearr_32909 = state_32903;
(statearr_32909[(12)] = inst_32851__$1);

return statearr_32909;
})();
if(cljs.core.truth_(inst_32852)){
var statearr_32910_32992 = state_32903__$1;
(statearr_32910_32992[(1)] = (30));

} else {
var statearr_32911_32993 = state_32903__$1;
(statearr_32911_32993[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (1))){
var state_32903__$1 = state_32903;
var statearr_32912_32994 = state_32903__$1;
(statearr_32912_32994[(2)] = null);

(statearr_32912_32994[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (24))){
var inst_32802 = (state_32903[(7)]);
var inst_32821 = (state_32903[(2)]);
var inst_32822 = cljs.core.next.call(null,inst_32802);
var inst_32780 = inst_32822;
var inst_32781 = null;
var inst_32782 = (0);
var inst_32783 = (0);
var state_32903__$1 = (function (){var statearr_32913 = state_32903;
(statearr_32913[(13)] = inst_32821);

(statearr_32913[(14)] = inst_32782);

(statearr_32913[(15)] = inst_32783);

(statearr_32913[(16)] = inst_32780);

(statearr_32913[(17)] = inst_32781);

return statearr_32913;
})();
var statearr_32914_32995 = state_32903__$1;
(statearr_32914_32995[(2)] = null);

(statearr_32914_32995[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (39))){
var state_32903__$1 = state_32903;
var statearr_32918_32996 = state_32903__$1;
(statearr_32918_32996[(2)] = null);

(statearr_32918_32996[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (4))){
var inst_32771 = (state_32903[(10)]);
var inst_32771__$1 = (state_32903[(2)]);
var inst_32772 = (inst_32771__$1 == null);
var state_32903__$1 = (function (){var statearr_32919 = state_32903;
(statearr_32919[(10)] = inst_32771__$1);

return statearr_32919;
})();
if(cljs.core.truth_(inst_32772)){
var statearr_32920_32997 = state_32903__$1;
(statearr_32920_32997[(1)] = (5));

} else {
var statearr_32921_32998 = state_32903__$1;
(statearr_32921_32998[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (15))){
var inst_32782 = (state_32903[(14)]);
var inst_32783 = (state_32903[(15)]);
var inst_32780 = (state_32903[(16)]);
var inst_32781 = (state_32903[(17)]);
var inst_32798 = (state_32903[(2)]);
var inst_32799 = (inst_32783 + (1));
var tmp32915 = inst_32782;
var tmp32916 = inst_32780;
var tmp32917 = inst_32781;
var inst_32780__$1 = tmp32916;
var inst_32781__$1 = tmp32917;
var inst_32782__$1 = tmp32915;
var inst_32783__$1 = inst_32799;
var state_32903__$1 = (function (){var statearr_32922 = state_32903;
(statearr_32922[(14)] = inst_32782__$1);

(statearr_32922[(15)] = inst_32783__$1);

(statearr_32922[(16)] = inst_32780__$1);

(statearr_32922[(18)] = inst_32798);

(statearr_32922[(17)] = inst_32781__$1);

return statearr_32922;
})();
var statearr_32923_32999 = state_32903__$1;
(statearr_32923_32999[(2)] = null);

(statearr_32923_32999[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (21))){
var inst_32825 = (state_32903[(2)]);
var state_32903__$1 = state_32903;
var statearr_32927_33000 = state_32903__$1;
(statearr_32927_33000[(2)] = inst_32825);

(statearr_32927_33000[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (31))){
var inst_32851 = (state_32903[(12)]);
var inst_32855 = done.call(null,null);
var inst_32856 = cljs.core.async.untap_STAR_.call(null,m,inst_32851);
var state_32903__$1 = (function (){var statearr_32928 = state_32903;
(statearr_32928[(19)] = inst_32855);

return statearr_32928;
})();
var statearr_32929_33001 = state_32903__$1;
(statearr_32929_33001[(2)] = inst_32856);

(statearr_32929_33001[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (32))){
var inst_32846 = (state_32903[(9)]);
var inst_32843 = (state_32903[(20)]);
var inst_32844 = (state_32903[(11)]);
var inst_32845 = (state_32903[(21)]);
var inst_32858 = (state_32903[(2)]);
var inst_32859 = (inst_32846 + (1));
var tmp32924 = inst_32843;
var tmp32925 = inst_32844;
var tmp32926 = inst_32845;
var inst_32843__$1 = tmp32924;
var inst_32844__$1 = tmp32925;
var inst_32845__$1 = tmp32926;
var inst_32846__$1 = inst_32859;
var state_32903__$1 = (function (){var statearr_32930 = state_32903;
(statearr_32930[(9)] = inst_32846__$1);

(statearr_32930[(20)] = inst_32843__$1);

(statearr_32930[(11)] = inst_32844__$1);

(statearr_32930[(21)] = inst_32845__$1);

(statearr_32930[(22)] = inst_32858);

return statearr_32930;
})();
var statearr_32931_33002 = state_32903__$1;
(statearr_32931_33002[(2)] = null);

(statearr_32931_33002[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (40))){
var inst_32871 = (state_32903[(23)]);
var inst_32875 = done.call(null,null);
var inst_32876 = cljs.core.async.untap_STAR_.call(null,m,inst_32871);
var state_32903__$1 = (function (){var statearr_32932 = state_32903;
(statearr_32932[(24)] = inst_32875);

return statearr_32932;
})();
var statearr_32933_33003 = state_32903__$1;
(statearr_32933_33003[(2)] = inst_32876);

(statearr_32933_33003[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (33))){
var inst_32862 = (state_32903[(25)]);
var inst_32864 = cljs.core.chunked_seq_QMARK_.call(null,inst_32862);
var state_32903__$1 = state_32903;
if(inst_32864){
var statearr_32934_33004 = state_32903__$1;
(statearr_32934_33004[(1)] = (36));

} else {
var statearr_32935_33005 = state_32903__$1;
(statearr_32935_33005[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (13))){
var inst_32792 = (state_32903[(26)]);
var inst_32795 = cljs.core.async.close_BANG_.call(null,inst_32792);
var state_32903__$1 = state_32903;
var statearr_32936_33006 = state_32903__$1;
(statearr_32936_33006[(2)] = inst_32795);

(statearr_32936_33006[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (22))){
var inst_32815 = (state_32903[(8)]);
var inst_32818 = cljs.core.async.close_BANG_.call(null,inst_32815);
var state_32903__$1 = state_32903;
var statearr_32937_33007 = state_32903__$1;
(statearr_32937_33007[(2)] = inst_32818);

(statearr_32937_33007[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (36))){
var inst_32862 = (state_32903[(25)]);
var inst_32866 = cljs.core.chunk_first.call(null,inst_32862);
var inst_32867 = cljs.core.chunk_rest.call(null,inst_32862);
var inst_32868 = cljs.core.count.call(null,inst_32866);
var inst_32843 = inst_32867;
var inst_32844 = inst_32866;
var inst_32845 = inst_32868;
var inst_32846 = (0);
var state_32903__$1 = (function (){var statearr_32938 = state_32903;
(statearr_32938[(9)] = inst_32846);

(statearr_32938[(20)] = inst_32843);

(statearr_32938[(11)] = inst_32844);

(statearr_32938[(21)] = inst_32845);

return statearr_32938;
})();
var statearr_32939_33008 = state_32903__$1;
(statearr_32939_33008[(2)] = null);

(statearr_32939_33008[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (41))){
var inst_32862 = (state_32903[(25)]);
var inst_32878 = (state_32903[(2)]);
var inst_32879 = cljs.core.next.call(null,inst_32862);
var inst_32843 = inst_32879;
var inst_32844 = null;
var inst_32845 = (0);
var inst_32846 = (0);
var state_32903__$1 = (function (){var statearr_32940 = state_32903;
(statearr_32940[(9)] = inst_32846);

(statearr_32940[(20)] = inst_32843);

(statearr_32940[(11)] = inst_32844);

(statearr_32940[(27)] = inst_32878);

(statearr_32940[(21)] = inst_32845);

return statearr_32940;
})();
var statearr_32941_33009 = state_32903__$1;
(statearr_32941_33009[(2)] = null);

(statearr_32941_33009[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (43))){
var state_32903__$1 = state_32903;
var statearr_32942_33010 = state_32903__$1;
(statearr_32942_33010[(2)] = null);

(statearr_32942_33010[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (29))){
var inst_32887 = (state_32903[(2)]);
var state_32903__$1 = state_32903;
var statearr_32943_33011 = state_32903__$1;
(statearr_32943_33011[(2)] = inst_32887);

(statearr_32943_33011[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (44))){
var inst_32896 = (state_32903[(2)]);
var state_32903__$1 = (function (){var statearr_32944 = state_32903;
(statearr_32944[(28)] = inst_32896);

return statearr_32944;
})();
var statearr_32945_33012 = state_32903__$1;
(statearr_32945_33012[(2)] = null);

(statearr_32945_33012[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (6))){
var inst_32835 = (state_32903[(29)]);
var inst_32834 = cljs.core.deref.call(null,cs);
var inst_32835__$1 = cljs.core.keys.call(null,inst_32834);
var inst_32836 = cljs.core.count.call(null,inst_32835__$1);
var inst_32837 = cljs.core.reset_BANG_.call(null,dctr,inst_32836);
var inst_32842 = cljs.core.seq.call(null,inst_32835__$1);
var inst_32843 = inst_32842;
var inst_32844 = null;
var inst_32845 = (0);
var inst_32846 = (0);
var state_32903__$1 = (function (){var statearr_32946 = state_32903;
(statearr_32946[(9)] = inst_32846);

(statearr_32946[(20)] = inst_32843);

(statearr_32946[(11)] = inst_32844);

(statearr_32946[(29)] = inst_32835__$1);

(statearr_32946[(21)] = inst_32845);

(statearr_32946[(30)] = inst_32837);

return statearr_32946;
})();
var statearr_32947_33013 = state_32903__$1;
(statearr_32947_33013[(2)] = null);

(statearr_32947_33013[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (28))){
var inst_32843 = (state_32903[(20)]);
var inst_32862 = (state_32903[(25)]);
var inst_32862__$1 = cljs.core.seq.call(null,inst_32843);
var state_32903__$1 = (function (){var statearr_32948 = state_32903;
(statearr_32948[(25)] = inst_32862__$1);

return statearr_32948;
})();
if(inst_32862__$1){
var statearr_32949_33014 = state_32903__$1;
(statearr_32949_33014[(1)] = (33));

} else {
var statearr_32950_33015 = state_32903__$1;
(statearr_32950_33015[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (25))){
var inst_32846 = (state_32903[(9)]);
var inst_32845 = (state_32903[(21)]);
var inst_32848 = (inst_32846 < inst_32845);
var inst_32849 = inst_32848;
var state_32903__$1 = state_32903;
if(cljs.core.truth_(inst_32849)){
var statearr_32951_33016 = state_32903__$1;
(statearr_32951_33016[(1)] = (27));

} else {
var statearr_32952_33017 = state_32903__$1;
(statearr_32952_33017[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (34))){
var state_32903__$1 = state_32903;
var statearr_32953_33018 = state_32903__$1;
(statearr_32953_33018[(2)] = null);

(statearr_32953_33018[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (17))){
var state_32903__$1 = state_32903;
var statearr_32954_33019 = state_32903__$1;
(statearr_32954_33019[(2)] = null);

(statearr_32954_33019[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (3))){
var inst_32901 = (state_32903[(2)]);
var state_32903__$1 = state_32903;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32903__$1,inst_32901);
} else {
if((state_val_32904 === (12))){
var inst_32830 = (state_32903[(2)]);
var state_32903__$1 = state_32903;
var statearr_32955_33020 = state_32903__$1;
(statearr_32955_33020[(2)] = inst_32830);

(statearr_32955_33020[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (2))){
var state_32903__$1 = state_32903;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32903__$1,(4),ch);
} else {
if((state_val_32904 === (23))){
var state_32903__$1 = state_32903;
var statearr_32956_33021 = state_32903__$1;
(statearr_32956_33021[(2)] = null);

(statearr_32956_33021[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (35))){
var inst_32885 = (state_32903[(2)]);
var state_32903__$1 = state_32903;
var statearr_32957_33022 = state_32903__$1;
(statearr_32957_33022[(2)] = inst_32885);

(statearr_32957_33022[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (19))){
var inst_32802 = (state_32903[(7)]);
var inst_32806 = cljs.core.chunk_first.call(null,inst_32802);
var inst_32807 = cljs.core.chunk_rest.call(null,inst_32802);
var inst_32808 = cljs.core.count.call(null,inst_32806);
var inst_32780 = inst_32807;
var inst_32781 = inst_32806;
var inst_32782 = inst_32808;
var inst_32783 = (0);
var state_32903__$1 = (function (){var statearr_32958 = state_32903;
(statearr_32958[(14)] = inst_32782);

(statearr_32958[(15)] = inst_32783);

(statearr_32958[(16)] = inst_32780);

(statearr_32958[(17)] = inst_32781);

return statearr_32958;
})();
var statearr_32959_33023 = state_32903__$1;
(statearr_32959_33023[(2)] = null);

(statearr_32959_33023[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (11))){
var inst_32802 = (state_32903[(7)]);
var inst_32780 = (state_32903[(16)]);
var inst_32802__$1 = cljs.core.seq.call(null,inst_32780);
var state_32903__$1 = (function (){var statearr_32960 = state_32903;
(statearr_32960[(7)] = inst_32802__$1);

return statearr_32960;
})();
if(inst_32802__$1){
var statearr_32961_33024 = state_32903__$1;
(statearr_32961_33024[(1)] = (16));

} else {
var statearr_32962_33025 = state_32903__$1;
(statearr_32962_33025[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (9))){
var inst_32832 = (state_32903[(2)]);
var state_32903__$1 = state_32903;
var statearr_32963_33026 = state_32903__$1;
(statearr_32963_33026[(2)] = inst_32832);

(statearr_32963_33026[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (5))){
var inst_32778 = cljs.core.deref.call(null,cs);
var inst_32779 = cljs.core.seq.call(null,inst_32778);
var inst_32780 = inst_32779;
var inst_32781 = null;
var inst_32782 = (0);
var inst_32783 = (0);
var state_32903__$1 = (function (){var statearr_32964 = state_32903;
(statearr_32964[(14)] = inst_32782);

(statearr_32964[(15)] = inst_32783);

(statearr_32964[(16)] = inst_32780);

(statearr_32964[(17)] = inst_32781);

return statearr_32964;
})();
var statearr_32965_33027 = state_32903__$1;
(statearr_32965_33027[(2)] = null);

(statearr_32965_33027[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (14))){
var state_32903__$1 = state_32903;
var statearr_32966_33028 = state_32903__$1;
(statearr_32966_33028[(2)] = null);

(statearr_32966_33028[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (45))){
var inst_32893 = (state_32903[(2)]);
var state_32903__$1 = state_32903;
var statearr_32967_33029 = state_32903__$1;
(statearr_32967_33029[(2)] = inst_32893);

(statearr_32967_33029[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (26))){
var inst_32835 = (state_32903[(29)]);
var inst_32889 = (state_32903[(2)]);
var inst_32890 = cljs.core.seq.call(null,inst_32835);
var state_32903__$1 = (function (){var statearr_32968 = state_32903;
(statearr_32968[(31)] = inst_32889);

return statearr_32968;
})();
if(inst_32890){
var statearr_32969_33030 = state_32903__$1;
(statearr_32969_33030[(1)] = (42));

} else {
var statearr_32970_33031 = state_32903__$1;
(statearr_32970_33031[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (16))){
var inst_32802 = (state_32903[(7)]);
var inst_32804 = cljs.core.chunked_seq_QMARK_.call(null,inst_32802);
var state_32903__$1 = state_32903;
if(inst_32804){
var statearr_32971_33032 = state_32903__$1;
(statearr_32971_33032[(1)] = (19));

} else {
var statearr_32972_33033 = state_32903__$1;
(statearr_32972_33033[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (38))){
var inst_32882 = (state_32903[(2)]);
var state_32903__$1 = state_32903;
var statearr_32973_33034 = state_32903__$1;
(statearr_32973_33034[(2)] = inst_32882);

(statearr_32973_33034[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (30))){
var state_32903__$1 = state_32903;
var statearr_32974_33035 = state_32903__$1;
(statearr_32974_33035[(2)] = null);

(statearr_32974_33035[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (10))){
var inst_32783 = (state_32903[(15)]);
var inst_32781 = (state_32903[(17)]);
var inst_32791 = cljs.core._nth.call(null,inst_32781,inst_32783);
var inst_32792 = cljs.core.nth.call(null,inst_32791,(0),null);
var inst_32793 = cljs.core.nth.call(null,inst_32791,(1),null);
var state_32903__$1 = (function (){var statearr_32975 = state_32903;
(statearr_32975[(26)] = inst_32792);

return statearr_32975;
})();
if(cljs.core.truth_(inst_32793)){
var statearr_32976_33036 = state_32903__$1;
(statearr_32976_33036[(1)] = (13));

} else {
var statearr_32977_33037 = state_32903__$1;
(statearr_32977_33037[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (18))){
var inst_32828 = (state_32903[(2)]);
var state_32903__$1 = state_32903;
var statearr_32978_33038 = state_32903__$1;
(statearr_32978_33038[(2)] = inst_32828);

(statearr_32978_33038[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (42))){
var state_32903__$1 = state_32903;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32903__$1,(45),dchan);
} else {
if((state_val_32904 === (37))){
var inst_32771 = (state_32903[(10)]);
var inst_32871 = (state_32903[(23)]);
var inst_32862 = (state_32903[(25)]);
var inst_32871__$1 = cljs.core.first.call(null,inst_32862);
var inst_32872 = cljs.core.async.put_BANG_.call(null,inst_32871__$1,inst_32771,done);
var state_32903__$1 = (function (){var statearr_32979 = state_32903;
(statearr_32979[(23)] = inst_32871__$1);

return statearr_32979;
})();
if(cljs.core.truth_(inst_32872)){
var statearr_32980_33039 = state_32903__$1;
(statearr_32980_33039[(1)] = (39));

} else {
var statearr_32981_33040 = state_32903__$1;
(statearr_32981_33040[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32904 === (8))){
var inst_32782 = (state_32903[(14)]);
var inst_32783 = (state_32903[(15)]);
var inst_32785 = (inst_32783 < inst_32782);
var inst_32786 = inst_32785;
var state_32903__$1 = state_32903;
if(cljs.core.truth_(inst_32786)){
var statearr_32982_33041 = state_32903__$1;
(statearr_32982_33041[(1)] = (10));

} else {
var statearr_32983_33042 = state_32903__$1;
(statearr_32983_33042[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__32183__auto___32988,cs,m,dchan,dctr,done))
;
return ((function (switch__32095__auto__,c__32183__auto___32988,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__32096__auto__ = null;
var cljs$core$async$mult_$_state_machine__32096__auto____0 = (function (){
var statearr_32984 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32984[(0)] = cljs$core$async$mult_$_state_machine__32096__auto__);

(statearr_32984[(1)] = (1));

return statearr_32984;
});
var cljs$core$async$mult_$_state_machine__32096__auto____1 = (function (state_32903){
while(true){
var ret_value__32097__auto__ = (function (){try{while(true){
var result__32098__auto__ = switch__32095__auto__.call(null,state_32903);
if(cljs.core.keyword_identical_QMARK_.call(null,result__32098__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32098__auto__;
}
break;
}
}catch (e32985){if((e32985 instanceof Object)){
var ex__32099__auto__ = e32985;
var statearr_32986_33043 = state_32903;
(statearr_32986_33043[(5)] = ex__32099__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32903);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32985;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__32097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33044 = state_32903;
state_32903 = G__33044;
continue;
} else {
return ret_value__32097__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__32096__auto__ = function(state_32903){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__32096__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__32096__auto____1.call(this,state_32903);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__32096__auto____0;
cljs$core$async$mult_$_state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__32096__auto____1;
return cljs$core$async$mult_$_state_machine__32096__auto__;
})()
;})(switch__32095__auto__,c__32183__auto___32988,cs,m,dchan,dctr,done))
})();
var state__32185__auto__ = (function (){var statearr_32987 = f__32184__auto__.call(null);
(statearr_32987[(6)] = c__32183__auto___32988);

return statearr_32987;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__32185__auto__);
});})(c__32183__auto___32988,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__33046 = arguments.length;
switch (G__33046) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__27162__auto__ = (((m == null))?null:m);
var m__27163__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__27162__auto__)]);
if(!((m__27163__auto__ == null))){
return m__27163__auto__.call(null,m,ch);
} else {
var m__27163__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__27163__auto____$1 == null))){
return m__27163__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__27162__auto__ = (((m == null))?null:m);
var m__27163__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__27162__auto__)]);
if(!((m__27163__auto__ == null))){
return m__27163__auto__.call(null,m,ch);
} else {
var m__27163__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__27163__auto____$1 == null))){
return m__27163__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__27162__auto__ = (((m == null))?null:m);
var m__27163__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__27162__auto__)]);
if(!((m__27163__auto__ == null))){
return m__27163__auto__.call(null,m);
} else {
var m__27163__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__27163__auto____$1 == null))){
return m__27163__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__27162__auto__ = (((m == null))?null:m);
var m__27163__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__27162__auto__)]);
if(!((m__27163__auto__ == null))){
return m__27163__auto__.call(null,m,state_map);
} else {
var m__27163__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__27163__auto____$1 == null))){
return m__27163__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__27162__auto__ = (((m == null))?null:m);
var m__27163__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__27162__auto__)]);
if(!((m__27163__auto__ == null))){
return m__27163__auto__.call(null,m,mode);
} else {
var m__27163__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__27163__auto____$1 == null))){
return m__27163__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__27625__auto__ = [];
var len__27618__auto___33058 = arguments.length;
var i__27619__auto___33059 = (0);
while(true){
if((i__27619__auto___33059 < len__27618__auto___33058)){
args__27625__auto__.push((arguments[i__27619__auto___33059]));

var G__33060 = (i__27619__auto___33059 + (1));
i__27619__auto___33059 = G__33060;
continue;
} else {
}
break;
}

var argseq__27626__auto__ = ((((3) < args__27625__auto__.length))?(new cljs.core.IndexedSeq(args__27625__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__27626__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__33052){
var map__33053 = p__33052;
var map__33053__$1 = ((((!((map__33053 == null)))?((((map__33053.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33053.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33053):map__33053);
var opts = map__33053__$1;
var statearr_33055_33061 = state;
(statearr_33055_33061[(1)] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__33053,map__33053__$1,opts){
return (function (val){
var statearr_33056_33062 = state;
(statearr_33056_33062[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__33053,map__33053__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_33057_33063 = state;
(statearr_33057_33063[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq33048){
var G__33049 = cljs.core.first.call(null,seq33048);
var seq33048__$1 = cljs.core.next.call(null,seq33048);
var G__33050 = cljs.core.first.call(null,seq33048__$1);
var seq33048__$2 = cljs.core.next.call(null,seq33048__$1);
var G__33051 = cljs.core.first.call(null,seq33048__$2);
var seq33048__$3 = cljs.core.next.call(null,seq33048__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__33049,G__33050,G__33051,seq33048__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async33064 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33064 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta33065){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta33065 = meta33065;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async33064.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_33066,meta33065__$1){
var self__ = this;
var _33066__$1 = this;
return (new cljs.core.async.t_cljs$core$async33064(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta33065__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33064.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_33066){
var self__ = this;
var _33066__$1 = this;
return self__.meta33065;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33064.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33064.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33064.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33064.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33064.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33064.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33064.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33064.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1("mode must be one of: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33064.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta33065","meta33065",240052287,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33064.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33064.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33064";

cljs.core.async.t_cljs$core$async33064.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__27104__auto__,writer__27105__auto__,opt__27106__auto__){
return cljs.core._write.call(null,writer__27105__auto__,"cljs.core.async/t_cljs$core$async33064");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async33064 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async33064(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta33065){
return (new cljs.core.async.t_cljs$core$async33064(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta33065));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async33064(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__32183__auto___33228 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__32183__auto___33228,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__32184__auto__ = (function (){var switch__32095__auto__ = ((function (c__32183__auto___33228,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_33168){
var state_val_33169 = (state_33168[(1)]);
if((state_val_33169 === (7))){
var inst_33083 = (state_33168[(2)]);
var state_33168__$1 = state_33168;
var statearr_33170_33229 = state_33168__$1;
(statearr_33170_33229[(2)] = inst_33083);

(statearr_33170_33229[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33169 === (20))){
var inst_33095 = (state_33168[(7)]);
var state_33168__$1 = state_33168;
var statearr_33171_33230 = state_33168__$1;
(statearr_33171_33230[(2)] = inst_33095);

(statearr_33171_33230[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33169 === (27))){
var state_33168__$1 = state_33168;
var statearr_33172_33231 = state_33168__$1;
(statearr_33172_33231[(2)] = null);

(statearr_33172_33231[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33169 === (1))){
var inst_33070 = (state_33168[(8)]);
var inst_33070__$1 = calc_state.call(null);
var inst_33072 = (inst_33070__$1 == null);
var inst_33073 = cljs.core.not.call(null,inst_33072);
var state_33168__$1 = (function (){var statearr_33173 = state_33168;
(statearr_33173[(8)] = inst_33070__$1);

return statearr_33173;
})();
if(inst_33073){
var statearr_33174_33232 = state_33168__$1;
(statearr_33174_33232[(1)] = (2));

} else {
var statearr_33175_33233 = state_33168__$1;
(statearr_33175_33233[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33169 === (24))){
var inst_33119 = (state_33168[(9)]);
var inst_33128 = (state_33168[(10)]);
var inst_33142 = (state_33168[(11)]);
var inst_33142__$1 = inst_33119.call(null,inst_33128);
var state_33168__$1 = (function (){var statearr_33176 = state_33168;
(statearr_33176[(11)] = inst_33142__$1);

return statearr_33176;
})();
if(cljs.core.truth_(inst_33142__$1)){
var statearr_33177_33234 = state_33168__$1;
(statearr_33177_33234[(1)] = (29));

} else {
var statearr_33178_33235 = state_33168__$1;
(statearr_33178_33235[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33169 === (4))){
var inst_33086 = (state_33168[(2)]);
var state_33168__$1 = state_33168;
if(cljs.core.truth_(inst_33086)){
var statearr_33179_33236 = state_33168__$1;
(statearr_33179_33236[(1)] = (8));

} else {
var statearr_33180_33237 = state_33168__$1;
(statearr_33180_33237[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33169 === (15))){
var inst_33113 = (state_33168[(2)]);
var state_33168__$1 = state_33168;
if(cljs.core.truth_(inst_33113)){
var statearr_33181_33238 = state_33168__$1;
(statearr_33181_33238[(1)] = (19));

} else {
var statearr_33182_33239 = state_33168__$1;
(statearr_33182_33239[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33169 === (21))){
var inst_33118 = (state_33168[(12)]);
var inst_33118__$1 = (state_33168[(2)]);
var inst_33119 = cljs.core.get.call(null,inst_33118__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_33120 = cljs.core.get.call(null,inst_33118__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_33121 = cljs.core.get.call(null,inst_33118__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_33168__$1 = (function (){var statearr_33183 = state_33168;
(statearr_33183[(9)] = inst_33119);

(statearr_33183[(13)] = inst_33120);

(statearr_33183[(12)] = inst_33118__$1);

return statearr_33183;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_33168__$1,(22),inst_33121);
} else {
if((state_val_33169 === (31))){
var inst_33150 = (state_33168[(2)]);
var state_33168__$1 = state_33168;
if(cljs.core.truth_(inst_33150)){
var statearr_33184_33240 = state_33168__$1;
(statearr_33184_33240[(1)] = (32));

} else {
var statearr_33185_33241 = state_33168__$1;
(statearr_33185_33241[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33169 === (32))){
var inst_33127 = (state_33168[(14)]);
var state_33168__$1 = state_33168;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33168__$1,(35),out,inst_33127);
} else {
if((state_val_33169 === (33))){
var inst_33118 = (state_33168[(12)]);
var inst_33095 = inst_33118;
var state_33168__$1 = (function (){var statearr_33186 = state_33168;
(statearr_33186[(7)] = inst_33095);

return statearr_33186;
})();
var statearr_33187_33242 = state_33168__$1;
(statearr_33187_33242[(2)] = null);

(statearr_33187_33242[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33169 === (13))){
var inst_33095 = (state_33168[(7)]);
var inst_33102 = inst_33095.cljs$lang$protocol_mask$partition0$;
var inst_33103 = (inst_33102 & (64));
var inst_33104 = inst_33095.cljs$core$ISeq$;
var inst_33105 = (cljs.core.PROTOCOL_SENTINEL === inst_33104);
var inst_33106 = (inst_33103) || (inst_33105);
var state_33168__$1 = state_33168;
if(cljs.core.truth_(inst_33106)){
var statearr_33188_33243 = state_33168__$1;
(statearr_33188_33243[(1)] = (16));

} else {
var statearr_33189_33244 = state_33168__$1;
(statearr_33189_33244[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33169 === (22))){
var inst_33128 = (state_33168[(10)]);
var inst_33127 = (state_33168[(14)]);
var inst_33126 = (state_33168[(2)]);
var inst_33127__$1 = cljs.core.nth.call(null,inst_33126,(0),null);
var inst_33128__$1 = cljs.core.nth.call(null,inst_33126,(1),null);
var inst_33129 = (inst_33127__$1 == null);
var inst_33130 = cljs.core._EQ_.call(null,inst_33128__$1,change);
var inst_33131 = (inst_33129) || (inst_33130);
var state_33168__$1 = (function (){var statearr_33190 = state_33168;
(statearr_33190[(10)] = inst_33128__$1);

(statearr_33190[(14)] = inst_33127__$1);

return statearr_33190;
})();
if(cljs.core.truth_(inst_33131)){
var statearr_33191_33245 = state_33168__$1;
(statearr_33191_33245[(1)] = (23));

} else {
var statearr_33192_33246 = state_33168__$1;
(statearr_33192_33246[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33169 === (36))){
var inst_33118 = (state_33168[(12)]);
var inst_33095 = inst_33118;
var state_33168__$1 = (function (){var statearr_33193 = state_33168;
(statearr_33193[(7)] = inst_33095);

return statearr_33193;
})();
var statearr_33194_33247 = state_33168__$1;
(statearr_33194_33247[(2)] = null);

(statearr_33194_33247[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33169 === (29))){
var inst_33142 = (state_33168[(11)]);
var state_33168__$1 = state_33168;
var statearr_33195_33248 = state_33168__$1;
(statearr_33195_33248[(2)] = inst_33142);

(statearr_33195_33248[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33169 === (6))){
var state_33168__$1 = state_33168;
var statearr_33196_33249 = state_33168__$1;
(statearr_33196_33249[(2)] = false);

(statearr_33196_33249[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33169 === (28))){
var inst_33138 = (state_33168[(2)]);
var inst_33139 = calc_state.call(null);
var inst_33095 = inst_33139;
var state_33168__$1 = (function (){var statearr_33197 = state_33168;
(statearr_33197[(7)] = inst_33095);

(statearr_33197[(15)] = inst_33138);

return statearr_33197;
})();
var statearr_33198_33250 = state_33168__$1;
(statearr_33198_33250[(2)] = null);

(statearr_33198_33250[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33169 === (25))){
var inst_33164 = (state_33168[(2)]);
var state_33168__$1 = state_33168;
var statearr_33199_33251 = state_33168__$1;
(statearr_33199_33251[(2)] = inst_33164);

(statearr_33199_33251[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33169 === (34))){
var inst_33162 = (state_33168[(2)]);
var state_33168__$1 = state_33168;
var statearr_33200_33252 = state_33168__$1;
(statearr_33200_33252[(2)] = inst_33162);

(statearr_33200_33252[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33169 === (17))){
var state_33168__$1 = state_33168;
var statearr_33201_33253 = state_33168__$1;
(statearr_33201_33253[(2)] = false);

(statearr_33201_33253[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33169 === (3))){
var state_33168__$1 = state_33168;
var statearr_33202_33254 = state_33168__$1;
(statearr_33202_33254[(2)] = false);

(statearr_33202_33254[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33169 === (12))){
var inst_33166 = (state_33168[(2)]);
var state_33168__$1 = state_33168;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33168__$1,inst_33166);
} else {
if((state_val_33169 === (2))){
var inst_33070 = (state_33168[(8)]);
var inst_33075 = inst_33070.cljs$lang$protocol_mask$partition0$;
var inst_33076 = (inst_33075 & (64));
var inst_33077 = inst_33070.cljs$core$ISeq$;
var inst_33078 = (cljs.core.PROTOCOL_SENTINEL === inst_33077);
var inst_33079 = (inst_33076) || (inst_33078);
var state_33168__$1 = state_33168;
if(cljs.core.truth_(inst_33079)){
var statearr_33203_33255 = state_33168__$1;
(statearr_33203_33255[(1)] = (5));

} else {
var statearr_33204_33256 = state_33168__$1;
(statearr_33204_33256[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33169 === (23))){
var inst_33127 = (state_33168[(14)]);
var inst_33133 = (inst_33127 == null);
var state_33168__$1 = state_33168;
if(cljs.core.truth_(inst_33133)){
var statearr_33205_33257 = state_33168__$1;
(statearr_33205_33257[(1)] = (26));

} else {
var statearr_33206_33258 = state_33168__$1;
(statearr_33206_33258[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33169 === (35))){
var inst_33153 = (state_33168[(2)]);
var state_33168__$1 = state_33168;
if(cljs.core.truth_(inst_33153)){
var statearr_33207_33259 = state_33168__$1;
(statearr_33207_33259[(1)] = (36));

} else {
var statearr_33208_33260 = state_33168__$1;
(statearr_33208_33260[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33169 === (19))){
var inst_33095 = (state_33168[(7)]);
var inst_33115 = cljs.core.apply.call(null,cljs.core.hash_map,inst_33095);
var state_33168__$1 = state_33168;
var statearr_33209_33261 = state_33168__$1;
(statearr_33209_33261[(2)] = inst_33115);

(statearr_33209_33261[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33169 === (11))){
var inst_33095 = (state_33168[(7)]);
var inst_33099 = (inst_33095 == null);
var inst_33100 = cljs.core.not.call(null,inst_33099);
var state_33168__$1 = state_33168;
if(inst_33100){
var statearr_33210_33262 = state_33168__$1;
(statearr_33210_33262[(1)] = (13));

} else {
var statearr_33211_33263 = state_33168__$1;
(statearr_33211_33263[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33169 === (9))){
var inst_33070 = (state_33168[(8)]);
var state_33168__$1 = state_33168;
var statearr_33212_33264 = state_33168__$1;
(statearr_33212_33264[(2)] = inst_33070);

(statearr_33212_33264[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33169 === (5))){
var state_33168__$1 = state_33168;
var statearr_33213_33265 = state_33168__$1;
(statearr_33213_33265[(2)] = true);

(statearr_33213_33265[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33169 === (14))){
var state_33168__$1 = state_33168;
var statearr_33214_33266 = state_33168__$1;
(statearr_33214_33266[(2)] = false);

(statearr_33214_33266[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33169 === (26))){
var inst_33128 = (state_33168[(10)]);
var inst_33135 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_33128);
var state_33168__$1 = state_33168;
var statearr_33215_33267 = state_33168__$1;
(statearr_33215_33267[(2)] = inst_33135);

(statearr_33215_33267[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33169 === (16))){
var state_33168__$1 = state_33168;
var statearr_33216_33268 = state_33168__$1;
(statearr_33216_33268[(2)] = true);

(statearr_33216_33268[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33169 === (38))){
var inst_33158 = (state_33168[(2)]);
var state_33168__$1 = state_33168;
var statearr_33217_33269 = state_33168__$1;
(statearr_33217_33269[(2)] = inst_33158);

(statearr_33217_33269[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33169 === (30))){
var inst_33119 = (state_33168[(9)]);
var inst_33128 = (state_33168[(10)]);
var inst_33120 = (state_33168[(13)]);
var inst_33145 = cljs.core.empty_QMARK_.call(null,inst_33119);
var inst_33146 = inst_33120.call(null,inst_33128);
var inst_33147 = cljs.core.not.call(null,inst_33146);
var inst_33148 = (inst_33145) && (inst_33147);
var state_33168__$1 = state_33168;
var statearr_33218_33270 = state_33168__$1;
(statearr_33218_33270[(2)] = inst_33148);

(statearr_33218_33270[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33169 === (10))){
var inst_33070 = (state_33168[(8)]);
var inst_33091 = (state_33168[(2)]);
var inst_33092 = cljs.core.get.call(null,inst_33091,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_33093 = cljs.core.get.call(null,inst_33091,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_33094 = cljs.core.get.call(null,inst_33091,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_33095 = inst_33070;
var state_33168__$1 = (function (){var statearr_33219 = state_33168;
(statearr_33219[(7)] = inst_33095);

(statearr_33219[(16)] = inst_33093);

(statearr_33219[(17)] = inst_33094);

(statearr_33219[(18)] = inst_33092);

return statearr_33219;
})();
var statearr_33220_33271 = state_33168__$1;
(statearr_33220_33271[(2)] = null);

(statearr_33220_33271[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33169 === (18))){
var inst_33110 = (state_33168[(2)]);
var state_33168__$1 = state_33168;
var statearr_33221_33272 = state_33168__$1;
(statearr_33221_33272[(2)] = inst_33110);

(statearr_33221_33272[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33169 === (37))){
var state_33168__$1 = state_33168;
var statearr_33222_33273 = state_33168__$1;
(statearr_33222_33273[(2)] = null);

(statearr_33222_33273[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33169 === (8))){
var inst_33070 = (state_33168[(8)]);
var inst_33088 = cljs.core.apply.call(null,cljs.core.hash_map,inst_33070);
var state_33168__$1 = state_33168;
var statearr_33223_33274 = state_33168__$1;
(statearr_33223_33274[(2)] = inst_33088);

(statearr_33223_33274[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__32183__auto___33228,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__32095__auto__,c__32183__auto___33228,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__32096__auto__ = null;
var cljs$core$async$mix_$_state_machine__32096__auto____0 = (function (){
var statearr_33224 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33224[(0)] = cljs$core$async$mix_$_state_machine__32096__auto__);

(statearr_33224[(1)] = (1));

return statearr_33224;
});
var cljs$core$async$mix_$_state_machine__32096__auto____1 = (function (state_33168){
while(true){
var ret_value__32097__auto__ = (function (){try{while(true){
var result__32098__auto__ = switch__32095__auto__.call(null,state_33168);
if(cljs.core.keyword_identical_QMARK_.call(null,result__32098__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32098__auto__;
}
break;
}
}catch (e33225){if((e33225 instanceof Object)){
var ex__32099__auto__ = e33225;
var statearr_33226_33275 = state_33168;
(statearr_33226_33275[(5)] = ex__32099__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33168);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33225;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__32097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33276 = state_33168;
state_33168 = G__33276;
continue;
} else {
return ret_value__32097__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__32096__auto__ = function(state_33168){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__32096__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__32096__auto____1.call(this,state_33168);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__32096__auto____0;
cljs$core$async$mix_$_state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__32096__auto____1;
return cljs$core$async$mix_$_state_machine__32096__auto__;
})()
;})(switch__32095__auto__,c__32183__auto___33228,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__32185__auto__ = (function (){var statearr_33227 = f__32184__auto__.call(null);
(statearr_33227[(6)] = c__32183__auto___33228);

return statearr_33227;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__32185__auto__);
});})(c__32183__auto___33228,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__27162__auto__ = (((p == null))?null:p);
var m__27163__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__27162__auto__)]);
if(!((m__27163__auto__ == null))){
return m__27163__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__27163__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__27163__auto____$1 == null))){
return m__27163__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__27162__auto__ = (((p == null))?null:p);
var m__27163__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__27162__auto__)]);
if(!((m__27163__auto__ == null))){
return m__27163__auto__.call(null,p,v,ch);
} else {
var m__27163__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__27163__auto____$1 == null))){
return m__27163__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__33278 = arguments.length;
switch (G__33278) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__27162__auto__ = (((p == null))?null:p);
var m__27163__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__27162__auto__)]);
if(!((m__27163__auto__ == null))){
return m__27163__auto__.call(null,p);
} else {
var m__27163__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__27163__auto____$1 == null))){
return m__27163__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__27162__auto__ = (((p == null))?null:p);
var m__27163__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__27162__auto__)]);
if(!((m__27163__auto__ == null))){
return m__27163__auto__.call(null,p,v);
} else {
var m__27163__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__27163__auto____$1 == null))){
return m__27163__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__33282 = arguments.length;
switch (G__33282) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__26493__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__26493__auto__)){
return or__26493__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__26493__auto__,mults){
return (function (p1__33280_SHARP_){
if(cljs.core.truth_(p1__33280_SHARP_.call(null,topic))){
return p1__33280_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__33280_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__26493__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async33283 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33283 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta33284){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta33284 = meta33284;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async33283.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_33285,meta33284__$1){
var self__ = this;
var _33285__$1 = this;
return (new cljs.core.async.t_cljs$core$async33283(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta33284__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33283.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_33285){
var self__ = this;
var _33285__$1 = this;
return self__.meta33284;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33283.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33283.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33283.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33283.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33283.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33283.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33283.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33283.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta33284","meta33284",7898366,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33283.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33283.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33283";

cljs.core.async.t_cljs$core$async33283.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__27104__auto__,writer__27105__auto__,opt__27106__auto__){
return cljs.core._write.call(null,writer__27105__auto__,"cljs.core.async/t_cljs$core$async33283");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async33283 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async33283(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta33284){
return (new cljs.core.async.t_cljs$core$async33283(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta33284));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async33283(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__32183__auto___33403 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__32183__auto___33403,mults,ensure_mult,p){
return (function (){
var f__32184__auto__ = (function (){var switch__32095__auto__ = ((function (c__32183__auto___33403,mults,ensure_mult,p){
return (function (state_33357){
var state_val_33358 = (state_33357[(1)]);
if((state_val_33358 === (7))){
var inst_33353 = (state_33357[(2)]);
var state_33357__$1 = state_33357;
var statearr_33359_33404 = state_33357__$1;
(statearr_33359_33404[(2)] = inst_33353);

(statearr_33359_33404[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33358 === (20))){
var state_33357__$1 = state_33357;
var statearr_33360_33405 = state_33357__$1;
(statearr_33360_33405[(2)] = null);

(statearr_33360_33405[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33358 === (1))){
var state_33357__$1 = state_33357;
var statearr_33361_33406 = state_33357__$1;
(statearr_33361_33406[(2)] = null);

(statearr_33361_33406[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33358 === (24))){
var inst_33336 = (state_33357[(7)]);
var inst_33345 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_33336);
var state_33357__$1 = state_33357;
var statearr_33362_33407 = state_33357__$1;
(statearr_33362_33407[(2)] = inst_33345);

(statearr_33362_33407[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33358 === (4))){
var inst_33288 = (state_33357[(8)]);
var inst_33288__$1 = (state_33357[(2)]);
var inst_33289 = (inst_33288__$1 == null);
var state_33357__$1 = (function (){var statearr_33363 = state_33357;
(statearr_33363[(8)] = inst_33288__$1);

return statearr_33363;
})();
if(cljs.core.truth_(inst_33289)){
var statearr_33364_33408 = state_33357__$1;
(statearr_33364_33408[(1)] = (5));

} else {
var statearr_33365_33409 = state_33357__$1;
(statearr_33365_33409[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33358 === (15))){
var inst_33330 = (state_33357[(2)]);
var state_33357__$1 = state_33357;
var statearr_33366_33410 = state_33357__$1;
(statearr_33366_33410[(2)] = inst_33330);

(statearr_33366_33410[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33358 === (21))){
var inst_33350 = (state_33357[(2)]);
var state_33357__$1 = (function (){var statearr_33367 = state_33357;
(statearr_33367[(9)] = inst_33350);

return statearr_33367;
})();
var statearr_33368_33411 = state_33357__$1;
(statearr_33368_33411[(2)] = null);

(statearr_33368_33411[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33358 === (13))){
var inst_33312 = (state_33357[(10)]);
var inst_33314 = cljs.core.chunked_seq_QMARK_.call(null,inst_33312);
var state_33357__$1 = state_33357;
if(inst_33314){
var statearr_33369_33412 = state_33357__$1;
(statearr_33369_33412[(1)] = (16));

} else {
var statearr_33370_33413 = state_33357__$1;
(statearr_33370_33413[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33358 === (22))){
var inst_33342 = (state_33357[(2)]);
var state_33357__$1 = state_33357;
if(cljs.core.truth_(inst_33342)){
var statearr_33371_33414 = state_33357__$1;
(statearr_33371_33414[(1)] = (23));

} else {
var statearr_33372_33415 = state_33357__$1;
(statearr_33372_33415[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33358 === (6))){
var inst_33288 = (state_33357[(8)]);
var inst_33336 = (state_33357[(7)]);
var inst_33338 = (state_33357[(11)]);
var inst_33336__$1 = topic_fn.call(null,inst_33288);
var inst_33337 = cljs.core.deref.call(null,mults);
var inst_33338__$1 = cljs.core.get.call(null,inst_33337,inst_33336__$1);
var state_33357__$1 = (function (){var statearr_33373 = state_33357;
(statearr_33373[(7)] = inst_33336__$1);

(statearr_33373[(11)] = inst_33338__$1);

return statearr_33373;
})();
if(cljs.core.truth_(inst_33338__$1)){
var statearr_33374_33416 = state_33357__$1;
(statearr_33374_33416[(1)] = (19));

} else {
var statearr_33375_33417 = state_33357__$1;
(statearr_33375_33417[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33358 === (25))){
var inst_33347 = (state_33357[(2)]);
var state_33357__$1 = state_33357;
var statearr_33376_33418 = state_33357__$1;
(statearr_33376_33418[(2)] = inst_33347);

(statearr_33376_33418[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33358 === (17))){
var inst_33312 = (state_33357[(10)]);
var inst_33321 = cljs.core.first.call(null,inst_33312);
var inst_33322 = cljs.core.async.muxch_STAR_.call(null,inst_33321);
var inst_33323 = cljs.core.async.close_BANG_.call(null,inst_33322);
var inst_33324 = cljs.core.next.call(null,inst_33312);
var inst_33298 = inst_33324;
var inst_33299 = null;
var inst_33300 = (0);
var inst_33301 = (0);
var state_33357__$1 = (function (){var statearr_33377 = state_33357;
(statearr_33377[(12)] = inst_33298);

(statearr_33377[(13)] = inst_33299);

(statearr_33377[(14)] = inst_33323);

(statearr_33377[(15)] = inst_33300);

(statearr_33377[(16)] = inst_33301);

return statearr_33377;
})();
var statearr_33378_33419 = state_33357__$1;
(statearr_33378_33419[(2)] = null);

(statearr_33378_33419[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33358 === (3))){
var inst_33355 = (state_33357[(2)]);
var state_33357__$1 = state_33357;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33357__$1,inst_33355);
} else {
if((state_val_33358 === (12))){
var inst_33332 = (state_33357[(2)]);
var state_33357__$1 = state_33357;
var statearr_33379_33420 = state_33357__$1;
(statearr_33379_33420[(2)] = inst_33332);

(statearr_33379_33420[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33358 === (2))){
var state_33357__$1 = state_33357;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33357__$1,(4),ch);
} else {
if((state_val_33358 === (23))){
var state_33357__$1 = state_33357;
var statearr_33380_33421 = state_33357__$1;
(statearr_33380_33421[(2)] = null);

(statearr_33380_33421[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33358 === (19))){
var inst_33288 = (state_33357[(8)]);
var inst_33338 = (state_33357[(11)]);
var inst_33340 = cljs.core.async.muxch_STAR_.call(null,inst_33338);
var state_33357__$1 = state_33357;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33357__$1,(22),inst_33340,inst_33288);
} else {
if((state_val_33358 === (11))){
var inst_33298 = (state_33357[(12)]);
var inst_33312 = (state_33357[(10)]);
var inst_33312__$1 = cljs.core.seq.call(null,inst_33298);
var state_33357__$1 = (function (){var statearr_33381 = state_33357;
(statearr_33381[(10)] = inst_33312__$1);

return statearr_33381;
})();
if(inst_33312__$1){
var statearr_33382_33422 = state_33357__$1;
(statearr_33382_33422[(1)] = (13));

} else {
var statearr_33383_33423 = state_33357__$1;
(statearr_33383_33423[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33358 === (9))){
var inst_33334 = (state_33357[(2)]);
var state_33357__$1 = state_33357;
var statearr_33384_33424 = state_33357__$1;
(statearr_33384_33424[(2)] = inst_33334);

(statearr_33384_33424[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33358 === (5))){
var inst_33295 = cljs.core.deref.call(null,mults);
var inst_33296 = cljs.core.vals.call(null,inst_33295);
var inst_33297 = cljs.core.seq.call(null,inst_33296);
var inst_33298 = inst_33297;
var inst_33299 = null;
var inst_33300 = (0);
var inst_33301 = (0);
var state_33357__$1 = (function (){var statearr_33385 = state_33357;
(statearr_33385[(12)] = inst_33298);

(statearr_33385[(13)] = inst_33299);

(statearr_33385[(15)] = inst_33300);

(statearr_33385[(16)] = inst_33301);

return statearr_33385;
})();
var statearr_33386_33425 = state_33357__$1;
(statearr_33386_33425[(2)] = null);

(statearr_33386_33425[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33358 === (14))){
var state_33357__$1 = state_33357;
var statearr_33390_33426 = state_33357__$1;
(statearr_33390_33426[(2)] = null);

(statearr_33390_33426[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33358 === (16))){
var inst_33312 = (state_33357[(10)]);
var inst_33316 = cljs.core.chunk_first.call(null,inst_33312);
var inst_33317 = cljs.core.chunk_rest.call(null,inst_33312);
var inst_33318 = cljs.core.count.call(null,inst_33316);
var inst_33298 = inst_33317;
var inst_33299 = inst_33316;
var inst_33300 = inst_33318;
var inst_33301 = (0);
var state_33357__$1 = (function (){var statearr_33391 = state_33357;
(statearr_33391[(12)] = inst_33298);

(statearr_33391[(13)] = inst_33299);

(statearr_33391[(15)] = inst_33300);

(statearr_33391[(16)] = inst_33301);

return statearr_33391;
})();
var statearr_33392_33427 = state_33357__$1;
(statearr_33392_33427[(2)] = null);

(statearr_33392_33427[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33358 === (10))){
var inst_33298 = (state_33357[(12)]);
var inst_33299 = (state_33357[(13)]);
var inst_33300 = (state_33357[(15)]);
var inst_33301 = (state_33357[(16)]);
var inst_33306 = cljs.core._nth.call(null,inst_33299,inst_33301);
var inst_33307 = cljs.core.async.muxch_STAR_.call(null,inst_33306);
var inst_33308 = cljs.core.async.close_BANG_.call(null,inst_33307);
var inst_33309 = (inst_33301 + (1));
var tmp33387 = inst_33298;
var tmp33388 = inst_33299;
var tmp33389 = inst_33300;
var inst_33298__$1 = tmp33387;
var inst_33299__$1 = tmp33388;
var inst_33300__$1 = tmp33389;
var inst_33301__$1 = inst_33309;
var state_33357__$1 = (function (){var statearr_33393 = state_33357;
(statearr_33393[(12)] = inst_33298__$1);

(statearr_33393[(17)] = inst_33308);

(statearr_33393[(13)] = inst_33299__$1);

(statearr_33393[(15)] = inst_33300__$1);

(statearr_33393[(16)] = inst_33301__$1);

return statearr_33393;
})();
var statearr_33394_33428 = state_33357__$1;
(statearr_33394_33428[(2)] = null);

(statearr_33394_33428[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33358 === (18))){
var inst_33327 = (state_33357[(2)]);
var state_33357__$1 = state_33357;
var statearr_33395_33429 = state_33357__$1;
(statearr_33395_33429[(2)] = inst_33327);

(statearr_33395_33429[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33358 === (8))){
var inst_33300 = (state_33357[(15)]);
var inst_33301 = (state_33357[(16)]);
var inst_33303 = (inst_33301 < inst_33300);
var inst_33304 = inst_33303;
var state_33357__$1 = state_33357;
if(cljs.core.truth_(inst_33304)){
var statearr_33396_33430 = state_33357__$1;
(statearr_33396_33430[(1)] = (10));

} else {
var statearr_33397_33431 = state_33357__$1;
(statearr_33397_33431[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__32183__auto___33403,mults,ensure_mult,p))
;
return ((function (switch__32095__auto__,c__32183__auto___33403,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__32096__auto__ = null;
var cljs$core$async$state_machine__32096__auto____0 = (function (){
var statearr_33398 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33398[(0)] = cljs$core$async$state_machine__32096__auto__);

(statearr_33398[(1)] = (1));

return statearr_33398;
});
var cljs$core$async$state_machine__32096__auto____1 = (function (state_33357){
while(true){
var ret_value__32097__auto__ = (function (){try{while(true){
var result__32098__auto__ = switch__32095__auto__.call(null,state_33357);
if(cljs.core.keyword_identical_QMARK_.call(null,result__32098__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32098__auto__;
}
break;
}
}catch (e33399){if((e33399 instanceof Object)){
var ex__32099__auto__ = e33399;
var statearr_33400_33432 = state_33357;
(statearr_33400_33432[(5)] = ex__32099__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33357);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33399;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__32097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33433 = state_33357;
state_33357 = G__33433;
continue;
} else {
return ret_value__32097__auto__;
}
break;
}
});
cljs$core$async$state_machine__32096__auto__ = function(state_33357){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__32096__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__32096__auto____1.call(this,state_33357);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__32096__auto____0;
cljs$core$async$state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__32096__auto____1;
return cljs$core$async$state_machine__32096__auto__;
})()
;})(switch__32095__auto__,c__32183__auto___33403,mults,ensure_mult,p))
})();
var state__32185__auto__ = (function (){var statearr_33401 = f__32184__auto__.call(null);
(statearr_33401[(6)] = c__32183__auto___33403);

return statearr_33401;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__32185__auto__);
});})(c__32183__auto___33403,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__33435 = arguments.length;
switch (G__33435) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__33438 = arguments.length;
switch (G__33438) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__33441 = arguments.length;
switch (G__33441) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__32183__auto___33508 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__32183__auto___33508,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__32184__auto__ = (function (){var switch__32095__auto__ = ((function (c__32183__auto___33508,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_33480){
var state_val_33481 = (state_33480[(1)]);
if((state_val_33481 === (7))){
var state_33480__$1 = state_33480;
var statearr_33482_33509 = state_33480__$1;
(statearr_33482_33509[(2)] = null);

(statearr_33482_33509[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33481 === (1))){
var state_33480__$1 = state_33480;
var statearr_33483_33510 = state_33480__$1;
(statearr_33483_33510[(2)] = null);

(statearr_33483_33510[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33481 === (4))){
var inst_33444 = (state_33480[(7)]);
var inst_33446 = (inst_33444 < cnt);
var state_33480__$1 = state_33480;
if(cljs.core.truth_(inst_33446)){
var statearr_33484_33511 = state_33480__$1;
(statearr_33484_33511[(1)] = (6));

} else {
var statearr_33485_33512 = state_33480__$1;
(statearr_33485_33512[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33481 === (15))){
var inst_33476 = (state_33480[(2)]);
var state_33480__$1 = state_33480;
var statearr_33486_33513 = state_33480__$1;
(statearr_33486_33513[(2)] = inst_33476);

(statearr_33486_33513[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33481 === (13))){
var inst_33469 = cljs.core.async.close_BANG_.call(null,out);
var state_33480__$1 = state_33480;
var statearr_33487_33514 = state_33480__$1;
(statearr_33487_33514[(2)] = inst_33469);

(statearr_33487_33514[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33481 === (6))){
var state_33480__$1 = state_33480;
var statearr_33488_33515 = state_33480__$1;
(statearr_33488_33515[(2)] = null);

(statearr_33488_33515[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33481 === (3))){
var inst_33478 = (state_33480[(2)]);
var state_33480__$1 = state_33480;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33480__$1,inst_33478);
} else {
if((state_val_33481 === (12))){
var inst_33466 = (state_33480[(8)]);
var inst_33466__$1 = (state_33480[(2)]);
var inst_33467 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_33466__$1);
var state_33480__$1 = (function (){var statearr_33489 = state_33480;
(statearr_33489[(8)] = inst_33466__$1);

return statearr_33489;
})();
if(cljs.core.truth_(inst_33467)){
var statearr_33490_33516 = state_33480__$1;
(statearr_33490_33516[(1)] = (13));

} else {
var statearr_33491_33517 = state_33480__$1;
(statearr_33491_33517[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33481 === (2))){
var inst_33443 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_33444 = (0);
var state_33480__$1 = (function (){var statearr_33492 = state_33480;
(statearr_33492[(9)] = inst_33443);

(statearr_33492[(7)] = inst_33444);

return statearr_33492;
})();
var statearr_33493_33518 = state_33480__$1;
(statearr_33493_33518[(2)] = null);

(statearr_33493_33518[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33481 === (11))){
var inst_33444 = (state_33480[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_33480,(10),Object,null,(9));
var inst_33453 = chs__$1.call(null,inst_33444);
var inst_33454 = done.call(null,inst_33444);
var inst_33455 = cljs.core.async.take_BANG_.call(null,inst_33453,inst_33454);
var state_33480__$1 = state_33480;
var statearr_33494_33519 = state_33480__$1;
(statearr_33494_33519[(2)] = inst_33455);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33480__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33481 === (9))){
var inst_33444 = (state_33480[(7)]);
var inst_33457 = (state_33480[(2)]);
var inst_33458 = (inst_33444 + (1));
var inst_33444__$1 = inst_33458;
var state_33480__$1 = (function (){var statearr_33495 = state_33480;
(statearr_33495[(7)] = inst_33444__$1);

(statearr_33495[(10)] = inst_33457);

return statearr_33495;
})();
var statearr_33496_33520 = state_33480__$1;
(statearr_33496_33520[(2)] = null);

(statearr_33496_33520[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33481 === (5))){
var inst_33464 = (state_33480[(2)]);
var state_33480__$1 = (function (){var statearr_33497 = state_33480;
(statearr_33497[(11)] = inst_33464);

return statearr_33497;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33480__$1,(12),dchan);
} else {
if((state_val_33481 === (14))){
var inst_33466 = (state_33480[(8)]);
var inst_33471 = cljs.core.apply.call(null,f,inst_33466);
var state_33480__$1 = state_33480;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33480__$1,(16),out,inst_33471);
} else {
if((state_val_33481 === (16))){
var inst_33473 = (state_33480[(2)]);
var state_33480__$1 = (function (){var statearr_33498 = state_33480;
(statearr_33498[(12)] = inst_33473);

return statearr_33498;
})();
var statearr_33499_33521 = state_33480__$1;
(statearr_33499_33521[(2)] = null);

(statearr_33499_33521[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33481 === (10))){
var inst_33448 = (state_33480[(2)]);
var inst_33449 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_33480__$1 = (function (){var statearr_33500 = state_33480;
(statearr_33500[(13)] = inst_33448);

return statearr_33500;
})();
var statearr_33501_33522 = state_33480__$1;
(statearr_33501_33522[(2)] = inst_33449);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33480__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33481 === (8))){
var inst_33462 = (state_33480[(2)]);
var state_33480__$1 = state_33480;
var statearr_33502_33523 = state_33480__$1;
(statearr_33502_33523[(2)] = inst_33462);

(statearr_33502_33523[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__32183__auto___33508,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__32095__auto__,c__32183__auto___33508,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__32096__auto__ = null;
var cljs$core$async$state_machine__32096__auto____0 = (function (){
var statearr_33503 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33503[(0)] = cljs$core$async$state_machine__32096__auto__);

(statearr_33503[(1)] = (1));

return statearr_33503;
});
var cljs$core$async$state_machine__32096__auto____1 = (function (state_33480){
while(true){
var ret_value__32097__auto__ = (function (){try{while(true){
var result__32098__auto__ = switch__32095__auto__.call(null,state_33480);
if(cljs.core.keyword_identical_QMARK_.call(null,result__32098__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32098__auto__;
}
break;
}
}catch (e33504){if((e33504 instanceof Object)){
var ex__32099__auto__ = e33504;
var statearr_33505_33524 = state_33480;
(statearr_33505_33524[(5)] = ex__32099__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33480);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33504;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__32097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33525 = state_33480;
state_33480 = G__33525;
continue;
} else {
return ret_value__32097__auto__;
}
break;
}
});
cljs$core$async$state_machine__32096__auto__ = function(state_33480){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__32096__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__32096__auto____1.call(this,state_33480);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__32096__auto____0;
cljs$core$async$state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__32096__auto____1;
return cljs$core$async$state_machine__32096__auto__;
})()
;})(switch__32095__auto__,c__32183__auto___33508,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__32185__auto__ = (function (){var statearr_33506 = f__32184__auto__.call(null);
(statearr_33506[(6)] = c__32183__auto___33508);

return statearr_33506;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__32185__auto__);
});})(c__32183__auto___33508,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__33528 = arguments.length;
switch (G__33528) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__32183__auto___33582 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__32183__auto___33582,out){
return (function (){
var f__32184__auto__ = (function (){var switch__32095__auto__ = ((function (c__32183__auto___33582,out){
return (function (state_33560){
var state_val_33561 = (state_33560[(1)]);
if((state_val_33561 === (7))){
var inst_33539 = (state_33560[(7)]);
var inst_33540 = (state_33560[(8)]);
var inst_33539__$1 = (state_33560[(2)]);
var inst_33540__$1 = cljs.core.nth.call(null,inst_33539__$1,(0),null);
var inst_33541 = cljs.core.nth.call(null,inst_33539__$1,(1),null);
var inst_33542 = (inst_33540__$1 == null);
var state_33560__$1 = (function (){var statearr_33562 = state_33560;
(statearr_33562[(7)] = inst_33539__$1);

(statearr_33562[(8)] = inst_33540__$1);

(statearr_33562[(9)] = inst_33541);

return statearr_33562;
})();
if(cljs.core.truth_(inst_33542)){
var statearr_33563_33583 = state_33560__$1;
(statearr_33563_33583[(1)] = (8));

} else {
var statearr_33564_33584 = state_33560__$1;
(statearr_33564_33584[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33561 === (1))){
var inst_33529 = cljs.core.vec.call(null,chs);
var inst_33530 = inst_33529;
var state_33560__$1 = (function (){var statearr_33565 = state_33560;
(statearr_33565[(10)] = inst_33530);

return statearr_33565;
})();
var statearr_33566_33585 = state_33560__$1;
(statearr_33566_33585[(2)] = null);

(statearr_33566_33585[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33561 === (4))){
var inst_33530 = (state_33560[(10)]);
var state_33560__$1 = state_33560;
return cljs.core.async.ioc_alts_BANG_.call(null,state_33560__$1,(7),inst_33530);
} else {
if((state_val_33561 === (6))){
var inst_33556 = (state_33560[(2)]);
var state_33560__$1 = state_33560;
var statearr_33567_33586 = state_33560__$1;
(statearr_33567_33586[(2)] = inst_33556);

(statearr_33567_33586[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33561 === (3))){
var inst_33558 = (state_33560[(2)]);
var state_33560__$1 = state_33560;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33560__$1,inst_33558);
} else {
if((state_val_33561 === (2))){
var inst_33530 = (state_33560[(10)]);
var inst_33532 = cljs.core.count.call(null,inst_33530);
var inst_33533 = (inst_33532 > (0));
var state_33560__$1 = state_33560;
if(cljs.core.truth_(inst_33533)){
var statearr_33569_33587 = state_33560__$1;
(statearr_33569_33587[(1)] = (4));

} else {
var statearr_33570_33588 = state_33560__$1;
(statearr_33570_33588[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33561 === (11))){
var inst_33530 = (state_33560[(10)]);
var inst_33549 = (state_33560[(2)]);
var tmp33568 = inst_33530;
var inst_33530__$1 = tmp33568;
var state_33560__$1 = (function (){var statearr_33571 = state_33560;
(statearr_33571[(11)] = inst_33549);

(statearr_33571[(10)] = inst_33530__$1);

return statearr_33571;
})();
var statearr_33572_33589 = state_33560__$1;
(statearr_33572_33589[(2)] = null);

(statearr_33572_33589[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33561 === (9))){
var inst_33540 = (state_33560[(8)]);
var state_33560__$1 = state_33560;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33560__$1,(11),out,inst_33540);
} else {
if((state_val_33561 === (5))){
var inst_33554 = cljs.core.async.close_BANG_.call(null,out);
var state_33560__$1 = state_33560;
var statearr_33573_33590 = state_33560__$1;
(statearr_33573_33590[(2)] = inst_33554);

(statearr_33573_33590[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33561 === (10))){
var inst_33552 = (state_33560[(2)]);
var state_33560__$1 = state_33560;
var statearr_33574_33591 = state_33560__$1;
(statearr_33574_33591[(2)] = inst_33552);

(statearr_33574_33591[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33561 === (8))){
var inst_33539 = (state_33560[(7)]);
var inst_33540 = (state_33560[(8)]);
var inst_33541 = (state_33560[(9)]);
var inst_33530 = (state_33560[(10)]);
var inst_33544 = (function (){var cs = inst_33530;
var vec__33535 = inst_33539;
var v = inst_33540;
var c = inst_33541;
return ((function (cs,vec__33535,v,c,inst_33539,inst_33540,inst_33541,inst_33530,state_val_33561,c__32183__auto___33582,out){
return (function (p1__33526_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__33526_SHARP_);
});
;})(cs,vec__33535,v,c,inst_33539,inst_33540,inst_33541,inst_33530,state_val_33561,c__32183__auto___33582,out))
})();
var inst_33545 = cljs.core.filterv.call(null,inst_33544,inst_33530);
var inst_33530__$1 = inst_33545;
var state_33560__$1 = (function (){var statearr_33575 = state_33560;
(statearr_33575[(10)] = inst_33530__$1);

return statearr_33575;
})();
var statearr_33576_33592 = state_33560__$1;
(statearr_33576_33592[(2)] = null);

(statearr_33576_33592[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__32183__auto___33582,out))
;
return ((function (switch__32095__auto__,c__32183__auto___33582,out){
return (function() {
var cljs$core$async$state_machine__32096__auto__ = null;
var cljs$core$async$state_machine__32096__auto____0 = (function (){
var statearr_33577 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33577[(0)] = cljs$core$async$state_machine__32096__auto__);

(statearr_33577[(1)] = (1));

return statearr_33577;
});
var cljs$core$async$state_machine__32096__auto____1 = (function (state_33560){
while(true){
var ret_value__32097__auto__ = (function (){try{while(true){
var result__32098__auto__ = switch__32095__auto__.call(null,state_33560);
if(cljs.core.keyword_identical_QMARK_.call(null,result__32098__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32098__auto__;
}
break;
}
}catch (e33578){if((e33578 instanceof Object)){
var ex__32099__auto__ = e33578;
var statearr_33579_33593 = state_33560;
(statearr_33579_33593[(5)] = ex__32099__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33560);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33578;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__32097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33594 = state_33560;
state_33560 = G__33594;
continue;
} else {
return ret_value__32097__auto__;
}
break;
}
});
cljs$core$async$state_machine__32096__auto__ = function(state_33560){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__32096__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__32096__auto____1.call(this,state_33560);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__32096__auto____0;
cljs$core$async$state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__32096__auto____1;
return cljs$core$async$state_machine__32096__auto__;
})()
;})(switch__32095__auto__,c__32183__auto___33582,out))
})();
var state__32185__auto__ = (function (){var statearr_33580 = f__32184__auto__.call(null);
(statearr_33580[(6)] = c__32183__auto___33582);

return statearr_33580;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__32185__auto__);
});})(c__32183__auto___33582,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__33596 = arguments.length;
switch (G__33596) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__32183__auto___33641 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__32183__auto___33641,out){
return (function (){
var f__32184__auto__ = (function (){var switch__32095__auto__ = ((function (c__32183__auto___33641,out){
return (function (state_33620){
var state_val_33621 = (state_33620[(1)]);
if((state_val_33621 === (7))){
var inst_33602 = (state_33620[(7)]);
var inst_33602__$1 = (state_33620[(2)]);
var inst_33603 = (inst_33602__$1 == null);
var inst_33604 = cljs.core.not.call(null,inst_33603);
var state_33620__$1 = (function (){var statearr_33622 = state_33620;
(statearr_33622[(7)] = inst_33602__$1);

return statearr_33622;
})();
if(inst_33604){
var statearr_33623_33642 = state_33620__$1;
(statearr_33623_33642[(1)] = (8));

} else {
var statearr_33624_33643 = state_33620__$1;
(statearr_33624_33643[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33621 === (1))){
var inst_33597 = (0);
var state_33620__$1 = (function (){var statearr_33625 = state_33620;
(statearr_33625[(8)] = inst_33597);

return statearr_33625;
})();
var statearr_33626_33644 = state_33620__$1;
(statearr_33626_33644[(2)] = null);

(statearr_33626_33644[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33621 === (4))){
var state_33620__$1 = state_33620;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33620__$1,(7),ch);
} else {
if((state_val_33621 === (6))){
var inst_33615 = (state_33620[(2)]);
var state_33620__$1 = state_33620;
var statearr_33627_33645 = state_33620__$1;
(statearr_33627_33645[(2)] = inst_33615);

(statearr_33627_33645[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33621 === (3))){
var inst_33617 = (state_33620[(2)]);
var inst_33618 = cljs.core.async.close_BANG_.call(null,out);
var state_33620__$1 = (function (){var statearr_33628 = state_33620;
(statearr_33628[(9)] = inst_33617);

return statearr_33628;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33620__$1,inst_33618);
} else {
if((state_val_33621 === (2))){
var inst_33597 = (state_33620[(8)]);
var inst_33599 = (inst_33597 < n);
var state_33620__$1 = state_33620;
if(cljs.core.truth_(inst_33599)){
var statearr_33629_33646 = state_33620__$1;
(statearr_33629_33646[(1)] = (4));

} else {
var statearr_33630_33647 = state_33620__$1;
(statearr_33630_33647[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33621 === (11))){
var inst_33597 = (state_33620[(8)]);
var inst_33607 = (state_33620[(2)]);
var inst_33608 = (inst_33597 + (1));
var inst_33597__$1 = inst_33608;
var state_33620__$1 = (function (){var statearr_33631 = state_33620;
(statearr_33631[(8)] = inst_33597__$1);

(statearr_33631[(10)] = inst_33607);

return statearr_33631;
})();
var statearr_33632_33648 = state_33620__$1;
(statearr_33632_33648[(2)] = null);

(statearr_33632_33648[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33621 === (9))){
var state_33620__$1 = state_33620;
var statearr_33633_33649 = state_33620__$1;
(statearr_33633_33649[(2)] = null);

(statearr_33633_33649[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33621 === (5))){
var state_33620__$1 = state_33620;
var statearr_33634_33650 = state_33620__$1;
(statearr_33634_33650[(2)] = null);

(statearr_33634_33650[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33621 === (10))){
var inst_33612 = (state_33620[(2)]);
var state_33620__$1 = state_33620;
var statearr_33635_33651 = state_33620__$1;
(statearr_33635_33651[(2)] = inst_33612);

(statearr_33635_33651[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33621 === (8))){
var inst_33602 = (state_33620[(7)]);
var state_33620__$1 = state_33620;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33620__$1,(11),out,inst_33602);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__32183__auto___33641,out))
;
return ((function (switch__32095__auto__,c__32183__auto___33641,out){
return (function() {
var cljs$core$async$state_machine__32096__auto__ = null;
var cljs$core$async$state_machine__32096__auto____0 = (function (){
var statearr_33636 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33636[(0)] = cljs$core$async$state_machine__32096__auto__);

(statearr_33636[(1)] = (1));

return statearr_33636;
});
var cljs$core$async$state_machine__32096__auto____1 = (function (state_33620){
while(true){
var ret_value__32097__auto__ = (function (){try{while(true){
var result__32098__auto__ = switch__32095__auto__.call(null,state_33620);
if(cljs.core.keyword_identical_QMARK_.call(null,result__32098__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32098__auto__;
}
break;
}
}catch (e33637){if((e33637 instanceof Object)){
var ex__32099__auto__ = e33637;
var statearr_33638_33652 = state_33620;
(statearr_33638_33652[(5)] = ex__32099__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33620);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33637;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__32097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33653 = state_33620;
state_33620 = G__33653;
continue;
} else {
return ret_value__32097__auto__;
}
break;
}
});
cljs$core$async$state_machine__32096__auto__ = function(state_33620){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__32096__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__32096__auto____1.call(this,state_33620);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__32096__auto____0;
cljs$core$async$state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__32096__auto____1;
return cljs$core$async$state_machine__32096__auto__;
})()
;})(switch__32095__auto__,c__32183__auto___33641,out))
})();
var state__32185__auto__ = (function (){var statearr_33639 = f__32184__auto__.call(null);
(statearr_33639[(6)] = c__32183__auto___33641);

return statearr_33639;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__32185__auto__);
});})(c__32183__auto___33641,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async33655 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33655 = (function (f,ch,meta33656){
this.f = f;
this.ch = ch;
this.meta33656 = meta33656;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async33655.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33657,meta33656__$1){
var self__ = this;
var _33657__$1 = this;
return (new cljs.core.async.t_cljs$core$async33655(self__.f,self__.ch,meta33656__$1));
});

cljs.core.async.t_cljs$core$async33655.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33657){
var self__ = this;
var _33657__$1 = this;
return self__.meta33656;
});

cljs.core.async.t_cljs$core$async33655.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33655.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async33655.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async33655.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33655.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async33658 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33658 = (function (f,ch,meta33656,_,fn1,meta33659){
this.f = f;
this.ch = ch;
this.meta33656 = meta33656;
this._ = _;
this.fn1 = fn1;
this.meta33659 = meta33659;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async33658.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_33660,meta33659__$1){
var self__ = this;
var _33660__$1 = this;
return (new cljs.core.async.t_cljs$core$async33658(self__.f,self__.ch,self__.meta33656,self__._,self__.fn1,meta33659__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async33658.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_33660){
var self__ = this;
var _33660__$1 = this;
return self__.meta33659;
});})(___$1))
;

cljs.core.async.t_cljs$core$async33658.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33658.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async33658.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async33658.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__33654_SHARP_){
return f1.call(null,(((p1__33654_SHARP_ == null))?null:self__.f.call(null,p1__33654_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async33658.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33656","meta33656",-27304228,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async33655","cljs.core.async/t_cljs$core$async33655",-870335021,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta33659","meta33659",-1021915730,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async33658.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33658.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33658";

cljs.core.async.t_cljs$core$async33658.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__27104__auto__,writer__27105__auto__,opt__27106__auto__){
return cljs.core._write.call(null,writer__27105__auto__,"cljs.core.async/t_cljs$core$async33658");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async33658 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async33658(f__$1,ch__$1,meta33656__$1,___$2,fn1__$1,meta33659){
return (new cljs.core.async.t_cljs$core$async33658(f__$1,ch__$1,meta33656__$1,___$2,fn1__$1,meta33659));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async33658(self__.f,self__.ch,self__.meta33656,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__26481__auto__ = ret;
if(cljs.core.truth_(and__26481__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__26481__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async33655.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33655.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async33655.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33656","meta33656",-27304228,null)], null);
});

cljs.core.async.t_cljs$core$async33655.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33655.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33655";

cljs.core.async.t_cljs$core$async33655.cljs$lang$ctorPrWriter = (function (this__27104__auto__,writer__27105__auto__,opt__27106__auto__){
return cljs.core._write.call(null,writer__27105__auto__,"cljs.core.async/t_cljs$core$async33655");
});

cljs.core.async.__GT_t_cljs$core$async33655 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async33655(f__$1,ch__$1,meta33656){
return (new cljs.core.async.t_cljs$core$async33655(f__$1,ch__$1,meta33656));
});

}

return (new cljs.core.async.t_cljs$core$async33655(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async33661 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33661 = (function (f,ch,meta33662){
this.f = f;
this.ch = ch;
this.meta33662 = meta33662;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async33661.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33663,meta33662__$1){
var self__ = this;
var _33663__$1 = this;
return (new cljs.core.async.t_cljs$core$async33661(self__.f,self__.ch,meta33662__$1));
});

cljs.core.async.t_cljs$core$async33661.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33663){
var self__ = this;
var _33663__$1 = this;
return self__.meta33662;
});

cljs.core.async.t_cljs$core$async33661.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33661.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async33661.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33661.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async33661.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33661.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async33661.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33662","meta33662",1621438617,null)], null);
});

cljs.core.async.t_cljs$core$async33661.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33661.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33661";

cljs.core.async.t_cljs$core$async33661.cljs$lang$ctorPrWriter = (function (this__27104__auto__,writer__27105__auto__,opt__27106__auto__){
return cljs.core._write.call(null,writer__27105__auto__,"cljs.core.async/t_cljs$core$async33661");
});

cljs.core.async.__GT_t_cljs$core$async33661 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async33661(f__$1,ch__$1,meta33662){
return (new cljs.core.async.t_cljs$core$async33661(f__$1,ch__$1,meta33662));
});

}

return (new cljs.core.async.t_cljs$core$async33661(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async33664 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33664 = (function (p,ch,meta33665){
this.p = p;
this.ch = ch;
this.meta33665 = meta33665;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async33664.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33666,meta33665__$1){
var self__ = this;
var _33666__$1 = this;
return (new cljs.core.async.t_cljs$core$async33664(self__.p,self__.ch,meta33665__$1));
});

cljs.core.async.t_cljs$core$async33664.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33666){
var self__ = this;
var _33666__$1 = this;
return self__.meta33665;
});

cljs.core.async.t_cljs$core$async33664.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33664.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async33664.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async33664.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33664.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async33664.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33664.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async33664.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33665","meta33665",-1025670817,null)], null);
});

cljs.core.async.t_cljs$core$async33664.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33664.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33664";

cljs.core.async.t_cljs$core$async33664.cljs$lang$ctorPrWriter = (function (this__27104__auto__,writer__27105__auto__,opt__27106__auto__){
return cljs.core._write.call(null,writer__27105__auto__,"cljs.core.async/t_cljs$core$async33664");
});

cljs.core.async.__GT_t_cljs$core$async33664 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async33664(p__$1,ch__$1,meta33665){
return (new cljs.core.async.t_cljs$core$async33664(p__$1,ch__$1,meta33665));
});

}

return (new cljs.core.async.t_cljs$core$async33664(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__33668 = arguments.length;
switch (G__33668) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__32183__auto___33708 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__32183__auto___33708,out){
return (function (){
var f__32184__auto__ = (function (){var switch__32095__auto__ = ((function (c__32183__auto___33708,out){
return (function (state_33689){
var state_val_33690 = (state_33689[(1)]);
if((state_val_33690 === (7))){
var inst_33685 = (state_33689[(2)]);
var state_33689__$1 = state_33689;
var statearr_33691_33709 = state_33689__$1;
(statearr_33691_33709[(2)] = inst_33685);

(statearr_33691_33709[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33690 === (1))){
var state_33689__$1 = state_33689;
var statearr_33692_33710 = state_33689__$1;
(statearr_33692_33710[(2)] = null);

(statearr_33692_33710[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33690 === (4))){
var inst_33671 = (state_33689[(7)]);
var inst_33671__$1 = (state_33689[(2)]);
var inst_33672 = (inst_33671__$1 == null);
var state_33689__$1 = (function (){var statearr_33693 = state_33689;
(statearr_33693[(7)] = inst_33671__$1);

return statearr_33693;
})();
if(cljs.core.truth_(inst_33672)){
var statearr_33694_33711 = state_33689__$1;
(statearr_33694_33711[(1)] = (5));

} else {
var statearr_33695_33712 = state_33689__$1;
(statearr_33695_33712[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33690 === (6))){
var inst_33671 = (state_33689[(7)]);
var inst_33676 = p.call(null,inst_33671);
var state_33689__$1 = state_33689;
if(cljs.core.truth_(inst_33676)){
var statearr_33696_33713 = state_33689__$1;
(statearr_33696_33713[(1)] = (8));

} else {
var statearr_33697_33714 = state_33689__$1;
(statearr_33697_33714[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33690 === (3))){
var inst_33687 = (state_33689[(2)]);
var state_33689__$1 = state_33689;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33689__$1,inst_33687);
} else {
if((state_val_33690 === (2))){
var state_33689__$1 = state_33689;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33689__$1,(4),ch);
} else {
if((state_val_33690 === (11))){
var inst_33679 = (state_33689[(2)]);
var state_33689__$1 = state_33689;
var statearr_33698_33715 = state_33689__$1;
(statearr_33698_33715[(2)] = inst_33679);

(statearr_33698_33715[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33690 === (9))){
var state_33689__$1 = state_33689;
var statearr_33699_33716 = state_33689__$1;
(statearr_33699_33716[(2)] = null);

(statearr_33699_33716[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33690 === (5))){
var inst_33674 = cljs.core.async.close_BANG_.call(null,out);
var state_33689__$1 = state_33689;
var statearr_33700_33717 = state_33689__$1;
(statearr_33700_33717[(2)] = inst_33674);

(statearr_33700_33717[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33690 === (10))){
var inst_33682 = (state_33689[(2)]);
var state_33689__$1 = (function (){var statearr_33701 = state_33689;
(statearr_33701[(8)] = inst_33682);

return statearr_33701;
})();
var statearr_33702_33718 = state_33689__$1;
(statearr_33702_33718[(2)] = null);

(statearr_33702_33718[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33690 === (8))){
var inst_33671 = (state_33689[(7)]);
var state_33689__$1 = state_33689;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33689__$1,(11),out,inst_33671);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__32183__auto___33708,out))
;
return ((function (switch__32095__auto__,c__32183__auto___33708,out){
return (function() {
var cljs$core$async$state_machine__32096__auto__ = null;
var cljs$core$async$state_machine__32096__auto____0 = (function (){
var statearr_33703 = [null,null,null,null,null,null,null,null,null];
(statearr_33703[(0)] = cljs$core$async$state_machine__32096__auto__);

(statearr_33703[(1)] = (1));

return statearr_33703;
});
var cljs$core$async$state_machine__32096__auto____1 = (function (state_33689){
while(true){
var ret_value__32097__auto__ = (function (){try{while(true){
var result__32098__auto__ = switch__32095__auto__.call(null,state_33689);
if(cljs.core.keyword_identical_QMARK_.call(null,result__32098__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32098__auto__;
}
break;
}
}catch (e33704){if((e33704 instanceof Object)){
var ex__32099__auto__ = e33704;
var statearr_33705_33719 = state_33689;
(statearr_33705_33719[(5)] = ex__32099__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33689);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33704;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__32097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33720 = state_33689;
state_33689 = G__33720;
continue;
} else {
return ret_value__32097__auto__;
}
break;
}
});
cljs$core$async$state_machine__32096__auto__ = function(state_33689){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__32096__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__32096__auto____1.call(this,state_33689);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__32096__auto____0;
cljs$core$async$state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__32096__auto____1;
return cljs$core$async$state_machine__32096__auto__;
})()
;})(switch__32095__auto__,c__32183__auto___33708,out))
})();
var state__32185__auto__ = (function (){var statearr_33706 = f__32184__auto__.call(null);
(statearr_33706[(6)] = c__32183__auto___33708);

return statearr_33706;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__32185__auto__);
});})(c__32183__auto___33708,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__33722 = arguments.length;
switch (G__33722) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__32183__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__32183__auto__){
return (function (){
var f__32184__auto__ = (function (){var switch__32095__auto__ = ((function (c__32183__auto__){
return (function (state_33785){
var state_val_33786 = (state_33785[(1)]);
if((state_val_33786 === (7))){
var inst_33781 = (state_33785[(2)]);
var state_33785__$1 = state_33785;
var statearr_33787_33825 = state_33785__$1;
(statearr_33787_33825[(2)] = inst_33781);

(statearr_33787_33825[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33786 === (20))){
var inst_33751 = (state_33785[(7)]);
var inst_33762 = (state_33785[(2)]);
var inst_33763 = cljs.core.next.call(null,inst_33751);
var inst_33737 = inst_33763;
var inst_33738 = null;
var inst_33739 = (0);
var inst_33740 = (0);
var state_33785__$1 = (function (){var statearr_33788 = state_33785;
(statearr_33788[(8)] = inst_33738);

(statearr_33788[(9)] = inst_33762);

(statearr_33788[(10)] = inst_33739);

(statearr_33788[(11)] = inst_33740);

(statearr_33788[(12)] = inst_33737);

return statearr_33788;
})();
var statearr_33789_33826 = state_33785__$1;
(statearr_33789_33826[(2)] = null);

(statearr_33789_33826[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33786 === (1))){
var state_33785__$1 = state_33785;
var statearr_33790_33827 = state_33785__$1;
(statearr_33790_33827[(2)] = null);

(statearr_33790_33827[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33786 === (4))){
var inst_33726 = (state_33785[(13)]);
var inst_33726__$1 = (state_33785[(2)]);
var inst_33727 = (inst_33726__$1 == null);
var state_33785__$1 = (function (){var statearr_33791 = state_33785;
(statearr_33791[(13)] = inst_33726__$1);

return statearr_33791;
})();
if(cljs.core.truth_(inst_33727)){
var statearr_33792_33828 = state_33785__$1;
(statearr_33792_33828[(1)] = (5));

} else {
var statearr_33793_33829 = state_33785__$1;
(statearr_33793_33829[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33786 === (15))){
var state_33785__$1 = state_33785;
var statearr_33797_33830 = state_33785__$1;
(statearr_33797_33830[(2)] = null);

(statearr_33797_33830[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33786 === (21))){
var state_33785__$1 = state_33785;
var statearr_33798_33831 = state_33785__$1;
(statearr_33798_33831[(2)] = null);

(statearr_33798_33831[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33786 === (13))){
var inst_33738 = (state_33785[(8)]);
var inst_33739 = (state_33785[(10)]);
var inst_33740 = (state_33785[(11)]);
var inst_33737 = (state_33785[(12)]);
var inst_33747 = (state_33785[(2)]);
var inst_33748 = (inst_33740 + (1));
var tmp33794 = inst_33738;
var tmp33795 = inst_33739;
var tmp33796 = inst_33737;
var inst_33737__$1 = tmp33796;
var inst_33738__$1 = tmp33794;
var inst_33739__$1 = tmp33795;
var inst_33740__$1 = inst_33748;
var state_33785__$1 = (function (){var statearr_33799 = state_33785;
(statearr_33799[(8)] = inst_33738__$1);

(statearr_33799[(10)] = inst_33739__$1);

(statearr_33799[(11)] = inst_33740__$1);

(statearr_33799[(12)] = inst_33737__$1);

(statearr_33799[(14)] = inst_33747);

return statearr_33799;
})();
var statearr_33800_33832 = state_33785__$1;
(statearr_33800_33832[(2)] = null);

(statearr_33800_33832[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33786 === (22))){
var state_33785__$1 = state_33785;
var statearr_33801_33833 = state_33785__$1;
(statearr_33801_33833[(2)] = null);

(statearr_33801_33833[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33786 === (6))){
var inst_33726 = (state_33785[(13)]);
var inst_33735 = f.call(null,inst_33726);
var inst_33736 = cljs.core.seq.call(null,inst_33735);
var inst_33737 = inst_33736;
var inst_33738 = null;
var inst_33739 = (0);
var inst_33740 = (0);
var state_33785__$1 = (function (){var statearr_33802 = state_33785;
(statearr_33802[(8)] = inst_33738);

(statearr_33802[(10)] = inst_33739);

(statearr_33802[(11)] = inst_33740);

(statearr_33802[(12)] = inst_33737);

return statearr_33802;
})();
var statearr_33803_33834 = state_33785__$1;
(statearr_33803_33834[(2)] = null);

(statearr_33803_33834[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33786 === (17))){
var inst_33751 = (state_33785[(7)]);
var inst_33755 = cljs.core.chunk_first.call(null,inst_33751);
var inst_33756 = cljs.core.chunk_rest.call(null,inst_33751);
var inst_33757 = cljs.core.count.call(null,inst_33755);
var inst_33737 = inst_33756;
var inst_33738 = inst_33755;
var inst_33739 = inst_33757;
var inst_33740 = (0);
var state_33785__$1 = (function (){var statearr_33804 = state_33785;
(statearr_33804[(8)] = inst_33738);

(statearr_33804[(10)] = inst_33739);

(statearr_33804[(11)] = inst_33740);

(statearr_33804[(12)] = inst_33737);

return statearr_33804;
})();
var statearr_33805_33835 = state_33785__$1;
(statearr_33805_33835[(2)] = null);

(statearr_33805_33835[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33786 === (3))){
var inst_33783 = (state_33785[(2)]);
var state_33785__$1 = state_33785;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33785__$1,inst_33783);
} else {
if((state_val_33786 === (12))){
var inst_33771 = (state_33785[(2)]);
var state_33785__$1 = state_33785;
var statearr_33806_33836 = state_33785__$1;
(statearr_33806_33836[(2)] = inst_33771);

(statearr_33806_33836[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33786 === (2))){
var state_33785__$1 = state_33785;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33785__$1,(4),in$);
} else {
if((state_val_33786 === (23))){
var inst_33779 = (state_33785[(2)]);
var state_33785__$1 = state_33785;
var statearr_33807_33837 = state_33785__$1;
(statearr_33807_33837[(2)] = inst_33779);

(statearr_33807_33837[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33786 === (19))){
var inst_33766 = (state_33785[(2)]);
var state_33785__$1 = state_33785;
var statearr_33808_33838 = state_33785__$1;
(statearr_33808_33838[(2)] = inst_33766);

(statearr_33808_33838[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33786 === (11))){
var inst_33751 = (state_33785[(7)]);
var inst_33737 = (state_33785[(12)]);
var inst_33751__$1 = cljs.core.seq.call(null,inst_33737);
var state_33785__$1 = (function (){var statearr_33809 = state_33785;
(statearr_33809[(7)] = inst_33751__$1);

return statearr_33809;
})();
if(inst_33751__$1){
var statearr_33810_33839 = state_33785__$1;
(statearr_33810_33839[(1)] = (14));

} else {
var statearr_33811_33840 = state_33785__$1;
(statearr_33811_33840[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33786 === (9))){
var inst_33773 = (state_33785[(2)]);
var inst_33774 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_33785__$1 = (function (){var statearr_33812 = state_33785;
(statearr_33812[(15)] = inst_33773);

return statearr_33812;
})();
if(cljs.core.truth_(inst_33774)){
var statearr_33813_33841 = state_33785__$1;
(statearr_33813_33841[(1)] = (21));

} else {
var statearr_33814_33842 = state_33785__$1;
(statearr_33814_33842[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33786 === (5))){
var inst_33729 = cljs.core.async.close_BANG_.call(null,out);
var state_33785__$1 = state_33785;
var statearr_33815_33843 = state_33785__$1;
(statearr_33815_33843[(2)] = inst_33729);

(statearr_33815_33843[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33786 === (14))){
var inst_33751 = (state_33785[(7)]);
var inst_33753 = cljs.core.chunked_seq_QMARK_.call(null,inst_33751);
var state_33785__$1 = state_33785;
if(inst_33753){
var statearr_33816_33844 = state_33785__$1;
(statearr_33816_33844[(1)] = (17));

} else {
var statearr_33817_33845 = state_33785__$1;
(statearr_33817_33845[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33786 === (16))){
var inst_33769 = (state_33785[(2)]);
var state_33785__$1 = state_33785;
var statearr_33818_33846 = state_33785__$1;
(statearr_33818_33846[(2)] = inst_33769);

(statearr_33818_33846[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33786 === (10))){
var inst_33738 = (state_33785[(8)]);
var inst_33740 = (state_33785[(11)]);
var inst_33745 = cljs.core._nth.call(null,inst_33738,inst_33740);
var state_33785__$1 = state_33785;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33785__$1,(13),out,inst_33745);
} else {
if((state_val_33786 === (18))){
var inst_33751 = (state_33785[(7)]);
var inst_33760 = cljs.core.first.call(null,inst_33751);
var state_33785__$1 = state_33785;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33785__$1,(20),out,inst_33760);
} else {
if((state_val_33786 === (8))){
var inst_33739 = (state_33785[(10)]);
var inst_33740 = (state_33785[(11)]);
var inst_33742 = (inst_33740 < inst_33739);
var inst_33743 = inst_33742;
var state_33785__$1 = state_33785;
if(cljs.core.truth_(inst_33743)){
var statearr_33819_33847 = state_33785__$1;
(statearr_33819_33847[(1)] = (10));

} else {
var statearr_33820_33848 = state_33785__$1;
(statearr_33820_33848[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__32183__auto__))
;
return ((function (switch__32095__auto__,c__32183__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__32096__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__32096__auto____0 = (function (){
var statearr_33821 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33821[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__32096__auto__);

(statearr_33821[(1)] = (1));

return statearr_33821;
});
var cljs$core$async$mapcat_STAR__$_state_machine__32096__auto____1 = (function (state_33785){
while(true){
var ret_value__32097__auto__ = (function (){try{while(true){
var result__32098__auto__ = switch__32095__auto__.call(null,state_33785);
if(cljs.core.keyword_identical_QMARK_.call(null,result__32098__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32098__auto__;
}
break;
}
}catch (e33822){if((e33822 instanceof Object)){
var ex__32099__auto__ = e33822;
var statearr_33823_33849 = state_33785;
(statearr_33823_33849[(5)] = ex__32099__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33785);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33822;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__32097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33850 = state_33785;
state_33785 = G__33850;
continue;
} else {
return ret_value__32097__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__32096__auto__ = function(state_33785){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__32096__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__32096__auto____1.call(this,state_33785);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__32096__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__32096__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__32096__auto__;
})()
;})(switch__32095__auto__,c__32183__auto__))
})();
var state__32185__auto__ = (function (){var statearr_33824 = f__32184__auto__.call(null);
(statearr_33824[(6)] = c__32183__auto__);

return statearr_33824;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__32185__auto__);
});})(c__32183__auto__))
);

return c__32183__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__33852 = arguments.length;
switch (G__33852) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__33855 = arguments.length;
switch (G__33855) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__33858 = arguments.length;
switch (G__33858) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__32183__auto___33905 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__32183__auto___33905,out){
return (function (){
var f__32184__auto__ = (function (){var switch__32095__auto__ = ((function (c__32183__auto___33905,out){
return (function (state_33882){
var state_val_33883 = (state_33882[(1)]);
if((state_val_33883 === (7))){
var inst_33877 = (state_33882[(2)]);
var state_33882__$1 = state_33882;
var statearr_33884_33906 = state_33882__$1;
(statearr_33884_33906[(2)] = inst_33877);

(statearr_33884_33906[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33883 === (1))){
var inst_33859 = null;
var state_33882__$1 = (function (){var statearr_33885 = state_33882;
(statearr_33885[(7)] = inst_33859);

return statearr_33885;
})();
var statearr_33886_33907 = state_33882__$1;
(statearr_33886_33907[(2)] = null);

(statearr_33886_33907[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33883 === (4))){
var inst_33862 = (state_33882[(8)]);
var inst_33862__$1 = (state_33882[(2)]);
var inst_33863 = (inst_33862__$1 == null);
var inst_33864 = cljs.core.not.call(null,inst_33863);
var state_33882__$1 = (function (){var statearr_33887 = state_33882;
(statearr_33887[(8)] = inst_33862__$1);

return statearr_33887;
})();
if(inst_33864){
var statearr_33888_33908 = state_33882__$1;
(statearr_33888_33908[(1)] = (5));

} else {
var statearr_33889_33909 = state_33882__$1;
(statearr_33889_33909[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33883 === (6))){
var state_33882__$1 = state_33882;
var statearr_33890_33910 = state_33882__$1;
(statearr_33890_33910[(2)] = null);

(statearr_33890_33910[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33883 === (3))){
var inst_33879 = (state_33882[(2)]);
var inst_33880 = cljs.core.async.close_BANG_.call(null,out);
var state_33882__$1 = (function (){var statearr_33891 = state_33882;
(statearr_33891[(9)] = inst_33879);

return statearr_33891;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33882__$1,inst_33880);
} else {
if((state_val_33883 === (2))){
var state_33882__$1 = state_33882;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33882__$1,(4),ch);
} else {
if((state_val_33883 === (11))){
var inst_33862 = (state_33882[(8)]);
var inst_33871 = (state_33882[(2)]);
var inst_33859 = inst_33862;
var state_33882__$1 = (function (){var statearr_33892 = state_33882;
(statearr_33892[(7)] = inst_33859);

(statearr_33892[(10)] = inst_33871);

return statearr_33892;
})();
var statearr_33893_33911 = state_33882__$1;
(statearr_33893_33911[(2)] = null);

(statearr_33893_33911[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33883 === (9))){
var inst_33862 = (state_33882[(8)]);
var state_33882__$1 = state_33882;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33882__$1,(11),out,inst_33862);
} else {
if((state_val_33883 === (5))){
var inst_33859 = (state_33882[(7)]);
var inst_33862 = (state_33882[(8)]);
var inst_33866 = cljs.core._EQ_.call(null,inst_33862,inst_33859);
var state_33882__$1 = state_33882;
if(inst_33866){
var statearr_33895_33912 = state_33882__$1;
(statearr_33895_33912[(1)] = (8));

} else {
var statearr_33896_33913 = state_33882__$1;
(statearr_33896_33913[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33883 === (10))){
var inst_33874 = (state_33882[(2)]);
var state_33882__$1 = state_33882;
var statearr_33897_33914 = state_33882__$1;
(statearr_33897_33914[(2)] = inst_33874);

(statearr_33897_33914[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33883 === (8))){
var inst_33859 = (state_33882[(7)]);
var tmp33894 = inst_33859;
var inst_33859__$1 = tmp33894;
var state_33882__$1 = (function (){var statearr_33898 = state_33882;
(statearr_33898[(7)] = inst_33859__$1);

return statearr_33898;
})();
var statearr_33899_33915 = state_33882__$1;
(statearr_33899_33915[(2)] = null);

(statearr_33899_33915[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__32183__auto___33905,out))
;
return ((function (switch__32095__auto__,c__32183__auto___33905,out){
return (function() {
var cljs$core$async$state_machine__32096__auto__ = null;
var cljs$core$async$state_machine__32096__auto____0 = (function (){
var statearr_33900 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33900[(0)] = cljs$core$async$state_machine__32096__auto__);

(statearr_33900[(1)] = (1));

return statearr_33900;
});
var cljs$core$async$state_machine__32096__auto____1 = (function (state_33882){
while(true){
var ret_value__32097__auto__ = (function (){try{while(true){
var result__32098__auto__ = switch__32095__auto__.call(null,state_33882);
if(cljs.core.keyword_identical_QMARK_.call(null,result__32098__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32098__auto__;
}
break;
}
}catch (e33901){if((e33901 instanceof Object)){
var ex__32099__auto__ = e33901;
var statearr_33902_33916 = state_33882;
(statearr_33902_33916[(5)] = ex__32099__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33882);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33901;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__32097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33917 = state_33882;
state_33882 = G__33917;
continue;
} else {
return ret_value__32097__auto__;
}
break;
}
});
cljs$core$async$state_machine__32096__auto__ = function(state_33882){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__32096__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__32096__auto____1.call(this,state_33882);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__32096__auto____0;
cljs$core$async$state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__32096__auto____1;
return cljs$core$async$state_machine__32096__auto__;
})()
;})(switch__32095__auto__,c__32183__auto___33905,out))
})();
var state__32185__auto__ = (function (){var statearr_33903 = f__32184__auto__.call(null);
(statearr_33903[(6)] = c__32183__auto___33905);

return statearr_33903;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__32185__auto__);
});})(c__32183__auto___33905,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__33919 = arguments.length;
switch (G__33919) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__32183__auto___33985 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__32183__auto___33985,out){
return (function (){
var f__32184__auto__ = (function (){var switch__32095__auto__ = ((function (c__32183__auto___33985,out){
return (function (state_33957){
var state_val_33958 = (state_33957[(1)]);
if((state_val_33958 === (7))){
var inst_33953 = (state_33957[(2)]);
var state_33957__$1 = state_33957;
var statearr_33959_33986 = state_33957__$1;
(statearr_33959_33986[(2)] = inst_33953);

(statearr_33959_33986[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33958 === (1))){
var inst_33920 = (new Array(n));
var inst_33921 = inst_33920;
var inst_33922 = (0);
var state_33957__$1 = (function (){var statearr_33960 = state_33957;
(statearr_33960[(7)] = inst_33921);

(statearr_33960[(8)] = inst_33922);

return statearr_33960;
})();
var statearr_33961_33987 = state_33957__$1;
(statearr_33961_33987[(2)] = null);

(statearr_33961_33987[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33958 === (4))){
var inst_33925 = (state_33957[(9)]);
var inst_33925__$1 = (state_33957[(2)]);
var inst_33926 = (inst_33925__$1 == null);
var inst_33927 = cljs.core.not.call(null,inst_33926);
var state_33957__$1 = (function (){var statearr_33962 = state_33957;
(statearr_33962[(9)] = inst_33925__$1);

return statearr_33962;
})();
if(inst_33927){
var statearr_33963_33988 = state_33957__$1;
(statearr_33963_33988[(1)] = (5));

} else {
var statearr_33964_33989 = state_33957__$1;
(statearr_33964_33989[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33958 === (15))){
var inst_33947 = (state_33957[(2)]);
var state_33957__$1 = state_33957;
var statearr_33965_33990 = state_33957__$1;
(statearr_33965_33990[(2)] = inst_33947);

(statearr_33965_33990[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33958 === (13))){
var state_33957__$1 = state_33957;
var statearr_33966_33991 = state_33957__$1;
(statearr_33966_33991[(2)] = null);

(statearr_33966_33991[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33958 === (6))){
var inst_33922 = (state_33957[(8)]);
var inst_33943 = (inst_33922 > (0));
var state_33957__$1 = state_33957;
if(cljs.core.truth_(inst_33943)){
var statearr_33967_33992 = state_33957__$1;
(statearr_33967_33992[(1)] = (12));

} else {
var statearr_33968_33993 = state_33957__$1;
(statearr_33968_33993[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33958 === (3))){
var inst_33955 = (state_33957[(2)]);
var state_33957__$1 = state_33957;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33957__$1,inst_33955);
} else {
if((state_val_33958 === (12))){
var inst_33921 = (state_33957[(7)]);
var inst_33945 = cljs.core.vec.call(null,inst_33921);
var state_33957__$1 = state_33957;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33957__$1,(15),out,inst_33945);
} else {
if((state_val_33958 === (2))){
var state_33957__$1 = state_33957;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33957__$1,(4),ch);
} else {
if((state_val_33958 === (11))){
var inst_33937 = (state_33957[(2)]);
var inst_33938 = (new Array(n));
var inst_33921 = inst_33938;
var inst_33922 = (0);
var state_33957__$1 = (function (){var statearr_33969 = state_33957;
(statearr_33969[(7)] = inst_33921);

(statearr_33969[(10)] = inst_33937);

(statearr_33969[(8)] = inst_33922);

return statearr_33969;
})();
var statearr_33970_33994 = state_33957__$1;
(statearr_33970_33994[(2)] = null);

(statearr_33970_33994[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33958 === (9))){
var inst_33921 = (state_33957[(7)]);
var inst_33935 = cljs.core.vec.call(null,inst_33921);
var state_33957__$1 = state_33957;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33957__$1,(11),out,inst_33935);
} else {
if((state_val_33958 === (5))){
var inst_33930 = (state_33957[(11)]);
var inst_33921 = (state_33957[(7)]);
var inst_33922 = (state_33957[(8)]);
var inst_33925 = (state_33957[(9)]);
var inst_33929 = (inst_33921[inst_33922] = inst_33925);
var inst_33930__$1 = (inst_33922 + (1));
var inst_33931 = (inst_33930__$1 < n);
var state_33957__$1 = (function (){var statearr_33971 = state_33957;
(statearr_33971[(11)] = inst_33930__$1);

(statearr_33971[(12)] = inst_33929);

return statearr_33971;
})();
if(cljs.core.truth_(inst_33931)){
var statearr_33972_33995 = state_33957__$1;
(statearr_33972_33995[(1)] = (8));

} else {
var statearr_33973_33996 = state_33957__$1;
(statearr_33973_33996[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33958 === (14))){
var inst_33950 = (state_33957[(2)]);
var inst_33951 = cljs.core.async.close_BANG_.call(null,out);
var state_33957__$1 = (function (){var statearr_33975 = state_33957;
(statearr_33975[(13)] = inst_33950);

return statearr_33975;
})();
var statearr_33976_33997 = state_33957__$1;
(statearr_33976_33997[(2)] = inst_33951);

(statearr_33976_33997[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33958 === (10))){
var inst_33941 = (state_33957[(2)]);
var state_33957__$1 = state_33957;
var statearr_33977_33998 = state_33957__$1;
(statearr_33977_33998[(2)] = inst_33941);

(statearr_33977_33998[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33958 === (8))){
var inst_33930 = (state_33957[(11)]);
var inst_33921 = (state_33957[(7)]);
var tmp33974 = inst_33921;
var inst_33921__$1 = tmp33974;
var inst_33922 = inst_33930;
var state_33957__$1 = (function (){var statearr_33978 = state_33957;
(statearr_33978[(7)] = inst_33921__$1);

(statearr_33978[(8)] = inst_33922);

return statearr_33978;
})();
var statearr_33979_33999 = state_33957__$1;
(statearr_33979_33999[(2)] = null);

(statearr_33979_33999[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__32183__auto___33985,out))
;
return ((function (switch__32095__auto__,c__32183__auto___33985,out){
return (function() {
var cljs$core$async$state_machine__32096__auto__ = null;
var cljs$core$async$state_machine__32096__auto____0 = (function (){
var statearr_33980 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33980[(0)] = cljs$core$async$state_machine__32096__auto__);

(statearr_33980[(1)] = (1));

return statearr_33980;
});
var cljs$core$async$state_machine__32096__auto____1 = (function (state_33957){
while(true){
var ret_value__32097__auto__ = (function (){try{while(true){
var result__32098__auto__ = switch__32095__auto__.call(null,state_33957);
if(cljs.core.keyword_identical_QMARK_.call(null,result__32098__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32098__auto__;
}
break;
}
}catch (e33981){if((e33981 instanceof Object)){
var ex__32099__auto__ = e33981;
var statearr_33982_34000 = state_33957;
(statearr_33982_34000[(5)] = ex__32099__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33957);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33981;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__32097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34001 = state_33957;
state_33957 = G__34001;
continue;
} else {
return ret_value__32097__auto__;
}
break;
}
});
cljs$core$async$state_machine__32096__auto__ = function(state_33957){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__32096__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__32096__auto____1.call(this,state_33957);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__32096__auto____0;
cljs$core$async$state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__32096__auto____1;
return cljs$core$async$state_machine__32096__auto__;
})()
;})(switch__32095__auto__,c__32183__auto___33985,out))
})();
var state__32185__auto__ = (function (){var statearr_33983 = f__32184__auto__.call(null);
(statearr_33983[(6)] = c__32183__auto___33985);

return statearr_33983;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__32185__auto__);
});})(c__32183__auto___33985,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__34003 = arguments.length;
switch (G__34003) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__32183__auto___34073 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__32183__auto___34073,out){
return (function (){
var f__32184__auto__ = (function (){var switch__32095__auto__ = ((function (c__32183__auto___34073,out){
return (function (state_34045){
var state_val_34046 = (state_34045[(1)]);
if((state_val_34046 === (7))){
var inst_34041 = (state_34045[(2)]);
var state_34045__$1 = state_34045;
var statearr_34047_34074 = state_34045__$1;
(statearr_34047_34074[(2)] = inst_34041);

(statearr_34047_34074[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34046 === (1))){
var inst_34004 = [];
var inst_34005 = inst_34004;
var inst_34006 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_34045__$1 = (function (){var statearr_34048 = state_34045;
(statearr_34048[(7)] = inst_34006);

(statearr_34048[(8)] = inst_34005);

return statearr_34048;
})();
var statearr_34049_34075 = state_34045__$1;
(statearr_34049_34075[(2)] = null);

(statearr_34049_34075[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34046 === (4))){
var inst_34009 = (state_34045[(9)]);
var inst_34009__$1 = (state_34045[(2)]);
var inst_34010 = (inst_34009__$1 == null);
var inst_34011 = cljs.core.not.call(null,inst_34010);
var state_34045__$1 = (function (){var statearr_34050 = state_34045;
(statearr_34050[(9)] = inst_34009__$1);

return statearr_34050;
})();
if(inst_34011){
var statearr_34051_34076 = state_34045__$1;
(statearr_34051_34076[(1)] = (5));

} else {
var statearr_34052_34077 = state_34045__$1;
(statearr_34052_34077[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34046 === (15))){
var inst_34035 = (state_34045[(2)]);
var state_34045__$1 = state_34045;
var statearr_34053_34078 = state_34045__$1;
(statearr_34053_34078[(2)] = inst_34035);

(statearr_34053_34078[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34046 === (13))){
var state_34045__$1 = state_34045;
var statearr_34054_34079 = state_34045__$1;
(statearr_34054_34079[(2)] = null);

(statearr_34054_34079[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34046 === (6))){
var inst_34005 = (state_34045[(8)]);
var inst_34030 = inst_34005.length;
var inst_34031 = (inst_34030 > (0));
var state_34045__$1 = state_34045;
if(cljs.core.truth_(inst_34031)){
var statearr_34055_34080 = state_34045__$1;
(statearr_34055_34080[(1)] = (12));

} else {
var statearr_34056_34081 = state_34045__$1;
(statearr_34056_34081[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34046 === (3))){
var inst_34043 = (state_34045[(2)]);
var state_34045__$1 = state_34045;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34045__$1,inst_34043);
} else {
if((state_val_34046 === (12))){
var inst_34005 = (state_34045[(8)]);
var inst_34033 = cljs.core.vec.call(null,inst_34005);
var state_34045__$1 = state_34045;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34045__$1,(15),out,inst_34033);
} else {
if((state_val_34046 === (2))){
var state_34045__$1 = state_34045;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34045__$1,(4),ch);
} else {
if((state_val_34046 === (11))){
var inst_34013 = (state_34045[(10)]);
var inst_34009 = (state_34045[(9)]);
var inst_34023 = (state_34045[(2)]);
var inst_34024 = [];
var inst_34025 = inst_34024.push(inst_34009);
var inst_34005 = inst_34024;
var inst_34006 = inst_34013;
var state_34045__$1 = (function (){var statearr_34057 = state_34045;
(statearr_34057[(7)] = inst_34006);

(statearr_34057[(8)] = inst_34005);

(statearr_34057[(11)] = inst_34023);

(statearr_34057[(12)] = inst_34025);

return statearr_34057;
})();
var statearr_34058_34082 = state_34045__$1;
(statearr_34058_34082[(2)] = null);

(statearr_34058_34082[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34046 === (9))){
var inst_34005 = (state_34045[(8)]);
var inst_34021 = cljs.core.vec.call(null,inst_34005);
var state_34045__$1 = state_34045;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34045__$1,(11),out,inst_34021);
} else {
if((state_val_34046 === (5))){
var inst_34006 = (state_34045[(7)]);
var inst_34013 = (state_34045[(10)]);
var inst_34009 = (state_34045[(9)]);
var inst_34013__$1 = f.call(null,inst_34009);
var inst_34014 = cljs.core._EQ_.call(null,inst_34013__$1,inst_34006);
var inst_34015 = cljs.core.keyword_identical_QMARK_.call(null,inst_34006,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_34016 = (inst_34014) || (inst_34015);
var state_34045__$1 = (function (){var statearr_34059 = state_34045;
(statearr_34059[(10)] = inst_34013__$1);

return statearr_34059;
})();
if(cljs.core.truth_(inst_34016)){
var statearr_34060_34083 = state_34045__$1;
(statearr_34060_34083[(1)] = (8));

} else {
var statearr_34061_34084 = state_34045__$1;
(statearr_34061_34084[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34046 === (14))){
var inst_34038 = (state_34045[(2)]);
var inst_34039 = cljs.core.async.close_BANG_.call(null,out);
var state_34045__$1 = (function (){var statearr_34063 = state_34045;
(statearr_34063[(13)] = inst_34038);

return statearr_34063;
})();
var statearr_34064_34085 = state_34045__$1;
(statearr_34064_34085[(2)] = inst_34039);

(statearr_34064_34085[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34046 === (10))){
var inst_34028 = (state_34045[(2)]);
var state_34045__$1 = state_34045;
var statearr_34065_34086 = state_34045__$1;
(statearr_34065_34086[(2)] = inst_34028);

(statearr_34065_34086[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34046 === (8))){
var inst_34005 = (state_34045[(8)]);
var inst_34013 = (state_34045[(10)]);
var inst_34009 = (state_34045[(9)]);
var inst_34018 = inst_34005.push(inst_34009);
var tmp34062 = inst_34005;
var inst_34005__$1 = tmp34062;
var inst_34006 = inst_34013;
var state_34045__$1 = (function (){var statearr_34066 = state_34045;
(statearr_34066[(7)] = inst_34006);

(statearr_34066[(8)] = inst_34005__$1);

(statearr_34066[(14)] = inst_34018);

return statearr_34066;
})();
var statearr_34067_34087 = state_34045__$1;
(statearr_34067_34087[(2)] = null);

(statearr_34067_34087[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__32183__auto___34073,out))
;
return ((function (switch__32095__auto__,c__32183__auto___34073,out){
return (function() {
var cljs$core$async$state_machine__32096__auto__ = null;
var cljs$core$async$state_machine__32096__auto____0 = (function (){
var statearr_34068 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34068[(0)] = cljs$core$async$state_machine__32096__auto__);

(statearr_34068[(1)] = (1));

return statearr_34068;
});
var cljs$core$async$state_machine__32096__auto____1 = (function (state_34045){
while(true){
var ret_value__32097__auto__ = (function (){try{while(true){
var result__32098__auto__ = switch__32095__auto__.call(null,state_34045);
if(cljs.core.keyword_identical_QMARK_.call(null,result__32098__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32098__auto__;
}
break;
}
}catch (e34069){if((e34069 instanceof Object)){
var ex__32099__auto__ = e34069;
var statearr_34070_34088 = state_34045;
(statearr_34070_34088[(5)] = ex__32099__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34045);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34069;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__32097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34089 = state_34045;
state_34045 = G__34089;
continue;
} else {
return ret_value__32097__auto__;
}
break;
}
});
cljs$core$async$state_machine__32096__auto__ = function(state_34045){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__32096__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__32096__auto____1.call(this,state_34045);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__32096__auto____0;
cljs$core$async$state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__32096__auto____1;
return cljs$core$async$state_machine__32096__auto__;
})()
;})(switch__32095__auto__,c__32183__auto___34073,out))
})();
var state__32185__auto__ = (function (){var statearr_34071 = f__32184__auto__.call(null);
(statearr_34071[(6)] = c__32183__auto___34073);

return statearr_34071;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__32185__auto__);
});})(c__32183__auto___34073,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1500131135317