// Compiled by ClojureScript 1.9.671 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('figwheel.client.utils');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.net.jsloader');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.core.async');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__26493__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__26493__auto__){
return or__26493__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.fix_node_request_url = (function figwheel$client$file_reloading$fix_node_request_url(url){

if(cljs.core.truth_(goog.string.startsWith(url,"../"))){
return clojure.string.replace.call(null,url,"../","");
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("goog/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
}
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__26493__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, ["svgpan.SvgPan",null,"far.out",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__26493__auto__)){
return or__26493__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__35711_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__35711_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([name]));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([parent_ns]));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__35712 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__35713 = null;
var count__35714 = (0);
var i__35715 = (0);
while(true){
if((i__35715 < count__35714)){
var n = cljs.core._nth.call(null,chunk__35713,i__35715);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__35716 = seq__35712;
var G__35717 = chunk__35713;
var G__35718 = count__35714;
var G__35719 = (i__35715 + (1));
seq__35712 = G__35716;
chunk__35713 = G__35717;
count__35714 = G__35718;
i__35715 = G__35719;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__35712);
if(temp__4657__auto__){
var seq__35712__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__35712__$1)){
var c__27313__auto__ = cljs.core.chunk_first.call(null,seq__35712__$1);
var G__35720 = cljs.core.chunk_rest.call(null,seq__35712__$1);
var G__35721 = c__27313__auto__;
var G__35722 = cljs.core.count.call(null,c__27313__auto__);
var G__35723 = (0);
seq__35712 = G__35720;
chunk__35713 = G__35721;
count__35714 = G__35722;
i__35715 = G__35723;
continue;
} else {
var n = cljs.core.first.call(null,seq__35712__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__35724 = cljs.core.next.call(null,seq__35712__$1);
var G__35725 = null;
var G__35726 = (0);
var G__35727 = (0);
seq__35712 = G__35724;
chunk__35713 = G__35725;
count__35714 = G__35726;
i__35715 = G__35727;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__35737_35745 = cljs.core.seq.call(null,deps);
var chunk__35738_35746 = null;
var count__35739_35747 = (0);
var i__35740_35748 = (0);
while(true){
if((i__35740_35748 < count__35739_35747)){
var dep_35749 = cljs.core._nth.call(null,chunk__35738_35746,i__35740_35748);
topo_sort_helper_STAR_.call(null,dep_35749,(depth + (1)),state);

var G__35750 = seq__35737_35745;
var G__35751 = chunk__35738_35746;
var G__35752 = count__35739_35747;
var G__35753 = (i__35740_35748 + (1));
seq__35737_35745 = G__35750;
chunk__35738_35746 = G__35751;
count__35739_35747 = G__35752;
i__35740_35748 = G__35753;
continue;
} else {
var temp__4657__auto___35754 = cljs.core.seq.call(null,seq__35737_35745);
if(temp__4657__auto___35754){
var seq__35737_35755__$1 = temp__4657__auto___35754;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__35737_35755__$1)){
var c__27313__auto___35756 = cljs.core.chunk_first.call(null,seq__35737_35755__$1);
var G__35757 = cljs.core.chunk_rest.call(null,seq__35737_35755__$1);
var G__35758 = c__27313__auto___35756;
var G__35759 = cljs.core.count.call(null,c__27313__auto___35756);
var G__35760 = (0);
seq__35737_35745 = G__35757;
chunk__35738_35746 = G__35758;
count__35739_35747 = G__35759;
i__35740_35748 = G__35760;
continue;
} else {
var dep_35761 = cljs.core.first.call(null,seq__35737_35755__$1);
topo_sort_helper_STAR_.call(null,dep_35761,(depth + (1)),state);

var G__35762 = cljs.core.next.call(null,seq__35737_35755__$1);
var G__35763 = null;
var G__35764 = (0);
var G__35765 = (0);
seq__35737_35745 = G__35762;
chunk__35738_35746 = G__35763;
count__35739_35747 = G__35764;
i__35740_35748 = G__35765;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__35741){
var vec__35742 = p__35741;
var seq__35743 = cljs.core.seq.call(null,vec__35742);
var first__35744 = cljs.core.first.call(null,seq__35743);
var seq__35743__$1 = cljs.core.next.call(null,seq__35743);
var x = first__35744;
var xs = seq__35743__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__35742,seq__35743,first__35744,seq__35743__$1,x,xs,get_deps__$1){
return (function (p1__35728_SHARP_){
return clojure.set.difference.call(null,p1__35728_SHARP_,x);
});})(vec__35742,seq__35743,first__35744,seq__35743__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__35766 = cljs.core.seq.call(null,provides);
var chunk__35767 = null;
var count__35768 = (0);
var i__35769 = (0);
while(true){
if((i__35769 < count__35768)){
var prov = cljs.core._nth.call(null,chunk__35767,i__35769);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__35770_35778 = cljs.core.seq.call(null,requires);
var chunk__35771_35779 = null;
var count__35772_35780 = (0);
var i__35773_35781 = (0);
while(true){
if((i__35773_35781 < count__35772_35780)){
var req_35782 = cljs.core._nth.call(null,chunk__35771_35779,i__35773_35781);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_35782,prov);

var G__35783 = seq__35770_35778;
var G__35784 = chunk__35771_35779;
var G__35785 = count__35772_35780;
var G__35786 = (i__35773_35781 + (1));
seq__35770_35778 = G__35783;
chunk__35771_35779 = G__35784;
count__35772_35780 = G__35785;
i__35773_35781 = G__35786;
continue;
} else {
var temp__4657__auto___35787 = cljs.core.seq.call(null,seq__35770_35778);
if(temp__4657__auto___35787){
var seq__35770_35788__$1 = temp__4657__auto___35787;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__35770_35788__$1)){
var c__27313__auto___35789 = cljs.core.chunk_first.call(null,seq__35770_35788__$1);
var G__35790 = cljs.core.chunk_rest.call(null,seq__35770_35788__$1);
var G__35791 = c__27313__auto___35789;
var G__35792 = cljs.core.count.call(null,c__27313__auto___35789);
var G__35793 = (0);
seq__35770_35778 = G__35790;
chunk__35771_35779 = G__35791;
count__35772_35780 = G__35792;
i__35773_35781 = G__35793;
continue;
} else {
var req_35794 = cljs.core.first.call(null,seq__35770_35788__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_35794,prov);

var G__35795 = cljs.core.next.call(null,seq__35770_35788__$1);
var G__35796 = null;
var G__35797 = (0);
var G__35798 = (0);
seq__35770_35778 = G__35795;
chunk__35771_35779 = G__35796;
count__35772_35780 = G__35797;
i__35773_35781 = G__35798;
continue;
}
} else {
}
}
break;
}

var G__35799 = seq__35766;
var G__35800 = chunk__35767;
var G__35801 = count__35768;
var G__35802 = (i__35769 + (1));
seq__35766 = G__35799;
chunk__35767 = G__35800;
count__35768 = G__35801;
i__35769 = G__35802;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__35766);
if(temp__4657__auto__){
var seq__35766__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__35766__$1)){
var c__27313__auto__ = cljs.core.chunk_first.call(null,seq__35766__$1);
var G__35803 = cljs.core.chunk_rest.call(null,seq__35766__$1);
var G__35804 = c__27313__auto__;
var G__35805 = cljs.core.count.call(null,c__27313__auto__);
var G__35806 = (0);
seq__35766 = G__35803;
chunk__35767 = G__35804;
count__35768 = G__35805;
i__35769 = G__35806;
continue;
} else {
var prov = cljs.core.first.call(null,seq__35766__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__35774_35807 = cljs.core.seq.call(null,requires);
var chunk__35775_35808 = null;
var count__35776_35809 = (0);
var i__35777_35810 = (0);
while(true){
if((i__35777_35810 < count__35776_35809)){
var req_35811 = cljs.core._nth.call(null,chunk__35775_35808,i__35777_35810);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_35811,prov);

var G__35812 = seq__35774_35807;
var G__35813 = chunk__35775_35808;
var G__35814 = count__35776_35809;
var G__35815 = (i__35777_35810 + (1));
seq__35774_35807 = G__35812;
chunk__35775_35808 = G__35813;
count__35776_35809 = G__35814;
i__35777_35810 = G__35815;
continue;
} else {
var temp__4657__auto___35816__$1 = cljs.core.seq.call(null,seq__35774_35807);
if(temp__4657__auto___35816__$1){
var seq__35774_35817__$1 = temp__4657__auto___35816__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__35774_35817__$1)){
var c__27313__auto___35818 = cljs.core.chunk_first.call(null,seq__35774_35817__$1);
var G__35819 = cljs.core.chunk_rest.call(null,seq__35774_35817__$1);
var G__35820 = c__27313__auto___35818;
var G__35821 = cljs.core.count.call(null,c__27313__auto___35818);
var G__35822 = (0);
seq__35774_35807 = G__35819;
chunk__35775_35808 = G__35820;
count__35776_35809 = G__35821;
i__35777_35810 = G__35822;
continue;
} else {
var req_35823 = cljs.core.first.call(null,seq__35774_35817__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_35823,prov);

var G__35824 = cljs.core.next.call(null,seq__35774_35817__$1);
var G__35825 = null;
var G__35826 = (0);
var G__35827 = (0);
seq__35774_35807 = G__35824;
chunk__35775_35808 = G__35825;
count__35776_35809 = G__35826;
i__35777_35810 = G__35827;
continue;
}
} else {
}
}
break;
}

var G__35828 = cljs.core.next.call(null,seq__35766__$1);
var G__35829 = null;
var G__35830 = (0);
var G__35831 = (0);
seq__35766 = G__35828;
chunk__35767 = G__35829;
count__35768 = G__35830;
i__35769 = G__35831;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__35832_35836 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__35833_35837 = null;
var count__35834_35838 = (0);
var i__35835_35839 = (0);
while(true){
if((i__35835_35839 < count__35834_35838)){
var ns_35840 = cljs.core._nth.call(null,chunk__35833_35837,i__35835_35839);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_35840);

var G__35841 = seq__35832_35836;
var G__35842 = chunk__35833_35837;
var G__35843 = count__35834_35838;
var G__35844 = (i__35835_35839 + (1));
seq__35832_35836 = G__35841;
chunk__35833_35837 = G__35842;
count__35834_35838 = G__35843;
i__35835_35839 = G__35844;
continue;
} else {
var temp__4657__auto___35845 = cljs.core.seq.call(null,seq__35832_35836);
if(temp__4657__auto___35845){
var seq__35832_35846__$1 = temp__4657__auto___35845;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__35832_35846__$1)){
var c__27313__auto___35847 = cljs.core.chunk_first.call(null,seq__35832_35846__$1);
var G__35848 = cljs.core.chunk_rest.call(null,seq__35832_35846__$1);
var G__35849 = c__27313__auto___35847;
var G__35850 = cljs.core.count.call(null,c__27313__auto___35847);
var G__35851 = (0);
seq__35832_35836 = G__35848;
chunk__35833_35837 = G__35849;
count__35834_35838 = G__35850;
i__35835_35839 = G__35851;
continue;
} else {
var ns_35852 = cljs.core.first.call(null,seq__35832_35846__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_35852);

var G__35853 = cljs.core.next.call(null,seq__35832_35846__$1);
var G__35854 = null;
var G__35855 = (0);
var G__35856 = (0);
seq__35832_35836 = G__35853;
chunk__35833_35837 = G__35854;
count__35834_35838 = G__35855;
i__35835_35839 = G__35856;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__26493__auto__ = goog.require__;
if(cljs.core.truth_(or__26493__auto__)){
return or__26493__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__35857__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__35857 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__35858__i = 0, G__35858__a = new Array(arguments.length -  0);
while (G__35858__i < G__35858__a.length) {G__35858__a[G__35858__i] = arguments[G__35858__i + 0]; ++G__35858__i;}
  args = new cljs.core.IndexedSeq(G__35858__a,0,null);
} 
return G__35857__delegate.call(this,args);};
G__35857.cljs$lang$maxFixedArity = 0;
G__35857.cljs$lang$applyTo = (function (arglist__35859){
var args = cljs.core.seq(arglist__35859);
return G__35857__delegate(args);
});
G__35857.cljs$core$IFn$_invoke$arity$variadic = G__35857__delegate;
return G__35857;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__35861 = cljs.core._EQ_;
var expr__35862 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__35861.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__35862))){
var path_parts = ((function (pred__35861,expr__35862){
return (function (p1__35860_SHARP_){
return clojure.string.split.call(null,p1__35860_SHARP_,/[\/\\]/);
});})(pred__35861,expr__35862))
;
var sep = (cljs.core.truth_(cljs.core.re_matches.call(null,/win.*/,process.platform))?"\\":"/");
var root = clojure.string.join.call(null,sep,cljs.core.pop.call(null,cljs.core.pop.call(null,path_parts.call(null,__dirname))));
return ((function (path_parts,sep,root,pred__35861,expr__35862){
return (function (request_url,callback){

var cache_path = clojure.string.join.call(null,sep,cljs.core.cons.call(null,root,path_parts.call(null,figwheel.client.file_reloading.fix_node_request_url.call(null,request_url))));
(require.cache[cache_path] = null);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e35864){if((e35864 instanceof Error)){
var e = e35864;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Error loading file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e35864;

}
}})());
});
;})(path_parts,sep,root,pred__35861,expr__35862))
} else {
if(cljs.core.truth_(pred__35861.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__35862))){
return ((function (pred__35861,expr__35862){
return (function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
deferred.addCallback(((function (deferred,pred__35861,expr__35862){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred,pred__35861,expr__35862))
);

return deferred.addErrback(((function (deferred,pred__35861,expr__35862){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred,pred__35861,expr__35862))
);
});
;})(pred__35861,expr__35862))
} else {
return ((function (pred__35861,expr__35862){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__35861,expr__35862))
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__35865,callback){
var map__35866 = p__35865;
var map__35866__$1 = ((((!((map__35866 == null)))?((((map__35866.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35866.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35866):map__35866);
var file_msg = map__35866__$1;
var request_url = cljs.core.get.call(null,map__35866__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("FigWheel: Attempting to load "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__35866,map__35866__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("FigWheel: Successfully loaded "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Error loading file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__35866,map__35866__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__32183__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__32183__auto__){
return (function (){
var f__32184__auto__ = (function (){var switch__32095__auto__ = ((function (c__32183__auto__){
return (function (state_35890){
var state_val_35891 = (state_35890[(1)]);
if((state_val_35891 === (7))){
var inst_35886 = (state_35890[(2)]);
var state_35890__$1 = state_35890;
var statearr_35892_35909 = state_35890__$1;
(statearr_35892_35909[(2)] = inst_35886);

(statearr_35892_35909[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35891 === (1))){
var state_35890__$1 = state_35890;
var statearr_35893_35910 = state_35890__$1;
(statearr_35893_35910[(2)] = null);

(statearr_35893_35910[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35891 === (4))){
var inst_35870 = (state_35890[(7)]);
var inst_35870__$1 = (state_35890[(2)]);
var state_35890__$1 = (function (){var statearr_35894 = state_35890;
(statearr_35894[(7)] = inst_35870__$1);

return statearr_35894;
})();
if(cljs.core.truth_(inst_35870__$1)){
var statearr_35895_35911 = state_35890__$1;
(statearr_35895_35911[(1)] = (5));

} else {
var statearr_35896_35912 = state_35890__$1;
(statearr_35896_35912[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35891 === (6))){
var state_35890__$1 = state_35890;
var statearr_35897_35913 = state_35890__$1;
(statearr_35897_35913[(2)] = null);

(statearr_35897_35913[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35891 === (3))){
var inst_35888 = (state_35890[(2)]);
var state_35890__$1 = state_35890;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35890__$1,inst_35888);
} else {
if((state_val_35891 === (2))){
var state_35890__$1 = state_35890;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35890__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_35891 === (11))){
var inst_35882 = (state_35890[(2)]);
var state_35890__$1 = (function (){var statearr_35898 = state_35890;
(statearr_35898[(8)] = inst_35882);

return statearr_35898;
})();
var statearr_35899_35914 = state_35890__$1;
(statearr_35899_35914[(2)] = null);

(statearr_35899_35914[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35891 === (9))){
var inst_35876 = (state_35890[(9)]);
var inst_35874 = (state_35890[(10)]);
var inst_35878 = inst_35876.call(null,inst_35874);
var state_35890__$1 = state_35890;
var statearr_35900_35915 = state_35890__$1;
(statearr_35900_35915[(2)] = inst_35878);

(statearr_35900_35915[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35891 === (5))){
var inst_35870 = (state_35890[(7)]);
var inst_35872 = figwheel.client.file_reloading.blocking_load.call(null,inst_35870);
var state_35890__$1 = state_35890;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35890__$1,(8),inst_35872);
} else {
if((state_val_35891 === (10))){
var inst_35874 = (state_35890[(10)]);
var inst_35880 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_35874);
var state_35890__$1 = state_35890;
var statearr_35901_35916 = state_35890__$1;
(statearr_35901_35916[(2)] = inst_35880);

(statearr_35901_35916[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35891 === (8))){
var inst_35876 = (state_35890[(9)]);
var inst_35870 = (state_35890[(7)]);
var inst_35874 = (state_35890[(2)]);
var inst_35875 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_35876__$1 = cljs.core.get.call(null,inst_35875,inst_35870);
var state_35890__$1 = (function (){var statearr_35902 = state_35890;
(statearr_35902[(9)] = inst_35876__$1);

(statearr_35902[(10)] = inst_35874);

return statearr_35902;
})();
if(cljs.core.truth_(inst_35876__$1)){
var statearr_35903_35917 = state_35890__$1;
(statearr_35903_35917[(1)] = (9));

} else {
var statearr_35904_35918 = state_35890__$1;
(statearr_35904_35918[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__32183__auto__))
;
return ((function (switch__32095__auto__,c__32183__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__32096__auto__ = null;
var figwheel$client$file_reloading$state_machine__32096__auto____0 = (function (){
var statearr_35905 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_35905[(0)] = figwheel$client$file_reloading$state_machine__32096__auto__);

(statearr_35905[(1)] = (1));

return statearr_35905;
});
var figwheel$client$file_reloading$state_machine__32096__auto____1 = (function (state_35890){
while(true){
var ret_value__32097__auto__ = (function (){try{while(true){
var result__32098__auto__ = switch__32095__auto__.call(null,state_35890);
if(cljs.core.keyword_identical_QMARK_.call(null,result__32098__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32098__auto__;
}
break;
}
}catch (e35906){if((e35906 instanceof Object)){
var ex__32099__auto__ = e35906;
var statearr_35907_35919 = state_35890;
(statearr_35907_35919[(5)] = ex__32099__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35890);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35906;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__32097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35920 = state_35890;
state_35890 = G__35920;
continue;
} else {
return ret_value__32097__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__32096__auto__ = function(state_35890){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__32096__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__32096__auto____1.call(this,state_35890);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__32096__auto____0;
figwheel$client$file_reloading$state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__32096__auto____1;
return figwheel$client$file_reloading$state_machine__32096__auto__;
})()
;})(switch__32095__auto__,c__32183__auto__))
})();
var state__32185__auto__ = (function (){var statearr_35908 = f__32184__auto__.call(null);
(statearr_35908[(6)] = c__32183__auto__);

return statearr_35908;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__32185__auto__);
});})(c__32183__auto__))
);

return c__32183__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__35921,callback){
var map__35922 = p__35921;
var map__35922__$1 = ((((!((map__35922 == null)))?((((map__35922.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35922.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35922):map__35922);
var file_msg = map__35922__$1;
var namespace = cljs.core.get.call(null,map__35922__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__35922,map__35922__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__35922,map__35922__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__35924){
var map__35925 = p__35924;
var map__35925__$1 = ((((!((map__35925 == null)))?((((map__35925.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35925.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35925):map__35925);
var file_msg = map__35925__$1;
var namespace = cljs.core.get.call(null,map__35925__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__26481__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas));
if(and__26481__auto__){
var or__26493__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__26493__auto__)){
return or__26493__auto__;
} else {
var or__26493__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__26493__auto____$1)){
return or__26493__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__26481__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__35927,callback){
var map__35928 = p__35927;
var map__35928__$1 = ((((!((map__35928 == null)))?((((map__35928.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35928.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35928):map__35928);
var file_msg = map__35928__$1;
var request_url = cljs.core.get.call(null,map__35928__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__35928__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Not trying to load file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__32183__auto___35978 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__32183__auto___35978,out){
return (function (){
var f__32184__auto__ = (function (){var switch__32095__auto__ = ((function (c__32183__auto___35978,out){
return (function (state_35963){
var state_val_35964 = (state_35963[(1)]);
if((state_val_35964 === (1))){
var inst_35937 = cljs.core.seq.call(null,files);
var inst_35938 = cljs.core.first.call(null,inst_35937);
var inst_35939 = cljs.core.next.call(null,inst_35937);
var inst_35940 = files;
var state_35963__$1 = (function (){var statearr_35965 = state_35963;
(statearr_35965[(7)] = inst_35940);

(statearr_35965[(8)] = inst_35938);

(statearr_35965[(9)] = inst_35939);

return statearr_35965;
})();
var statearr_35966_35979 = state_35963__$1;
(statearr_35966_35979[(2)] = null);

(statearr_35966_35979[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35964 === (2))){
var inst_35940 = (state_35963[(7)]);
var inst_35946 = (state_35963[(10)]);
var inst_35945 = cljs.core.seq.call(null,inst_35940);
var inst_35946__$1 = cljs.core.first.call(null,inst_35945);
var inst_35947 = cljs.core.next.call(null,inst_35945);
var inst_35948 = (inst_35946__$1 == null);
var inst_35949 = cljs.core.not.call(null,inst_35948);
var state_35963__$1 = (function (){var statearr_35967 = state_35963;
(statearr_35967[(11)] = inst_35947);

(statearr_35967[(10)] = inst_35946__$1);

return statearr_35967;
})();
if(inst_35949){
var statearr_35968_35980 = state_35963__$1;
(statearr_35968_35980[(1)] = (4));

} else {
var statearr_35969_35981 = state_35963__$1;
(statearr_35969_35981[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35964 === (3))){
var inst_35961 = (state_35963[(2)]);
var state_35963__$1 = state_35963;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35963__$1,inst_35961);
} else {
if((state_val_35964 === (4))){
var inst_35946 = (state_35963[(10)]);
var inst_35951 = figwheel.client.file_reloading.reload_js_file.call(null,inst_35946);
var state_35963__$1 = state_35963;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35963__$1,(7),inst_35951);
} else {
if((state_val_35964 === (5))){
var inst_35957 = cljs.core.async.close_BANG_.call(null,out);
var state_35963__$1 = state_35963;
var statearr_35970_35982 = state_35963__$1;
(statearr_35970_35982[(2)] = inst_35957);

(statearr_35970_35982[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35964 === (6))){
var inst_35959 = (state_35963[(2)]);
var state_35963__$1 = state_35963;
var statearr_35971_35983 = state_35963__$1;
(statearr_35971_35983[(2)] = inst_35959);

(statearr_35971_35983[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35964 === (7))){
var inst_35947 = (state_35963[(11)]);
var inst_35953 = (state_35963[(2)]);
var inst_35954 = cljs.core.async.put_BANG_.call(null,out,inst_35953);
var inst_35940 = inst_35947;
var state_35963__$1 = (function (){var statearr_35972 = state_35963;
(statearr_35972[(7)] = inst_35940);

(statearr_35972[(12)] = inst_35954);

return statearr_35972;
})();
var statearr_35973_35984 = state_35963__$1;
(statearr_35973_35984[(2)] = null);

(statearr_35973_35984[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__32183__auto___35978,out))
;
return ((function (switch__32095__auto__,c__32183__auto___35978,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__32096__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__32096__auto____0 = (function (){
var statearr_35974 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35974[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__32096__auto__);

(statearr_35974[(1)] = (1));

return statearr_35974;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__32096__auto____1 = (function (state_35963){
while(true){
var ret_value__32097__auto__ = (function (){try{while(true){
var result__32098__auto__ = switch__32095__auto__.call(null,state_35963);
if(cljs.core.keyword_identical_QMARK_.call(null,result__32098__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32098__auto__;
}
break;
}
}catch (e35975){if((e35975 instanceof Object)){
var ex__32099__auto__ = e35975;
var statearr_35976_35985 = state_35963;
(statearr_35976_35985[(5)] = ex__32099__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35963);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35975;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__32097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35986 = state_35963;
state_35963 = G__35986;
continue;
} else {
return ret_value__32097__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__32096__auto__ = function(state_35963){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__32096__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__32096__auto____1.call(this,state_35963);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__32096__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__32096__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__32096__auto__;
})()
;})(switch__32095__auto__,c__32183__auto___35978,out))
})();
var state__32185__auto__ = (function (){var statearr_35977 = f__32184__auto__.call(null);
(statearr_35977[(6)] = c__32183__auto___35978);

return statearr_35977;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__32185__auto__);
});})(c__32183__auto___35978,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__35987,opts){
var map__35988 = p__35987;
var map__35988__$1 = ((((!((map__35988 == null)))?((((map__35988.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35988.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35988):map__35988);
var eval_body = cljs.core.get.call(null,map__35988__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__35988__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__26481__auto__ = eval_body;
if(cljs.core.truth_(and__26481__auto__)){
return typeof eval_body === 'string';
} else {
return and__26481__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Evaling file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e35990){var e = e35990;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Unable to evaluate "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["figwheel.connect",null], null), null),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__4655__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__35991_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__35991_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__4655__auto__)){
var file_msg = temp__4655__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__35992){
var vec__35993 = p__35992;
var k = cljs.core.nth.call(null,vec__35993,(0),null);
var v = cljs.core.nth.call(null,vec__35993,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__35996){
var vec__35997 = p__35996;
var k = cljs.core.nth.call(null,vec__35997,(0),null);
var v = cljs.core.nth.call(null,vec__35997,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__36003,p__36004){
var map__36005 = p__36003;
var map__36005__$1 = ((((!((map__36005 == null)))?((((map__36005.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36005.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36005):map__36005);
var opts = map__36005__$1;
var before_jsload = cljs.core.get.call(null,map__36005__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__36005__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__36005__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__36006 = p__36004;
var map__36006__$1 = ((((!((map__36006 == null)))?((((map__36006.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36006.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36006):map__36006);
var msg = map__36006__$1;
var files = cljs.core.get.call(null,map__36006__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__36006__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__36006__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__32183__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__32183__auto__,map__36005,map__36005__$1,opts,before_jsload,on_jsload,reload_dependents,map__36006,map__36006__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__32184__auto__ = (function (){var switch__32095__auto__ = ((function (c__32183__auto__,map__36005,map__36005__$1,opts,before_jsload,on_jsload,reload_dependents,map__36006,map__36006__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_36160){
var state_val_36161 = (state_36160[(1)]);
if((state_val_36161 === (7))){
var inst_36020 = (state_36160[(7)]);
var inst_36021 = (state_36160[(8)]);
var inst_36022 = (state_36160[(9)]);
var inst_36023 = (state_36160[(10)]);
var inst_36028 = cljs.core._nth.call(null,inst_36021,inst_36023);
var inst_36029 = figwheel.client.file_reloading.eval_body.call(null,inst_36028,opts);
var inst_36030 = (inst_36023 + (1));
var tmp36162 = inst_36020;
var tmp36163 = inst_36021;
var tmp36164 = inst_36022;
var inst_36020__$1 = tmp36162;
var inst_36021__$1 = tmp36163;
var inst_36022__$1 = tmp36164;
var inst_36023__$1 = inst_36030;
var state_36160__$1 = (function (){var statearr_36165 = state_36160;
(statearr_36165[(7)] = inst_36020__$1);

(statearr_36165[(11)] = inst_36029);

(statearr_36165[(8)] = inst_36021__$1);

(statearr_36165[(9)] = inst_36022__$1);

(statearr_36165[(10)] = inst_36023__$1);

return statearr_36165;
})();
var statearr_36166_36249 = state_36160__$1;
(statearr_36166_36249[(2)] = null);

(statearr_36166_36249[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (20))){
var inst_36063 = (state_36160[(12)]);
var inst_36071 = figwheel.client.file_reloading.sort_files.call(null,inst_36063);
var state_36160__$1 = state_36160;
var statearr_36167_36250 = state_36160__$1;
(statearr_36167_36250[(2)] = inst_36071);

(statearr_36167_36250[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (27))){
var state_36160__$1 = state_36160;
var statearr_36168_36251 = state_36160__$1;
(statearr_36168_36251[(2)] = null);

(statearr_36168_36251[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (1))){
var inst_36012 = (state_36160[(13)]);
var inst_36009 = before_jsload.call(null,files);
var inst_36010 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_36011 = (function (){return ((function (inst_36012,inst_36009,inst_36010,state_val_36161,c__32183__auto__,map__36005,map__36005__$1,opts,before_jsload,on_jsload,reload_dependents,map__36006,map__36006__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__36000_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__36000_SHARP_);
});
;})(inst_36012,inst_36009,inst_36010,state_val_36161,c__32183__auto__,map__36005,map__36005__$1,opts,before_jsload,on_jsload,reload_dependents,map__36006,map__36006__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_36012__$1 = cljs.core.filter.call(null,inst_36011,files);
var inst_36013 = cljs.core.not_empty.call(null,inst_36012__$1);
var state_36160__$1 = (function (){var statearr_36169 = state_36160;
(statearr_36169[(13)] = inst_36012__$1);

(statearr_36169[(14)] = inst_36009);

(statearr_36169[(15)] = inst_36010);

return statearr_36169;
})();
if(cljs.core.truth_(inst_36013)){
var statearr_36170_36252 = state_36160__$1;
(statearr_36170_36252[(1)] = (2));

} else {
var statearr_36171_36253 = state_36160__$1;
(statearr_36171_36253[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (24))){
var state_36160__$1 = state_36160;
var statearr_36172_36254 = state_36160__$1;
(statearr_36172_36254[(2)] = null);

(statearr_36172_36254[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (39))){
var inst_36113 = (state_36160[(16)]);
var state_36160__$1 = state_36160;
var statearr_36173_36255 = state_36160__$1;
(statearr_36173_36255[(2)] = inst_36113);

(statearr_36173_36255[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (46))){
var inst_36155 = (state_36160[(2)]);
var state_36160__$1 = state_36160;
var statearr_36174_36256 = state_36160__$1;
(statearr_36174_36256[(2)] = inst_36155);

(statearr_36174_36256[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (4))){
var inst_36057 = (state_36160[(2)]);
var inst_36058 = cljs.core.List.EMPTY;
var inst_36059 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_36058);
var inst_36060 = (function (){return ((function (inst_36057,inst_36058,inst_36059,state_val_36161,c__32183__auto__,map__36005,map__36005__$1,opts,before_jsload,on_jsload,reload_dependents,map__36006,map__36006__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__36001_SHARP_){
var and__26481__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__36001_SHARP_);
if(cljs.core.truth_(and__26481__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__36001_SHARP_));
} else {
return and__26481__auto__;
}
});
;})(inst_36057,inst_36058,inst_36059,state_val_36161,c__32183__auto__,map__36005,map__36005__$1,opts,before_jsload,on_jsload,reload_dependents,map__36006,map__36006__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_36061 = cljs.core.filter.call(null,inst_36060,files);
var inst_36062 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_36063 = cljs.core.concat.call(null,inst_36061,inst_36062);
var state_36160__$1 = (function (){var statearr_36175 = state_36160;
(statearr_36175[(17)] = inst_36059);

(statearr_36175[(12)] = inst_36063);

(statearr_36175[(18)] = inst_36057);

return statearr_36175;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_36176_36257 = state_36160__$1;
(statearr_36176_36257[(1)] = (16));

} else {
var statearr_36177_36258 = state_36160__$1;
(statearr_36177_36258[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (15))){
var inst_36047 = (state_36160[(2)]);
var state_36160__$1 = state_36160;
var statearr_36178_36259 = state_36160__$1;
(statearr_36178_36259[(2)] = inst_36047);

(statearr_36178_36259[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (21))){
var inst_36073 = (state_36160[(19)]);
var inst_36073__$1 = (state_36160[(2)]);
var inst_36074 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_36073__$1);
var state_36160__$1 = (function (){var statearr_36179 = state_36160;
(statearr_36179[(19)] = inst_36073__$1);

return statearr_36179;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36160__$1,(22),inst_36074);
} else {
if((state_val_36161 === (31))){
var inst_36158 = (state_36160[(2)]);
var state_36160__$1 = state_36160;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36160__$1,inst_36158);
} else {
if((state_val_36161 === (32))){
var inst_36113 = (state_36160[(16)]);
var inst_36118 = inst_36113.cljs$lang$protocol_mask$partition0$;
var inst_36119 = (inst_36118 & (64));
var inst_36120 = inst_36113.cljs$core$ISeq$;
var inst_36121 = (cljs.core.PROTOCOL_SENTINEL === inst_36120);
var inst_36122 = (inst_36119) || (inst_36121);
var state_36160__$1 = state_36160;
if(cljs.core.truth_(inst_36122)){
var statearr_36180_36260 = state_36160__$1;
(statearr_36180_36260[(1)] = (35));

} else {
var statearr_36181_36261 = state_36160__$1;
(statearr_36181_36261[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (40))){
var inst_36135 = (state_36160[(20)]);
var inst_36134 = (state_36160[(2)]);
var inst_36135__$1 = cljs.core.get.call(null,inst_36134,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_36136 = cljs.core.get.call(null,inst_36134,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_36137 = cljs.core.not_empty.call(null,inst_36135__$1);
var state_36160__$1 = (function (){var statearr_36182 = state_36160;
(statearr_36182[(21)] = inst_36136);

(statearr_36182[(20)] = inst_36135__$1);

return statearr_36182;
})();
if(cljs.core.truth_(inst_36137)){
var statearr_36183_36262 = state_36160__$1;
(statearr_36183_36262[(1)] = (41));

} else {
var statearr_36184_36263 = state_36160__$1;
(statearr_36184_36263[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (33))){
var state_36160__$1 = state_36160;
var statearr_36185_36264 = state_36160__$1;
(statearr_36185_36264[(2)] = false);

(statearr_36185_36264[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (13))){
var inst_36033 = (state_36160[(22)]);
var inst_36037 = cljs.core.chunk_first.call(null,inst_36033);
var inst_36038 = cljs.core.chunk_rest.call(null,inst_36033);
var inst_36039 = cljs.core.count.call(null,inst_36037);
var inst_36020 = inst_36038;
var inst_36021 = inst_36037;
var inst_36022 = inst_36039;
var inst_36023 = (0);
var state_36160__$1 = (function (){var statearr_36186 = state_36160;
(statearr_36186[(7)] = inst_36020);

(statearr_36186[(8)] = inst_36021);

(statearr_36186[(9)] = inst_36022);

(statearr_36186[(10)] = inst_36023);

return statearr_36186;
})();
var statearr_36187_36265 = state_36160__$1;
(statearr_36187_36265[(2)] = null);

(statearr_36187_36265[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (22))){
var inst_36073 = (state_36160[(19)]);
var inst_36077 = (state_36160[(23)]);
var inst_36081 = (state_36160[(24)]);
var inst_36076 = (state_36160[(25)]);
var inst_36076__$1 = (state_36160[(2)]);
var inst_36077__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_36076__$1);
var inst_36078 = (function (){var all_files = inst_36073;
var res_SINGLEQUOTE_ = inst_36076__$1;
var res = inst_36077__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_36073,inst_36077,inst_36081,inst_36076,inst_36076__$1,inst_36077__$1,state_val_36161,c__32183__auto__,map__36005,map__36005__$1,opts,before_jsload,on_jsload,reload_dependents,map__36006,map__36006__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__36002_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__36002_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_36073,inst_36077,inst_36081,inst_36076,inst_36076__$1,inst_36077__$1,state_val_36161,c__32183__auto__,map__36005,map__36005__$1,opts,before_jsload,on_jsload,reload_dependents,map__36006,map__36006__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_36079 = cljs.core.filter.call(null,inst_36078,inst_36076__$1);
var inst_36080 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_36081__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_36080);
var inst_36082 = cljs.core.not_empty.call(null,inst_36081__$1);
var state_36160__$1 = (function (){var statearr_36188 = state_36160;
(statearr_36188[(26)] = inst_36079);

(statearr_36188[(23)] = inst_36077__$1);

(statearr_36188[(24)] = inst_36081__$1);

(statearr_36188[(25)] = inst_36076__$1);

return statearr_36188;
})();
if(cljs.core.truth_(inst_36082)){
var statearr_36189_36266 = state_36160__$1;
(statearr_36189_36266[(1)] = (23));

} else {
var statearr_36190_36267 = state_36160__$1;
(statearr_36190_36267[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (36))){
var state_36160__$1 = state_36160;
var statearr_36191_36268 = state_36160__$1;
(statearr_36191_36268[(2)] = false);

(statearr_36191_36268[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (41))){
var inst_36135 = (state_36160[(20)]);
var inst_36139 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_36140 = cljs.core.map.call(null,inst_36139,inst_36135);
var inst_36141 = cljs.core.pr_str.call(null,inst_36140);
var inst_36142 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("figwheel-no-load meta-data: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36141)].join('');
var inst_36143 = figwheel.client.utils.log.call(null,inst_36142);
var state_36160__$1 = state_36160;
var statearr_36192_36269 = state_36160__$1;
(statearr_36192_36269[(2)] = inst_36143);

(statearr_36192_36269[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (43))){
var inst_36136 = (state_36160[(21)]);
var inst_36146 = (state_36160[(2)]);
var inst_36147 = cljs.core.not_empty.call(null,inst_36136);
var state_36160__$1 = (function (){var statearr_36193 = state_36160;
(statearr_36193[(27)] = inst_36146);

return statearr_36193;
})();
if(cljs.core.truth_(inst_36147)){
var statearr_36194_36270 = state_36160__$1;
(statearr_36194_36270[(1)] = (44));

} else {
var statearr_36195_36271 = state_36160__$1;
(statearr_36195_36271[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (29))){
var inst_36113 = (state_36160[(16)]);
var inst_36079 = (state_36160[(26)]);
var inst_36073 = (state_36160[(19)]);
var inst_36077 = (state_36160[(23)]);
var inst_36081 = (state_36160[(24)]);
var inst_36076 = (state_36160[(25)]);
var inst_36109 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_36112 = (function (){var all_files = inst_36073;
var res_SINGLEQUOTE_ = inst_36076;
var res = inst_36077;
var files_not_loaded = inst_36079;
var dependencies_that_loaded = inst_36081;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_36113,inst_36079,inst_36073,inst_36077,inst_36081,inst_36076,inst_36109,state_val_36161,c__32183__auto__,map__36005,map__36005__$1,opts,before_jsload,on_jsload,reload_dependents,map__36006,map__36006__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__36111){
var map__36196 = p__36111;
var map__36196__$1 = ((((!((map__36196 == null)))?((((map__36196.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36196.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36196):map__36196);
var namespace = cljs.core.get.call(null,map__36196__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_36113,inst_36079,inst_36073,inst_36077,inst_36081,inst_36076,inst_36109,state_val_36161,c__32183__auto__,map__36005,map__36005__$1,opts,before_jsload,on_jsload,reload_dependents,map__36006,map__36006__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_36113__$1 = cljs.core.group_by.call(null,inst_36112,inst_36079);
var inst_36115 = (inst_36113__$1 == null);
var inst_36116 = cljs.core.not.call(null,inst_36115);
var state_36160__$1 = (function (){var statearr_36198 = state_36160;
(statearr_36198[(28)] = inst_36109);

(statearr_36198[(16)] = inst_36113__$1);

return statearr_36198;
})();
if(inst_36116){
var statearr_36199_36272 = state_36160__$1;
(statearr_36199_36272[(1)] = (32));

} else {
var statearr_36200_36273 = state_36160__$1;
(statearr_36200_36273[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (44))){
var inst_36136 = (state_36160[(21)]);
var inst_36149 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_36136);
var inst_36150 = cljs.core.pr_str.call(null,inst_36149);
var inst_36151 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("not required: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36150)].join('');
var inst_36152 = figwheel.client.utils.log.call(null,inst_36151);
var state_36160__$1 = state_36160;
var statearr_36201_36274 = state_36160__$1;
(statearr_36201_36274[(2)] = inst_36152);

(statearr_36201_36274[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (6))){
var inst_36054 = (state_36160[(2)]);
var state_36160__$1 = state_36160;
var statearr_36202_36275 = state_36160__$1;
(statearr_36202_36275[(2)] = inst_36054);

(statearr_36202_36275[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (28))){
var inst_36079 = (state_36160[(26)]);
var inst_36106 = (state_36160[(2)]);
var inst_36107 = cljs.core.not_empty.call(null,inst_36079);
var state_36160__$1 = (function (){var statearr_36203 = state_36160;
(statearr_36203[(29)] = inst_36106);

return statearr_36203;
})();
if(cljs.core.truth_(inst_36107)){
var statearr_36204_36276 = state_36160__$1;
(statearr_36204_36276[(1)] = (29));

} else {
var statearr_36205_36277 = state_36160__$1;
(statearr_36205_36277[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (25))){
var inst_36077 = (state_36160[(23)]);
var inst_36093 = (state_36160[(2)]);
var inst_36094 = cljs.core.not_empty.call(null,inst_36077);
var state_36160__$1 = (function (){var statearr_36206 = state_36160;
(statearr_36206[(30)] = inst_36093);

return statearr_36206;
})();
if(cljs.core.truth_(inst_36094)){
var statearr_36207_36278 = state_36160__$1;
(statearr_36207_36278[(1)] = (26));

} else {
var statearr_36208_36279 = state_36160__$1;
(statearr_36208_36279[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (34))){
var inst_36129 = (state_36160[(2)]);
var state_36160__$1 = state_36160;
if(cljs.core.truth_(inst_36129)){
var statearr_36209_36280 = state_36160__$1;
(statearr_36209_36280[(1)] = (38));

} else {
var statearr_36210_36281 = state_36160__$1;
(statearr_36210_36281[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (17))){
var state_36160__$1 = state_36160;
var statearr_36211_36282 = state_36160__$1;
(statearr_36211_36282[(2)] = recompile_dependents);

(statearr_36211_36282[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (3))){
var state_36160__$1 = state_36160;
var statearr_36212_36283 = state_36160__$1;
(statearr_36212_36283[(2)] = null);

(statearr_36212_36283[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (12))){
var inst_36050 = (state_36160[(2)]);
var state_36160__$1 = state_36160;
var statearr_36213_36284 = state_36160__$1;
(statearr_36213_36284[(2)] = inst_36050);

(statearr_36213_36284[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (2))){
var inst_36012 = (state_36160[(13)]);
var inst_36019 = cljs.core.seq.call(null,inst_36012);
var inst_36020 = inst_36019;
var inst_36021 = null;
var inst_36022 = (0);
var inst_36023 = (0);
var state_36160__$1 = (function (){var statearr_36214 = state_36160;
(statearr_36214[(7)] = inst_36020);

(statearr_36214[(8)] = inst_36021);

(statearr_36214[(9)] = inst_36022);

(statearr_36214[(10)] = inst_36023);

return statearr_36214;
})();
var statearr_36215_36285 = state_36160__$1;
(statearr_36215_36285[(2)] = null);

(statearr_36215_36285[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (23))){
var inst_36079 = (state_36160[(26)]);
var inst_36073 = (state_36160[(19)]);
var inst_36077 = (state_36160[(23)]);
var inst_36081 = (state_36160[(24)]);
var inst_36076 = (state_36160[(25)]);
var inst_36084 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_36086 = (function (){var all_files = inst_36073;
var res_SINGLEQUOTE_ = inst_36076;
var res = inst_36077;
var files_not_loaded = inst_36079;
var dependencies_that_loaded = inst_36081;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_36079,inst_36073,inst_36077,inst_36081,inst_36076,inst_36084,state_val_36161,c__32183__auto__,map__36005,map__36005__$1,opts,before_jsload,on_jsload,reload_dependents,map__36006,map__36006__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__36085){
var map__36216 = p__36085;
var map__36216__$1 = ((((!((map__36216 == null)))?((((map__36216.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36216.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36216):map__36216);
var request_url = cljs.core.get.call(null,map__36216__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_36079,inst_36073,inst_36077,inst_36081,inst_36076,inst_36084,state_val_36161,c__32183__auto__,map__36005,map__36005__$1,opts,before_jsload,on_jsload,reload_dependents,map__36006,map__36006__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_36087 = cljs.core.reverse.call(null,inst_36081);
var inst_36088 = cljs.core.map.call(null,inst_36086,inst_36087);
var inst_36089 = cljs.core.pr_str.call(null,inst_36088);
var inst_36090 = figwheel.client.utils.log.call(null,inst_36089);
var state_36160__$1 = (function (){var statearr_36218 = state_36160;
(statearr_36218[(31)] = inst_36084);

return statearr_36218;
})();
var statearr_36219_36286 = state_36160__$1;
(statearr_36219_36286[(2)] = inst_36090);

(statearr_36219_36286[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (35))){
var state_36160__$1 = state_36160;
var statearr_36220_36287 = state_36160__$1;
(statearr_36220_36287[(2)] = true);

(statearr_36220_36287[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (19))){
var inst_36063 = (state_36160[(12)]);
var inst_36069 = figwheel.client.file_reloading.expand_files.call(null,inst_36063);
var state_36160__$1 = state_36160;
var statearr_36221_36288 = state_36160__$1;
(statearr_36221_36288[(2)] = inst_36069);

(statearr_36221_36288[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (11))){
var state_36160__$1 = state_36160;
var statearr_36222_36289 = state_36160__$1;
(statearr_36222_36289[(2)] = null);

(statearr_36222_36289[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (9))){
var inst_36052 = (state_36160[(2)]);
var state_36160__$1 = state_36160;
var statearr_36223_36290 = state_36160__$1;
(statearr_36223_36290[(2)] = inst_36052);

(statearr_36223_36290[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (5))){
var inst_36022 = (state_36160[(9)]);
var inst_36023 = (state_36160[(10)]);
var inst_36025 = (inst_36023 < inst_36022);
var inst_36026 = inst_36025;
var state_36160__$1 = state_36160;
if(cljs.core.truth_(inst_36026)){
var statearr_36224_36291 = state_36160__$1;
(statearr_36224_36291[(1)] = (7));

} else {
var statearr_36225_36292 = state_36160__$1;
(statearr_36225_36292[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (14))){
var inst_36033 = (state_36160[(22)]);
var inst_36042 = cljs.core.first.call(null,inst_36033);
var inst_36043 = figwheel.client.file_reloading.eval_body.call(null,inst_36042,opts);
var inst_36044 = cljs.core.next.call(null,inst_36033);
var inst_36020 = inst_36044;
var inst_36021 = null;
var inst_36022 = (0);
var inst_36023 = (0);
var state_36160__$1 = (function (){var statearr_36226 = state_36160;
(statearr_36226[(7)] = inst_36020);

(statearr_36226[(8)] = inst_36021);

(statearr_36226[(9)] = inst_36022);

(statearr_36226[(32)] = inst_36043);

(statearr_36226[(10)] = inst_36023);

return statearr_36226;
})();
var statearr_36227_36293 = state_36160__$1;
(statearr_36227_36293[(2)] = null);

(statearr_36227_36293[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (45))){
var state_36160__$1 = state_36160;
var statearr_36228_36294 = state_36160__$1;
(statearr_36228_36294[(2)] = null);

(statearr_36228_36294[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (26))){
var inst_36079 = (state_36160[(26)]);
var inst_36073 = (state_36160[(19)]);
var inst_36077 = (state_36160[(23)]);
var inst_36081 = (state_36160[(24)]);
var inst_36076 = (state_36160[(25)]);
var inst_36096 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_36098 = (function (){var all_files = inst_36073;
var res_SINGLEQUOTE_ = inst_36076;
var res = inst_36077;
var files_not_loaded = inst_36079;
var dependencies_that_loaded = inst_36081;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_36079,inst_36073,inst_36077,inst_36081,inst_36076,inst_36096,state_val_36161,c__32183__auto__,map__36005,map__36005__$1,opts,before_jsload,on_jsload,reload_dependents,map__36006,map__36006__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__36097){
var map__36229 = p__36097;
var map__36229__$1 = ((((!((map__36229 == null)))?((((map__36229.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36229.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36229):map__36229);
var namespace = cljs.core.get.call(null,map__36229__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__36229__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_36079,inst_36073,inst_36077,inst_36081,inst_36076,inst_36096,state_val_36161,c__32183__auto__,map__36005,map__36005__$1,opts,before_jsload,on_jsload,reload_dependents,map__36006,map__36006__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_36099 = cljs.core.map.call(null,inst_36098,inst_36077);
var inst_36100 = cljs.core.pr_str.call(null,inst_36099);
var inst_36101 = figwheel.client.utils.log.call(null,inst_36100);
var inst_36102 = (function (){var all_files = inst_36073;
var res_SINGLEQUOTE_ = inst_36076;
var res = inst_36077;
var files_not_loaded = inst_36079;
var dependencies_that_loaded = inst_36081;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_36079,inst_36073,inst_36077,inst_36081,inst_36076,inst_36096,inst_36098,inst_36099,inst_36100,inst_36101,state_val_36161,c__32183__auto__,map__36005,map__36005__$1,opts,before_jsload,on_jsload,reload_dependents,map__36006,map__36006__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_36079,inst_36073,inst_36077,inst_36081,inst_36076,inst_36096,inst_36098,inst_36099,inst_36100,inst_36101,state_val_36161,c__32183__auto__,map__36005,map__36005__$1,opts,before_jsload,on_jsload,reload_dependents,map__36006,map__36006__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_36103 = setTimeout(inst_36102,(10));
var state_36160__$1 = (function (){var statearr_36231 = state_36160;
(statearr_36231[(33)] = inst_36101);

(statearr_36231[(34)] = inst_36096);

return statearr_36231;
})();
var statearr_36232_36295 = state_36160__$1;
(statearr_36232_36295[(2)] = inst_36103);

(statearr_36232_36295[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (16))){
var state_36160__$1 = state_36160;
var statearr_36233_36296 = state_36160__$1;
(statearr_36233_36296[(2)] = reload_dependents);

(statearr_36233_36296[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (38))){
var inst_36113 = (state_36160[(16)]);
var inst_36131 = cljs.core.apply.call(null,cljs.core.hash_map,inst_36113);
var state_36160__$1 = state_36160;
var statearr_36234_36297 = state_36160__$1;
(statearr_36234_36297[(2)] = inst_36131);

(statearr_36234_36297[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (30))){
var state_36160__$1 = state_36160;
var statearr_36235_36298 = state_36160__$1;
(statearr_36235_36298[(2)] = null);

(statearr_36235_36298[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (10))){
var inst_36033 = (state_36160[(22)]);
var inst_36035 = cljs.core.chunked_seq_QMARK_.call(null,inst_36033);
var state_36160__$1 = state_36160;
if(inst_36035){
var statearr_36236_36299 = state_36160__$1;
(statearr_36236_36299[(1)] = (13));

} else {
var statearr_36237_36300 = state_36160__$1;
(statearr_36237_36300[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (18))){
var inst_36067 = (state_36160[(2)]);
var state_36160__$1 = state_36160;
if(cljs.core.truth_(inst_36067)){
var statearr_36238_36301 = state_36160__$1;
(statearr_36238_36301[(1)] = (19));

} else {
var statearr_36239_36302 = state_36160__$1;
(statearr_36239_36302[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (42))){
var state_36160__$1 = state_36160;
var statearr_36240_36303 = state_36160__$1;
(statearr_36240_36303[(2)] = null);

(statearr_36240_36303[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (37))){
var inst_36126 = (state_36160[(2)]);
var state_36160__$1 = state_36160;
var statearr_36241_36304 = state_36160__$1;
(statearr_36241_36304[(2)] = inst_36126);

(statearr_36241_36304[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36161 === (8))){
var inst_36020 = (state_36160[(7)]);
var inst_36033 = (state_36160[(22)]);
var inst_36033__$1 = cljs.core.seq.call(null,inst_36020);
var state_36160__$1 = (function (){var statearr_36242 = state_36160;
(statearr_36242[(22)] = inst_36033__$1);

return statearr_36242;
})();
if(inst_36033__$1){
var statearr_36243_36305 = state_36160__$1;
(statearr_36243_36305[(1)] = (10));

} else {
var statearr_36244_36306 = state_36160__$1;
(statearr_36244_36306[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__32183__auto__,map__36005,map__36005__$1,opts,before_jsload,on_jsload,reload_dependents,map__36006,map__36006__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__32095__auto__,c__32183__auto__,map__36005,map__36005__$1,opts,before_jsload,on_jsload,reload_dependents,map__36006,map__36006__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__32096__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__32096__auto____0 = (function (){
var statearr_36245 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36245[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__32096__auto__);

(statearr_36245[(1)] = (1));

return statearr_36245;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__32096__auto____1 = (function (state_36160){
while(true){
var ret_value__32097__auto__ = (function (){try{while(true){
var result__32098__auto__ = switch__32095__auto__.call(null,state_36160);
if(cljs.core.keyword_identical_QMARK_.call(null,result__32098__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32098__auto__;
}
break;
}
}catch (e36246){if((e36246 instanceof Object)){
var ex__32099__auto__ = e36246;
var statearr_36247_36307 = state_36160;
(statearr_36247_36307[(5)] = ex__32099__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_36160);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e36246;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__32097__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36308 = state_36160;
state_36160 = G__36308;
continue;
} else {
return ret_value__32097__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__32096__auto__ = function(state_36160){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__32096__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__32096__auto____1.call(this,state_36160);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__32096__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__32096__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__32096__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__32096__auto__;
})()
;})(switch__32095__auto__,c__32183__auto__,map__36005,map__36005__$1,opts,before_jsload,on_jsload,reload_dependents,map__36006,map__36006__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__32185__auto__ = (function (){var statearr_36248 = f__32184__auto__.call(null);
(statearr_36248[(6)] = c__32183__auto__);

return statearr_36248;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__32185__auto__);
});})(c__32183__auto__,map__36005,map__36005__$1,opts,before_jsload,on_jsload,reload_dependents,map__36006,map__36006__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__32183__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),cljs.core.str.cljs$core$IFn$_invoke$arity$1("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__36311,link){
var map__36312 = p__36311;
var map__36312__$1 = ((((!((map__36312 == null)))?((((map__36312.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36312.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36312):map__36312);
var file = cljs.core.get.call(null,map__36312__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = link.href;
if(cljs.core.truth_(temp__4657__auto__)){
var link_href = temp__4657__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4657__auto__,map__36312,map__36312__$1,file){
return (function (p1__36309_SHARP_,p2__36310_SHARP_){
if(cljs.core._EQ_.call(null,p1__36309_SHARP_,p2__36310_SHARP_)){
return p1__36309_SHARP_;
} else {
return false;
}
});})(link_href,temp__4657__auto__,map__36312,map__36312__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4657__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__36315){
var map__36316 = p__36315;
var map__36316__$1 = ((((!((map__36316 == null)))?((((map__36316.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36316.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36316):map__36316);
var match_length = cljs.core.get.call(null,map__36316__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__36316__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__36314_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__36314_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4657__auto__)){
var res = temp__4657__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.add_link_to_doc = (function figwheel$client$file_reloading$add_link_to_doc(var_args){
var G__36319 = arguments.length;
switch (G__36319) {
case 1:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = (function (new_link){
return (document.getElementsByTagName("head")[(0)]).appendChild(new_link);
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = (function (orig_link,klone){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
return parent.removeChild(orig_link);
});})(parent))
,(300));
});

figwheel.client.file_reloading.add_link_to_doc.cljs$lang$maxFixedArity = 2;

figwheel.client.file_reloading.distictify = (function figwheel$client$file_reloading$distictify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__36321_SHARP_,p2__36322_SHARP_){
return cljs.core.assoc.call(null,p1__36321_SHARP_,cljs.core.get.call(null,p2__36322_SHARP_,key),p2__36322_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(p__36323){
var map__36324 = p__36323;
var map__36324__$1 = ((((!((map__36324 == null)))?((((map__36324.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36324.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36324):map__36324);
var f_data = map__36324__$1;
var file = cljs.core.get.call(null,map__36324__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4657__auto__)){
var link = temp__4657__auto__;
return figwheel.client.file_reloading.add_link_to_doc.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href));
} else {
return null;
}
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__36326,p__36327){
var map__36328 = p__36326;
var map__36328__$1 = ((((!((map__36328 == null)))?((((map__36328.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36328.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36328):map__36328);
var opts = map__36328__$1;
var on_cssload = cljs.core.get.call(null,map__36328__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__36329 = p__36327;
var map__36329__$1 = ((((!((map__36329 == null)))?((((map__36329.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36329.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36329):map__36329);
var files_msg = map__36329__$1;
var files = cljs.core.get.call(null,map__36329__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var seq__36332_36336 = cljs.core.seq.call(null,figwheel.client.file_reloading.distictify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
var chunk__36333_36337 = null;
var count__36334_36338 = (0);
var i__36335_36339 = (0);
while(true){
if((i__36335_36339 < count__36334_36338)){
var f_36340 = cljs.core._nth.call(null,chunk__36333_36337,i__36335_36339);
figwheel.client.file_reloading.reload_css_file.call(null,f_36340);

var G__36341 = seq__36332_36336;
var G__36342 = chunk__36333_36337;
var G__36343 = count__36334_36338;
var G__36344 = (i__36335_36339 + (1));
seq__36332_36336 = G__36341;
chunk__36333_36337 = G__36342;
count__36334_36338 = G__36343;
i__36335_36339 = G__36344;
continue;
} else {
var temp__4657__auto___36345 = cljs.core.seq.call(null,seq__36332_36336);
if(temp__4657__auto___36345){
var seq__36332_36346__$1 = temp__4657__auto___36345;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__36332_36346__$1)){
var c__27313__auto___36347 = cljs.core.chunk_first.call(null,seq__36332_36346__$1);
var G__36348 = cljs.core.chunk_rest.call(null,seq__36332_36346__$1);
var G__36349 = c__27313__auto___36347;
var G__36350 = cljs.core.count.call(null,c__27313__auto___36347);
var G__36351 = (0);
seq__36332_36336 = G__36348;
chunk__36333_36337 = G__36349;
count__36334_36338 = G__36350;
i__36335_36339 = G__36351;
continue;
} else {
var f_36352 = cljs.core.first.call(null,seq__36332_36346__$1);
figwheel.client.file_reloading.reload_css_file.call(null,f_36352);

var G__36353 = cljs.core.next.call(null,seq__36332_36346__$1);
var G__36354 = null;
var G__36355 = (0);
var G__36356 = (0);
seq__36332_36336 = G__36353;
chunk__36333_36337 = G__36354;
count__36334_36338 = G__36355;
i__36335_36339 = G__36356;
continue;
}
} else {
}
}
break;
}

return setTimeout(((function (map__36328,map__36328__$1,opts,on_cssload,map__36329,map__36329__$1,files_msg,files){
return (function (){
figwheel.client.file_reloading.on_cssload_custom_event.call(null,files);

return on_cssload.call(null,files);
});})(map__36328,map__36328__$1,opts,on_cssload,map__36329,map__36329__$1,files_msg,files))
,(100));
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1500131137971